/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.model.LEConfig;
import COM.livingston.model.LEDBLoginUsers;
import COM.livingston.model.LEDBNetUsers;
import COM.livingston.model.LELoginUsers;
import COM.livingston.model.LENetUsers;
import COM.livingston.model.LEPortMaster;

public class LEUsers
extends LEConfig {
    public static final String DB_LOGIN_USERS = "logindialback";
    public static final String DB_NET_USERS = "netdialback";
    public static final String LOGIN_USERS = "user";
    public static final String NET_USERS = "netuser";
    public static final int KEY_COUNT = 4;
    static String[] s_keys = null;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[4];
            int i = 0;
            LEUsers.s_keys[i++] = DB_LOGIN_USERS;
            LEUsers.s_keys[i++] = DB_NET_USERS;
            LEUsers.s_keys[i++] = LOGIN_USERS;
            LEUsers.s_keys[i++] = NET_USERS;
        }
        return s_keys;
    }

    public LEUsers(LEPortMaster pm) {
        super(pm);
    }

    public Object clone() {
        LEUsers config = new LEUsers(this.m_pm);
        this.copyTo(config);
        return config;
    }

    public Object getUser(String name) {
        LENetUsers nusers;
        LELoginUsers lusers;
        LEDBNetUsers dbnusers;
        Object user = null;
        LEDBLoginUsers dblusers = (LEDBLoginUsers)this.get(DB_LOGIN_USERS);
        if (dblusers != null) {
            user = dblusers.get(name);
        }
        if (user == null && (dbnusers = (LEDBNetUsers)this.get(DB_NET_USERS)) != null) {
            user = dbnusers.get(name);
        }
        if (user == null && (lusers = (LELoginUsers)this.get(LOGIN_USERS)) != null) {
            user = lusers.get(name);
        }
        if (user == null && (nusers = (LENetUsers)this.get(NET_USERS)) != null) {
            user = nusers.get(name);
        }
        return user;
    }

    LEConfig createConfig(String key) {
        LEConfig config = key.equals(DB_LOGIN_USERS) ? new LEDBLoginUsers(this.m_pm) : (key.equals(DB_NET_USERS) ? new LEDBNetUsers(this.m_pm) : (key.equals(LOGIN_USERS) ? new LELoginUsers(this.m_pm) : (key.equals(NET_USERS) ? new LENetUsers(this.m_pm) : new LEConfig(this.m_pm))));
        return config;
    }
}

