/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.ui;

import COM.livingston.ui.LETextField;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEOctets;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class LEIPPanel
extends Panel
implements KeyListener {
    public static final String DOT = ".";
    public static final int MIN = 0;
    public static final int MAX = 255;
    public static final String NO_ADDRESS = "0.0.0.0";
    LETextField[] m_tfs = new LETextField[4];

    public LEIPPanel() {
        super(new FlowLayout(0, 0, 0));
        int n = 0;
        while (n < 4) {
            if (n > 0) {
                this.add(new Label(DOT, 1));
            }
            this.m_tfs[n] = new LETextField(3);
            this.add(this.m_tfs[n]);
            this.m_tfs[n].setNumeric(true);
            this.m_tfs[n].setBounds(0L, 255L);
            this.m_tfs[n].addKeyListener(this);
            ++n;
        }
    }

    public LEIPPanel(String string) {
        this();
        this.setAddress(string);
    }

    public void setAddress(String string) {
        if (string.length() > 0) {
            LEOctets lEOctets = new LEOctets(string);
            short[] sArray = lEOctets.getOctets();
            int n = Math.min(sArray.length, 4);
            int n2 = 0;
            while (n2 < n) {
                ((TextComponent)this.m_tfs[n2]).setText(Integer.toString(sArray[n2]));
                ++n2;
            }
            return;
        }
        int n = 0;
        while (n < 4) {
            ((TextComponent)this.m_tfs[n]).setText(null);
            ++n;
        }
    }

    public String getAddress() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < 4) {
            String string;
            if (n > 0) {
                stringBuffer.append(DOT);
            }
            if ((string = this.m_tfs[n].getText()).length() == 0) {
                string = Integer.toString(0);
            } else {
                try {
                    int n2 = Integer.parseInt(string);
                    n2 = Math.min(n2, 255);
                    n2 = Math.max(n2, 0);
                    string = Integer.toString(n2);
                }
                catch (NumberFormatException numberFormatException) {
                    LEDebug.getLog().logln(20, numberFormatException);
                    string = Integer.toString(0);
                }
            }
            stringBuffer.append(string);
            ++n;
        }
        return stringBuffer.toString();
    }

    public void setEnabled(boolean bl) {
        int n = 0;
        while (n < 4) {
            this.m_tfs[n].setEnabled(bl);
            ++n;
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '.') {
            LETextField lETextField = (LETextField)keyEvent.getSource();
            int n = 0;
            while (n < 3) {
                if (lETextField == this.m_tfs[n]) {
                    this.m_tfs[n + 1].requestFocus();
                }
                ++n;
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

