/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.util;

import COM.livingston.util.LELog;
import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.Writer;

public class LEDebugLog
extends LELog {
    public static final int NONE = 0;
    public static final int FATAL_ERRORS = 10;
    public static final int ALL_ERRORS = 20;
    public static final int DEBUG = 30;
    public static final int VERBOSE = 40;
    protected boolean m_lineInfo;
    protected String stackClassEntry;
    protected String stackSuperclassEntry;

    LEDebugLog() {
    }

    LEDebugLog(OutputStream outputStream) {
        super(outputStream);
    }

    LEDebugLog(PrintWriter printWriter) {
        super(printWriter);
    }

    LEDebugLog(Writer writer) {
        super(writer);
    }

    public synchronized void setLineInfo(boolean bl) {
        this.m_lineInfo = bl;
    }

    public synchronized void loglnNoTrace(int n, Throwable throwable) {
        if (this.shouldLog(n)) {
            this.logException(throwable);
        }
    }

    public synchronized void logln(int n, Throwable throwable) {
        if (this.shouldLog(n)) {
            this.logException(throwable);
            PrintWriter printWriter = this.getPrintWriter();
            printWriter.println("Exception handled at:");
            this.dumpStack();
        }
    }

    public synchronized void logLineInfo(int n) {
        String string;
        if (this.shouldLog(n) && (string = this.getLineInfo()) != null && string.length() > 0) {
            PrintWriter printWriter = this.getPrintWriter();
            printWriter.print(string);
        }
    }

    public synchronized void loglnLineInfo(int n) {
        String string;
        if (this.shouldLog(n) && (string = this.getLineInfo()) != null && string.length() > 0) {
            PrintWriter printWriter = this.getPrintWriter();
            printWriter.print(this.m_indentBuf);
            printWriter.println(string);
        }
    }

    public synchronized void logStack() {
        this.logStack(40);
    }

    public synchronized void logStack(int n) {
        if (this.shouldLog(n)) {
            boolean bl = this.m_lineInfo;
            this.m_lineInfo = false;
            this.printHeader(null);
            this.m_lineInfo = bl;
            this.dumpStack();
        }
    }

    protected synchronized void printOtherHeader() {
        String string;
        if (this.m_lineInfo && (string = this.getLineInfo()) != null && string.length() > 0) {
            this.m_printWriter.println(string);
        }
    }

    protected synchronized String getLineInfo() {
        String string = null;
        PrintWriter printWriter = this.getPrintWriter();
        Exception exception = new Exception();
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        PrintWriter printWriter2 = new PrintWriter(charArrayWriter);
        exception.printStackTrace(printWriter2);
        String string2 = charArrayWriter.toString();
        StringReader stringReader = new StringReader(string2);
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        try {
            string = bufferedReader.readLine();
            string = bufferedReader.readLine();
            while (string != null && (string.indexOf(this.stackClassEntry) != -1 || string.indexOf(this.stackSuperclassEntry) != -1)) {
                string = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            printWriter.println("An error occured while trying to create a stack trace!");
            iOException.printStackTrace(printWriter);
        }
        return string;
    }

    protected void init() {
        super.init();
        this.m_lineInfo = false;
        this.stackClassEntry = this.getClass().getName();
        this.stackSuperclassEntry = this.getClass().getSuperclass().getName();
    }

    protected void logException(Throwable throwable) {
        boolean bl = this.m_lineInfo;
        this.m_lineInfo = false;
        this.printHeader(null);
        this.m_lineInfo = bl;
        PrintWriter printWriter = this.getPrintWriter();
        try {
            throwable.printStackTrace(printWriter);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    protected void dumpStack() {
        PrintWriter printWriter = this.getPrintWriter();
        Exception exception = new Exception();
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        PrintWriter printWriter2 = new PrintWriter(charArrayWriter);
        exception.printStackTrace(printWriter2);
        String string = charArrayWriter.toString();
        StringReader stringReader = new StringReader(string);
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        try {
            String string2 = bufferedReader.readLine();
            string2 = bufferedReader.readLine();
            while (string2 != null && (string2.indexOf(this.stackClassEntry) != -1 || string2.indexOf(this.stackSuperclassEntry) != -1)) {
                string2 = bufferedReader.readLine();
            }
            while (string2 != null) {
                printWriter.print(this.m_indentBuf);
                printWriter.println(string2);
                string2 = bufferedReader.readLine();
            }
            return;
        }
        catch (Exception exception2) {
            printWriter.println("An error occured while trying to create a stack trace!");
            exception2.printStackTrace(printWriter);
            return;
        }
    }
}

