/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.backend.LEDSSPMAuthFailureException;
import COM.livingston.backend.LEDSSPortMaster;
import COM.livingston.model.LEConfig;
import COM.livingston.model.LEPortMaster;
import COM.livingston.ui.LEAboutDialog;
import COM.livingston.ui.LEActionClient;
import COM.livingston.ui.LEActionDialog;
import COM.livingston.ui.LEBorderPanel;
import COM.livingston.ui.LEClipboard;
import COM.livingston.ui.LEColor;
import COM.livingston.ui.LEConnectDialog;
import COM.livingston.ui.LEErrorDialog;
import COM.livingston.ui.LEFont;
import COM.livingston.ui.LEHelpBar;
import COM.livingston.ui.LELEDs;
import COM.livingston.ui.LELoginClient;
import COM.livingston.ui.LEMLEvent;
import COM.livingston.ui.LEMLListener;
import COM.livingston.ui.LEPathEvent;
import COM.livingston.ui.LEPathListener;
import COM.livingston.ui.LEScrollPanel;
import COM.livingston.ui.LESplitterPanel;
import COM.livingston.ui.LEStatusBar;
import COM.livingston.ui.LETitleBar;
import COM.livingston.ui.LETreeEvent;
import COM.livingston.ui.LETreeItem;
import COM.livingston.ui.LETreeListener;
import COM.livingston.ui.LEUiUtils;
import COM.livingston.util.LEAppInfo;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEResource;
import COM.livingston.util.LEStatusManager;
import COM.livingston.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.help.Book;
import oracle.help.Help;

public class LEConsole
extends Frame
implements LEActionClient,
LELoginClient,
LETreeListener,
LEMLListener,
LEPathListener,
LEViewListener,
ActionListener,
WindowListener,
Runnable {
    public static final String ACTION_ABOUT = "about";
    public static final String ACTION_CONNECT = "connect";
    public static final String ACTION_DISCONNECT = "disconnect";
    public static final String ACTION_EXIT = "exit";
    public static final String ACTION_HELP_CONTENTS = "help_contents";
    public static final String ACTION_HELP_CURRENT = "help_current";
    public static final String ACTION_HELP_SEARCH = "help_search";
    public static final String ACTION_REBOOT = "reboot";
    public static final String ACTION_RECONNECT = "reconnect";
    public static final String ACTION_UPDATE_START = "update_start";
    public static final String ACTION_UPDATE_END = "update_end";
    static LEConsole s_console;
    static Image s_main32;
    static Image s_main16;
    static String s_path;
    MenuBar m_menubar;
    MenuItem m_disconn;
    MenuItem m_reboot;
    MenuItem m_recon;
    LEStatusBar m_statusbar;
    LEHelpBar m_helpbar;
    LEBorderPanel m_work;
    LEBorderPanel m_treePanel;
    LEControlTree m_tree;
    LEPMGrid m_grid;
    LEPMPathBar m_pathBar;
    LEView m_view;
    Panel m_workBottom;
    Component m_workMain;
    LEClipboard m_cb;
    Book m_book;
    Help m_help;
    Button m_dummy;
    LEPortMaster[] m_selPMs = new LEPortMaster[0];
    String m_hostname;
    String m_password;
    String m_username;
    LEPortMaster m_pm;
    Rectangle m_bounds;
    int m_treeWidth = 150;
    int m_gridHeight = 150;
    static final String PROPERTIES = "props.cfg";
    static final String MAIN_BOUNDS = "MAIN";
    static final String TREE_WIDTH = "TREE";
    static final String GRID_HEIGHT = "GRID";
    static /* synthetic */ Class class$pmvhlp$PMVisionHelp;

    public static void Display() {
        if (s_console == null) {
            new LEConsole();
        }
    }

    public static LEConsole GetConsole() {
        return s_console;
    }

    public LEConsole() {
        super(LEAppInfo.getAppTitle());
        LEUiUtils.SetBaseFrame(this);
        LEColor.CheckColorFlags();
        this.loadProperties();
        s_console = this;
        this.addWindowListener(this);
        this.setLayout(new BorderLayout(5, 5));
        ((Component)this).setBackground(LEColor.getBackground());
        this.m_menubar = this.createMenuBar();
        this.setMenuBar(this.m_menubar);
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 2, 10, 10));
        this.m_statusbar = new LEStatusBar(2, LEStatusManager.GetManager());
        this.m_statusbar.setStatusText(LEAppInfo.getAppTitle());
        panel.add(this.m_statusbar);
        this.m_helpbar = new LEHelpBar(2);
        panel.add(this.m_helpbar);
        this.add("South", panel);
        LESplitterPanel lESplitterPanel = new LESplitterPanel();
        this.m_treePanel = new LEBorderPanel(2);
        this.m_treePanel.setLayout(new BorderLayout(0, 0));
        this.m_treePanel.setInsets(1, 1, 1, 1);
        this.m_tree = new LEControlTree();
        this.m_tree.addListener(this);
        this.m_treePanel.add("Center", this.m_tree);
        lESplitterPanel.addColumn(this.m_treeWidth);
        lESplitterPanel.addComponent((Component)this.m_treePanel, 0);
        this.m_grid = new LEPMGrid();
        this.m_grid.addListener(this);
        lESplitterPanel.addColumn(0);
        new LEBorderPanel(2);
        LEScrollPanel lEScrollPanel = new LEScrollPanel(this.m_grid);
        lESplitterPanel.addComponent((Component)lEScrollPanel, this.m_gridHeight);
        this.m_pathBar = new LEPMPathBar();
        this.m_pathBar.addListener(this);
        this.m_work = new LEBorderPanel(2);
        this.m_work.setInsets(0, 0, 0, 0);
        this.m_work.setLayout(new BorderLayout(0, 0));
        this.m_work.add("North", this.m_pathBar);
        lESplitterPanel.addComponent((Component)this.m_work, 0);
        this.add("Center", lESplitterPanel);
        this.m_cb.watchContainer(this.m_work);
        this.m_dummy = new Button();
        this.m_dummy.addActionListener(this);
        ((Component)this).setVisible(true);
        String string = LEAppInfo.getFlag("-g");
        if (string != null) {
            try {
                int n = Integer.parseInt(string);
                LEDebug.getLog().setLogLevel(n);
            }
            catch (NumberFormatException numberFormatException) {
                LEDebug.getLog().logln(20, "Bad argument for log level: " + string);
            }
        }
        try {
            this.m_book = Help.createBook(class$pmvhlp$PMVisionHelp != null ? class$pmvhlp$PMVisionHelp : (class$pmvhlp$PMVisionHelp = LEConsole.class$("pmvhlp.PMVisionHelp")), ".", "Amberhlp", "PMVision Help");
            if (this.m_book != null) {
                this.m_help = new Help();
                this.m_help.addBook(this.m_book);
                return;
            }
        }
        catch (Throwable throwable) {
            LEDebug.getLog().logln(20, throwable);
            LEDebug.getLog().logln(20, "Help system disabled");
        }
    }

    public void addNotify() {
        Object object;
        Object object2;
        super.addNotify();
        LEFont.setDefaultFont(this.getFont());
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (this.m_bounds != null) {
            n = this.m_bounds.x;
            n2 = this.m_bounds.y;
            n3 = this.m_bounds.width;
            n4 = this.m_bounds.height;
        }
        if (n3 == 0 || n4 == 0) {
            object2 = Toolkit.getDefaultToolkit().getScreenSize();
            n3 = ((Dimension)object2).width;
            n4 = ((Dimension)object2).height - 30;
        }
        ((Component)this).setLocation(n, n2);
        ((Component)this).setSize(n3, n4);
        LELEDs.Initialize();
        try {
            s_main32 = LEResource.GetImage("lucent_32.gif");
            s_main16 = LEResource.GetImage("lucent_16.gif");
            if (s_main32 != null) {
                this.setIconImage(s_main32);
            }
            object2 = LEResource.GetImage("tree-col.gif");
            object = LEResource.GetImage("tree-exp.gif");
            if (object2 instanceof Image && object instanceof Image) {
                this.m_tree.setDefaultImages((Image)object2, (Image)object);
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        object2 = LEAppInfo.getFlag("-h");
        object = LEAppInfo.getFlag("-u");
        String string = LEAppInfo.getFlag("-p");
        if (object2 != null && string != null) {
            if (object == null) {
                object = "!root";
            }
            this.loginTo((String)object2, (String)object, string);
        } else if (object2 != null) {
            if (object == null) {
                object = "!root";
            }
            LEConnectDialog.Show(this, this, (String)object2, (String)object, string);
        }
        Vector vector = this.m_tree.getRoots();
        if (vector.size() > 0) {
            this.m_tree.select((LETreeItem)vector.elementAt(0), true);
        }
    }

    public void lock() {
        this.m_tree.setEnabled(false);
        this.m_pathBar.setEnabled(false);
        this.m_grid.setEnabled(false);
    }

    public void unlock() {
        this.m_tree.setEnabled(true);
        this.m_pathBar.setEnabled(true);
        this.m_grid.setEnabled(true);
    }

    public void setBusy() {
        this.lock();
        ((Component)this).setCursor(Cursor.getPredefinedCursor(3));
    }

    public void setIdle() {
        this.unlock();
        ((Component)this).setCursor(Cursor.getDefaultCursor());
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.goodbye();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(ACTION_ABOUT)) {
            LEAboutDialog.Show(this);
            return;
        }
        if (string.equals(ACTION_CONNECT)) {
            LEConnectDialog.Show(this, this);
            return;
        }
        if (string.equals(ACTION_DISCONNECT)) {
            this.m_grid.deleteSelectedPMs();
            return;
        }
        if (string.equals(ACTION_EXIT)) {
            this.goodbye();
            return;
        }
        if (string.equals(ACTION_HELP_CONTENTS)) {
            if (this.m_help != null) {
                this.m_help.showContents();
                return;
            }
        } else if (string.equals(ACTION_HELP_CURRENT)) {
            if (this.m_help != null) {
                String string2 = this.getHelpTopic();
                try {
                    if (string2 == null) {
                        this.m_help.showContents();
                        return;
                    }
                    this.m_help.showTopic(this.m_book, string2);
                    return;
                }
                catch (Exception exception) {
                    String string3 = string2 == null ? "Error in help subsystem" : "No help found for topic: " + string2;
                    new LEErrorDialog((Frame)this, string3);
                    return;
                }
            }
        } else if (string.equals(ACTION_HELP_SEARCH)) {
            if (this.m_help != null) {
                this.m_help.showSearch();
                return;
            }
        } else {
            if (string.equals(ACTION_REBOOT)) {
                this.m_grid.rebootSelectedPMs();
                return;
            }
            if (string.equals(ACTION_RECONNECT)) {
                this.m_grid.reconnectSelectedPMs();
                return;
            }
            if (string.equals(ACTION_UPDATE_START)) {
                this.actionUpdateStart();
                return;
            }
            if (string.equals(ACTION_UPDATE_END)) {
                this.actionUpdateEnd();
                return;
            }
            LEDebug.getLog().logln(20, "Unknown LEConsole Action: " + string);
        }
    }

    public void loginTo(String string, String string2, String string3) {
        if (this.m_grid != null && this.m_grid.connectedTo(string)) {
            String string4 = String.valueOf(LEAppInfo.getAppName()) + " is already connected to " + string;
            new LEErrorDialog((Frame)this, string4);
            return;
        }
        this.m_hostname = string;
        this.m_password = string3;
        this.m_username = string2;
        LEActionDialog lEActionDialog = new LEActionDialog((Frame)this, "Connecting", this, LEStatusManager.GetManager());
        new Thread(lEActionDialog).start();
        ((Component)lEActionDialog).setVisible(true);
    }

    public void actionStart(LEActionDialog lEActionDialog) {
        this.setBusy();
        try {
            LEStatusBar lEStatusBar = lEActionDialog.getStatusBar();
            lEStatusBar.setStatusText("Connecting to " + this.m_hostname + "...");
            this.m_pm = new LEPortMaster(this.m_hostname, this.m_username, this.m_password);
            if (this.m_hostname == null) {
                this.m_pm.disconnect();
                this.m_pm = null;
                return;
            }
            LEDSSPortMaster lEDSSPortMaster = this.m_pm.getDSS();
            if (lEDSSPortMaster == null || !lEDSSPortMaster.isConnected()) {
                new LEErrorDialog((Frame)this, new String("Failed to connect to " + this.m_hostname));
                this.m_pm = null;
            }
            return;
        }
        catch (LEDSSPMAuthFailureException lEDSSPMAuthFailureException) {
            this.m_pm = null;
            new LEErrorDialog((Frame)this, new String("Invalid password!"));
            return;
        }
        catch (Exception exception) {
            this.m_pm = null;
            LEDebug.getLog().logln(20, exception);
            if (this.m_hostname != null) {
                new LEErrorDialog((Frame)this, exception.getMessage());
            }
            return;
        }
    }

    public void actionDone(LEActionDialog lEActionDialog) {
        if (this.m_pm != null) {
            this.m_grid.addPortMaster(this.m_hostname, this.m_pm);
        }
        this.m_statusbar.setStatusText("");
        this.actionCancel(lEActionDialog);
    }

    public synchronized void actionCancel(LEActionDialog lEActionDialog) {
        this.m_pm = null;
        this.m_hostname = null;
        this.m_password = null;
        this.setIdle();
    }

    public void onLETreeEvent(LETreeEvent lETreeEvent) {
        if (lETreeEvent.m_id == 1) {
            this.m_pathBar.setPath(this.m_tree);
            this.updateView();
        }
    }

    public void onLEMLEvent(LEMLEvent lEMLEvent) {
        if (lEMLEvent.getType() == 3) {
            this.m_selPMs = this.m_grid.getSelectedPMs();
            if (this.m_selPMs.length > 0) {
                this.m_disconn.setEnabled(true);
                this.m_reboot.setEnabled(true);
                this.m_recon.setEnabled(true);
            } else {
                this.m_disconn.setEnabled(false);
                this.m_reboot.setEnabled(false);
                this.m_recon.setEnabled(false);
            }
            this.updateSelection();
        }
    }

    public void onLEPathEvent(LEPathEvent lEPathEvent) {
        LETreeItem lETreeItem = (LETreeItem)lEPathEvent.getItem().getData();
        this.m_tree.select(lETreeItem, true);
    }

    public void onLEViewEvent(LEViewEvent lEViewEvent) {
        int n = lEViewEvent.getId();
        if (n == 1) {
            LEConfig lEConfig = lEViewEvent.getConfig();
            String string = (String)lEViewEvent.getData();
            this.m_tree.selectChild(lEConfig, string, string, true);
            return;
        }
        if (n == 2) {
            this.m_tree.selectParent((String)lEViewEvent.getData(), true);
            return;
        }
        if (n == 3) {
            this.m_tree.selectItem((LEVector)lEViewEvent.getData(), true);
            return;
        }
        if (n == 8) {
            this.lock();
            return;
        }
        if (n == 9) {
            this.unlock();
        }
    }

    public void updateSelection() {
        if (this.m_view != null) {
            this.setBusy();
            try {
                this.m_statusbar.setStatusText("Building display...");
                this.m_view.setSelection(this.m_selPMs);
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
            }
            this.m_statusbar.setStatusText(null);
            this.setIdle();
            return;
        }
        this.updateView();
    }

    public void updateView() {
        try {
            ActionEvent actionEvent = new ActionEvent(this.m_dummy, 1001, ACTION_UPDATE_START);
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(actionEvent);
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            this.actionUpdateStart();
            return;
        }
    }

    public void actionUpdateStart() {
        this.setBusy();
        try {
            Thread.currentThread();
            Thread.yield();
            if (this.m_view != null) {
                this.m_view.deleteListener(this);
                this.m_view.going();
            }
            if (this.m_workMain != null) {
                this.m_workMain.setVisible(false);
                this.m_work.remove(this.m_workMain);
                this.m_workMain = null;
            }
            if (this.m_workBottom != null) {
                this.m_workBottom.setVisible(false);
                this.m_work.remove(this.m_workBottom);
                this.m_workBottom = null;
            }
            if (this.m_view != null) {
                this.m_view.gone();
                this.m_view = null;
                LEClipboard.GetClipboard().reset();
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            this.m_view = null;
        }
        Thread thread = new Thread(this);
        thread.setName("Console Update");
        thread.start();
    }

    public void run() {
        try {
            this.m_view = LEViewFactory.GetView(this.m_tree, this.m_selPMs);
            ActionEvent actionEvent = new ActionEvent(this.m_dummy, 1001, ACTION_UPDATE_END);
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(actionEvent);
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            this.actionUpdateEnd();
            return;
        }
    }

    public void actionUpdateEnd() {
        try {
            Thread.currentThread();
            Thread.yield();
            if (this.m_view != null) {
                Component component;
                this.m_view.addListener(this);
                this.m_workMain = this.m_view.getMainPanel();
                if (this.m_workMain != null) {
                    this.m_work.add("Center", this.m_workMain);
                }
                if ((component = this.m_view.getBottomPanel()) != null) {
                    this.m_workBottom = new Panel();
                    this.m_workBottom.setLayout(new BorderLayout(5, 5));
                    this.m_workBottom.add("North", new LETitleBar());
                    this.m_workBottom.add("Center", component);
                    this.m_work.add("South", this.m_workBottom);
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        this.m_work.invalidate();
        this.m_work.validate();
        this.m_statusbar.setStatusText(null);
        this.setIdle();
    }

    String getHelpTopic() {
        String string = null;
        String string2 = null;
        LETreeItem lETreeItem = this.m_tree.getSelectedItem();
        while (lETreeItem != null) {
            if (lETreeItem.m_label.equals("Monitor")) {
                if (string2 == null) {
                    string = "Monitor_Panel";
                } else if (string2.equals("Modems")) {
                    string = "Monitor_Modems";
                } else if (string2.equals("Lines")) {
                    string = "Monitor_Lines";
                }
            } else if (lETreeItem.m_label.equals("Sessions")) {
                string = "Monitor_Sessions";
            } else if (lETreeItem.m_label.equals("Modems")) {
                string2 = lETreeItem.m_label;
            } else if (lETreeItem.m_label.equals("Lines")) {
                string2 = lETreeItem.m_label;
            } else if (lETreeItem.m_label.equals("Interfaces")) {
                string = "Monitor_Interfaces";
            } else if (lETreeItem.m_label.equals("Diagnose")) {
                string = "Diagnose_Panel";
            } else if (lETreeItem.m_label.equals("Debug")) {
                string = "Debug";
            } else if (lETreeItem.m_label.equals("Maintain")) {
                string = "Maintain_Panel";
            } else if (lETreeItem.m_label.equals("Back Up")) {
                string = "Maintain_Backup";
            } else if (lETreeItem.m_label.equals("Restore")) {
                string = "Maintain_Restore";
            } else if (lETreeItem.m_label.equals("Upgrade")) {
                string = "Maintain_Upgrade";
            } else if (lETreeItem.m_label.equals("Command")) {
                string = "Command_Panel";
            } else if (lETreeItem.m_label.equals("Configure")) {
                if (string2 == null) {
                    string = "Configure_Panel";
                } else if (string2.equals("Modems")) {
                    string = "Configure_Modems";
                } else if (string2.equals("Lines")) {
                    string = "Configure_ISDN_PRI_Lines";
                }
            } else if (lETreeItem.m_label.equals("Global")) {
                string = "Configure_Global";
            } else if (lETreeItem.m_label.equals("RADIUS")) {
                string = "Configure_RADIUS";
            } else if (lETreeItem.m_label.equals("ChoiceNet")) {
                string = "Configure_ChoiceNet";
            } else if (lETreeItem.m_label.equals("SNMP")) {
                string = "Configure_SNMP";
            } else if (lETreeItem.m_label.equals("OSPF")) {
                string = "Configure_OSPF";
            } else if (lETreeItem.m_label.equals("OSPF Areas")) {
                string = "Configure_OSPF_Areas";
            } else if (lETreeItem.m_label.equals("Locations")) {
                string = "Configure_Locations";
            } else if (lETreeItem.m_label.equals("Users")) {
                string = "Configure_Users_Panel";
            } else if (lETreeItem.m_label.equals("Filters")) {
                string = "Configure_Filters";
            } else if (lETreeItem.m_label.equals("Routes")) {
                string = "Configure_Routes";
            } else if (lETreeItem.m_label.equals("Hosts")) {
                string = "Configure_Hosts";
            } else if (lETreeItem.m_label.equals("Modems")) {
                string2 = lETreeItem.m_label;
            } else if (lETreeItem.m_label.equals("Lines")) {
                string2 = lETreeItem.m_label;
            } else if (lETreeItem.m_label.equals("Ports")) {
                string = "Configure_Ports_Panel";
            } else if (lETreeItem.m_label.equals("Ethernets")) {
                string = "Configure_Ethernets";
            } else if (lETreeItem.m_label.equals("Syslog")) {
                string = "Configure_Syslog";
            } else if (lETreeItem.m_label.equals("SubInterfaces")) {
                string = "Configure_Subinterfaces";
            }
            lETreeItem = string == null ? lETreeItem.m_parent : null;
        }
        return string;
    }

    MenuBar createMenuBar() {
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu("File");
        MenuItem menuItem = new MenuItem("Exit");
        menuItem.setActionCommand(ACTION_EXIT);
        menu.add(menuItem);
        menuItem.addActionListener(this);
        menuBar.add(menu);
        Menu menu2 = new Menu("Edit");
        MenuItem menuItem2 = new MenuItem("Cut");
        MenuItem menuItem3 = new MenuItem("Copy");
        MenuItem menuItem4 = new MenuItem("Paste");
        MenuItem menuItem5 = new MenuItem("Delete");
        menu2.add(menuItem2);
        menu2.add(menuItem3);
        menu2.add(menuItem4);
        menu2.add(menuItem5);
        this.m_cb = LEClipboard.GetClipboard();
        this.m_cb.setMenuItems(menuItem2, menuItem3, menuItem4, menuItem5);
        this.m_cb.reset();
        menuBar.add(menu2);
        menu = new Menu("PortMaster");
        menuItem = new MenuItem("Connect...");
        menu.add(menuItem);
        menuItem.setActionCommand(ACTION_CONNECT);
        menuItem.addActionListener(this);
        this.m_recon = new MenuItem("Reconnect");
        this.m_recon.setActionCommand(ACTION_RECONNECT);
        this.m_recon.setEnabled(false);
        this.m_recon.addActionListener(this);
        menu.add(this.m_recon);
        this.m_disconn = new MenuItem("Disconnect");
        this.m_disconn.setActionCommand(ACTION_DISCONNECT);
        this.m_disconn.setEnabled(false);
        this.m_disconn.addActionListener(this);
        menu.add(this.m_disconn);
        menu.addSeparator();
        this.m_reboot = new MenuItem("Reboot");
        this.m_reboot.setActionCommand(ACTION_REBOOT);
        this.m_reboot.setEnabled(false);
        this.m_reboot.addActionListener(this);
        menu.add(this.m_reboot);
        menuBar.add(menu);
        menu = new Menu("Help");
        menuItem = new MenuItem("Help on Current Panel...");
        menu.add(menuItem);
        menuItem.setActionCommand(ACTION_HELP_CURRENT);
        menuItem.addActionListener(this);
        menuItem = new MenuItem("Help Contents...");
        menu.add(menuItem);
        menuItem.setActionCommand(ACTION_HELP_CONTENTS);
        menuItem.addActionListener(this);
        menuItem = new MenuItem("Search for Help on...");
        menu.add(menuItem);
        menuItem.setActionCommand(ACTION_HELP_SEARCH);
        menuItem.addActionListener(this);
        menu.addSeparator();
        menuItem = new MenuItem("About " + LEAppInfo.getAppName() + "...");
        menuItem.setActionCommand(ACTION_ABOUT);
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuBar.add(menu);
        return menuBar;
    }

    void loadProperties() {
        File file;
        if (s_path == null) {
            s_path = LEAppInfo.getUserAppDirPath(PROPERTIES);
        }
        if ((file = new File(s_path)).exists()) {
            try {
                FileReader fileReader = new FileReader(file);
                BufferedReader bufferedReader = new BufferedReader(fileReader);
                String string = bufferedReader.readLine();
                while (string != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string);
                    if (stringTokenizer.hasMoreTokens()) {
                        this.parseProperty(stringTokenizer, stringTokenizer.nextToken());
                    }
                    string = bufferedReader.readLine();
                }
                return;
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
                return;
            }
        }
    }

    void parseProperty(StringTokenizer stringTokenizer, String string) {
        block12: {
            try {
                if (string.equals(MAIN_BOUNDS)) {
                    int n = 0;
                    int n2 = 0;
                    int n3 = 0;
                    int n4 = 0;
                    if (stringTokenizer.hasMoreTokens()) {
                        n = Integer.parseInt(stringTokenizer.nextToken());
                    }
                    if (stringTokenizer.hasMoreTokens()) {
                        n2 = Integer.parseInt(stringTokenizer.nextToken());
                    }
                    if (stringTokenizer.hasMoreTokens()) {
                        n3 = Integer.parseInt(stringTokenizer.nextToken());
                    }
                    if (stringTokenizer.hasMoreTokens()) {
                        n4 = Integer.parseInt(stringTokenizer.nextToken());
                    }
                    this.m_bounds = new Rectangle(n, n2, n3, n4);
                    return;
                }
                if (string.equals(TREE_WIDTH)) {
                    if (stringTokenizer.hasMoreTokens()) {
                        this.m_treeWidth = Integer.parseInt(stringTokenizer.nextToken());
                        return;
                    }
                } else {
                    if (!string.equals(GRID_HEIGHT) || !stringTokenizer.hasMoreTokens()) break block12;
                    this.m_gridHeight = Integer.parseInt(stringTokenizer.nextToken());
                }
                return;
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
            }
        }
    }

    void saveProperties() {
        try {
            File file = new File(s_path);
            FileWriter fileWriter = new FileWriter(file);
            PrintWriter printWriter = new PrintWriter((Writer)fileWriter, true);
            Rectangle rectangle = this.getBounds();
            printWriter.print(MAIN_BOUNDS);
            printWriter.print(" ");
            printWriter.print(rectangle.x);
            printWriter.print(" ");
            printWriter.print(rectangle.y);
            printWriter.print(" ");
            printWriter.print(rectangle.width);
            printWriter.print(" ");
            if (LEAppInfo.isUnix()) {
                printWriter.println(rectangle.height);
            } else {
                printWriter.println(rectangle.height + 19);
            }
            Dimension dimension = this.m_treePanel.getSize();
            printWriter.print(TREE_WIDTH);
            printWriter.print(" ");
            if (dimension.width < 0) {
                printWriter.println(0);
            } else {
                printWriter.println(dimension.width);
            }
            dimension = this.m_grid.getSize();
            printWriter.print(GRID_HEIGHT);
            printWriter.print(" ");
            if (dimension.height < 0) {
                printWriter.println(0);
                return;
            }
            printWriter.println(dimension.height);
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    void goodbye() {
        this.saveProperties();
        ((Component)this).setVisible(false);
        System.exit(0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

