/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.amf.LEAMFactory;
import COM.livingston.backend.LEDSSException;
import COM.livingston.backend.LEDSSPortMaster;
import COM.livingston.backend.LEDeltaFactory;
import COM.livingston.backend.LEDeltaLinesMessage;
import COM.livingston.backend.LEMonLinesMessage;
import COM.livingston.backend.LEMonitorFactory;
import COM.livingston.backend.LEStatusFactory;
import COM.livingston.backend.LEStatusMessage;
import COM.livingston.model.LEPortMaster;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEVector;

public class LEMonLinesView
extends LEMonitorPanel {
    public LEMonLinesView() {
        this.initialize(1, 2, 8);
        int n = this.getNumColumns();
        int n2 = 4;
        while (n2 < n) {
            this.setCellJustification(n2, 2);
            ++n2;
        }
        this.m_resetCols = new int[6];
        int n3 = 0;
        while (n3 < 6) {
            this.m_resetCols[n3] = n3 + 4;
            ++n3;
        }
    }

    public synchronized void update(LEAMFactory lEAMFactory, String string, Object object) {
        if (object instanceof LEDeltaLinesMessage) {
            LEDeltaLinesMessage lEDeltaLinesMessage = (LEDeltaLinesMessage)object;
            String string2 = lEDeltaLinesMessage.getName();
            Integer n = this.getRow(string, string2);
            if (n != null) {
                this.updateRow((int)n, lEDeltaLinesMessage);
                return;
            }
        } else {
            if (object instanceof LEMonLinesMessage) {
                LEMonLinesMessage lEMonLinesMessage = (LEMonLinesMessage)object;
                String string3 = lEMonLinesMessage.getName();
                Integer n = this.getRow(string, string3);
                if (n == null) {
                    this.createRow(string, string3, lEMonLinesMessage);
                    return;
                }
                this.updateRow((int)n, lEMonLinesMessage);
                return;
            }
            if (object instanceof LEStatusMessage) {
                this.updateStatus(string, (LEStatusMessage)object);
            }
        }
    }

    void createColumnTitles(int n, int n2, Object[] objectArray) {
        objectArray[n2++] = new String("Line");
        objectArray[n2++] = new String("Status");
        objectArray[n2++] = new String("Receive Level");
        objectArray[n2++] = new String("Blue Alarm");
        objectArray[n2++] = new String("Yellow Alarm");
        objectArray[n2++] = new String("Carrier Loss");
        objectArray[n2++] = new String("Sync Loss");
        objectArray[n2++] = new String("Bipolar Error");
        objectArray[n2++] = new String("CRC Error");
    }

    void createRow(String string, String string2, LEMonLinesMessage lEMonLinesMessage) {
        Object[] objectArray = new Object[this.getNumColumns()];
        int n = 0;
        objectArray[n++] = string;
        objectArray[n++] = lEMonLinesMessage.getName();
        objectArray[n++] = lEMonLinesMessage.getStatus();
        objectArray[n++] = lEMonLinesMessage.getRecvLevel();
        objectArray[n++] = new Long(lEMonLinesMessage.getBlueAlarm());
        objectArray[n++] = new Long(lEMonLinesMessage.getYellowAlarm());
        objectArray[n++] = new Long(lEMonLinesMessage.getCarrierLoss());
        objectArray[n++] = new Long(lEMonLinesMessage.getSyncLoss());
        objectArray[n++] = new Long(lEMonLinesMessage.getBIPolarError());
        objectArray[n++] = new Long(lEMonLinesMessage.getCRCError());
        this.addRow(string, string2, objectArray);
    }

    void updateRow(int n, LEMonLinesMessage lEMonLinesMessage) {
        int n2 = 0;
        ++n2;
        int n3 = ++n2;
        this.setCellItem(n, n3, lEMonLinesMessage.getStatus());
        int n4 = ++n2;
        ++n2;
        this.setCellItem(n, n4, lEMonLinesMessage.getRecvLevel());
        LEMonitorData lEMonitorData = (LEMonitorData)this.getRowObject(n);
        if (lEMonitorData == null) {
            return;
        }
        this.setCellItem(n, n2, lEMonitorData.getCounter(n2, lEMonLinesMessage.getBlueAlarm()));
        this.setCellItem(n, ++n2, lEMonitorData.getCounter(n2, lEMonLinesMessage.getYellowAlarm()));
        this.setCellItem(n, ++n2, lEMonitorData.getCounter(n2, lEMonLinesMessage.getCarrierLoss()));
        this.setCellItem(n, ++n2, lEMonitorData.getCounter(n2, lEMonLinesMessage.getSyncLoss()));
        this.setCellItem(n, ++n2, lEMonitorData.getCounter(n2, lEMonLinesMessage.getBIPolarError()));
        this.setCellItem(n, ++n2, lEMonitorData.getCounter(n2, lEMonLinesMessage.getCRCError()));
    }

    void updateRow(int n, LEDeltaLinesMessage lEDeltaLinesMessage) {
        int n2 = 0;
        ++n2;
        ++n2;
        ++n2;
        if (lEDeltaLinesMessage.getRecvLevelChanged()) {
            this.setCellItem(n, n2, lEDeltaLinesMessage.getRecvLevel());
        }
        ++n2;
        LEMonitorData lEMonitorData = (LEMonitorData)this.getRowObject(n);
        if (lEMonitorData == null) {
            return;
        }
        if (lEDeltaLinesMessage.getBlueAlarmChanged()) {
            this.setCellItem(n, n2, lEMonitorData.getCounter(n2, lEDeltaLinesMessage.getBlueAlarm()));
        }
        ++n2;
        if (lEDeltaLinesMessage.getYellowAlarmChanged()) {
            this.setCellItem(n, n2, lEMonitorData.getCounter(n2, lEDeltaLinesMessage.getYellowAlarm()));
        }
        ++n2;
        if (lEDeltaLinesMessage.getCarrierLossChanged()) {
            this.setCellItem(n, n2, lEMonitorData.getCounter(n2, lEDeltaLinesMessage.getCarrierLoss()));
        }
        ++n2;
        if (lEDeltaLinesMessage.getSyncLossChanged()) {
            this.setCellItem(n, n2, lEMonitorData.getCounter(n2, lEDeltaLinesMessage.getSyncLoss()));
        }
        ++n2;
        if (lEDeltaLinesMessage.getBIPolarErrorChanged()) {
            this.setCellItem(n, n2, lEMonitorData.getCounter(n2, lEDeltaLinesMessage.getBIPolarError()));
        }
        ++n2;
        if (lEDeltaLinesMessage.getCRCErrorChanged()) {
            this.setCellItem(n, n2, lEMonitorData.getCounter(n2, lEDeltaLinesMessage.getCRCError()));
        }
    }

    void startMonitoring(LEPortMaster lEPortMaster) {
        String string = lEPortMaster.getHostname();
        LEStatusFactory.GetFactory().addObserver(string, this);
        LEMonitorFactory.GetFactory().addObserver(string, this);
        LEDeltaFactory.GetFactory().addObserver(string, this);
        LEDSSPortMaster lEDSSPortMaster = lEPortMaster.getDSS();
        try {
            long l = lEDSSPortMaster.monitor(131072, 30000);
            LEVector lEVector = new LEVector();
            lEVector.addElement(new Long(l));
            this.m_monitors.put(string, lEVector);
            l = lEDSSPortMaster.delta(131072, 500);
            lEVector = new LEVector();
            lEVector.addElement(new Long(l));
            this.m_deltas.put(string, lEVector);
            return;
        }
        catch (LEDSSException lEDSSException) {
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }
}

