/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.amf.LEAMFactory;
import COM.livingston.backend.LEDSSException;
import COM.livingston.backend.LEDSSPortMaster;
import COM.livingston.backend.LEDeltaFactory;
import COM.livingston.backend.LEDeltaModemsMessage;
import COM.livingston.backend.LEMonModemsMessage;
import COM.livingston.backend.LEMonitorFactory;
import COM.livingston.backend.LEStatusFactory;
import COM.livingston.backend.LEStatusMessage;
import COM.livingston.model.LEModem;
import COM.livingston.model.LEPortMaster;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEVector;

public class LEMonModemsView
extends LEMonitorPanel
implements Runnable {
    static final String MONITOR_TIME = new String("30000");
    static final String DELTA_TIME = new String("250 0");
    Thread m_timer;
    boolean m_blinkOn = false;
    boolean m_flag = false;
    boolean m_run = true;

    public LEMonModemsView() {
        this.initialize(1, 3, 11);
        int n = this.getNumColumns();
        int n2 = 9;
        while (n2 < n) {
            this.setCellJustification(n2, 2);
            ++n2;
        }
        this.m_resetCols = new int[5];
        int n3 = 0;
        while (n3 < 5) {
            this.m_resetCols[n3] = n3 + 9;
            ++n3;
        }
    }

    public synchronized void update(LEAMFactory lEAMFactory, String string, Object object) {
        if (object instanceof LEDeltaModemsMessage) {
            LEDeltaModemsMessage lEDeltaModemsMessage = (LEDeltaModemsMessage)object;
            String string2 = lEDeltaModemsMessage.getName();
            Integer n = this.getRow(string, string2);
            if (n != null) {
                this.updateRow((int)n, lEDeltaModemsMessage);
                return;
            }
        } else {
            if (object instanceof LEMonModemsMessage) {
                LEMonModemsMessage lEMonModemsMessage = (LEMonModemsMessage)object;
                String string3 = lEMonModemsMessage.getName();
                Integer n = this.getRow(string, string3);
                if (n == null) {
                    this.createRow(string, string3, lEMonModemsMessage);
                    return;
                }
                this.updateRow((int)n, lEMonModemsMessage);
                return;
            }
            if (object instanceof LEStatusMessage) {
                this.updateStatus(string, (LEStatusMessage)object);
            }
        }
    }

    public void gone() {
        if (this.m_timer != null) {
            this.m_run = false;
            this.m_timer = null;
        }
        super.gone();
    }

    public void run() {
        while (this.m_run) {
            try {
                Thread.currentThread();
                Thread.sleep(250L);
                if (!this.m_run) continue;
                this.toggleTXRX();
                if (this.m_flag) {
                    this.toggleBlink();
                }
                this.m_flag = !this.m_flag;
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
            }
        }
    }

    void createColumnTitles(int n, int n2, Object[] objectArray) {
        objectArray[n2++] = new String("Modem");
        objectArray[n2++] = new String("");
        objectArray[n2++] = new String("Port");
        objectArray[n2++] = new String("State");
        objectArray[n2++] = new String("Protocol");
        objectArray[n2++] = new String("Compression");
        objectArray[n2++] = new String("RD Rate");
        objectArray[n2++] = new String("TR Rate");
        objectArray[n2++] = new String("RD Count");
        objectArray[n2++] = new String("TR Count");
        objectArray[n2++] = new String("Renegotiate");
        objectArray[n2++] = new String("Retrain");
        objectArray[n2++] = new String("Calls");
    }

    void createRow(String string, String string2, LEMonModemsMessage lEMonModemsMessage) {
        if (this.m_timer == null) {
            this.m_timer = new Thread(this);
            this.m_timer.start();
        }
        Object[] objectArray = new Object[14];
        int n = 0;
        objectArray[n++] = string;
        objectArray[n++] = lEMonModemsMessage.getName();
        LEModemLED3 lEModemLED3 = new LEModemLED3(new LEModem(lEMonModemsMessage));
        objectArray[n++] = lEModemLED3;
        objectArray[n++] = lEMonModemsMessage.getPortName();
        objectArray[n++] = lEModemLED3.getModem().getStateString();
        objectArray[n++] = lEMonModemsMessage.getProtocol();
        objectArray[n++] = lEMonModemsMessage.getCompression();
        objectArray[n++] = lEMonModemsMessage.getRXRate();
        objectArray[n++] = lEMonModemsMessage.getTXRate();
        objectArray[n++] = new Long(lEMonModemsMessage.getRXCount());
        objectArray[n++] = new Long(lEMonModemsMessage.getTXCount());
        objectArray[n++] = new Long(lEMonModemsMessage.getRenegotiate());
        objectArray[n++] = new Long(lEMonModemsMessage.getRetrain());
        objectArray[n++] = new Long(lEMonModemsMessage.getCalls());
        this.addRow(string, string2, objectArray);
    }

    void updateRow(int n, LEMonModemsMessage lEMonModemsMessage) {
        int n2 = 0;
        ++n2;
        LEModemLED3 lEModemLED3 = (LEModemLED3)this.getCellItem(n, ++n2);
        lEModemLED3.getModem().setState(lEMonModemsMessage);
        this.setCellItem(n, n2++, lEModemLED3);
        this.setCellItem(n, n2++, lEMonModemsMessage.getPortName());
        this.setCellItem(n, n2++, lEModemLED3.getModem().getStateString());
        this.setCellItem(n, n2++, lEMonModemsMessage.getProtocol());
        this.setCellItem(n, n2++, lEMonModemsMessage.getCompression());
        this.setCellItem(n, n2++, lEMonModemsMessage.getRXRate());
        this.setCellItem(n, n2++, lEMonModemsMessage.getTXRate());
        LEMonitorData lEMonitorData = (LEMonitorData)this.getRowObject(n);
        if (lEMonitorData == null) {
            return;
        }
        this.setCellItem(n, n2, lEMonitorData.getCounter(n2, lEMonModemsMessage.getRXCount()));
        this.setCellItem(n, ++n2, lEMonitorData.getCounter(n2, lEMonModemsMessage.getTXCount()));
        this.setCellItem(n, ++n2, lEMonitorData.getCounter(n2, lEMonModemsMessage.getRenegotiate()));
        this.setCellItem(n, ++n2, lEMonitorData.getCounter(n2, lEMonModemsMessage.getRetrain()));
        this.setCellItem(n, ++n2, lEMonitorData.getCounter(n2, lEMonModemsMessage.getCalls()));
    }

    void updateRow(int n, LEDeltaModemsMessage lEDeltaModemsMessage) {
        int n2 = 0;
        ++n2;
        LEModemLED3 lEModemLED3 = (LEModemLED3)this.getCellItem(n, ++n2);
        lEModemLED3.getModem().setState(lEDeltaModemsMessage);
        this.setCellItem(n, n2++, lEModemLED3);
        int n3 = ++n2;
        ++n2;
        this.setCellItem(n, n3, lEModemLED3.getModem().getStateString());
        ++n2;
        ++n2;
        if (lEDeltaModemsMessage.getRXRateChanged()) {
            this.setCellItem(n, n2, lEDeltaModemsMessage.getRXRate());
        }
        ++n2;
        if (lEDeltaModemsMessage.getTXRateChanged()) {
            this.setCellItem(n, n2, lEDeltaModemsMessage.getTXRate());
        }
        ++n2;
        LEMonitorData lEMonitorData = (LEMonitorData)this.getRowObject(n);
        if (lEMonitorData == null) {
            return;
        }
        if (lEDeltaModemsMessage.getRXCountChanged()) {
            this.setCellItem(n, n2, lEMonitorData.getCounter(n2, lEDeltaModemsMessage.getRXCount()));
        }
        ++n2;
        if (lEDeltaModemsMessage.getTXCountChanged()) {
            this.setCellItem(n, n2, lEMonitorData.getCounter(n2, lEDeltaModemsMessage.getTXCount()));
        }
        ++n2;
        if (lEDeltaModemsMessage.getRenegotiateChanged()) {
            this.setCellItem(n, n2, lEMonitorData.getCounter(n2, lEDeltaModemsMessage.getRenegotiate()));
        }
        ++n2;
        if (lEDeltaModemsMessage.getRetrainChanged()) {
            this.setCellItem(n, n2, lEMonitorData.getCounter(n2, lEDeltaModemsMessage.getRetrain()));
        }
    }

    void toggleTXRX() {
        int n = this.getNumRows();
        int n2 = 2;
        int n3 = 0;
        while (n3 < n) {
            LEModemLED3 lEModemLED3 = (LEModemLED3)this.getCellItem(n3, n2);
            LEModem lEModem = lEModemLED3.getModem();
            if (lEModem.getState() > 7) {
                lEModem.setState(7, false, false);
                this.setCellItem(n3, n2, lEModemLED3);
            }
            ++n3;
        }
    }

    void toggleBlink() {
        this.m_blinkOn = !this.m_blinkOn;
        int n = this.getNumRows();
        int n2 = 2;
        int n3 = 0;
        while (n3 < n) {
            LEModemLED3 lEModemLED3 = (LEModemLED3)this.getCellItem(n3, n2);
            lEModemLED3.blink(this.m_blinkOn);
            int n4 = lEModemLED3.getModem().getState();
            if (n4 == 3 || n4 == 5 || n4 == 6) {
                this.setCellItem(n3, n2, lEModemLED3);
            }
            ++n3;
        }
    }

    void startMonitoring(LEPortMaster lEPortMaster) {
        String string = lEPortMaster.getHostname();
        LEStatusFactory.GetFactory().addObserver(string, this);
        LEMonitorFactory.GetFactory().addObserver(string, this);
        LEDeltaFactory.GetFactory().addObserver(string, this);
        LEDSSPortMaster lEDSSPortMaster = lEPortMaster.getDSS();
        try {
            long l = lEDSSPortMaster.monitor(196608, 30000);
            LEVector lEVector = new LEVector();
            lEVector.addElement(new Long(l));
            this.m_monitors.put(string, lEVector);
            l = lEDSSPortMaster.delta(196608, 250);
            lEVector = new LEVector();
            lEVector.addElement(new Long(l));
            this.m_deltas.put(string, lEVector);
            return;
        }
        catch (LEDSSException lEDSSException) {
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }
}

