/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.amf.LEAMFactory;
import COM.livingston.backend.LEDSSException;
import COM.livingston.backend.LEDSSPortMaster;
import COM.livingston.backend.LEDeltaFactory;
import COM.livingston.backend.LEDeltaSessionsMessage;
import COM.livingston.backend.LEMonSessionsMessage;
import COM.livingston.backend.LEMonitorFactory;
import COM.livingston.backend.LEStatusFactory;
import COM.livingston.backend.LEStatusMessage;
import COM.livingston.model.LEPortMaster;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEVector;

public class LEMonSessionsView
extends LEMonitorPanel {
    public LEMonSessionsView() {
        this.initialize(1, 2, 11);
        int n = this.getNumColumns();
        int n2 = 8;
        while (n2 < n) {
            this.setCellJustification(n2, 2);
            ++n2;
        }
        this.m_resetCols = new int[3];
        int n3 = 0;
        while (n3 < 3) {
            this.m_resetCols[n3] = n3 + 10;
            ++n3;
        }
    }

    public synchronized void update(LEAMFactory lEAMFactory, String string, Object object) {
        if (object instanceof LEDeltaSessionsMessage) {
            LEDeltaSessionsMessage lEDeltaSessionsMessage = (LEDeltaSessionsMessage)object;
            String string2 = lEDeltaSessionsMessage.getName();
            Integer n = this.getRow(string, string2);
            if (n != null) {
                this.updateRow((int)n, lEDeltaSessionsMessage);
                return;
            }
        } else {
            if (object instanceof LEMonSessionsMessage) {
                LEMonSessionsMessage lEMonSessionsMessage = (LEMonSessionsMessage)object;
                String string3 = lEMonSessionsMessage.getName();
                Integer n = this.getRow(string, string3);
                if (n == null) {
                    this.createRow(string, string3, lEMonSessionsMessage);
                    return;
                }
                this.updateRow((int)n, lEMonSessionsMessage);
                return;
            }
            if (object instanceof LEStatusMessage) {
                this.updateStatus(string, (LEStatusMessage)object);
            }
        }
    }

    void createColumnTitles(int n, int n2, Object[] objectArray) {
        objectArray[n2++] = new String("Port");
        objectArray[n2++] = new String("User");
        objectArray[n2++] = new String("Destination");
        objectArray[n2++] = new String("Port Config");
        objectArray[n2++] = new String("Direction");
        objectArray[n2++] = new String("Status");
        objectArray[n2++] = new String("Modem");
        objectArray[n2++] = new String("Start Time");
        objectArray[n2++] = new String("Idle Time");
        objectArray[n2++] = new String("In Bytes");
        objectArray[n2++] = new String("Out Bytes");
        objectArray[n2++] = new String("Pending Bytes");
    }

    void createRow(String string, String string2, LEMonSessionsMessage lEMonSessionsMessage) {
        Object[] objectArray = new Object[13];
        int n = 0;
        objectArray[n++] = string;
        objectArray[n++] = lEMonSessionsMessage.getPortName();
        objectArray[n++] = lEMonSessionsMessage.getUsername();
        objectArray[n++] = lEMonSessionsMessage.getHostname();
        objectArray[n++] = lEMonSessionsMessage.getPortType();
        objectArray[n++] = lEMonSessionsMessage.getDirection();
        objectArray[n++] = lEMonSessionsMessage.getStatus();
        objectArray[n++] = lEMonSessionsMessage.getModem();
        objectArray[n++] = lEMonSessionsMessage.getStartTime();
        objectArray[n++] = lEMonSessionsMessage.getIdleTime();
        objectArray[n++] = new Long(lEMonSessionsMessage.getInputBytes());
        objectArray[n++] = new Long(lEMonSessionsMessage.getOutputBytes());
        objectArray[n++] = new Long(lEMonSessionsMessage.getPendingBytes());
        this.addRow(string, string2, objectArray);
    }

    void updateRow(int n, LEMonSessionsMessage lEMonSessionsMessage) {
        int n2 = 0;
        ++n2;
        int n3 = ++n2;
        this.setCellItem(n, n3, lEMonSessionsMessage.getUsername());
        int n4 = ++n2;
        this.setCellItem(n, n4, lEMonSessionsMessage.getHostname());
        int n5 = ++n2;
        this.setCellItem(n, n5, lEMonSessionsMessage.getPortType());
        int n6 = ++n2;
        this.setCellItem(n, n6, lEMonSessionsMessage.getDirection());
        int n7 = ++n2;
        this.setCellItem(n, n7, lEMonSessionsMessage.getStatus());
        int n8 = ++n2;
        this.setCellItem(n, n8, lEMonSessionsMessage.getModem());
        int n9 = ++n2;
        this.setCellItem(n, n9, lEMonSessionsMessage.getStartTime());
        int n10 = ++n2;
        ++n2;
        this.setCellItem(n, n10, lEMonSessionsMessage.getIdleTime());
        LEMonitorData lEMonitorData = (LEMonitorData)this.getRowObject(n);
        if (lEMonitorData == null) {
            return;
        }
        this.setCellItem(n, n2, lEMonitorData.getCounter(n2, lEMonSessionsMessage.getInputBytes()));
        this.setCellItem(n, ++n2, lEMonitorData.getCounter(n2, lEMonSessionsMessage.getOutputBytes()));
        this.setCellItem(n, ++n2, lEMonitorData.getCounter(n2, lEMonSessionsMessage.getPendingBytes()));
    }

    void updateRow(int n, LEDeltaSessionsMessage lEDeltaSessionsMessage) {
        int n2 = 0;
        ++n2;
        ++n2;
        ++n2;
        ++n2;
        ++n2;
        ++n2;
        if (lEDeltaSessionsMessage.getStatusChanged()) {
            this.setCellItem(n, n2, lEDeltaSessionsMessage.getStatus());
        }
        ++n2;
        ++n2;
        ++n2;
        ++n2;
        LEMonitorData lEMonitorData = (LEMonitorData)this.getRowObject(n);
        if (lEMonitorData == null) {
            return;
        }
        if (lEDeltaSessionsMessage.getInputBytesChanged()) {
            this.setCellItem(n, n2, lEMonitorData.getCounter(n2, lEDeltaSessionsMessage.getInputBytes()));
        }
        ++n2;
        if (lEDeltaSessionsMessage.getOutputBytesChanged()) {
            this.setCellItem(n, n2, lEMonitorData.getCounter(n2, lEDeltaSessionsMessage.getOutputBytes()));
        }
        ++n2;
        if (lEDeltaSessionsMessage.getPendingBytesChanged()) {
            this.setCellItem(n, n2, lEMonitorData.getCounter(n2, lEDeltaSessionsMessage.getPendingBytes()));
        }
    }

    void startMonitoring(LEPortMaster lEPortMaster) {
        String string = lEPortMaster.getHostname();
        LEStatusFactory.GetFactory().addObserver(string, this);
        LEMonitorFactory.GetFactory().addObserver(string, this);
        LEDeltaFactory.GetFactory().addObserver(string, this);
        LEDSSPortMaster lEDSSPortMaster = lEPortMaster.getDSS();
        try {
            long l = lEDSSPortMaster.monitor(65536, 30000);
            LEVector lEVector = new LEVector();
            lEVector.addElement(new Long(l));
            this.m_monitors.put(string, lEVector);
            l = lEDSSPortMaster.delta(65536, 1000);
            lEVector = new LEVector();
            lEVector.addElement(new Long(l));
            this.m_deltas.put(string, lEVector);
            return;
        }
        catch (LEDSSException lEDSSException) {
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }
}

