/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.model.LEPortMaster;
import COM.livingston.ui.LEColor;
import COM.livingston.ui.LEScrollPanel;
import COM.livingston.ui.LEScrollable;
import COM.livingston.util.LEDebug;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.Hashtable;

public class LEMonitorView
extends Canvas
implements LEView,
LEScrollable,
MouseListener,
Runnable {
    public static final String PREFIX = "LE";
    public static final String SUFFIX = "Display";
    public static final String DEFAULT = "PM";
    static Hashtable s_classes = new Hashtable();
    static int s_border = 5;
    static LELegendDisplay s_legend;
    LEViewListener m_listener;
    LEScrollPanel m_scroll;
    Image m_buf;
    LEMonitorDisplay[] m_displays;
    LEPortMaster[] m_pms;
    Thread m_flash;
    boolean m_layout = true;
    boolean m_redraw = true;
    int m_maxHeight;
    int m_maxWidth;
    int m_height;
    int m_width;
    int m_columns;
    int m_rows;
    int m_x;
    int m_y;

    public static LEMonitorDisplay GetDisplay(LEPortMaster lEPortMaster) {
        Serializable serializable;
        String string;
        LEMonitorDisplay lEMonitorDisplay = null;
        String string2 = lEPortMaster.getHardwareType();
        if (string2 == null || string2.length() == 0) {
            string2 = DEFAULT;
        }
        if ((string = (String)s_classes.get(string2)) == null) {
            string = string2.replace(' ', '_');
            string = string.replace('-', '_');
            serializable = new StringBuffer(PREFIX);
            ((StringBuffer)serializable).append(string);
            ((StringBuffer)serializable).append(SUFFIX);
            string = new String((StringBuffer)serializable);
            s_classes.put(string2, string);
        }
        try {
            serializable = Class.forName(string);
            Object obj = ((Class)serializable).newInstance();
            if (obj instanceof LEMonitorDisplay) {
                lEMonitorDisplay = (LEMonitorDisplay)obj;
            } else {
                LEDebug.getLog().logln(20, "Class " + string + " is not a subclass of LEMonitorDisplay");
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        if (lEMonitorDisplay == null) {
            lEMonitorDisplay = new LEPMDisplay();
        }
        lEMonitorDisplay.setPortMaster(lEPortMaster);
        return lEMonitorDisplay;
    }

    public LEMonitorView() {
        this.addMouseListener(this);
        this.m_scroll = new LEScrollPanel(this);
    }

    public void addNotify() {
        super.addNotify();
        this.determineLayout();
        this.m_flash = new Thread(this);
        this.m_flash.setName("Monitor LED Timer");
        this.m_flash.start();
    }

    public void setSelection(LEPortMaster[] lEPortMasterArray) {
        int n = lEPortMasterArray.length;
        if (n > 0) {
            ++n;
        }
        LEMonitorDisplay[] lEMonitorDisplayArray = new LEMonitorDisplay[n];
        int n2 = 0;
        while (n2 < lEPortMasterArray.length) {
            lEMonitorDisplayArray[n2] = null;
            if (this.m_pms != null) {
                int n3 = 0;
                while (n3 < this.m_pms.length) {
                    if (this.m_pms[n3] == lEPortMasterArray[n2]) {
                        lEMonitorDisplayArray[n2] = this.m_displays[n3];
                    } else {
                        this.m_displays[n3].shutdown();
                    }
                    ++n3;
                }
            }
            if (lEMonitorDisplayArray[n2] == null) {
                lEMonitorDisplayArray[n2] = LEMonitorView.GetDisplay(lEPortMasterArray[n2]);
            }
            ++n2;
        }
        if (n > 0) {
            if (s_legend == null) {
                s_legend = new LELegendDisplay();
            }
            lEMonitorDisplayArray[n - 1] = s_legend;
        }
        this.m_pms = lEPortMasterArray;
        this.m_displays = lEMonitorDisplayArray;
        this.m_layout = true;
        this.m_redraw = true;
        this.repaint();
    }

    public void going() {
        this.m_flash.stop();
        int n = 0;
        while (n < this.m_displays.length) {
            this.m_displays[n].shutdown();
            ++n;
        }
    }

    public void gone() {
    }

    public Component getMainPanel() {
        return this.m_scroll;
    }

    public Component getBottomPanel() {
        return null;
    }

    public void addListener(LEViewListener lEViewListener) {
        this.m_listener = lEViewListener;
    }

    public void deleteListener(LEViewListener lEViewListener) {
        if (this.m_listener == lEViewListener) {
            this.m_listener = null;
        }
    }

    public void run() {
        boolean bl = false;
        int n = 0;
        while (true) {
            try {
                while (true) {
                    Thread.currentThread();
                    Thread.sleep(500L);
                    bl = !bl;
                    int n2 = this.blink(bl);
                    if (++n == 10) {
                        n2 |= this.heartbeat();
                        n = 0;
                    }
                    if ((n2 & 4) > 0) {
                        this.m_layout = true;
                        this.repaint();
                        continue;
                    }
                    if ((n2 & 2) > 0) {
                        this.m_redraw = true;
                        this.repaint();
                        continue;
                    }
                    if ((n2 & 1) <= 0) continue;
                    this.repaint();
                }
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
                continue;
            }
            break;
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        boolean bl = this.m_redraw;
        if (this.m_layout) {
            bl = true;
            this.determineLayout();
        }
        if (this.m_buf == null || this.m_width != this.m_buf.getWidth(null) || this.m_height != this.m_buf.getHeight(null)) {
            if (this.m_buf != null) {
                this.m_buf.flush();
                this.m_buf = null;
            }
            if (this.m_width > 0 && this.m_height > 0) {
                this.m_buf = this.createImage(this.m_width, this.m_height);
            }
            bl = true;
        }
        if (bl) {
            Dimension dimension = this.getSize();
            graphics.setColor(LEColor.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            this.draw();
        }
        if (this.m_buf != null) {
            graphics.drawImage(this.m_buf, this.m_x, this.m_y, null);
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        Dimension dimension = this.getSize();
        if (dimension.width != n3 || dimension.height != n4) {
            this.m_layout = true;
        }
        super.setBounds(n, n2, n3, n4);
    }

    public void setBounds(Rectangle rectangle) {
        this.m_layout = true;
        super.setBounds(rectangle);
    }

    public void setSize(int n, int n2) {
        this.m_layout = true;
        super.setSize(n, n2);
    }

    public void setSize(Dimension dimension) {
        this.m_layout = true;
        super.setSize(dimension);
    }

    public void setScrollPanel(LEScrollPanel lEScrollPanel) {
    }

    public void setOrigin(int n, int n2) {
        this.m_x = n;
        this.m_y = n2;
    }

    public void scrollTo(int n, int n2) {
        this.m_x = n;
        this.m_y = n2;
        this.repaint();
    }

    public void startScroll() {
    }

    public void endScroll() {
    }

    public Dimension totalArea() {
        return new Dimension(this.m_width, this.m_height);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n;
        if (this.m_listener == null) {
            return;
        }
        int n2 = mouseEvent.getX() - this.m_x;
        int n3 = mouseEvent.getY() - this.m_y;
        int n4 = n2 / (this.m_maxWidth + 2 * s_border);
        int n5 = n3 / (this.m_maxHeight + 2 * s_border);
        if (n4 >= this.m_columns) {
            n4 = this.m_columns - 1;
        }
        if (n5 >= this.m_rows) {
            n5 = this.m_rows - 1;
        }
        if ((n = n5 * this.m_columns + n4) < this.m_displays.length) {
            this.m_displays[n].select(n2, n3, this.m_listener);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    synchronized int heartbeat() {
        Graphics graphics;
        int n = 0;
        if (this.m_displays != null && this.m_buf != null && (graphics = this.m_buf.getGraphics()) != null) {
            int n2 = 0;
            while (n2 < this.m_displays.length) {
                n |= this.m_displays[n2].heartbeat(graphics);
                ++n2;
            }
            graphics.dispose();
        }
        return n;
    }

    synchronized int blink(boolean bl) {
        Graphics graphics;
        int n = 0;
        if (this.m_displays != null && this.m_buf != null && (graphics = this.m_buf.getGraphics()) != null) {
            int n2 = 0;
            while (n2 < this.m_displays.length) {
                n |= this.m_displays[n2].blink(graphics, bl);
                ++n2;
            }
            graphics.dispose();
        }
        return n;
    }

    void determineLayout() {
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        Dimension dimension = this.getSize();
        this.m_layout = false;
        this.m_maxHeight = 0;
        this.m_maxWidth = 0;
        int n = 0;
        while (n < this.m_displays.length) {
            int n2 = this.m_displays[n].getWidth(graphics);
            if (n2 > 0) {
                this.m_maxWidth = Math.max(this.m_maxWidth, n2);
            } else {
                this.m_layout = true;
            }
            int n3 = this.m_displays[n].getHeight(graphics);
            if (n3 > 0) {
                this.m_maxHeight = Math.max(this.m_maxHeight, n3);
            } else {
                this.m_layout = true;
            }
            ++n;
        }
        this.m_columns = this.m_maxWidth > 0 ? (dimension.width - 20) / this.m_maxWidth : this.m_displays.length;
        if (this.m_columns < 1) {
            this.m_columns = 1;
        } else if (this.m_columns > this.m_displays.length) {
            this.m_columns = this.m_displays.length;
        }
        this.m_rows = (this.m_displays.length - 1) / this.m_columns + 1;
        this.m_width = this.m_columns * (this.m_maxWidth + 2 * s_border);
        this.m_height = this.m_rows * (this.m_maxHeight + 2 * s_border);
        graphics.dispose();
        if (this.m_scroll != null) {
            this.m_scroll.updateScrollbars(this.m_width, this.m_height);
        }
    }

    void draw() {
        if (this.m_buf == null) {
            return;
        }
        Graphics graphics = this.m_buf.getGraphics();
        if (graphics == null) {
            return;
        }
        graphics.setColor(LEColor.getBackground());
        graphics.fillRect(0, 0, this.m_width, this.m_height);
        int n = s_border;
        int n2 = s_border;
        int n3 = 0;
        while (n3 < this.m_displays.length) {
            this.m_displays[n3].draw(graphics, n, n2);
            if ((n3 + 1) % this.m_columns == 0) {
                n = s_border;
                n2 += this.m_maxHeight + 2 * s_border;
            } else {
                n += this.m_maxWidth + 2 * s_border;
            }
            ++n3;
        }
        graphics.dispose();
        this.m_redraw = false;
    }
}

