/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.amf.LEAMFactory;
import COM.livingston.amf.LEAMObserver;
import COM.livingston.backend.LEDSSPortMaster;
import COM.livingston.backend.LEDeltaFactory;
import COM.livingston.backend.LEDeltaSessionsMessage;
import COM.livingston.backend.LEMonSessionsMessage;
import COM.livingston.backend.LEMonitorFactory;
import COM.livingston.backend.LEStatusFactory;
import COM.livingston.backend.LEStatusMessage;
import COM.livingston.model.LEPortMaster;
import COM.livingston.ui.LEColor;
import COM.livingston.ui.LEFont;
import COM.livingston.ui.LELEDs;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LELoggedException;
import COM.livingston.util.LEResource;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;

public class LEPM_25Display
implements LEMonitorDisplay,
LEAMObserver,
ImageObserver {
    public static final int MAX_MODEMS = 25;
    public static final String ESTAB = "Established";
    static Image s_pm25 = null;
    LEPortMaster m_pm;
    String m_host;
    int m_height = -1;
    int m_width = -1;
    int m_nameHeight;
    int m_x;
    int m_y;
    int m_flags;
    boolean m_blink;
    boolean m_active;
    boolean m_connected;
    boolean m_drawHeartbeat;
    boolean m_drawInterfaces;
    boolean m_drawSessions;
    Image m_hb;
    Image m_etherTop;
    Image m_etherBottom;
    Image[] m_sessions = new Image[25];
    long[] m_deltas;
    long[] m_monitors;

    public LEPM_25Display() {
        if (s_pm25 == null) {
            s_pm25 = LEResource.GetImage("pm25.gif");
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            if (!toolkit.prepareImage(s_pm25, -1, -1, this)) {
                this.m_flags = 2;
            }
        }
        this.m_hb = LELEDs.GetLED(LELEDs.GREEN);
        this.m_etherTop = LELEDs.GetLED(LELEDs.GREEN);
        this.m_etherBottom = LELEDs.GetLED(LELEDs.GRAY);
        int n = 0;
        while (n < this.m_sessions.length) {
            this.m_sessions[n] = LELEDs.GetLED(LELEDs.GRAY);
            ++n;
        }
    }

    public void setPortMaster(LEPortMaster lEPortMaster) {
        this.m_pm = lEPortMaster;
        this.m_host = this.m_pm.getHostname();
        this.m_connected = this.m_pm.isConnected();
        LEStatusFactory.GetFactory().addObserver(this.m_host, this);
        LEDeltaFactory.GetFactory().addObserver(this.m_host, this);
        LEMonitorFactory.GetFactory().addObserver(this.m_host, this);
        if (!this.m_connected) {
            this.m_hb = LELEDs.GetLED(LELEDs.GRAY);
            this.m_etherTop = LELEDs.GetLED(LELEDs.GRAY);
            this.m_etherBottom = LELEDs.GetLED(LELEDs.GRAY);
        }
        this.m_active = this.m_pm.getDSS().supportsEntities();
        if (this.m_active) {
            this.startMonitoring();
        }
    }

    public void select(int n, int n2, LEViewListener lEViewListener) {
    }

    public int getHeight(Graphics graphics) {
        if (this.m_height < 1) {
            this.determineSize(graphics);
            this.m_flags |= 4;
        }
        return this.m_height;
    }

    public int getWidth(Graphics graphics) {
        if (this.m_width < 1) {
            this.determineSize(graphics);
            this.m_flags |= 4;
        }
        return this.m_width;
    }

    public void draw(Graphics graphics, int n, int n2) {
        if (this.m_width == -1 || this.m_height == -1) {
            this.determineSize(graphics);
        }
        if (this.m_width == -1 || this.m_height == -1) {
            return;
        }
        graphics.setColor(LEColor.getBackground());
        graphics.fillRect(n, n2, this.m_width, this.m_height);
        Font font = LEFont.getBoldFont();
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n3 = n + (this.m_width - fontMetrics.stringWidth(this.m_host)) / 2;
        graphics.setColor(LEColor.getForeground());
        graphics.drawString(this.m_host, n3, n2 + fontMetrics.getAscent());
        this.m_nameHeight = fontMetrics.getHeight() + 2;
        this.m_x = n;
        this.m_y = n2 + this.m_nameHeight;
        graphics.drawImage(s_pm25, this.m_x, this.m_y, this);
        if (this.m_active && this.m_connected) {
            this.drawHeartbeat(graphics);
            this.drawInterfaces(graphics);
            this.drawSessions(graphics);
            return;
        }
        if (this.m_active) {
            graphics.setFont(LEFont.getFont());
            fontMetrics = graphics.getFontMetrics();
            int n4 = fontMetrics.stringWidth("Not connected") + 20;
            int n5 = fontMetrics.getHeight() + 20;
            n3 = this.m_x + (this.m_width - n4) / 2;
            int n6 = this.m_y + (this.m_height - this.m_nameHeight - n5) / 2;
            this.drawBox(graphics, n3, n6, n4, n5);
            graphics.drawString("Not connected", n3 + 10, n6 + 10 + fontMetrics.getAscent());
            return;
        }
        graphics.setFont(LEFont.getFont());
        fontMetrics = graphics.getFontMetrics();
        int n7 = fontMetrics.stringWidth("Monitoring requires ComOS 3.8 or later") + 20;
        int n8 = fontMetrics.getHeight() + 20;
        n3 = this.m_x + (this.m_width - n7) / 2;
        int n9 = this.m_y + (this.m_height - this.m_nameHeight - n8) / 2;
        this.drawBox(graphics, n3, n9, n7, n8);
        graphics.drawString("Monitoring requires ComOS 3.8 or later", n3 + 10, n9 + 10 + fontMetrics.getAscent());
    }

    public synchronized int heartbeat(Graphics graphics) {
        if (this.m_active && this.m_connected) {
            this.m_hb = LELEDs.GetLED(LELEDs.GRAY);
            this.drawHeartbeat(graphics);
            this.m_drawHeartbeat = true;
            return 1;
        }
        return 0;
    }

    public synchronized int blink(Graphics graphics, boolean bl) {
        this.m_blink = bl;
        if (this.m_active && this.m_connected && this.m_drawHeartbeat) {
            this.m_hb = LELEDs.GetLED(LELEDs.GREEN);
            this.drawHeartbeat(graphics);
        }
        if (this.m_active && this.m_connected && this.m_drawInterfaces) {
            this.drawInterfaces(graphics);
        }
        if (this.m_active && this.m_drawSessions) {
            this.drawSessions(graphics);
        }
        int n = this.m_flags;
        this.m_flags = 0;
        return n;
    }

    public void shutdown() {
        LEStatusFactory.GetFactory().deleteObserver(this.m_host, this);
        LEDeltaFactory.GetFactory().deleteObserver(this.m_host, this);
        LEMonitorFactory.GetFactory().deleteObserver(this.m_host, this);
        this.stopMonitoring();
    }

    public synchronized boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0x20) != 0) {
            this.m_flags |= 2;
            return false;
        }
        return true;
    }

    public synchronized void update(LEAMFactory lEAMFactory, String string, Object object) {
        if (object instanceof LEDeltaSessionsMessage) {
            this.updateSession((LEDeltaSessionsMessage)object);
            return;
        }
        if (object instanceof LEMonSessionsMessage) {
            this.updateSession((LEMonSessionsMessage)object);
            return;
        }
        if (object instanceof LEStatusMessage) {
            this.updateStatus((LEStatusMessage)object);
        }
    }

    void determineSize(Graphics graphics) {
        this.m_width = s_pm25.getWidth(this);
        this.m_height = s_pm25.getHeight(this);
        if (this.m_width == -1 || this.m_height == -1) {
            return;
        }
        Font font = LEFont.getBoldFont();
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        this.m_height += fontMetrics.getHeight() + 4;
    }

    void startMonitoring() {
        this.m_monitors = new long[1];
        this.m_deltas = new long[1];
        try {
            LEDSSPortMaster lEDSSPortMaster = this.m_pm.getDSS();
            this.m_monitors[0] = lEDSSPortMaster.monitor(65536, 30000);
            this.m_deltas[0] = lEDSSPortMaster.delta(65536, 1000);
            return;
        }
        catch (LELoggedException lELoggedException) {
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    void stopMonitoring() {
        try {
            int n;
            LEDSSPortMaster lEDSSPortMaster = this.m_pm.getDSS();
            if (this.m_deltas != null) {
                n = 0;
                while (n < this.m_deltas.length) {
                    lEDSSPortMaster.killDelta(this.m_deltas[n]);
                    ++n;
                }
            }
            if (this.m_monitors != null) {
                n = 0;
                while (n < this.m_monitors.length) {
                    if (this.m_monitors[n] > 0L) {
                        lEDSSPortMaster.killMonitor(this.m_monitors[n]);
                    }
                    ++n;
                }
            }
        }
        catch (LELoggedException lELoggedException) {
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        this.m_deltas = null;
        this.m_monitors = null;
    }

    void updateSession(LEDeltaSessionsMessage lEDeltaSessionsMessage) {
        String string = lEDeltaSessionsMessage.getName();
        try {
            int n = Integer.parseInt(string);
            this.updateSession(n, lEDeltaSessionsMessage.getStatus());
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    void updateSession(LEMonSessionsMessage lEMonSessionsMessage) {
        String string = lEMonSessionsMessage.getPortName();
        if (string.charAt(0) != 'S') {
            return;
        }
        try {
            int n = Integer.parseInt(string.substring(1, string.length()));
            this.updateSession(n, lEMonSessionsMessage.getStatus());
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    void updateSession(int n, String string) {
        try {
            this.m_sessions[n] = string.equalsIgnoreCase(ESTAB) ? LELEDs.GetLED(LELEDs.BLUE) : LELEDs.GetLED(LELEDs.GRAY);
            this.m_drawSessions = true;
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    void updateStatus(LEStatusMessage lEStatusMessage) {
        switch (lEStatusMessage.getStatus()) {
            case 1: {
                this.m_active = this.m_pm.getDSS().supportsEntities();
                if (this.m_active) {
                    this.startMonitoring();
                }
                this.m_connected = true;
                this.m_hb = LELEDs.GetLED(LELEDs.GREEN);
                this.m_etherTop = LELEDs.GetLED(LELEDs.GREEN);
                this.m_etherBottom = LELEDs.GetLED(LELEDs.GRAY);
                this.m_flags |= 2;
                return;
            }
            case 2: 
            case 4: {
                this.m_connected = false;
                this.m_hb = LELEDs.GetLED(LELEDs.GRAY);
                this.m_etherTop = LELEDs.GetLED(LELEDs.GRAY);
                this.m_etherBottom = LELEDs.GetLED(LELEDs.GRAY);
                this.m_flags |= 2;
                return;
            }
        }
    }

    void drawHeartbeat(Graphics graphics) {
        graphics.drawImage(this.m_hb, this.m_x + 180, this.m_y + 34, null);
        this.m_drawHeartbeat = false;
        this.m_flags |= 1;
    }

    void drawInterfaces(Graphics graphics) {
        graphics.drawImage(this.m_etherTop, this.m_x + 303, this.m_y + 33, null);
        graphics.drawImage(this.m_etherBottom, this.m_x + 303, this.m_y + 44, null);
        this.m_flags |= 1;
        this.m_drawInterfaces = false;
    }

    void drawSessions(Graphics graphics) {
        int n = 0;
        while (n < this.m_sessions.length) {
            this.drawSession(graphics, n);
            ++n;
        }
        this.m_flags |= 1;
        this.m_drawSessions = false;
    }

    void drawSession(Graphics graphics, int n) {
        int n2;
        if (this.m_sessions[n] == null) {
            return;
        }
        int n3 = 20;
        int n4 = n % 8 - 1;
        if (n == 0) {
            n2 = 127;
            n3 = 39;
        } else {
            n2 = n > 0 && n < 9 ? 178 + n4 * 7 : (n > 5 && n < 17 ? 258 + n4 * 7 : 338 + n4 * 7);
        }
        graphics.drawImage(this.m_sessions[n], n2, n3, null);
    }

    void drawBox(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(Color.white);
        graphics.fillRect(n, n2, n3, n4);
        graphics.setColor(Color.black);
        graphics.drawRect(n, n2, n3, n4);
        graphics.drawRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
    }
}

