/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.dialog.directory;

import java.awt.Image;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import oracle.ewt.dTree.DTree;
import oracle.ewt.dTree.DTreeItem;
import oracle.ewt.dTree.DTreeRange;
import oracle.ewt.dTree.DTreeRangeSet;
import oracle.ewt.dTree.DTreeRootItem;
import oracle.ewt.dTree.DTreeSelection;
import oracle.ewt.dTree.DTreeSimpleParent;
import oracle.ewt.dTree.DTreeSimpleRoot;
import oracle.ewt.dialog.directory.DirectoryFilter;
import oracle.ewt.dialog.directory.DirectoryItem;
import oracle.ewt.dialog.directory.DirectoryParentItemFactory;
import oracle.ewt.dialog.directory.DirectoryRootItem;
import oracle.ewt.dialog.directory.FileDataSource;
import oracle.ewt.dialog.directory.FileUtils;
import oracle.ewt.graphics.ImageUtils;

class DirectoryTree
extends DTree {
    public static final String ROOT_DIRECTORY_PROPERTY = "rootDirectory";
    public static final int SET_SUCCEEDED = 0;
    public static final int SET_WRITE_FAILED = 1;
    public static final int SET_CREATE_FAILED = 2;
    public static final int SET_FAILED = 3;
    public static final int SET_PARTIAL_SUCCESS = 4;
    private File _directory;
    private DirectoryItem _rootDirectoryItem;
    private PropertyChangeSupport _propSupport;
    private static Image _sDirectoryImage;
    static /* synthetic */ Class class$oracle$ewt$dialog$directory$DirectoryTree;

    public static Image getDirectoryIcon() {
        if (_sDirectoryImage == null) {
            _sDirectoryImage = ImageUtils.getImageResource(class$oracle$ewt$dialog$directory$DirectoryTree != null ? class$oracle$ewt$dialog$directory$DirectoryTree : (class$oracle$ewt$dialog$directory$DirectoryTree = DirectoryTree.class$("oracle.ewt.dialog.directory.DirectoryTree")), "images/folder.gif");
        }
        return _sDirectoryImage;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._propSupport == null) {
            this._propSupport = new PropertyChangeSupport(this);
        }
        this._propSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public final File getDirectory() {
        DirectoryItem directoryItem = this.getDirectoryItem();
        if (directoryItem == null) {
            return null;
        }
        return directoryItem.getDirectory();
    }

    public DirectoryItem getDirectoryItem() {
        DTreeItem dTreeItem;
        DTreeItem dTreeItem2;
        DTreeRange dTreeRange;
        DTreeSelection dTreeSelection = this.getSelection();
        DTreeRangeSet dTreeRangeSet = dTreeSelection.getSelectionRanges();
        if (dTreeRangeSet.getCount() == 1 && (dTreeRange = dTreeRangeSet.getRange(0)).getCount() == 1 && (dTreeItem2 = (dTreeItem = dTreeRange.getParent()).getItem(dTreeRange.getStartIndex())) instanceof DirectoryItem) {
            DirectoryItem directoryItem = (DirectoryItem)dTreeItem2;
            return directoryItem;
        }
        return null;
    }

    public File getRootDirectory() {
        if (this._rootDirectoryItem == null) {
            return null;
        }
        return this._rootDirectoryItem.getDirectory();
    }

    public int setDirectory(File file, boolean bl) {
        DTreeItem dTreeItem;
        File[] fileArray = this._getPaths(file);
        if (fileArray.length == 0) {
            return 3;
        }
        File file2 = fileArray[0];
        File file3 = this.getRootDirectory();
        if (!file2.exists()) {
            if (bl && !file2.mkdir()) {
                return 2;
            }
            return 3;
        }
        if (file3 == null || !FileUtils.areDirectoriesEqual(file3, file2)) {
            FileDataSource fileDataSource = new FileDataSource(file2, DirectoryFilter.getInstance());
            this._rootDirectoryItem = new DirectoryRootItem(file2.getPath(), DirectoryTree.getDirectoryIcon(), fileDataSource, DirectoryParentItemFactory.getInstance());
            dTreeItem = new DTreeSimpleRoot();
            ((DTreeSimpleParent)dTreeItem).addItem(this._rootDirectoryItem);
            this.setRoot((DTreeRootItem)dTreeItem);
            if (this._propSupport != null) {
                this._propSupport.firePropertyChange(ROOT_DIRECTORY_PROPERTY, file3, file2);
            }
        }
        int n = 1;
        dTreeItem = this._rootDirectoryItem;
        while (n < fileArray.length) {
            DTreeItem dTreeItem2;
            File file4;
            File file5 = fileArray[n];
            if (!(!bl && !file5.exists() || (file4 = (dTreeItem2 = dTreeItem).createDirectory(FileUtils.getName(file5))) != null && file4.exists())) {
                if (!fileArray[n - 1].canWrite()) {
                    return 1;
                }
                return 2;
            }
            dTreeItem.setExpanded(true);
            int n2 = 0;
            int n3 = dTreeItem.getItemCount();
            while (n2 < n3) {
                File file6;
                DTreeItem dTreeItem3 = dTreeItem.getItem(n2);
                if (dTreeItem3 instanceof DirectoryItem && FileUtils.areDirectoriesEqual(file6 = ((DirectoryItem)dTreeItem3).getDirectory(), file5)) {
                    dTreeItem = dTreeItem3;
                    break;
                }
                ++n2;
            }
            if (n2 == n3) {
                this._selectItem(dTreeItem);
                return 4;
            }
            ++n;
        }
        if (dTreeItem != null) {
            this._selectItem(dTreeItem);
        }
        return 0;
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._propSupport.removePropertyChangeListener(propertyChangeListener);
    }

    private File[] _getPaths(File file) {
        File[] fileArray = new File[]{};
        while (file != null) {
            File[] fileArray2 = new File[fileArray.length + 1];
            System.arraycopy(fileArray, 0, fileArray2, 1, fileArray.length);
            fileArray = fileArray2;
            fileArray[0] = file;
            String string = FileUtils.getParent(file);
            if (string == null) break;
            file = new File(string);
        }
        return fileArray;
    }

    private void _selectItem(DTreeItem dTreeItem) {
        dTreeItem.setExpanded(true);
        DTreeSelection dTreeSelection = this.getSelection();
        dTreeSelection.selectItem(dTreeItem);
        this.makeVisible(dTreeItem);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

