/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.dialog.directory;

import java.io.File;
import java.io.FilenameFilter;
import java.text.Collator;
import java.util.Enumeration;
import java.util.Locale;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.dataSource.OneDDataSourceEvent;
import oracle.ewt.dataSource.OneDDataSourceListener;
import oracle.ewt.dialog.directory.DirectoryFilter;
import oracle.ewt.dialog.directory.FileUtils;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.util.Sort;
import oracle.ewt.util.StringComparator;

class FileDataSource
implements OneDDataSource {
    private File _directory;
    private File[] _files;
    private ListenerManager _listeners;

    public FileDataSource(File file, FilenameFilter filenameFilter) {
        this._directory = file;
    }

    public File createDirectory(String string) {
        File file = new File(this._directory, string);
        if (!(file.exists() || file.mkdir() && file.exists())) {
            return null;
        }
        if (this._files != null) {
            StringComparator stringComparator = new StringComparator(Collator.getInstance(Locale.getDefault()));
            int n = 0;
            while (n < this._files.length) {
                int n2 = stringComparator.compare(string, FileUtils.getName(this._files[n]));
                if (n2 == 0) {
                    return file;
                }
                if (n2 < 0) break;
                ++n;
            }
            File[] fileArray = new File[this._files.length + 1];
            System.arraycopy(this._files, 0, fileArray, 0, n);
            System.arraycopy(this._files, n, fileArray, n + 1, this._files.length - n);
            fileArray[n] = file;
            this._files = fileArray;
            this._fireItemsAdded(n, 1);
        }
        return file;
    }

    public int getItemCount() {
        if (this._files != null) {
            return this._files.length;
        }
        return 0;
    }

    public Object getData(int n) {
        return this._files[n];
    }

    public void setData(int n, Object object) {
    }

    public void addDataSourceListener(OneDDataSourceListener oneDDataSourceListener) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener(oneDDataSourceListener);
    }

    public void removeDataSourceListener(OneDDataSourceListener oneDDataSourceListener) {
        if (this._listeners != null) {
            this._listeners.removeListener(oneDDataSourceListener);
        }
    }

    public void itemExpanding() {
        Object[] objectArray;
        if (this._files == null && (objectArray = FileUtils.list(this._directory, DirectoryFilter.getInstance())) != null) {
            StringComparator stringComparator = new StringComparator(Collator.getInstance(Locale.getDefault()));
            Sort.qSort(objectArray, objectArray.length, stringComparator);
            this._files = new File[objectArray.length];
            int n = 0;
            while (n < objectArray.length) {
                this._files[n] = new File(this._directory, (String)objectArray[n]);
                ++n;
            }
        }
    }

    private void _fireItemsAdded(int n, int n2) {
        Enumeration enumeration;
        if (this._listeners != null && (enumeration = this._listeners.getListeners()) != null) {
            OneDDataSourceEvent oneDDataSourceEvent = new OneDDataSourceEvent(this, 2001, n, n2);
            while (enumeration.hasMoreElements()) {
                OneDDataSourceListener oneDDataSourceListener = (OneDDataSourceListener)enumeration.nextElement();
                oneDDataSourceListener.itemsAdded(oneDDataSourceEvent);
            }
        }
    }
}

