/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.graphics;

import java.awt.Color;

public class ColorUtils {
    public static final double NTSC_WEIGHT_RED = 0.299;
    public static final double NTSC_WEIGHT_GREEN = 0.587;
    public static final double NTSC_WEIGHT_BLUE = 0.144;
    public static final int DEFAULT_LIGHTER_CHANGE = 51;
    private static final int _LIGHT_LUMINANCE = 229;
    private static final int _DARK_LUMINANCE = 51;

    public static int getApproximateLuminance(Color color) {
        return (color.getRed() >> 2) + (color.getGreen() >> 1) + (color.getBlue() >> 2);
    }

    public static double getNTSCLuminance(Color color) {
        return (double)color.getRed() * 0.299 + (double)color.getGreen() * 0.587 + (double)color.getBlue() * 0.144;
    }

    public static Color shadeColor(Color color, int n) {
        int n2;
        if (n < -255 || n > 255) {
            throw new IllegalArgumentException();
        }
        int n3 = ColorUtils.getApproximateLuminance(color);
        if (n > 0) {
            n2 = n3 > 229 ? -n >> 1 : (n3 < 51 ? n + (n >> 2) : n);
        } else if (n3 < 51) {
            n2 = -n >> 1;
            n2 += n2 >> 1;
        } else {
            n2 = n;
        }
        if (n2 < 0) {
            return new Color(ColorUtils._darkenComponent(color.getRed(), n2), ColorUtils._darkenComponent(color.getGreen(), n2), ColorUtils._darkenComponent(color.getBlue(), n2));
        }
        return new Color(ColorUtils._lightenComponent(color.getRed(), n2), ColorUtils._lightenComponent(color.getGreen(), n2), ColorUtils._lightenComponent(color.getBlue(), n2));
    }

    public static final Color lighterShadeColor(Color color) {
        return ColorUtils.shadeColor(color, 51);
    }

    public static final Color darkerShadeColor(Color color) {
        return ColorUtils.shadeColor(color, -51);
    }

    private static final int _darkenComponent(int n, int n2) {
        int n3 = n + n2;
        if (n3 < 0) {
            n3 = 0;
        }
        return n3;
    }

    private static final int _lightenComponent(int n, int n2) {
        int n3 = n + n2;
        if (n3 > 255) {
            n3 = 255;
        }
        return n3;
    }
}

