/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class EqualRowLayout
implements LayoutManager {
    public static final int ALIGN_START = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_END = 2;
    private int _interiorGap;
    private int _layoutAlignment;
    private int _perpendicularAlignment;

    public EqualRowLayout() {
        this(0);
    }

    public EqualRowLayout(int n) {
        this(n, 1, 1);
    }

    public EqualRowLayout(int n, int n2, int n3) {
        this.setInteriorGap(n);
        this.setLayoutAlignment(n2);
        this.setPerpendicularAlignment(n3);
    }

    public void layoutContainer(Container container) {
        int n;
        int n2 = this.getLayoutAlignment();
        Insets insets = container.getInsets();
        Dimension dimension = this.getCellSize(container);
        Dimension dimension2 = container.getSize();
        int n3 = dimension2.width;
        int n4 = dimension2.height;
        int n5 = insets.left;
        if (n2 != 0) {
            n = this.getInsetLayoutSize((Container)container, (boolean)true).width;
            n5 = n2 == 2 ? n3 - n - insets.left : (n5 += n3 - n >> 1);
        }
        n = this.getPerpendicularAlignment();
        Enumeration enumeration = this.getComponentEnumeration(container);
        while (enumeration.hasMoreElements()) {
            Component component = (Component)enumeration.nextElement();
            if (!component.isVisible()) continue;
            int n6 = insets.top;
            if (n != 0) {
                n6 = n == 2 ? n4 - insets.bottom - dimension.height : (n6 += n4 - insets.bottom - insets.top - dimension.height >> 1);
            }
            component.setBounds(n5, n6, dimension.width, dimension.height);
            n5 += dimension.width + this.getInteriorGap();
        }
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        return this._getLayoutSize(container, true);
    }

    public Dimension minimumLayoutSize(Container container) {
        return this._getLayoutSize(container, false);
    }

    public void setInteriorGap(int n) {
        this._interiorGap = n;
    }

    public int getInteriorGap() {
        return this._interiorGap;
    }

    public void setLayoutAlignment(int n) {
        this._layoutAlignment = n;
    }

    public int getLayoutAlignment() {
        return this._layoutAlignment;
    }

    public void setPerpendicularAlignment(int n) {
        this._perpendicularAlignment = n;
    }

    public int getPerpendicularAlignment() {
        return this._perpendicularAlignment;
    }

    public static int getNumberVisibleChildren(Container container) {
        int n = container.getComponentCount();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (container.getComponent(n3).isVisible()) {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    protected Enumeration getComponentEnumeration(Container container) {
        return new Enum(container);
    }

    protected Dimension getCellSize(Container container) {
        int n = 0;
        int n2 = 0;
        int n3 = container.getComponentCount();
        int n4 = 0;
        while (n4 < n3) {
            Component component = container.getComponent(n4);
            if (component.isVisible()) {
                Dimension dimension = component.getPreferredSize();
                if (n2 < dimension.height) {
                    n2 = dimension.height;
                }
                if (n < dimension.width) {
                    n = dimension.width;
                }
            }
            ++n4;
        }
        return new Dimension(n, n2);
    }

    protected Dimension getInsetLayoutSize(Container container, boolean bl) {
        int n = EqualRowLayout.getNumberVisibleChildren(container);
        Dimension dimension = this.getCellSize(container);
        int n2 = dimension.width * n;
        if (n > 1) {
            n2 += this.getInteriorGap() * (n - 1);
        }
        return new Dimension(n2, dimension.height);
    }

    private Dimension _getLayoutSize(Container container, boolean bl) {
        Dimension dimension = this.getInsetLayoutSize(container, bl);
        Insets insets = container.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    class Enum
    implements Enumeration {
        private int _index;
        private int _count;
        private Container _target;

        public Enum(Container container) {
            EqualRowLayout.this = EqualRowLayout.this;
            this._count = container.getComponentCount();
            this._target = container;
        }

        public boolean hasMoreElements() {
            return this._index < this._count;
        }

        public Object nextElement() throws NoSuchElementException {
            if (this._index < this._count) {
                return this._target.getComponent(this._index++);
            }
            throw new NoSuchElementException();
        }
    }
}

