/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import oracle.ewt.button.EwtButton;
import oracle.ewt.dataSource.ArrayOneDDataSource;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.graphics.ArrowUtils;
import oracle.ewt.graphics.GraphicUtils;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.LWDataSourceList;
import oracle.ewt.popup.PopupOwner;
import oracle.ewt.popup.PopupUtils;
import oracle.ewt.util.WindowUtils;

public class LWChoice
extends LWComponent
implements ItemSelectable {
    private static final int _DEFAULT_ROWS = 8;
    private static final int _VINSET = 4;
    private static final int _HINSET = 10;
    private static String _sDefaultName = null;
    private static int _sInstanceCounter;
    private boolean _dragging;
    private ListListener _listListener;
    private static final int[] _sJustifications;
    private ArrayOneDDataSource _items = new ArrayOneDDataSource(null);
    private int _selectedIndex = -1;
    private EwtButton _button;
    private int _buttonWidth;
    private boolean _isDropDownVisible;
    private LWDataSourceList _list;
    private MouseCheck _mouseCheck;
    private MoveCheck _moveCheck;
    private ListenerManager _iListenerManager;
    private long _currentTime;
    private static final long _KEY_TIME = 750L;
    private StringBuffer _buffer;

    public LWChoice() {
        this.setBackground(Color.white);
        Image image = ArrowUtils.getDownArrow();
        this._button = new EwtButton(image);
        this._button.setFocusable(false);
        ButtonListen buttonListen = new ButtonListen();
        this._button.addMouseListener(buttonListen);
        this._button.addMouseMotionListener(buttonListen);
        this.add(this._button);
        long l = 60L;
        this.enableEvents(l);
        this._isDropDownVisible = false;
    }

    public int getItemCount() {
        return this._items.getItemCount();
    }

    public String getItem(int n) {
        return (String)this._items.getData(n);
    }

    public synchronized void add(String string) {
        this.addItem(string);
    }

    public synchronized void addItem(String string) {
        if (string == null) {
            throw new NullPointerException("cannot add null item to LWChoice");
        }
        Object[] objectArray = new Object[]{string};
        this._items.addItems(this.getItemCount(), objectArray);
        if (this.getSelectedIndex() < 0) {
            this.select(0);
        }
    }

    public synchronized void insert(String string, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        int n2 = this.getItemCount();
        if (n > n2) {
            String string2 = "index is greater than the number of elements.";
            throw new IllegalArgumentException(string2);
        }
        Object[] objectArray = new Object[]{string};
        this._items.addItems(n, objectArray);
        if (this._selectedIndex >= n) {
            ++this._selectedIndex;
        }
    }

    public synchronized void remove(String string) {
        int n = this._indexOf(string);
        if (n < 0) {
            throw new IllegalArgumentException("item " + string + " not found in choice");
        }
        this.remove(n);
    }

    public synchronized void remove(int n) {
        this._items.removeItems(n, 1);
        int n2 = this.getItemCount();
        if (n2 == 0 || this._selectedIndex == n) {
            this._selectedIndex = n2 == 0 ? -1 : 0;
        } else if (this._selectedIndex > n) {
            --this._selectedIndex;
        }
        this.repaint();
    }

    public synchronized void removeAll() {
        this._items.removeItems(0, this.getItemCount());
        this._selectedIndex = -1;
        this.repaint();
    }

    public synchronized String getSelectedItem() {
        int n = this.getSelectedIndex();
        if (n >= 0) {
            return this.getItem(n);
        }
        return null;
    }

    public synchronized Object[] getSelectedObjects() {
        int n = this.getSelectedIndex();
        if (n >= 0) {
            Object[] objectArray = new Object[]{this.getItem(n)};
            return objectArray;
        }
        return null;
    }

    public int getSelectedIndex() {
        return this._selectedIndex;
    }

    public synchronized void select(int n) {
        if (n < 0 || n >= this.getItemCount()) {
            String string = "illegal LWChoice item position: " + n;
            throw new IllegalArgumentException(string);
        }
        this._getList().select(n);
        this._selectedIndex = n;
        this.repaint();
    }

    public synchronized void select(String string) {
        int n = this._indexOf(string);
        if (n >= 0) {
            this.select(n);
        }
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        if (this._iListenerManager == null) {
            this._iListenerManager = new ListenerManager();
        }
        this._iListenerManager.addListener(itemListener);
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        if (this._iListenerManager != null) {
            this._iListenerManager.removeListener(itemListener);
        }
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        this._buttonWidth = this._button.getPreferredSize().width;
        int n = dimension.width - this._buttonWidth;
        this._button.setBounds(n, 0, this._buttonWidth, dimension.height);
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension();
        Font font = this.getFont();
        if (font == null) {
            dimension.width = 100;
            dimension.height = 20;
        } else {
            FontMetrics fontMetrics = this.getFontMetrics(font);
            dimension.height = fontMetrics.getHeight() + 4;
            dimension.width = fontMetrics.stringWidth("e");
            int n = this.getItemCount();
            int n2 = 0;
            while (n2 < n) {
                int n3 = fontMetrics.stringWidth(this.getItem(n2));
                if (n3 > dimension.width) {
                    dimension.width = n3;
                }
                ++n2;
            }
            dimension.width += 10;
            dimension.width += this._button.getPreferredSize().width;
        }
        return dimension;
    }

    public Dimension getMinimumSize() {
        Dimension dimension = this._button.getMinimumSize();
        dimension.width += 20;
        dimension.height += 4;
        return dimension;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.invalidate();
        this.repaint();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this._getList().setBackground(color);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this._getList().setForeground(color);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._button.setEnabled(bl);
        this.repaint();
    }

    public void paintInterior(Graphics graphics) {
        Color color;
        Color color2;
        if (this.hasFocus()) {
            color2 = SystemColor.textHighlight;
            color = SystemColor.textHighlightText;
        } else {
            color2 = this.getBackground();
            color = this.isEnabled() ? this.getForeground() : SystemColor.textInactiveText;
        }
        Font font = this.getFont();
        Dimension dimension = this.getSize();
        int n = dimension.width - this._buttonWidth;
        int n2 = dimension.height;
        graphics.setFont(font);
        graphics.setColor(color2);
        graphics.fillRect(1, 1, n - 2, n2 - 2);
        String string = this.getSelectedItem();
        if (string != null) {
            graphics.setColor(color);
            FontMetrics fontMetrics = this.getFontMetrics(font);
            int n3 = 1 + fontMetrics.getLeading() + fontMetrics.getAscent();
            graphics.drawString(string, 2, n3);
            if (this.hasFocus()) {
                graphics.setColor(Color.yellow);
                GraphicUtils.drawFocusRect(graphics, 1, 1, n - 3, n2 - 3);
            }
        }
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, n - 1, n2 - 1);
    }

    public void removeNotify() {
        this._setDropDownVisible(false);
        super.removeNotify();
    }

    protected String getDefaultName() {
        if (_sDefaultName == null) {
            _sDefaultName = this.getBaseClassName();
        }
        return String.valueOf(_sDefaultName) + _sInstanceCounter++;
    }

    protected void processEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)aWTEvent);
            return;
        }
        super.processEventImpl(aWTEvent);
    }

    protected void processItemEvent(ItemEvent itemEvent) {
        if (this._iListenerManager == null) {
            return;
        }
        Enumeration enumeration = this._iListenerManager.getListeners();
        while (enumeration.hasMoreElements()) {
            ((ItemListener)enumeration.nextElement()).itemStateChanged(itemEvent);
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        if (!this.hasFocus()) {
            this._setDropDownVisible(false);
        }
        this.repaint();
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (mouseEvent.isConsumed() || !this.isEnabled()) {
            return;
        }
        int n = mouseEvent.getModifiers();
        if ((n & 0x10) == 0) {
            return;
        }
        int n2 = mouseEvent.getID();
        switch (n2) {
            case 501: {
                Dimension dimension = this.getSize();
                int n3 = mouseEvent.getX();
                int n4 = mouseEvent.getY();
                if (n3 < 0 || n3 > dimension.width || n4 < 0 || n4 > dimension.height) break;
                this.requestFocus();
                this._button.simulatePush();
                this.toggleDropDown();
                mouseEvent.consume();
                return;
            }
            case 502: {
                this.processMouseReleased(mouseEvent);
                return;
            }
        }
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        super.processMouseMotionEvent(mouseEvent);
        if (mouseEvent.isConsumed() || mouseEvent.getID() != 506 || !this.isEnabled()) {
            return;
        }
        this.processMouseDrag(mouseEvent);
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (keyEvent.isConsumed() || !this.isEnabled() || this.getItemCount() == 0) {
            return;
        }
        switch (keyEvent.getID()) {
            case 400: {
                this._keyTyped(keyEvent);
                return;
            }
            case 401: {
                this._keyPressed(keyEvent);
                return;
            }
        }
    }

    protected String paramString() {
        return String.valueOf(super.paramString()) + ",current=" + this.getSelectedItem();
    }

    void _postEvent(String string, int n) {
        ItemEvent itemEvent = new ItemEvent(this, 701, string, n);
        this.processEvent(itemEvent);
    }

    boolean _isDropDownVisible() {
        return this._isDropDownVisible;
    }

    void _setDropDownVisible(boolean bl) {
        if (this._isDropDownVisible == bl) {
            return;
        }
        if (bl) {
            if (this._mouseCheck == null) {
                this._mouseCheck = new MouseCheck();
                this._moveCheck = new MoveCheck();
            }
            Font font = this.getFont();
            this._list.setFont(font);
            int n = this.getSelectedIndex();
            if (n != -1) {
                this._list.select(n);
            } else {
                n = this._list.getSelectedIndex();
                if (n != -1) {
                    this._list.deselect(n);
                }
            }
            this._isDropDownVisible = this._showDropDown();
            if (this._isDropDownVisible) {
                if (n != -1) {
                    this._list.makeVisible(n);
                }
                this._addChecks();
                return;
            }
        } else {
            PopupUtils.hidePopup(this._list);
            this._removeChecks();
            this._isDropDownVisible = false;
        }
    }

    LWDataSourceList _getList() {
        if (this._list == null) {
            this._list = new LWDataSourceList(this._items, 8, false);
            this._list.setFocusTraversable(false);
            this._listListener = new ListListener();
            this._list.addMouseMotionListener(this._listListener);
            this._list.addMouseListener(this._listListener);
        }
        return this._list;
    }

    void processMouseDrag(MouseEvent mouseEvent) {
        if (!this._isDropDownVisible()) {
            return;
        }
        Point point = this.getLocationOnScreen();
        Point point2 = this._list.getLocationOnScreen();
        int n = point.x - point2.x;
        int n2 = point.y - point2.y;
        mouseEvent.translatePoint(n, n2);
        Dimension dimension = this._list.getSize();
        if (!this._dragging && (n2 < 0 && mouseEvent.getY() < 0 || n2 > 0 && mouseEvent.getY() > n2 && n2 == dimension.height)) {
            return;
        }
        this._listListener.mouseMoved(mouseEvent);
        this._dragging = true;
        mouseEvent.consume();
    }

    void processMouseReleased(MouseEvent mouseEvent) {
        if (this._dragging) {
            Point point = this.getLocationOnScreen();
            Point point2 = this._list.getLocationOnScreen();
            int n = point.x - point2.x;
            int n2 = point.y - point2.y;
            mouseEvent.translatePoint(n, n2);
            this._listListener.mouseReleased(mouseEvent);
            mouseEvent.consume();
        }
        this._dragging = false;
    }

    void toggleDropDown() {
        boolean bl = !this._isDropDownVisible();
        this._setDropDownVisible(bl);
    }

    private void _keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        int n2 = this.getItemCount() - 1;
        int n3 = this._getList().getRows();
        int n4 = -1;
        int n5 = !this._isDropDownVisible() ? this.getSelectedIndex() : this._getList().getSelectedIndex();
        switch (n) {
            case 39: 
            case 40: {
                if (n5 == -1) {
                    n4 = 0;
                    break;
                }
                if (n5 >= this.getItemCount() - 1) break;
                n4 = n5 + 1;
                break;
            }
            case 37: 
            case 38: {
                if (n5 == -1) {
                    n4 = 0;
                    break;
                }
                if (n5 <= 0) break;
                n4 = n5 - 1;
                break;
            }
            case 36: {
                if (n5 == 0) break;
                n4 = 0;
                break;
            }
            case 35: {
                if (n5 == n2) break;
                n4 = n2;
                break;
            }
            case 33: {
                if (n5 == 0 || (n4 = n5 - n3) >= 0) break;
                n4 = 0;
                break;
            }
            case 34: {
                if (n5 == n2 || (n4 = n5 + n3) <= n2) break;
                n4 = n2;
                break;
            }
            case 10: {
                if (!this._isDropDownVisible()) break;
                n4 = this._getList().getSelectedIndex();
                this._setDropDownVisible(false);
                this.repaint();
                break;
            }
        }
        if (n4 != -1) {
            if (!this._isDropDownVisible()) {
                this.select(n4);
                this._postEvent(this.getItem(n4), 1);
                return;
            }
            this._getList().select(n4);
        }
    }

    private void _keyTyped(KeyEvent keyEvent) {
        if (this._checkTime(750L)) {
            this._buffer = null;
        }
        StringBuffer stringBuffer = this._getBuffer();
        stringBuffer.append(keyEvent.getKeyChar());
        int n = this.getSelectedIndex();
        if (n == -1) {
            n = 0;
        }
        if ((n = this._findItem(n, stringBuffer.toString())) != -1) {
            this.select(n);
            if (this._isDropDownVisible) {
                this._getList().select(n);
            }
        }
        this._storeTime();
    }

    private void _storeTime() {
        this._currentTime = System.currentTimeMillis();
    }

    private boolean _checkTime(long l) {
        long l2 = System.currentTimeMillis();
        return l2 - this._currentTime > l;
    }

    private StringBuffer _getBuffer() {
        if (this._buffer == null) {
            this._buffer = new StringBuffer();
        }
        return this._buffer;
    }

    private int _findItem(int n, String string) {
        int n2 = this.getItemCount();
        int n3 = n;
        while (n3 < n2) {
            if (this.getItem(n3).startsWith(string)) {
                return n3;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n) {
            if (this.getItem(n3).startsWith(string)) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    private void _addChecks() {
        Window window = WindowUtils.getWindow(this);
        window.addComponentListener(this._moveCheck);
        this._addChecks(window);
    }

    private void _addChecks(Component component) {
        if (component == this || component == this._getList()) {
            return;
        }
        component.addMouseListener(this._mouseCheck);
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            int n = 0;
            while (n < componentArray.length) {
                this._addChecks(componentArray[n]);
                ++n;
            }
        }
    }

    private void _removeChecks() {
        Window window = WindowUtils.getWindow(this);
        window.removeComponentListener(this._moveCheck);
        this._removeChecks(window);
    }

    private void _removeChecks(Component component) {
        if (component == this || component == this._getList()) {
            return;
        }
        component.removeMouseListener(this._mouseCheck);
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            int n = 0;
            while (n < componentArray.length) {
                this._removeChecks(componentArray[n]);
                ++n;
            }
        }
    }

    private boolean _showDropDown() {
        LWDataSourceList lWDataSourceList = this._getList();
        int n = this.getItemCount();
        int n2 = lWDataSourceList.getRows();
        if (n2 > n) {
            n2 = n;
        }
        int n3 = lWDataSourceList.getPreferredSize((int)n2).height;
        Dimension dimension = this.getSize();
        dimension.height = n3;
        int n4 = 17;
        PopupOwner popupOwner = PopupUtils.displayPopupRelativeTo((Component)this, (Component)this._list, null, dimension, n4);
        if (popupOwner != null) {
            return true;
        }
        n4 = 16;
        popupOwner = PopupUtils.displayPopupRelativeTo((Component)this, (Component)this._list, null, dimension, n4);
        if (popupOwner != null) {
            return true;
        }
        n4 = 15;
        popupOwner = PopupUtils.displayPopupRelativeTo((Component)this, (Component)this._list, null, dimension, n4);
        if (popupOwner != null) {
            return true;
        }
        popupOwner = PopupUtils.displayPopupRelativeTo((Component)this, (Component)this._list, null, dimension, _sJustifications);
        return popupOwner != null;
    }

    private int _indexOf(String string) {
        int n = this.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            if (this._items.getData(n2).toString().equals(string)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    static {
        _sJustifications = new int[]{13, 8, 10, 5};
    }

    private class ButtonListen
    extends MouseAdapter
    implements MouseMotionListener {
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            LWChoice.this.processMouseDrag(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n = mouseEvent.getModifiers();
            if (!LWChoice.this.isEnabled() || (n & 0x10) == 0) {
                return;
            }
            Component component = (Component)mouseEvent.getSource();
            Dimension dimension = component.getSize();
            int n2 = mouseEvent.getX();
            int n3 = mouseEvent.getY();
            if (n2 < 0 || n2 > dimension.width || n3 < 0 || n3 > dimension.height) {
                return;
            }
            LWChoice.this.toggleDropDown();
            LWChoice.this.requestFocus();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            LWChoice.this.processMouseReleased(mouseEvent);
        }

        ButtonListen() {
            LWChoice.this = LWChoice.this;
        }
    }

    private class ListListener
    extends MouseAdapter
    implements MouseMotionListener {
        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            LWDataSourceList lWDataSourceList = LWChoice.this._getList();
            int n = lWDataSourceList.getItemAt(mouseEvent.getY());
            if (n != -1) {
                lWDataSourceList.select(n);
                mouseEvent.consume();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            mouseEvent.consume();
            int n = mouseEvent.getModifiers();
            if ((n & 0x10) == 0) {
                return;
            }
            LWDataSourceList lWDataSourceList = LWChoice.this._getList();
            int n2 = lWDataSourceList.getItemAt(mouseEvent.getY());
            if (n2 == -1) {
                return;
            }
            LWChoice.this.select(n2);
            LWChoice.this._postEvent(LWChoice.this.getItem(n2), 1);
            LWChoice.this.requestFocus();
            LWChoice.this.repaint();
            LWChoice.this._setDropDownVisible(false);
        }

        ListListener() {
            LWChoice.this = LWChoice.this;
        }
    }

    private class MouseCheck
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            LWChoice.this._setDropDownVisible(false);
            mouseEvent.consume();
        }

        MouseCheck() {
            LWChoice.this = LWChoice.this;
        }
    }

    private class MoveCheck
    extends ComponentAdapter {
        public void componentMoved(ComponentEvent componentEvent) {
            LWChoice.this._setDropDownVisible(false);
        }

        MoveCheck() {
            LWChoice.this = LWChoice.this;
        }
    }
}

