/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.peer.LightweightPeer;
import oracle.ewt.event.AnyEventListener;
import oracle.ewt.event.AnyEventMulticaster;
import oracle.ewt.help.HelpCapable;
import oracle.ewt.help.HelpProvider;
import oracle.ewt.lwAWT.BalkingDoubleBuffer;
import oracle.ewt.lwAWT.DefaultFill;
import oracle.ewt.lwAWT.DoubleBuffer;
import oracle.ewt.lwAWT.DoubleBufferer;
import oracle.ewt.lwAWT.ImmediatePainter;
import oracle.ewt.lwAWT.InteriorPainter;
import oracle.ewt.lwAWT.SharedPainter;
import oracle.ewt.painter.Fill;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.popup.ToolTipClient;
import oracle.ewt.popup.ToolTipManager;

public class LWComponent
extends Container
implements HelpCapable,
ImmediatePainter,
DoubleBufferer,
InteriorPainter {
    private static String _sDefaultName = null;
    private static int _sInstanceCounter;
    private static LWComponent _sFocusedComponent;
    private static LWComponent _sMouseGrab;
    private static DoubleBuffer _sDoubleBuffer;
    private static final String _TOOLTIP_VALUE = "_EWTToolTip";
    private static final String _HELP_TOPIC = "_EWTHelpTopic";
    private static final String _HELP_BOOK = "_EWTHelpBook";
    private static final String _HELP_PROVIDER = "_EWTHelpProvider";
    private static HelpProvider _sDefaultHelpProvider;
    private SharedPainter _painter;
    private AnyEventListener _anyListener;
    private Object[] _properties;

    public LWComponent() {
        this.setName(this.getDefaultName());
        this._painter = new SharedPainter(this, DefaultFill.getTransparentFill());
        this.enableEvents(16L);
        this.enableEvents(4L);
    }

    public synchronized void addAnyEventListener(AnyEventListener anyEventListener) {
        this._anyListener = AnyEventMulticaster.add(this._anyListener, anyEventListener);
    }

    public synchronized void removeAnyEventListener(AnyEventListener anyEventListener) {
        this._anyListener = AnyEventMulticaster.remove(this._anyListener, anyEventListener);
    }

    public void setFill(Fill fill) {
        this._painter.setFill(fill);
    }

    public Fill getFill() {
        return this._painter.getFill();
    }

    public boolean isTransparent() {
        return this.getFill().isTransparent();
    }

    public boolean isPaintPropagationRequired() {
        return this.isTransparent() || this.isClippedBySibling();
    }

    public boolean isClippedBySibling() {
        return this._painter.isClippedBySibling();
    }

    public boolean isChildClipped(Component component) {
        return this._painter.isChildClipped(component);
    }

    public void freezeRepaints() {
        this._painter.freezeRepaints();
    }

    public void unfreezeRepaints() {
        this._painter.unfreezeRepaints(this.getDoubleBuffer());
    }

    public final void paintImmediate() {
        Dimension dimension = this.getSize();
        this.paintImmediate(0, 0, dimension.width, dimension.height);
    }

    public void paintImmediate(int n, int n2, int n3, int n4) {
        if (this.isShowing()) {
            this._painter.paintImmediateClipped(n, n2, n3, n4, this, this.getDoubleBuffer());
        }
    }

    public void paintImmediateUnclipped(int n, int n2, int n3, int n4) {
        this._painter.paintImmediate(n, n2, n3, n4, this, this.getDoubleBuffer());
    }

    public final boolean hasFocus() {
        return this == LWComponent.getFocusedComponent();
    }

    public static LWComponent getFocusedComponent() {
        return _sFocusedComponent;
    }

    public void setToolTipValue(String string) {
        this._setToolTipValue(string);
    }

    public void setToolTipValue(ToolTipClient toolTipClient) {
        this._setToolTipValue(toolTipClient);
    }

    public Object getToolTipValue() {
        return this.getClientProperty(_TOOLTIP_VALUE);
    }

    public String getHelpTopic() {
        HelpCapable helpCapable;
        Object object = this.getClientProperty(_HELP_TOPIC);
        if (object != null && object instanceof String) {
            return (String)object;
        }
        if (this.getClientProperty(_HELP_BOOK) == null && this.getClientProperty(_HELP_PROVIDER) == null && (helpCapable = LWComponent._getParentHelpCapable(this)) != null) {
            return helpCapable.getHelpTopic();
        }
        return null;
    }

    public void setHelpTopic(String string) {
        this.putClientProperty(_HELP_TOPIC, string);
    }

    public Object getHelpBook() {
        HelpCapable helpCapable;
        Object object = this.getClientProperty(_HELP_BOOK);
        if (object != null) {
            return object;
        }
        if (this.getClientProperty(_HELP_PROVIDER) == null && (helpCapable = LWComponent._getParentHelpCapable(this)) != null) {
            return helpCapable.getHelpBook();
        }
        return null;
    }

    public void setHelpBook(Object object) {
        this.putClientProperty(_HELP_BOOK, object);
    }

    public HelpProvider getHelpProvider() {
        Object object = this.getClientProperty(_HELP_PROVIDER);
        if (object != null && object instanceof HelpProvider) {
            return (HelpProvider)object;
        }
        HelpProvider helpProvider = null;
        HelpCapable helpCapable = LWComponent._getParentHelpCapable(this);
        if (helpCapable != null) {
            helpProvider = helpCapable.getHelpProvider();
        }
        if (helpProvider == null) {
            helpProvider = LWComponent.getDefaultHelpProvider();
        }
        return helpProvider;
    }

    public void setHelpProvider(HelpProvider helpProvider) {
        this.putClientProperty(_HELP_PROVIDER, helpProvider);
    }

    public static HelpProvider getDefaultHelpProvider() {
        return _sDefaultHelpProvider;
    }

    public static void setDefaultHelpProvider(HelpProvider helpProvider) {
        _sDefaultHelpProvider = helpProvider;
    }

    public void showHelp() {
        HelpProvider helpProvider = this.getHelpProvider();
        if (helpProvider != null) {
            helpProvider.showHelp(this.getHelpBook(), this.getHelpTopic(), this);
        }
    }

    public final synchronized void putClientProperty(Object object, Object object2) {
        Object[] objectArray;
        if (object2 == null) {
            this.removeClientProperty(object);
        }
        if ((objectArray = this._properties) == null) {
            this._properties = new Object[]{object, object2};
            return;
        }
        int n = this._getClientPropertyIndex(object);
        if (n >= 0) {
            objectArray[n * 2 + 1] = object2;
            return;
        }
        int n2 = objectArray.length;
        Object[] objectArray2 = new Object[n2 + 2];
        System.arraycopy(objectArray, 0, objectArray2, 0, n2);
        objectArray2[n2] = object;
        objectArray2[n2 + 1] = object2;
        this._properties = objectArray2;
    }

    public final synchronized void removeClientProperty(Object object) {
        int n = this._getClientPropertyIndex(object);
        if (n >= 0) {
            Object[] objectArray = this._properties;
            int n2 = objectArray.length;
            Object[] objectArray2 = new Object[n2 - 2];
            System.arraycopy(objectArray, 0, objectArray2, 0, 2 * n);
            System.arraycopy(objectArray, 2 * n + 2, objectArray2, 2 * n, n2 - (2 * n + 2));
            this._properties = objectArray2;
        }
    }

    public final synchronized Object getClientProperty(Object object) {
        int n = this._getClientPropertyIndex(object);
        if (n >= 0) {
            return this._properties[2 * n + 1];
        }
        return null;
    }

    public void clipToParents(Rectangle rectangle) {
        this._painter._clipToParents(rectangle);
    }

    public void removeNotify() {
        this._painter.clearClipCache();
        boolean bl = false;
        LWComponent lWComponent = LWComponent.getFocusedComponent();
        if (this._isParentOf(lWComponent)) {
            _sFocusedComponent = null;
            bl = true;
        }
        super.removeNotify();
        if (bl) {
            this.transferFocus();
            if (_sFocusedComponent == null) {
                _sFocusedComponent = lWComponent;
            }
        }
    }

    public void hide() {
        super.hide();
        if (this._isParentOf(LWComponent.getFocusedComponent())) {
            this.transferFocus();
        }
    }

    public void disable() {
        super.disable();
        if (this.hasFocus()) {
            this.transferFocus();
        }
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
        if (this._painter.repaint(n, n2, n3, n4)) {
            Rectangle rectangle = this.getBounds();
            rectangle.x = 0;
            rectangle.y = 0;
            Rectangle rectangle2 = new Rectangle(n, n2, n3, n4);
            SharedPainter._intersectRect(rectangle2, rectangle2, rectangle);
            if (rectangle2.width > 0 && rectangle2.height > 0) {
                super.repaint(l, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            }
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        this.paintComponent(graphics, LWComponent.isDoubleBuffered(this));
    }

    public void paintInterior(Graphics graphics) {
    }

    public void paintChildren(Graphics graphics) {
        super.paint(graphics);
    }

    public void paintAll(Graphics graphics) {
        if (this.isVisible()) {
            this.paint(graphics);
        }
    }

    public void reshape(int n, int n2, int n3, int n4) {
        Dimension dimension = null;
        if (this.getFill().damageOnResize()) {
            dimension = this.getSize();
        }
        super.reshape(n, n2, n3, n4);
        if (dimension != null && (dimension.width != n3 || dimension.height != n4)) {
            this.repaint();
        }
    }

    public void setBackground(Color color) {
        Fill fill = this.getFill();
        super.setBackground(color);
        if (fill instanceof DefaultFill) {
            Fill fill2;
            Fill fill3 = fill2 = color == null ? DefaultFill.getTransparentFill() : DefaultFill.getOpaqueFill();
            if (fill2 != fill) {
                this.setFill(fill2);
                return;
            }
        }
        this.repaint();
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.repaint();
    }

    public Graphics getGraphics() {
        Graphics graphics = super.getGraphics();
        if (graphics != null) {
            graphics.setFont(this.getFont());
            graphics.setColor(this.getForeground());
        }
        return graphics;
    }

    public void remove(int n) {
        Component component;
        Object object = this.getTreeLock();
        synchronized (object) {
            component = this.getComponent(n);
            if (!(component.getPeer() instanceof LightweightPeer)) {
                component = null;
            }
            super.remove(n);
            this._painter.remove(n);
        }
        if (component != null && component.isVisible()) {
            object = component.getBounds();
            this.repaint(((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).width, ((Rectangle)object).height);
        }
    }

    public void removeAll() {
        Rectangle rectangle;
        Object object = this.getTreeLock();
        synchronized (object) {
            rectangle = LWComponent._getLWChildBounds(this);
            super.removeAll();
            this._painter.removeAll();
        }
        if (rectangle != null) {
            this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void invalidate() {
        this._painter.clearClipCache();
        super.invalidate();
    }

    public void doLayout() {
        this._painter.clearClipCache();
        super.doLayout();
    }

    public void redispatchEvent(AWTEvent aWTEvent) {
        AnyEventListener anyEventListener = this._anyListener;
        if (anyEventListener != null) {
            anyEventListener.processEventStart(aWTEvent);
        }
        this.processEventImpl(aWTEvent);
        if (aWTEvent instanceof KeyEvent) {
            this._postProcessKeyEvent((KeyEvent)aWTEvent);
        }
        if (anyEventListener != null) {
            anyEventListener.processEventEnd(aWTEvent);
        }
    }

    protected final void processEvent(AWTEvent aWTEvent) {
        int n;
        Object object;
        InputEvent inputEvent;
        if (aWTEvent instanceof KeyEvent && !this.hasFocus()) {
            inputEvent = (KeyEvent)aWTEvent;
            object = LWComponent.getFocusedComponent();
            if (object != null) {
                ((LWComponent)object).redispatchEvent(new KeyEvent((Component)object, inputEvent.getID(), inputEvent.getWhen(), inputEvent.getModifiers(), ((KeyEvent)inputEvent).getKeyCode(), ((KeyEvent)inputEvent).getKeyChar()));
                inputEvent.consume();
                return;
            }
        }
        inputEvent = null;
        if (aWTEvent instanceof MouseEvent && (n = aWTEvent.getID()) != 503 && n != 504 && n != 505) {
            MouseEvent mouseEvent = (MouseEvent)aWTEvent;
            if (n == 501) {
                _sMouseGrab = this;
            } else if (n == 502 || n == 506) {
                LWComponent lWComponent = _sMouseGrab;
                if (lWComponent == null) {
                    return;
                }
                if (lWComponent != this) {
                    Point point = this._translatePoint(this, lWComponent, mouseEvent.getX(), mouseEvent.getY());
                    inputEvent = mouseEvent;
                    mouseEvent = new MouseEvent(lWComponent, n, mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                    lWComponent.redispatchEvent(mouseEvent);
                    if (mouseEvent.isConsumed()) {
                        inputEvent.consume();
                    }
                    return;
                }
                if (n == 502) {
                    _sMouseGrab = null;
                }
            }
            if (mouseEvent.getModifiers() == 0) {
                inputEvent = mouseEvent;
                aWTEvent = new MouseEvent(this, n, mouseEvent.getWhen(), 16, mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            }
        }
        if ((object = this._anyListener) != null) {
            object.processEventStart(aWTEvent);
        }
        this.processEventImpl(aWTEvent);
        if (aWTEvent instanceof KeyEvent) {
            this._postProcessKeyEvent((KeyEvent)aWTEvent);
        }
        if (object != null) {
            object.processEventEnd(aWTEvent);
        }
        if (inputEvent != null && aWTEvent instanceof InputEvent && ((InputEvent)aWTEvent).isConsumed()) {
            inputEvent.consume();
        }
    }

    protected void processEventImpl(AWTEvent aWTEvent) {
        super.processEvent(aWTEvent);
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        focusEvent.getID();
        switch (focusEvent.getID()) {
            case 1004: {
                if (this.isEnabled()) {
                    _sFocusedComponent = this;
                    break;
                }
                this.transferFocus();
                break;
            }
            case 1005: {
                _sFocusedComponent = null;
                break;
            }
        }
        super.processFocusEvent(focusEvent);
    }

    protected void addImpl(Component component, Object object, int n) {
        Object object2 = this.getTreeLock();
        synchronized (object2) {
            super.addImpl(component, object, n);
            this._painter.add(component, n);
        }
        if (component.getPeer() instanceof LightweightPeer && component.isVisible()) {
            component.repaint();
        }
    }

    protected void paintComponent(Graphics graphics, boolean bl) {
        graphics.setFont(this.getFont());
        graphics.setColor(this.getForeground());
        if (bl || this.isTransparent()) {
            this._painter.paintExtents(graphics, this);
            return;
        }
        this._painter.paint(graphics, this.getDoubleBuffer(), this);
    }

    protected DoubleBuffer getDoubleBuffer() {
        return LWComponent._getDoubleBuffer();
    }

    protected final PaintContext getPaintContext() {
        return this._painter;
    }

    protected void shiftFrozenDamage(int n, int n2) {
        this._painter.shiftFrozenDamage(n, n2);
    }

    protected String getDefaultName() {
        if (_sDefaultName == null) {
            _sDefaultName = this.getBaseClassName();
        }
        return String.valueOf(_sDefaultName) + _sInstanceCounter++;
    }

    protected String getBaseClassName() {
        String string = this.getClass().getName();
        return string.substring(string.lastIndexOf(46) + 1);
    }

    static boolean isDoubleBuffered(Component component) {
        Container container = component.getParent();
        if (container != null) {
            return container instanceof DoubleBufferer;
        }
        return false;
    }

    static DoubleBuffer _getDoubleBuffer() {
        if (_sDoubleBuffer == null) {
            _sDoubleBuffer = new BalkingDoubleBuffer();
        }
        return _sDoubleBuffer;
    }

    private void _postProcessKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.isConsumed()) {
            return;
        }
        int n = keyEvent.getID();
        if (n == 402) {
            switch (keyEvent.getKeyCode()) {
                case 112: 
                case 156: {
                    if (!this._hasHelp()) break;
                    this.showHelp();
                    keyEvent.consume();
                    return;
                }
            }
        }
    }

    static HelpCapable _getParentHelpCapable(Component component) {
        component = component.getParent();
        while (component != null) {
            if (component instanceof HelpCapable) {
                return (HelpCapable)((Object)component);
            }
            component = component.getParent();
        }
        return null;
    }

    private boolean _hasHelp() {
        return this.getHelpProvider() != null;
    }

    private synchronized void _setToolTipValue(Object object) {
        Object object2 = this.getToolTipValue();
        this.putClientProperty(_TOOLTIP_VALUE, object);
        if (object == null != (object2 == null)) {
            if (object != null) {
                ToolTipManager.getToolTipManager().registerComponent(this);
                return;
            }
            ToolTipManager.getToolTipManager().unregisterComponent(this);
        }
    }

    private int _getClientPropertyIndex(Object object) {
        Object[] objectArray = this._properties;
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                if (object.equals(objectArray[n])) {
                    return n / 2;
                }
                n += 2;
            }
        }
        return -1;
    }

    static boolean _loseFocusIfChild(Container container) {
        Container container2 = LWComponent.getFocusedComponent();
        while (container2 != null) {
            if (container2 == container) {
                _sFocusedComponent = null;
                return true;
            }
            container2 = container2.getParent();
        }
        return false;
    }

    private boolean _isParentOf(Component component) {
        while (component != null) {
            if (component == this) {
                return true;
            }
            component = component.getParent();
        }
        return false;
    }

    static Rectangle _getLWChildBounds(Container container) {
        Rectangle rectangle = null;
        if (container.isShowing()) {
            int n = container.getComponentCount();
            int n2 = 0;
            while (n2 < n) {
                Component component = container.getComponent(n2);
                if (component.isVisible() && component.getPeer() instanceof LightweightPeer) {
                    Rectangle rectangle2 = component.getBounds();
                    if (rectangle == null) {
                        rectangle = rectangle2;
                    } else {
                        rectangle.add(rectangle2);
                    }
                }
                ++n2;
            }
        }
        return rectangle;
    }

    private Point _translatePoint(Component component, Component component2, int n, int n2) {
        Point point;
        while (!(component instanceof Window)) {
            if (component == null) break;
            point = component.getLocation();
            n += point.x;
            n2 += point.y;
            component = component.getParent();
        }
        while (!(component2 instanceof Window)) {
            if (component2 == null) break;
            point = component2.getLocation();
            n -= point.x;
            n2 -= point.y;
            component2 = component2.getParent();
        }
        return new Point(n, n2);
    }

    static {
        _sMouseGrab = null;
    }
}

