/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT.lwText;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import oracle.ewt.EwtComponent;
import oracle.ewt.border.Border;
import oracle.ewt.border.FrameBorder;
import oracle.ewt.graphics.frame.LoweredFramePainter;
import oracle.ewt.graphics.frame.PlainFramePainter;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.lwText.CursorIdler;
import oracle.ewt.lwAWT.lwText.TextPosition;
import oracle.ewt.util.ClipboardProxy;

public abstract class LWTextComponent
extends EwtComponent {
    private static Border _sDefaultBorder;
    private TextListener _textListener;
    private TextPosition _selectionStart;
    private TextPosition _selectionEnd;
    private transient boolean _isSelectionAnchoredAtStart = true;
    private boolean _isEditable = true;
    private boolean _isFocusable = true;
    transient boolean _isOKToDrawSelection = true;

    protected LWTextComponent() {
        this.enableEvents(1052L);
        this.setCursor(Cursor.getPredefinedCursor(2));
        this.setBorder(LWTextComponent.getDefaultBorder());
        this._selectionStart = this._selectionEnd = this.getPosition(0);
        this.setBackground(Color.white);
        this.setForeground(SystemColor.textText);
        this.enableInputMethods(true);
    }

    public void setText(String string) {
        LWTextComponent lWTextComponent = this;
        synchronized (lWTextComponent) {
            this.replaceRangeDamage(string, 0, this.getTextLength(), false);
        }
        this.repaintCanvas();
    }

    public abstract String getText();

    public String getSelectedText() {
        String string = null;
        LWTextComponent lWTextComponent = this;
        synchronized (lWTextComponent) {
            String string2 = this.getText();
            if (string2 != null) {
                string = string2.substring(this.getSelectionStart(), this.getSelectionEnd());
            }
        }
        return string;
    }

    public int getTextLength() {
        String string = this.getText();
        if (string == null) {
            return 0;
        }
        return string.length();
    }

    public static Border getDefaultBorder() {
        if (_sDefaultBorder == null) {
            _sDefaultBorder = new FrameBorder(1, LoweredFramePainter.getFramePainter(), new FrameBorder(1, PlainFramePainter.getFramePainter()));
        }
        return _sDefaultBorder;
    }

    public void setFocusable(boolean bl) {
        if (this._isFocusable != bl) {
            this._isFocusable = bl;
            if (!bl && this.hasFocus()) {
                this.transferFocus();
            }
        }
    }

    public boolean isFocusable() {
        return this._isFocusable;
    }

    public void setEditable(boolean bl) {
        if (this._isEditable != bl) {
            this._isEditable = bl;
            this.enableInputMethods(this.isEnabled() && bl);
        }
    }

    public boolean isEditable() {
        return this._isEditable;
    }

    public final synchronized void select(int n, int n2) {
        this.select(this.getPosition(n), this.getPosition(n2));
    }

    public final void selectAll() {
        this.select(0, this.getTextLength());
    }

    public final synchronized void setSelectionStart(int n) {
        this.select(this.getPosition(n), this.getSelectionStartPos());
    }

    public int getSelectionStart() {
        return this._selectionStart.getIndex();
    }

    public final synchronized void setSelectionEnd(int n) {
        this.select(this.getSelectionEndPos(), this.getPosition(n));
    }

    public int getSelectionEnd() {
        return this._selectionEnd.getIndex();
    }

    public final synchronized void setCaretPosition(int n) {
        this.setCaretPosition(this.getPosition(n));
    }

    public final int getCaretPosition() {
        return this.getSelectionStart();
    }

    public void addTextListener(TextListener textListener) {
        this._textListener = AWTEventMulticaster.add(this._textListener, textListener);
    }

    public void removeTextListener(TextListener textListener) {
        this._textListener = AWTEventMulticaster.remove(this._textListener, textListener);
    }

    public void insert(String string, int n) {
        this.replaceRange(string, n, n);
    }

    public synchronized void append(String string) {
        int n = this.getTextLength();
        this.replaceRange(string, n, n);
    }

    public void replaceRange(String string, int n, int n2) {
        Rectangle rectangle = this.replaceRangeDamage(string, n, n2, true);
        this.repaintCanvas(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void cut() {
        Rectangle rectangle;
        LWTextComponent lWTextComponent = this;
        synchronized (lWTextComponent) {
            this.copy();
            int n = this.getSelectionStart();
            int n2 = this.getSelectionEnd();
            rectangle = this.replaceRangeDamage(null, n, n2, true);
        }
        this.paintText(rectangle, true);
        this.deliverTextChangedIfNecessary(rectangle);
    }

    public void copy() {
        String string = this.getSelectedText();
        if (string.length() != 0) {
            StringSelection stringSelection = new StringSelection(string);
            Clipboard clipboard = ClipboardProxy.getSystemClipboard();
            clipboard.setContents(stringSelection, stringSelection);
        }
    }

    public boolean isOKToPaste(Transferable transferable) {
        return this.isEditable() && transferable != null && (transferable.isDataFlavorSupported(DataFlavor.stringFlavor) || transferable.isDataFlavorSupported(DataFlavor.plainTextFlavor));
    }

    public void paste() {
        Clipboard clipboard = ClipboardProxy.getSystemClipboard();
        Transferable transferable = clipboard.getContents(this);
        if (transferable != null && this.isOKToPaste(transferable)) {
            try {
                Rectangle rectangle;
                LWTextComponent lWTextComponent = this;
                synchronized (lWTextComponent) {
                    int n = this.getSelectionStart();
                    int n2 = this.getSelectionEnd();
                    rectangle = this.replaceRangeDamage(LWTextComponent.getPasteString(transferable), n, n2, true);
                }
                this.paintText(rectangle, true);
                this.deliverTextChangedIfNecessary(rectangle);
                return;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }
    }

    public void clear() {
        Rectangle rectangle;
        LWTextComponent lWTextComponent = this;
        synchronized (lWTextComponent) {
            int n = this.getSelectionStart();
            int n2 = this.getSelectionEnd();
            rectangle = this.replaceRangeDamage(null, n, n2, true);
        }
        this.paintText(rectangle, true);
        this.deliverTextChangedIfNecessary(rectangle);
    }

    public boolean isFocusTraversable() {
        return this._isFocusable;
    }

    public void enableInputMethods(boolean bl) {
    }

    public Color getBorderBackground() {
        return this.getParent().getBackground();
    }

    public Color getBorderForeground() {
        return this.getParent().getForeground();
    }

    public void setEnabled(boolean bl) {
        if (bl != this.isEnabled()) {
            super.setEnabled(bl);
            this.enableInputMethods(bl && this.isEditable());
            this.repaintCanvas();
        }
    }

    public void addNotify() {
        CursorIdler.getCursorIdler().addRef();
        super.addNotify();
        if (this.hasFocus()) {
            CursorIdler.getCursorIdler().setIdlee(this);
        }
    }

    public void removeNotify() {
        CursorIdler cursorIdler = CursorIdler.getCursorIdler();
        cursorIdler.cancel(this);
        cursorIdler.release();
        super.removeNotify();
    }

    public void requestFocus() {
        if (this.isFocusable()) {
            super.requestFocus();
        }
    }

    public void setFont(Font font) {
        if (font != this.getFont()) {
            super.setFont(font);
            this.repaint();
        }
    }

    boolean changeSelection(TextPosition textPosition, TextPosition textPosition2) {
        if (textPosition.getIndex() < 0) {
            textPosition = this.getPosition(0);
        }
        int n = this.getTextLength();
        if (textPosition2.getIndex() > n) {
            textPosition2 = this.getPosition(n);
        }
        if (textPosition.getIndex() > textPosition2.getIndex()) {
            textPosition = textPosition2;
        } else if (textPosition.getIndex() == textPosition2.getIndex()) {
            textPosition2 = textPosition;
        }
        if (!this._selectionStart.equals(textPosition) || !this._selectionEnd.equals(textPosition2)) {
            CursorIdler cursorIdler = CursorIdler.getCursorIdler();
            if (textPosition == textPosition2) {
                cursorIdler.schedule(this);
            } else {
                cursorIdler.cancel(this);
            }
            LWTextComponent lWTextComponent = this;
            synchronized (lWTextComponent) {
                this._selectionStart = textPosition;
                this._selectionEnd = textPosition2;
                this.setSelectionAnchoredAtStart(true);
            }
            return true;
        }
        return false;
    }

    protected void processTextEvent(TextEvent textEvent) {
        if (this._textListener != null) {
            this._textListener.textValueChanged(textEvent);
        }
    }

    protected void processEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof TextEvent) {
            this.processTextEvent((TextEvent)aWTEvent);
            return;
        }
        super.processEventImpl(aWTEvent);
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        int n = focusEvent.getID();
        if (n == 1004 || n == 1005) {
            LWComponent lWComponent = LWComponent.getFocusedComponent();
            LWTextComponent lWTextComponent = lWComponent instanceof LWTextComponent ? (LWTextComponent)lWComponent : null;
            CursorIdler.getCursorIdler().setIdlee(lWTextComponent);
            this.paintSelection();
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (!mouseEvent.isConsumed() && !this.isEnabled()) {
            mouseEvent.consume();
        }
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (keyEvent.getID() == 401 && !keyEvent.isConsumed()) {
            int n = keyEvent.getKeyCode();
            boolean bl = (keyEvent.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0;
            boolean bl2 = false;
            switch (n) {
                case 127: {
                    if (!this.isEditable()) {
                        Toolkit.getDefaultToolkit().beep();
                        bl2 = true;
                        break;
                    }
                    if (!keyEvent.isShiftDown()) break;
                    this.cut();
                    bl2 = true;
                    break;
                }
                case 155: {
                    if (keyEvent.isShiftDown()) {
                        this.paste();
                        bl2 = true;
                        break;
                    }
                    if (!bl) break;
                    this.copy();
                    bl2 = true;
                    break;
                }
                case 67: {
                    if (!bl) break;
                    this.copy();
                    bl2 = true;
                    break;
                }
                case 86: {
                    if (!bl) break;
                    this.paste();
                    bl2 = true;
                    break;
                }
                case 88: {
                    if (!bl) break;
                    this.cut();
                    bl2 = true;
                    break;
                }
            }
            if (bl2) {
                keyEvent.consume();
            }
        }
    }

    protected String paramString() {
        String string = super.paramString();
        String string2 = this.getText();
        if (string2.length() > 40) {
            string2 = string2.substring(0, 40);
        }
        string = String.valueOf(string) + ", text = " + string2;
        if (this.isEditable()) {
            string = String.valueOf(string) + ", editable";
        }
        string = String.valueOf(string) + ", selection = " + this.getSelectionStart() + " - " + this.getSelectionEnd();
        return string;
    }

    abstract Point scrollSelectionIntoView(TextPosition var1);

    abstract Rectangle getSelectionBounds(TextPosition var1, TextPosition var2);

    abstract TextPosition getPosition(int var1);

    abstract Rectangle replaceRangeValue(String var1, int var2, int var3);

    final synchronized Rectangle getSelectionBounds() {
        return this.getSelectionBounds(this.getSelectionStartPos(), this.getSelectionEndPos());
    }

    static String getPasteString(Transferable transferable) throws UnsupportedFlavorException, IOException {
        if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            return (String)transferable.getTransferData(DataFlavor.stringFlavor);
        }
        if (transferable.isDataFlavorSupported(DataFlavor.plainTextFlavor)) {
            byte[] byArray = (byte[])transferable.getTransferData(DataFlavor.plainTextFlavor);
            try {
                return new String(byArray, 0, byArray.length, "8859_1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return null;
            }
        }
        throw new UnsupportedFlavorException(DataFlavor.stringFlavor);
    }

    TextPosition getSelectionStartPos() {
        return this._selectionStart;
    }

    TextPosition getSelectionEndPos() {
        return this._selectionEnd;
    }

    void setSelectionAnchoredAtStart(boolean bl) {
        this._isSelectionAnchoredAtStart = bl;
    }

    boolean isSelectionAnchoredAtStart() {
        return this._isSelectionAnchoredAtStart;
    }

    final void select(TextPosition textPosition, TextPosition textPosition2) {
        this.select(textPosition, textPosition2, textPosition);
    }

    public final void setCaretPosition(TextPosition textPosition) {
        this.select(textPosition, textPosition);
    }

    synchronized void select(TextPosition textPosition, TextPosition textPosition2, TextPosition textPosition3) {
        TextPosition textPosition4 = this.getSelectionStartPos();
        TextPosition textPosition5 = this.getSelectionEndPos();
        if (!(textPosition4.equals(textPosition) && textPosition5.equals(textPosition2) || !this.changeSelection(textPosition, textPosition2))) {
            Cloneable cloneable;
            if (this.hasFocus() && (cloneable = this.getChangedSelectionBounds(textPosition4, textPosition5)) != null) {
                this.paintText((Rectangle)cloneable, true);
            }
            if ((cloneable = this.scrollSelectionIntoView(textPosition3)) != null) {
                this.setCanvasOrigin(cloneable.x, cloneable.y);
            }
        }
    }

    String replaceRangeFilter(String string, int n, int n2) {
        return string;
    }

    Rectangle replaceRangeDamage(String string, int n, int n2, boolean bl) {
        Point point = null;
        Rectangle rectangle = null;
        LWTextComponent lWTextComponent = this;
        synchronized (lWTextComponent) {
            string = string == null ? "" : this.replaceRangeFilter(string, n, n2);
            int n3 = string.length();
            if (n3 != 0 || n != n2) {
                Object object;
                Rectangle rectangle2 = this.getSelectionBounds();
                int n4 = n;
                if (bl) {
                    n4 += n3;
                }
                int n5 = this.getTextLength() - (n2 - n) + n3;
                if (this.getSelectionEnd() > n5) {
                    object = this.getPosition(n4);
                    this.changeSelection((TextPosition)object, (TextPosition)object);
                }
                object = this.replaceRangeValue(string, n, n2);
                TextPosition textPosition = this.getPosition(n4);
                this.changeSelection(textPosition, textPosition);
                point = this.scrollSelectionIntoView(textPosition);
                Rectangle rectangle3 = this.getSelectionBounds();
                rectangle = LWTextComponent._unionRectangles(LWTextComponent._unionRectangles(rectangle2, rectangle3), (Rectangle)object);
            }
        }
        if (point != null) {
            this.setCanvasOrigin(point.x, point.y);
        }
        return rectangle;
    }

    void paintText(Rectangle rectangle, boolean bl) {
        this._isOKToDrawSelection = bl;
        if (rectangle != null) {
            this.paintImmediateCanvas(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    void paintSelection() {
        this.paintText(this.getSelectionBounds(), true);
    }

    void eraseSelection() {
        this.paintText(this.getSelectionBounds(), false);
    }

    void deliverTextChangedIfNecessary(Rectangle rectangle) {
        if (rectangle != null) {
            this.processEvent(new TextEvent(this, 900));
        }
    }

    private static Rectangle _unionRectangles(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle == null && rectangle2 == null) {
            return null;
        }
        if (rectangle == null) {
            return rectangle2;
        }
        if (rectangle2 == null) {
            return rectangle;
        }
        return rectangle.union(rectangle2);
    }

    Rectangle getChangedSelectionBounds(TextPosition textPosition, TextPosition textPosition2) {
        if (!this.hasFocus()) {
            return null;
        }
        Rectangle rectangle = this.getSelectionBounds(textPosition, textPosition2);
        Rectangle rectangle2 = this.getSelectionBounds();
        return LWTextComponent._unionRectangles(rectangle, rectangle2);
    }
}

