/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.scrolling.scrollBox;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

final class ScrollBoxLayout
implements LayoutManager {
    private Component _hscroll;
    private Component _vscroll;
    private Component _center;

    public void addLayoutComponent(String string, Component component) {
        if ("Hscroll".equals(string)) {
            this._hscroll = component;
            return;
        }
        if ("Vscroll".equals(string)) {
            this._vscroll = component;
            return;
        }
        if ("Center".equals(string)) {
            this._center = component;
        }
    }

    public final void removeLayoutComponent(Component component) {
        if (component == this._hscroll) {
            this._hscroll = null;
            return;
        }
        if (component == this._vscroll) {
            this._vscroll = null;
            return;
        }
        if (component == this._center) {
            this._center = null;
        }
    }

    public final Dimension preferredLayoutSize(Container container) {
        Cloneable cloneable;
        Dimension dimension = new Dimension(0, 0);
        if (this._center != null) {
            cloneable = this._center.getPreferredSize();
            dimension.width = cloneable.width;
            dimension.height = cloneable.height;
        }
        if (this._hscroll != null) {
            cloneable = this._hscroll.getPreferredSize();
            dimension.height += cloneable.height;
            dimension.width = Math.max(cloneable.width, dimension.width);
        }
        if (this._vscroll != null) {
            cloneable = this._vscroll.getPreferredSize();
            dimension.width += cloneable.width;
            dimension.height = Math.max(cloneable.height, dimension.height);
        }
        cloneable = container.getInsets();
        dimension.width += ((Insets)cloneable).left + ((Insets)cloneable).right;
        dimension.height += ((Insets)cloneable).top + ((Insets)cloneable).bottom;
        return dimension;
    }

    public final Dimension minimumLayoutSize(Container container) {
        Cloneable cloneable;
        Dimension dimension = new Dimension(0, 0);
        if (this._center != null) {
            cloneable = this._center.getMinimumSize();
            dimension.width = cloneable.width;
            dimension.height = cloneable.height;
        }
        if (this._hscroll != null) {
            cloneable = this._hscroll.getMinimumSize();
            dimension.height += cloneable.height;
            dimension.width = Math.max(cloneable.width, dimension.width);
        }
        if (this._vscroll != null) {
            cloneable = this._vscroll.getMinimumSize();
            dimension.width += cloneable.width;
            dimension.height = Math.max(cloneable.height, dimension.height);
        }
        cloneable = container.getInsets();
        dimension.width += ((Insets)cloneable).left + ((Insets)cloneable).right;
        dimension.height += ((Insets)cloneable).top + ((Insets)cloneable).bottom;
        return dimension;
    }

    public final void layoutContainer(Container container) {
        Dimension dimension = container.getSize();
        Dimension dimension2 = new Dimension(0, 0);
        Dimension dimension3 = new Dimension(0, 0);
        Insets insets = container.getInsets();
        dimension.width -= insets.left + insets.right;
        dimension.height -= insets.top + insets.bottom;
        if (this._hscroll != null && this._hscroll.isVisible()) {
            dimension2 = this._hscroll.getPreferredSize();
        }
        if (this._vscroll != null && this._vscroll.isVisible()) {
            dimension3 = this._vscroll.getPreferredSize();
        }
        if (this._center != null) {
            this._center.setBounds(insets.left, insets.top, dimension.width - dimension3.width, dimension.height - dimension2.height);
        }
        if (this._hscroll != null && this._hscroll.isVisible()) {
            this._hscroll.setBounds(insets.left, insets.top + dimension.height - dimension2.height, dimension.width - dimension3.width, dimension2.height);
        }
        if (this._vscroll != null && this._vscroll.isVisible()) {
            this._vscroll.setBounds(insets.left + dimension.width - dimension3.width, insets.top, dimension3.width, dimension.height - dimension2.height);
        }
    }
}

