/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;

public class WindowUtils {
    public static Frame parentFrame(Component component) {
        while (component != null) {
            if (component instanceof Frame) {
                return (Frame)component;
            }
            component = component.getParent();
        }
        return null;
    }

    public static void centerWindow(Window window, Component component) {
        if (component == null || !component.isShowing()) {
            return;
        }
        Point point = component.getLocationOnScreen();
        Dimension dimension = component.getSize();
        Dimension dimension2 = window.getSize();
        int n = point.x + (dimension.width - dimension2.width) / 2;
        int n2 = point.y + (dimension.height - dimension2.height) / 3;
        Dimension dimension3 = Toolkit.getDefaultToolkit().getScreenSize();
        if (n + dimension2.width > dimension3.width) {
            n = dimension3.width - dimension2.width;
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 + dimension2.height > dimension3.height) {
            n2 = dimension3.height - dimension2.height;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        ((Component)window).setLocation(n, n2);
    }

    public static Window getWindow(Component component) {
        while (component != null) {
            if (component instanceof Window) {
                return (Window)component;
            }
            component = component.getParent();
        }
        return null;
    }
}

