/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.wizard;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import oracle.ewt.button.EwtButton;
import oracle.ewt.button.TextContent;
import oracle.ewt.event.HelpEvent;
import oracle.ewt.event.HelpListener;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.wizard.WizardEvent;
import oracle.ewt.wizard.WizardListener;
import oracle.ewt.wizard.WizardPage;
import oracle.ewt.wizard.WizardRowLayout;

public abstract class BaseWizard
extends LWComponent {
    private LWComponent _buttonRow;
    Component _apply;
    Component _cancel;
    Component _finish;
    Component _next;
    Component _previous;
    Component _help;
    private Vector _pages;
    private ListenerManager _wizardListeners;
    private ListenerManager _helpListeners;
    private WizardPage _selectedPage;
    private int _customButtons;
    private static final int _BUTTON_SEPARATION = 12;
    private static final int _BUTTON_CONTENT_DISTANCE = 10;
    private static final String _FINISH_KEY = "FINISH";
    private static final String _APPLY_KEY = "APPLY";
    private static final String _CANCEL_KEY = "CANCEL";
    private static final String _PREVIOUS_KEY = "PREV";
    private static final String _NEXT_KEY = "NEXT";
    private static final String _HELP_KEY = "HELP";

    protected BaseWizard() {
        Action action = new Action();
        this.setLayout(new BorderLayout(0, 10));
        this._buttonRow = new LWComponent();
        this._buttonRow.setLayout(new WizardRowLayout(12));
        this.add("South", this._buttonRow);
        this._pages = new Vector();
        Component component = this.createButton(action);
        this._buttonRow.add(component, "Cancel");
        this._cancel = component;
        component = this.createButton(action);
        component.setVisible(false);
        this._buttonRow.add(component, "Help");
        this._help = component;
        component = this.createButton(action);
        component.setEnabled(false);
        this._buttonRow.add(component, "Back");
        this._previous = component;
        component = this.createButton(action);
        component.setEnabled(false);
        this._buttonRow.add(component, "Next");
        this._next = component;
        component = this.createButton(action);
        component.setVisible(false);
        this._buttonRow.add(component, "Apply");
        this._apply = component;
        component = this.createButton(action);
        component.setEnabled(false);
        this._buttonRow.add(component, "Finish");
        this._finish = component;
    }

    public void setHelpAvailable(boolean bl) {
        this._help.setVisible(bl);
    }

    public boolean isHelpAvailable() {
        return this._help.isVisible();
    }

    public void setCanApply(boolean bl) {
        this._apply.setVisible(bl);
    }

    public boolean getCanApply() {
        return this._apply.isVisible();
    }

    public final WizardPage addPage(WizardPage wizardPage) {
        return this.addPage(wizardPage, null);
    }

    public synchronized WizardPage addPage(WizardPage wizardPage, WizardPage wizardPage2) {
        if (wizardPage.getParent() != null) {
            wizardPage.getParent().removePage(wizardPage);
        }
        if (wizardPage2 == null) {
            this._pages.addElement(wizardPage);
        } else {
            this._pages.insertElementAt(wizardPage, this._pages.indexOf(wizardPage2));
        }
        wizardPage.setParent(this);
        if (this.getSelectedPage() == null && wizardPage.isEnabled() && wizardPage.isVisible()) {
            this.selectPage(wizardPage, false);
        }
        this.enableButtons();
        return wizardPage;
    }

    public final void addPages(BaseWizard baseWizard, WizardPage wizardPage) {
        Object[] objectArray;
        if (baseWizard == this || baseWizard.getPageCount() == 0) {
            return;
        }
        BaseWizard baseWizard2 = baseWizard;
        synchronized (baseWizard2) {
            objectArray = new WizardPage[baseWizard.getPageCount()];
            baseWizard._pages.copyInto(objectArray);
            baseWizard.removeAllPages();
        }
        int n = 0;
        while (n < objectArray.length) {
            this.addPage((WizardPage)objectArray[n], wizardPage);
            ++n;
        }
    }

    public synchronized void removePage(WizardPage wizardPage) {
        if (this._selectedPage == wizardPage) {
            WizardPage wizardPage2 = this.getNextPage(wizardPage);
            if (wizardPage2 == null) {
                wizardPage2 = this.getPreviousPage(wizardPage);
            }
            this.selectPage(wizardPage2, false);
        }
        this._pages.removeElement(wizardPage);
        wizardPage.setParent(null);
        this.enableButtons();
    }

    public synchronized void removeAllPages() {
        int n = this.getPageCount();
        while (--n >= 0) {
            this.getPageAt(n).setParent(null);
        }
        this._pages.removeAllElements();
        this.selectPage(null, false);
        this.enableButtons();
    }

    public int getPageCount() {
        return this._pages.size();
    }

    public WizardPage getPageAt(int n) {
        return (WizardPage)this._pages.elementAt(n);
    }

    public WizardPage getSelectedPage() {
        return this._selectedPage;
    }

    public int getCurrentPageIndex() {
        WizardPage wizardPage = this.getSelectedPage();
        if (wizardPage == null) {
            return -1;
        }
        return wizardPage.getIndex();
    }

    public void selectPage(WizardPage wizardPage) {
        this.selectPage(wizardPage, true);
    }

    public void restart() {
        if (this.getPageCount() == 0) {
            return;
        }
        WizardPage wizardPage = this.getPageAt(0);
        if (!wizardPage.isEnabled() || !wizardPage.isVisible()) {
            wizardPage = this.getNextPage(wizardPage);
        }
        if (wizardPage != null) {
            this.selectPage(wizardPage, false);
        }
    }

    public WizardPage getNextPage(WizardPage wizardPage) {
        if (wizardPage == null) {
            return null;
        }
        int n = wizardPage.getIndex();
        int n2 = this.getPageCount();
        while (++n < n2) {
            WizardPage wizardPage2 = this.getPageAt(n);
            if (!wizardPage2.isVisible() || !wizardPage2.isEnabled()) continue;
            return wizardPage2;
        }
        return null;
    }

    public WizardPage getPreviousPage(WizardPage wizardPage) {
        if (wizardPage == null) {
            return null;
        }
        int n = wizardPage.getIndex();
        while (--n >= 0) {
            WizardPage wizardPage2 = this.getPageAt(n);
            if (!wizardPage2.isVisible() || !wizardPage2.isEnabled()) continue;
            return wizardPage2;
        }
        return null;
    }

    public synchronized void addHelpListener(HelpListener helpListener) {
        if (this._helpListeners == null) {
            this._helpListeners = new ListenerManager();
        }
        this._helpListeners.addListener(helpListener);
    }

    public synchronized void removeHelpListener(HelpListener helpListener) {
        this._helpListeners.removeListener(helpListener);
    }

    public synchronized void addWizardListener(WizardListener wizardListener) {
        if (this._wizardListeners == null) {
            this._wizardListeners = new ListenerManager();
        }
        this._wizardListeners.addListener(wizardListener);
    }

    public synchronized void removeWizardListener(WizardListener wizardListener) {
        this._wizardListeners.removeListener(wizardListener);
    }

    public void addCustomButton(Component component) {
        if (component.getParent() != this._buttonRow) {
            this._buttonRow.add(component, 2 + this._customButtons);
            ++this._customButtons;
        }
    }

    public void removeCustomButton(Component component) {
        if (component.getParent() == this._buttonRow) {
            --this._customButtons;
            this._buttonRow.remove(component);
        }
    }

    public void setReservedButtonSpaces(int n) {
        ((WizardRowLayout)this._buttonRow.getLayout()).setReservedButtonSpaces(n);
    }

    public int getReservedButtonSpaces() {
        return ((WizardRowLayout)this._buttonRow.getLayout()).getReservedButtonSpaces();
    }

    public void setButtonFont(Font font) {
        ((Component)this._buttonRow).setFont(font);
    }

    public Font getButtonFont() {
        return this._buttonRow.getFont();
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (this.getParent() != null) {
            this.loadButtonText(locale);
        }
    }

    public void addNotify() {
        super.addNotify();
        this.loadButtonText(this.getLocale());
    }

    protected boolean getMustFinish() {
        return true;
    }

    protected boolean getCanAdvance() {
        WizardPage wizardPage = this.getSelectedPage();
        if (wizardPage == null) {
            return false;
        }
        return wizardPage.getCanAdvance();
    }

    protected void doCancel() {
        this.processEvent(new WizardEvent(this, 2003, this.getSelectedPage()));
    }

    protected void doApply() {
        if (this.validateSelectedPage()) {
            this.processEvent(new WizardEvent(this, 2002, this.getSelectedPage()));
        }
    }

    protected void doFinish() {
        if (this.validateSelectedPage()) {
            this.processEvent(new WizardEvent(this, 2004, this.getSelectedPage()));
        }
    }

    protected void doNext() {
        WizardPage wizardPage;
        if (this.validateSelectedPage() && (wizardPage = this.getNextPage(this.getSelectedPage())) != null) {
            this.selectPage(wizardPage, false);
        }
    }

    protected void doPrevious() {
        WizardPage wizardPage = this.getPreviousPage(this.getSelectedPage());
        if (wizardPage != null) {
            this.selectPage(wizardPage, false);
        }
    }

    protected void doHelp() {
        WizardPage wizardPage = this.getSelectedPage();
        this.processEvent(new HelpEvent(this, 2000));
        if (wizardPage != null) {
            wizardPage.processHelpEvent(new HelpEvent(wizardPage, 2000));
        }
    }

    protected void processEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent instanceof HelpEvent) {
            this.processHelpEvent((HelpEvent)aWTEvent);
            return;
        }
        if (aWTEvent instanceof WizardEvent) {
            this.processWizardEvent((WizardEvent)aWTEvent);
            return;
        }
        super.processEventImpl(aWTEvent);
    }

    protected void processHelpEvent(HelpEvent helpEvent) {
        Enumeration enumeration;
        int n = helpEvent.getID();
        ListenerManager listenerManager = this._helpListeners;
        if (listenerManager != null && (enumeration = listenerManager.getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                HelpListener helpListener = (HelpListener)enumeration.nextElement();
                helpListener.helpRequested(helpEvent);
            }
        }
    }

    protected void processWizardEvent(WizardEvent wizardEvent) {
        Enumeration enumeration;
        int n = wizardEvent.getID();
        ListenerManager listenerManager = this._wizardListeners;
        if (listenerManager != null && (enumeration = listenerManager.getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                WizardListener wizardListener = (WizardListener)enumeration.nextElement();
                switch (n) {
                    case 2001: {
                        wizardListener.wizardSelectionChanged(wizardEvent);
                        break;
                    }
                    case 2002: {
                        wizardListener.wizardApplyState(wizardEvent);
                        break;
                    }
                    case 2003: {
                        wizardListener.wizardCanceled(wizardEvent);
                        break;
                    }
                    case 2004: {
                        wizardListener.wizardFinished(wizardEvent);
                        break;
                    }
                }
            }
        }
    }

    protected void loadButtonText(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.ewt.wizard.resource.WizardBundle", locale);
        this.setButtonLabel(this._finish, resourceBundle.getString(_FINISH_KEY));
        this.setButtonLabel(this._apply, resourceBundle.getString(_APPLY_KEY));
        this.setButtonLabel(this._help, resourceBundle.getString(_HELP_KEY));
        this.setButtonLabel(this._previous, resourceBundle.getString(_PREVIOUS_KEY));
        this.setButtonLabel(this._next, resourceBundle.getString(_NEXT_KEY));
        this.setButtonLabel(this._cancel, resourceBundle.getString(_CANCEL_KEY));
    }

    protected String paramString() {
        String string = super.paramString();
        WizardPage wizardPage = this._selectedPage;
        if (wizardPage != null) {
            string = String.valueOf(string) + ",selected page=" + wizardPage;
        }
        return string;
    }

    protected void enableButtons() {
        WizardPage wizardPage = this._selectedPage;
        WizardPage wizardPage2 = this.getNextPage(wizardPage);
        boolean bl = this.getCanAdvance();
        this._finish.setEnabled(bl && (!this.getMustFinish() || wizardPage2 == null));
        this._next.setEnabled(bl && wizardPage2 != null);
        this._previous.setEnabled(this.getPreviousPage(wizardPage) != null);
        this._apply.setEnabled(bl);
    }

    protected void selectPage(WizardPage wizardPage, boolean bl) {
        if (wizardPage != this._selectedPage && (!bl || this.validateSelectedPage())) {
            this.setSelectedPage(wizardPage);
            this.processEvent(new WizardEvent(this, 2001, wizardPage));
            this.enableButtons();
        }
    }

    protected void setSelectedPage(WizardPage wizardPage) {
        this._selectedPage = wizardPage;
    }

    protected boolean validateSelectedPage() {
        WizardPage wizardPage = this.getSelectedPage();
        if (wizardPage == null) {
            return true;
        }
        return wizardPage.validatePage();
    }

    protected Component createButton(ActionListener actionListener) {
        EwtButton ewtButton = new EwtButton("");
        ewtButton.addActionListener(actionListener);
        return ewtButton;
    }

    protected void setButtonLabel(Component component, String string) {
        TextContent textContent = (TextContent)((EwtButton)component).getContent();
        textContent.setText(string);
    }

    int getPageIndex(WizardPage wizardPage) {
        int n = this._pages.indexOf(wizardPage);
        return n;
    }

    private class Action
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == BaseWizard.this._apply) {
                BaseWizard.this.doApply();
                return;
            }
            if (object == BaseWizard.this._cancel) {
                BaseWizard.this.doCancel();
                return;
            }
            if (object == BaseWizard.this._finish) {
                BaseWizard.this.doFinish();
                return;
            }
            if (object == BaseWizard.this._next) {
                BaseWizard.this.doNext();
                return;
            }
            if (object == BaseWizard.this._previous) {
                BaseWizard.this.doPrevious();
                return;
            }
            if (object == BaseWizard.this._help) {
                BaseWizard.this.doHelp();
            }
        }

        Action() {
            BaseWizard.this = BaseWizard.this;
        }
    }
}

