/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.bean;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.beans.Beans;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.Certificate;
import sun.misc.BASE64Encoder;
import sun.net.www.protocol.http.HttpAuthenticator;
import sun.net.www.protocol.http.HttpURLConnection;
import sunw.hotjava.bean.FrameFinder;
import sunw.hotjava.ui.AuthenticationDialog;

public class AuthenticatorBean
extends Component
implements HttpAuthenticator,
Externalizable {
    private String username;
    private String pw;
    private Frame frame;
    private URL url;
    private String realm;
    private String scheme;
    private static final String label = "AuthenticatorBean";
    static final long serialVersionUID = -6317711592517058059L;
    private static final int TEXT_XPAD = 12;
    private static final int TEXT_YPAD = 8;
    private static final int currentVersion = 1;

    public AuthenticatorBean() {
        HttpURLConnection.setDefaultAuthenticator(this);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public void setPassword(String string) {
        this.pw = string;
    }

    public InetAddress getRequestingSite() {
        try {
            return InetAddress.getByName(this.url.getHost());
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public int getRequestingPort() {
        return this.url.getPort();
    }

    public String getRequestingPrompt() {
        return this.realm;
    }

    public String getRequestingScheme() {
        return this.scheme;
    }

    public URL getRequestingURL() {
        return this.url;
    }

    public Certificate getUserCertificate() {
        return null;
    }

    public void setUserCertificate(Certificate certificate) {
    }

    public Certificate[] getSiteCertificate() {
        return null;
    }

    public String getRequestingPurpose() {
        return null;
    }

    public boolean authorize(Frame frame, boolean bl) {
        return false;
    }

    public boolean isTrusted(Frame frame) {
        return false;
    }

    public boolean schemeSupported(String string) {
        return "Basic".equalsIgnoreCase(string);
    }

    public String authString(URL uRL, String string, String string2) {
        this.frame = this.getFrame();
        this.url = uRL;
        this.scheme = string;
        this.realm = string2;
        this.getAuthentication();
        if (this.username != null && this.pw != null) {
            String string3 = String.valueOf(this.username) + ":" + this.pw;
            this.pw = null;
            byte[] byArray = string3.getBytes();
            return new BASE64Encoder().encode(byArray);
        }
        return null;
    }

    public Dimension getPreferredSize() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        return new Dimension(fontMetrics.stringWidth(label) + 12, fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + 8);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        if (!Beans.isDesignTime()) {
            graphics.clearRect(0, 0, n, n2);
            return;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.drawString(label, (n - fontMetrics.stringWidth(label)) / 2, (n2 + fontMetrics.getMaxAscent() - fontMetrics.getMaxDescent()) / 2);
    }

    protected void getAuthentication() {
        AuthenticationDialog authenticationDialog = new AuthenticationDialog("hotjava.auth", this.frame);
        authenticationDialog.getAuthString(this.url, this.realm, this.username);
        this.username = authenticationDialog.getUserName();
        this.pw = authenticationDialog.getPassword();
    }

    private Frame getFrame() {
        if (this.frame instanceof FrameFinder) {
            FrameFinder frameFinder = (FrameFinder)((Object)this.frame);
            return frameFinder.getActiveFrame();
        }
        return this.frame;
    }

    public void addNotify() {
        super.addNotify();
        Container container = this.getParent();
        while (container != null) {
            if (container instanceof FrameFinder) {
                this.frame = (Frame)container;
                break;
            }
            if (container instanceof Frame) {
                this.frame = (Frame)container;
            }
            container = container.getParent();
        }
        this.setSize();
    }

    private void setSize() {
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getPreferredSize();
        if (dimension2.width > dimension.width || dimension2.height > dimension.height) {
            int n;
            int n2 = dimension.width;
            if (dimension2.width > n2) {
                n2 = dimension2.width;
            }
            if (dimension2.height > (n = dimension.height)) {
                n = dimension2.height;
            }
            this.setSize(n2, n);
            Container container = this.getParent();
            if (container != null) {
                ((Component)container).invalidate();
            }
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(1);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        if (n != 1) {
            throw new IOException("version number mismatch for AuthenticatorBean.");
        }
    }
}

