/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.doc;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.PrintGraphics;
import java.io.IOException;
import java.text.BreakIterator;
import sunw.hotjava.doc.DocItem;
import sunw.hotjava.doc.DocLine;
import sunw.hotjava.doc.DocStyle;
import sunw.hotjava.doc.Document;
import sunw.hotjava.doc.DocumentState;
import sunw.hotjava.doc.FormatState;
import sunw.hotjava.doc.Formatter;
import sunw.hotjava.doc.MeasureState;
import sunw.hotjava.doc.Measurement;
import sunw.hotjava.doc.OverlappingStringMatch;
import sunw.hotjava.doc.TagItem;
import sunw.hotjava.doc.TextCharIterator;
import sunw.hotjava.doc.TraversalState;
import sunw.hotjava.misc.ScalingGraphics;
import sunw.html.HTMLOutputWriter;

public class TextItem
extends DocItem {
    char[] data;
    int length;
    private boolean isPseudoTextItem = false;
    private static final float brightWhiteThreshold = 0.95f;
    private static final float satWhiteThreshold = 0.05f;
    private static final float hueWhiteThreshold = 0.05f;
    private static boolean enableFastFormatText;
    private boolean fastFormatTextOK = enableFastFormatText;
    static float[] hsb;

    public static void initProperties() {
        enableFastFormatText = Boolean.getBoolean("hotjava.optimizeLineBreaks");
    }

    TextItem(char[] cArray, int n, int n2) {
        this.data = new char[n2];
        this.length = n2;
        System.arraycopy(cArray, n, this.data, 0, n2);
        this.checkFastFormatTextOK(cArray);
    }

    public void setPseudoTextItem(boolean bl) {
        this.isPseudoTextItem = bl;
    }

    public int findLabel(String string) {
        if (string.length() > 0 && string.charAt(0) == '@') {
            int n = Integer.parseInt(string.substring(1));
            if (n-- <= 1) {
                return this.index << 16;
            }
            int n2 = this.length;
            int n3 = 0;
            while (n3 < n2) {
                if (this.data[n3] == '\r') {
                    if (n3 + 1 < n2 && this.data[n3 + 1] == '\n') {
                        ++n3;
                    }
                    if (n-- <= 1) {
                        return this.index << 16 | n3;
                    }
                } else if (this.data[n3] == '\n' && n-- <= 1) {
                    return this.index << 16 | n3;
                }
                ++n3;
            }
        }
        return -1;
    }

    public boolean isText() {
        return true;
    }

    public String getText() {
        return new String(this.data, 0, this.length);
    }

    public String getText(int n, int n2) {
        if (n > n2) {
            return null;
        }
        int n3 = n >> 16;
        int n4 = n2 >> 16;
        int n5 = this.getIndex();
        int n6 = 0;
        int n7 = 0;
        if (n3 > n5 || n4 < n5) {
            return null;
        }
        n6 = n3 == n5 ? n & 0xFFFF : 0;
        n7 = n4 == n5 ? n2 & 0xFFFF : this.length;
        return new String(this.data, n6, n7 - n6);
    }

    public void write(HTMLOutputWriter hTMLOutputWriter) throws IOException {
        hTMLOutputWriter.text(this.data, this.length);
    }

    public int startOffset(Document document, int n) {
        if (n > this.length) {
            n = this.length;
        }
        while (n-- > 0) {
            switch (this.data[n]) {
                case '\n': 
                case '\r': {
                    return n + 1;
                }
            }
        }
        if (this.index > 0 && document.items[this.index - 1].isBlock() && document.items[this.index - 1].isEnd()) {
            return 0;
        }
        return -1;
    }

    public boolean ignoreInitialSpace(Formatter formatter, DocItem docItem) {
        Document document = formatter.getDocument();
        TagItem tagItem = docItem.getTag(document);
        if (tagItem != null && tagItem.isPreformatted()) {
            return false;
        }
        if (docItem.isBlock() || formatter.isFloater(docItem)) {
            return true;
        }
        return docItem.isEnd() && formatter.isFloater(docItem = document.items[docItem.getIndex() + docItem.getOffset()]);
    }

    public boolean format(Formatter formatter, FormatState formatState, FormatState formatState2) {
        if (formatState.state == 2) {
            return true;
        }
        int n = formatState.pos & 0x7FFF0000;
        int n2 = formatState.pos & 0xFFFF;
        DocStyle docStyle = formatState.style;
        int n3 = formatState.width;
        int n4 = formatState.maxWidth;
        FontMetrics fontMetrics = docStyle.font.getFontMetrics(docStyle);
        if (n2 == 0 && this.data.length != 0 && this.data[n2] == ' ') {
            Document document = formatter.getDocument();
            boolean bl = false;
            if (formatState.width == 0) {
                bl = true;
            } else {
                int n5 = this.getIndex() - 1;
                while (n5 >= 0) {
                    DocItem docItem = document.items[n5];
                    if (docItem.isText()) {
                        TextItem textItem = (TextItem)docItem;
                        if (textItem.getText().length() != 0) break;
                        bl = true;
                        break;
                    }
                    if (this.ignoreInitialSpace(formatter, docItem)) {
                        bl = true;
                        break;
                    }
                    --n5;
                }
            }
            if (bl) {
                if (this.length > 1) {
                    char[] cArray = new char[--this.length];
                    System.arraycopy(this.data, 1, cArray, 0, this.length);
                    this.data = cArray;
                } else {
                    this.length = 0;
                    if (!docStyle.nobreak) {
                        formatter.setBreak(formatState, formatState2, n2, n3);
                    }
                    formatState.pos = n + 65536;
                    return false;
                }
            }
        }
        formatState.state = 1;
        if (n2 < this.length) {
            formatState.ascent = Math.max(formatState.ascent, fontMetrics.getAscent());
            formatState.descent = Math.max(formatState.descent, fontMetrics.getDescent());
            formatState.textAscent = Math.max(formatState.textAscent, fontMetrics.getAscent());
        }
        if (docStyle.nobreak) {
            return this.formatNonBreakText(n, n2, formatState, n3, fontMetrics);
        }
        return this.formatText(formatter, n, n2, formatState, formatState2, n3, n4, fontMetrics);
    }

    private boolean formatNonBreakText(int n, int n2, FormatState formatState, int n3, FontMetrics fontMetrics) {
        int n4 = fontMetrics.charWidth('0') * 8;
        while (n2 < this.length) {
            int n5 = this.data[n2++] & 0xFFFF;
            switch (n5) {
                case 13: {
                    if (n2 < this.length && this.data[n2] == '\n') {
                        ++n2;
                    }
                }
                case 10: {
                    formatState.pos = n | n2;
                    formatState.width = n3;
                    return true;
                }
                case 9: {
                    n3 += n4 - n3 % n4;
                    break;
                }
                case 160: {
                    n3 += fontMetrics.charWidth(' ');
                    break;
                }
                default: {
                    n3 += fontMetrics.charWidth(n5);
                    break;
                }
            }
        }
        formatState.width = n3;
        formatState.pos = n + 65536;
        return false;
    }

    private boolean formatText(Formatter formatter, int n, int n2, FormatState formatState, FormatState formatState2, int n3, int n4, FontMetrics fontMetrics) {
        if (this.fastFormatTextOK) {
            return this.fastFormatText(formatter, n, n2, formatState, formatState2, n3, n4, fontMetrics);
        }
        BreakIterator breakIterator = BreakIterator.getLineInstance();
        TextCharIterator textCharIterator = new TextCharIterator(this.data, n2);
        breakIterator.setText(textCharIterator);
        int n5 = n2;
        int n6 = breakIterator.first();
        while (n6 != -1) {
            int n7 = fontMetrics.charsWidth(this.data, n5, n6 - n5);
            if ((n3 += n7) > n4 && n6 > n5) {
                formatter.setBreak(formatState, formatState2, n5, n3 - n7);
                formatState.pos = n | n6;
                formatState.width = n3;
                return false;
            }
            n5 = n6;
            n6 = breakIterator.next();
        }
        formatState.width = n3;
        formatState.pos = n + 65536;
        return false;
    }

    private boolean fastFormatText(Formatter formatter, int n, int n2, FormatState formatState, FormatState formatState2, int n3, int n4, FontMetrics fontMetrics) {
        int n5 = fontMetrics.getMaxAdvance();
        if (n5 <= 0) {
            n5 = n4 + 1;
        }
        int n6 = n2;
        int n7 = n3;
        while (n6 < this.data.length) {
            int n8;
            int n9;
            int n10 = (n4 - n3) / n5 + n6;
            if (n10 >= this.data.length) {
                n9 = this.data.length;
            } else {
                n9 = n10;
                while (n9 > n6 && this.data[n9] != ' ') {
                    --n9;
                }
                if (n9 <= n6) {
                    n9 = n6 + 1;
                    while (n9 < this.data.length && this.data[n9] != ' ') {
                        ++n9;
                    }
                }
            }
            if (n9 < this.data.length) {
                ++n9;
            }
            if ((n3 += (n8 = fontMetrics.charsWidth(this.data, n6, n9 - n6))) > n4 && n9 > n6) {
                formatter.setBreak(formatState, formatState2, n6, n7);
                formatState.pos = n | n9;
                formatState.width = n3;
                return false;
            }
            n6 = n9;
            n7 = n3;
            if (n9 == this.data.length) break;
        }
        formatState.width = n3;
        formatState.pos = n + 65536;
        return false;
    }

    public int paint(Formatter formatter, Graphics graphics, int n, int n2, DocLine docLine) {
        DocStyle docStyle = formatter.displayStyle;
        int n3 = formatter.displayPos;
        int n4 = n3 & 0xFFFF;
        int n5 = n3 >>> 16 == docLine.end >>> 16 ? docLine.end & 0xFFFF : this.length;
        int n6 = 0;
        if (this.length == 0) {
            formatter.displayPos = (formatter.displayPos & 0x7FFF0000) + 65536;
            return n6;
        }
        Color color = docStyle.color;
        if (graphics instanceof PrintGraphics && this.isColorCloseToWhite(color)) {
            color = Color.black;
        }
        graphics.setColor(color);
        graphics.setFont(docStyle.font);
        n2 += docLine.baseline;
        FontMetrics fontMetrics = docStyle.getFontMetrics();
        int n7 = fontMetrics.charWidth('0') * 8;
        switch (docStyle.script) {
            case 6: {
                n2 -= docLine.textAscent - fontMetrics.getAscent();
                break;
            }
            case 7: {
                n2 += docLine.lndescent - fontMetrics.getDescent();
                break;
            }
        }
        if (docStyle.format == 2) {
            int n8 = n4;
            while (n8 < n5) {
                char c = this.data[n8];
                if (c < ' ') {
                    graphics.drawChars(this.data, n4, n8 - n4, n + n6, n2);
                    n6 += fontMetrics.charsWidth(this.data, n4, n8 - n4);
                    if (c == '\t') {
                        n6 += n7 - (n + n6 - (docLine.margin >>> 16)) % n7;
                    }
                    n4 = n8 + 1;
                }
                ++n8;
            }
            graphics.drawChars(this.data, n4, n5 - n4, n + n6, n2);
            n6 += fontMetrics.charsWidth(this.data, n4, n5 - n4);
        } else {
            graphics.drawChars(this.data, n4, n5 - n4, n, n2);
            n6 = fontMetrics.charsWidth(this.data, n4, n5 - n4);
        }
        if (docStyle.underline && (this.length != 1 || (this.data[0] & 0xFF) != 32)) {
            if (graphics instanceof ScalingGraphics) {
                ((ScalingGraphics)graphics).drawTextUnderline(n, n2, n + n6, n2);
            } else {
                graphics.drawLine(n, n2 + 1, n + n6, n2 + 1);
            }
        }
        if (docStyle.strike) {
            graphics.drawLine(n, n2 - fontMetrics.getAscent() / 2, n + n6, n2 - fontMetrics.getAscent() / 2);
        }
        formatter.displayPos = (formatter.displayPos & 0x7FFF0000) + 65536;
        return n6;
    }

    private boolean isColorCloseToWhite(Color color) {
        if (hsb == null) {
            hsb = new float[3];
        }
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsb);
        float f = hsb[0];
        float f2 = hsb[1];
        float f3 = hsb[2];
        return f3 >= 0.95f && f <= 0.05f && f2 <= 0.05f;
    }

    public boolean doesOverflow(TraversalState traversalState, Formatter formatter, DocLine docLine, int n, Dimension dimension) {
        DocumentState documentState = formatter.getDocumentState();
        Document document = formatter.getDocument();
        DocStyle docStyle = document.getStyle(documentState.docStyle, traversalState.pos);
        traversalState.pos += 65536;
        n += docLine.baseline;
        FontMetrics fontMetrics = docStyle.getFontMetrics();
        switch (docStyle.script) {
            case 6: {
                n -= docLine.lnascent - fontMetrics.getAscent();
                break;
            }
            case 7: {
                n += docLine.lndescent - fontMetrics.getDescent();
                break;
            }
        }
        return n + fontMetrics.getDescent() > dimension.height;
    }

    public int findX(DocLine docLine, DocStyle docStyle, int n, int n2, int n3, Formatter formatter) {
        if (n >= n3) {
            return n2;
        }
        if (this.isPseudoTextItem) {
            return -1;
        }
        int n4 = n2 & 0x7FFF0000;
        int n5 = n2 & 0xFFFF;
        FontMetrics fontMetrics = docStyle.getFontMetrics();
        int n6 = fontMetrics.charWidth('0') * 8;
        int n7 = 0;
        n3 -= n;
        while (n5 < this.length) {
            int n8;
            int n9 = this.data[n5++] & 0xFFFF;
            switch (n9) {
                case 13: {
                    if (n5 < this.length && this.data[n5] == '\n') {
                        ++n5;
                    }
                }
                case 10: {
                    return n4 | n5;
                }
                case 9: {
                    n8 = n6 - (n + n7) % n6;
                    break;
                }
                case 160: {
                    n8 = fontMetrics.charWidth(' ');
                    break;
                }
                default: {
                    n8 = fontMetrics.charWidth(n9);
                }
            }
            if (n7 + (n8 >> 1) >= n3) {
                return n4 | n5 - 1;
            }
            if ((n7 += n8) < n3) continue;
            return n4 | n5;
        }
        return -1 - n7;
    }

    public int getWidth(DocLine docLine, DocStyle docStyle, int n, int n2, int n3) {
        if (n3 > this.length) {
            n3 = this.length;
        }
        if (n2 >= n3) {
            return 0;
        }
        FontMetrics fontMetrics = docStyle.getFontMetrics();
        int n4 = fontMetrics.charWidth('0') * 8;
        int n5 = 0;
        while (n2 < n3) {
            int n6 = this.data[n2++] & 0xFFFF;
            switch (n6) {
                case 10: 
                case 13: {
                    return n5;
                }
                case 9: {
                    n5 += n4 - (n + n5) % n4;
                    break;
                }
                default: {
                    n5 += fontMetrics.charWidth(n6);
                    break;
                }
            }
        }
        return n5;
    }

    public int insert(Document document, int n, char[] cArray, int n2, int n3) {
        int n4;
        if (this.length + n3 > 65535) {
            return -1;
        }
        if (n2 > this.length) {
            n2 = this.length;
        }
        if (this.length + n3 > this.data.length) {
            char[] cArray2 = new char[Math.max(this.data.length * 2, this.length + n3 + 10)];
            System.arraycopy(this.data, 0, cArray2, 0, this.length);
            this.data = cArray2;
        }
        if ((n4 = n & 0xFFFF) > this.length) {
            n4 = this.length;
        }
        System.arraycopy(this.data, n4, this.data, n4 + n3, this.length - n4);
        System.arraycopy(cArray, n2, this.data, n4, n3);
        this.length += n3;
        this.checkFastFormatTextOK(cArray);
        return (n & 0x7FFF0000) + n4 + n3;
    }

    public DocItem split(Document document, int n) {
        int n2 = n & 0xFFFF;
        if (n2 < this.length) {
            TextItem textItem = new TextItem(this.data, n2, this.length - n2);
            this.length = n2;
            return textItem;
        }
        return null;
    }

    public void delete(Document document, int n, int n2) {
        int n3 = n & 0xFFFF;
        if (n3 + n2 > this.length) {
            n2 = this.length - n3;
        }
        if (n2 <= 0) {
            return;
        }
        this.length -= n2;
        System.arraycopy(this.data, n3 + n2, this.data, n3, this.length - n3);
    }

    public int find(String string, int n, boolean bl) {
        if (bl) {
            return this.findIgnoreCase(string, n);
        }
        return this.findMatchCase(string, n);
    }

    public int find(String string, int n) {
        return this.findIgnoreCase(string, n);
    }

    public int find(String string, int n, OverlappingStringMatch overlappingStringMatch) {
        return this.findOverlappingIgnoreCase(string, n, overlappingStringMatch);
    }

    public int find(String string, int n, boolean bl, OverlappingStringMatch overlappingStringMatch) {
        if (bl) {
            return this.findOverlappingIgnoreCase(string, n, overlappingStringMatch);
        }
        return this.findOverlapping(string, n, overlappingStringMatch);
    }

    int findMatchCase(String string, int n) {
        int n2 = string.length();
        char c = string.charAt(0);
        while (n <= this.length - n2) {
            block4: {
                if (c == this.data[n]) {
                    int n3 = 1;
                    while (n3 < n2) {
                        if (string.charAt(n3) == this.data[n + n3]) {
                            ++n3;
                            continue;
                        }
                        break block4;
                    }
                    return n;
                }
            }
            ++n;
        }
        return -1;
    }

    int findOverlapping(String string, int n, OverlappingStringMatch overlappingStringMatch) {
        int n2 = string.length();
        char c = string.charAt(0);
        int n3 = 0;
        while (n < this.length) {
            block4: {
                if (c == this.data[n]) {
                    n3 = 1;
                    while (n3 < n2 && n3 + n < this.length) {
                        if (string.charAt(n3) == this.data[n + n3]) {
                            ++n3;
                            continue;
                        }
                        break block4;
                    }
                    overlappingStringMatch.overlappingMatch = string.substring(0, n3);
                    overlappingStringMatch.offsetIntoFirstString = n;
                    overlappingStringMatch.matchLength = n3;
                    return n;
                }
            }
            ++n;
        }
        return -1;
    }

    int findIgnoreCase(String string, int n) {
        String string2 = string.toLowerCase();
        int n2 = string2.length();
        char c = string2.charAt(0);
        while (n <= this.length - n2) {
            block4: {
                if (c == Character.toLowerCase(this.data[n])) {
                    int n3 = 1;
                    while (n3 < n2) {
                        if (string2.charAt(n3) == Character.toLowerCase(this.data[n + n3])) {
                            ++n3;
                            continue;
                        }
                        break block4;
                    }
                    return n;
                }
            }
            ++n;
        }
        return -1;
    }

    int findOverlappingIgnoreCase(String string, int n, OverlappingStringMatch overlappingStringMatch) {
        String string2 = string.toLowerCase();
        int n2 = string2.length();
        char c = string2.charAt(0);
        int n3 = 0;
        while (n < this.length) {
            block4: {
                if (c == Character.toLowerCase(this.data[n])) {
                    n3 = 1;
                    while (n3 < n2 && n3 + n < this.length) {
                        if (string2.charAt(n3) == Character.toLowerCase(this.data[n + n3])) {
                            ++n3;
                            continue;
                        }
                        break block4;
                    }
                    overlappingStringMatch.overlappingMatch = string.substring(0, n3);
                    overlappingStringMatch.offsetIntoFirstString = n;
                    overlappingStringMatch.matchLength = n3;
                    return n;
                }
            }
            ++n;
        }
        return -1;
    }

    public boolean measureItem(Formatter formatter, FormatState formatState, Measurement measurement, MeasureState measureState) {
        int n;
        int n2 = measureState.pos & 0xFFFF;
        FontMetrics fontMetrics = measureState.style.getFontMetrics();
        if (measureState.style.nobreak) {
            return this.measureNonBreakItem(formatState, fontMetrics, n2, measurement, measureState);
        }
        int n3 = 0;
        BreakIterator breakIterator = BreakIterator.getLineInstance();
        TextCharIterator textCharIterator = new TextCharIterator(this.data, 0);
        breakIterator.setText(textCharIterator);
        int n4 = 0;
        while ((n = breakIterator.next()) != -1) {
            int n5 = fontMetrics.charsWidth(this.data, n4, n - n4);
            measurement.setMinWidth(n5);
            n3 += n5;
            n4 = n;
        }
        measurement.setPreferredWidth(n3);
        measureState.pos += 65536;
        return false;
    }

    private boolean measureNonBreakItem(FormatState formatState, FontMetrics fontMetrics, int n, Measurement measurement, MeasureState measureState) {
        int n2 = 0;
        int n3 = fontMetrics.charWidth('0') * 8;
        while (n < this.length) {
            int n4 = this.data[n++] & 0xFFFF;
            switch (n4) {
                case 13: {
                    if (n < this.length && this.data[n] == '\n') {
                        ++n;
                    }
                }
                case 10: {
                    measureState.pos = measureState.pos & 0x7FFF0000 | n;
                    measurement.setMinWidth(n2);
                    measurement.setPreferredWidth(n2);
                    return true;
                }
                case 9: {
                    n2 += n3 - n2 % n3;
                    break;
                }
                case 160: {
                    n2 += fontMetrics.charWidth(' ');
                    break;
                }
                default: {
                    n2 += fontMetrics.charWidth(n4);
                    break;
                }
            }
        }
        measurement.setMinWidth(n2);
        measurement.setPreferredWidth(n2);
        measureState.pos = this.getIndex() + 1 << 16;
        return false;
    }

    public String toString() {
        return "\"" + new String(this.data, 0, this.length) + "\"";
    }

    private void checkFastFormatTextOK(char[] cArray) {
        if (!this.fastFormatTextOK) {
            return;
        }
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] >= '\u05ff') {
                this.fastFormatTextOK = false;
                return;
            }
            ++n;
        }
    }
}

