/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.forms;

import COM.livingston.forms.LEAddDialog;
import COM.livingston.forms.LECmdErrorDialog;
import COM.livingston.forms.LEFormLine;
import COM.livingston.forms.LEFormLineFactory;
import COM.livingston.forms.LENewEntry;
import COM.livingston.forms.LETableForm;
import COM.livingston.model.LEDataSpec;
import COM.livingston.model.LEGroup;
import COM.livingston.model.LEGroups;
import COM.livingston.model.LEPortMaster;
import COM.livingston.model.LETable;
import COM.livingston.ui.LECompGrid;
import COM.livingston.ui.LEErrorDialog;
import COM.livingston.ui.LEFont;
import COM.livingston.ui.LEUiUtils;
import COM.livingston.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;

public class LEGroupsForm
extends LETableForm {
    String m_addGroup;
    String m_addChannels;
    String m_addRate;

    boolean addNewEntry(LEDataSpec lEDataSpec, LEDataSpec lEDataSpec2) {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        Component[][] componentArray = new Component[3][2];
        componentArray[0][0] = new Label(String.valueOf(lEDataSpec.getDescription()) + ":");
        componentArray[0][0].setFont(LEFont.getBoldFont());
        componentArray[0][1] = LEFormLineFactory.BuildFormLine(null, null, null, lEDataSpec);
        LEDataSpec lEDataSpec3 = lEDataSpec2.getSpecFor(LEGroup.CHANNELS);
        componentArray[1][0] = new Label(String.valueOf(lEDataSpec3.getDescription()) + ":");
        componentArray[1][0].setFont(LEFont.getBoldFont());
        componentArray[1][1] = LEFormLineFactory.BuildFormLine(null, null, null, lEDataSpec3);
        lEDataSpec3 = lEDataSpec2.getSpecFor(LEGroup.SPEED);
        componentArray[2][0] = new Label(String.valueOf(lEDataSpec3.getDescription()) + ":");
        componentArray[2][0].setFont(LEFont.getBoldFont());
        componentArray[2][1] = LEFormLineFactory.BuildFormLine(null, null, null, lEDataSpec3);
        panel.add("Center", new LECompGrid(componentArray, 2, false));
        LEAddDialog lEAddDialog = new LEAddDialog(LEUiUtils.GetBaseFrame(), "Add Group", panel);
        if (lEAddDialog.okay()) {
            this.m_addGroup = ((LEFormLine)((Object)componentArray[0][1])).getValue();
            this.m_addChannels = ((LEFormLine)((Object)componentArray[1][1])).getValue();
            this.m_addRate = ((LEFormLine)((Object)componentArray[2][1])).getValue();
            if (this.m_addChannels.length() > 0) {
                return true;
            }
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), "A list of channels must be specified");
        }
        return false;
    }

    LENewEntry addNewEntryTo(LEPortMaster lEPortMaster) {
        LENewEntry lENewEntry = null;
        LEGroups lEGroups = (LEGroups)this.getTable(lEPortMaster);
        if (lEGroups.get(this.m_addGroup) == null) {
            LEVector lEVector = lEGroups.add(this.m_addGroup, this.m_addChannels, this.m_addRate);
            if (lEVector != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConfigFacility(), lEVector);
            }
            this.addEntry(lEPortMaster.getHostname(), lEGroups, this.m_addGroup);
            lENewEntry = new LENewEntry(lEPortMaster, lEGroups, this.m_addGroup);
        } else {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), String.valueOf(lEPortMaster.getHostname()) + " " + lEGroups.getLine() + " already contains group " + this.m_addGroup);
        }
        return lENewEntry;
    }

    void delete(LEPortMaster lEPortMaster, LETable lETable, String string) {
        if (!(lETable instanceof LEGroups)) {
            return;
        }
        LEGroups lEGroups = (LEGroups)lETable;
        LEVector lEVector = lEGroups.delete(string);
        if (lEVector != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConfigFacility(), lEVector);
        }
    }

    void pasteEntryTo(LEPortMaster lEPortMaster, Object object) {
        String string = this.getPasteKey(lEPortMaster, object);
        if (string == null) {
            return;
        }
        this.updateEntry(lEPortMaster.getHostname(), this.getTable(lEPortMaster), string);
    }

    String getPasteKey(LEPortMaster lEPortMaster, Object object) {
        String string;
        if (!(object instanceof LEGroup)) {
            return null;
        }
        LEGroup lEGroup = (LEGroup)object;
        LEGroups lEGroups = (LEGroups)this.getTable(lEPortMaster);
        if (lEGroups.get(string = lEGroup.getCGroup()) != null) {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), String.valueOf(lEPortMaster.getHostname()) + " " + lEGroups.getLine() + " already contains group " + string);
            string = null;
        } else {
            String string2 = (String)lEGroup.get(LEGroup.CHANNELS);
            String string3 = (String)lEGroup.get(LEGroup.SPEED);
            if (string2 == null || string3 == null) {
                return null;
            }
            LEVector lEVector = lEGroups.add(string, string2, string3);
            if (lEVector != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConfigFacility(), lEVector);
                string = null;
            }
        }
        return string;
    }
}

