/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.backend.LEDSSPortMaster;
import COM.livingston.backend.LESendResponse;
import COM.livingston.model.LEAsyncPort;
import COM.livingston.model.LEAsyncPorts;
import COM.livingston.model.LEBGPPeer;
import COM.livingston.model.LEBGPPolicy;
import COM.livingston.model.LEBGPPolicyRule;
import COM.livingston.model.LEBoard;
import COM.livingston.model.LEBoards;
import COM.livingston.model.LEChoicenet;
import COM.livingston.model.LEConfig;
import COM.livingston.model.LEDBNetUser;
import COM.livingston.model.LEDLCI;
import COM.livingston.model.LEDLCITable;
import COM.livingston.model.LEDialScript;
import COM.livingston.model.LEEthernet;
import COM.livingston.model.LEEthernets;
import COM.livingston.model.LEGroup;
import COM.livingston.model.LEGroups;
import COM.livingston.model.LEHost;
import COM.livingston.model.LEHostOverrides;
import COM.livingston.model.LEHosts;
import COM.livingston.model.LEISDNPort;
import COM.livingston.model.LEISDNPorts;
import COM.livingston.model.LELine;
import COM.livingston.model.LELines;
import COM.livingston.model.LELocation;
import COM.livingston.model.LELocations;
import COM.livingston.model.LELoginUser;
import COM.livingston.model.LEModems;
import COM.livingston.model.LENATMap;
import COM.livingston.model.LENATMapRule;
import COM.livingston.model.LENATMaps;
import COM.livingston.model.LENetUser;
import COM.livingston.model.LENetworkRanges;
import COM.livingston.model.LEOSPFArea;
import COM.livingston.model.LEParallelPort;
import COM.livingston.model.LEParallelPorts;
import COM.livingston.model.LEPortMaster;
import COM.livingston.model.LEPorts;
import COM.livingston.model.LERadius;
import COM.livingston.model.LERoute;
import COM.livingston.model.LESNMPHosts;
import COM.livingston.model.LESubInterface;
import COM.livingston.model.LESubInterfaces;
import COM.livingston.model.LESyncPort;
import COM.livingston.model.LESyncPorts;
import COM.livingston.model.LETable;
import COM.livingston.model.LEUsers;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEOctets;
import COM.livingston.util.LETokenizer;
import java.util.StringTokenizer;

public class LEPMEntityParser {
    public static final String MCPU_EMPTY = "0";
    public static final String MCPU_PRESENT = "1";
    public static final String MCPU_MGR_PM4 = "3";
    public static final String MCPU_PM4_QT1 = "5";
    public static final String MCPU_PM4_TE1 = "6";
    public static final String MCPU_T3MX = "7";
    public static final String MCPU_ETHER = "8";
    public static final String MCPU_E3MX = "9";
    public static final String ETHERNET_DAUGHTER_CARD = "10";
    public static final String ASYNC_PORT = "async";
    public static final String ISDN_PORT = "isdn";
    public static final String PARA_PORT = "parallel";
    public static final String SYNC_PORT = "sync";

    public static boolean Parse(String string, LEDSSPortMaster lEDSSPortMaster, LEPortMaster lEPortMaster) {
        String string2 = string;
        return LEPMEntityParser.Parse(lEDSSPortMaster, lEPortMaster.getConfig(string), string, string2);
    }

    public static boolean Parse(String string, String string2, LEDSSPortMaster lEDSSPortMaster, LEPortMaster lEPortMaster) {
        String string3 = String.valueOf(string) + " " + 275 + " " + string2;
        return LEPMEntityParser.Parse(lEDSSPortMaster, lEPortMaster.getConfig("2555904"), string, string3);
    }

    public static boolean Parse(LEDSSPortMaster lEDSSPortMaster, LEConfig lEConfig, String string, String string2) {
        boolean bl = true;
        try {
            LESendResponse lESendResponse = lEDSSPortMaster.send((byte)31, (short)string2.length(), string2, true);
            bl = lESendResponse.m_opCode != 9 && lESendResponse.m_opCode != 32 ? false : lESendResponse.successful();
            while (bl && LEPMEntityParser.Parse(string, lEConfig, lESendResponse.getStreamTok())) {
                lESendResponse = lEDSSPortMaster.recv(true);
                bl = lESendResponse.m_opCode != 9 && lESendResponse.m_opCode != 32 ? false : lESendResponse.successful();
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            bl = false;
        }
        lEDSSPortMaster.done();
        return bl;
    }

    public static boolean Parse(String string, LEConfig lEConfig, LETokenizer lETokenizer) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        boolean bl = false;
        switch (n) {
            case 0x210000: {
                bl = LEPMEntityParser.ParseGlobal(lEConfig, lETokenizer);
                break;
            }
            case 327680: {
                bl = LEPMEntityParser.ParseSyslog(lEConfig, lETokenizer);
                break;
            }
            case 0x150000: {
                bl = LEPMEntityParser.ParseSNMP(lEConfig, lETokenizer);
                break;
            }
            case 0x100000: {
                bl = LEPMEntityParser.ParseOSPF(lEConfig, lETokenizer);
                break;
            }
            case 524288: {
                bl = LEPMEntityParser.ParseOSPFAreas(lEConfig, lETokenizer);
                break;
            }
            case 0x140000: {
                bl = LEPMEntityParser.ParseRoutes(lEConfig, lETokenizer);
                break;
            }
            case 0x130000: {
                bl = LEPMEntityParser.ParseHosts(lEConfig, lETokenizer);
                break;
            }
            case 196608: {
                bl = LEPMEntityParser.ParseModems(lEConfig, lETokenizer);
                break;
            }
            case 131072: {
                bl = LEPMEntityParser.ParseLines(lEConfig, lETokenizer);
                break;
            }
            case 0x260000: {
                bl = LEPMEntityParser.ParseSubInterface(lEConfig, lETokenizer);
                break;
            }
            case 0x270000: {
                bl = LEPMEntityParser.ParseBoards(lEConfig, lETokenizer);
                break;
            }
            case 0x1A0000: {
                bl = LEPMEntityParser.ParseLocations(lEConfig, lETokenizer);
                break;
            }
            case 262144: {
                bl = LEPMEntityParser.ParsePorts(lEConfig, lETokenizer);
                break;
            }
            case 0x290000: {
                bl = LEPMEntityParser.ParseNATMaps(lEConfig, lETokenizer);
                break;
            }
            case 720896: {
                bl = LEPMEntityParser.ParseEthernets(lEConfig, lETokenizer);
                break;
            }
            case 0x1C0000: {
                bl = LEPMEntityParser.ParseUsers(lEConfig, lETokenizer);
                break;
            }
            case 0x310000: {
                bl = LEPMEntityParser.ParseUserPasswords(lEConfig, lETokenizer);
                break;
            }
            case 0x220000: {
                bl = LEPMEntityParser.ParseRadius(lEConfig, lETokenizer);
                break;
            }
            case 0x170000: {
                bl = LEPMEntityParser.ParseChoiceNet(lEConfig, lETokenizer);
                break;
            }
            case 0x320000: {
                bl = LEPMEntityParser.ParseSecrets(lEConfig, lETokenizer);
                break;
            }
            case 589824: {
                bl = LEPMEntityParser.ParseBGP(lEConfig, lETokenizer);
                break;
            }
            case 0x160000: {
                bl = LEPMEntityParser.ParseBGPPeers(lEConfig, lETokenizer);
                break;
            }
            case 0x300000: {
                bl = LEPMEntityParser.ParseBGPPolicies(lEConfig, lETokenizer);
                break;
            }
            case 0x250000: {
                bl = LEPMEntityParser.ParseSAs(lEConfig, lETokenizer);
                break;
            }
            default: {
                LEDebug.getLog().logln(20, "No parser for entity: " + n);
            }
        }
        return bl;
    }

    public static boolean ParseRoutes(LEConfig lEConfig, LETokenizer lETokenizer) {
        boolean bl = false;
        try {
            LEConfig lEConfig2 = null;
            boolean bl2 = false;
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            block12: while (!bl2) {
                int n = lETokenizer.getNextInt();
                switch (n) {
                    case 0x140000: {
                        String string5 = lETokenizer.getNextQuotedString();
                        if (string5.length() <= 0) continue block12;
                        string = string5;
                        break;
                    }
                    case 74: {
                        string = lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 75: {
                        string2 = lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 77: {
                        string3 = lETokenizer.getNextQuotedString().toLowerCase();
                        break;
                    }
                    case 78: {
                        string4 = lETokenizer.getNextQuotedString().toLowerCase();
                        break;
                    }
                    case 82: {
                        String string5 = lETokenizer.getNextQuotedString().toLowerCase();
                        lEConfig2 = null;
                        if (string3 != null && string3.equals("local") && string5 != null && string5.equals("static") && string != null) {
                            lEConfig2 = (LERoute)lEConfig.getConfig(string);
                            if (string2 != null) {
                                lEConfig2.setField(LERoute.GATEWAY, string2);
                            }
                            if (string4 != null) {
                                lEConfig2.setField(LERoute.TYPE, string4);
                            }
                            lEConfig2.setField(LERoute.SOURCE, string3);
                            lEConfig2.setField(LERoute.STATUS, string5);
                        }
                        string = null;
                        string2 = null;
                        string3 = null;
                        string4 = null;
                        break;
                    }
                    case 79: 
                    case 81: 
                    case 83: 
                    case 84: {
                        String string5 = lETokenizer.getNextQuotedString().toLowerCase();
                        if (lEConfig2 == null) continue block12;
                        lEConfig2.setField(Integer.toString(n), string5);
                        break;
                    }
                    case 65535: {
                        bl2 = true;
                        if (lETokenizer.getNextInt() != 1) continue block12;
                        bl = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("Routes", n, lETokenizer.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return bl;
    }

    public static boolean ParseGlobal(LEConfig lEConfig, LETokenizer lETokenizer) {
        boolean bl = false;
        try {
            boolean bl2 = false;
            block9: while (!bl2) {
                int n = lETokenizer.getNextInt();
                switch (n) {
                    case 0x210000: {
                        lETokenizer.getNextQuotedString();
                        if (lEConfig == null) continue block9;
                        lEConfig.setField("password", "");
                        break;
                    }
                    case 36: 
                    case 57: 
                    case 75: 
                    case 143: 
                    case 144: 
                    case 145: 
                    case 146: 
                    case 148: 
                    case 149: 
                    case 150: 
                    case 151: 
                    case 152: 
                    case 153: 
                    case 154: 
                    case 155: 
                    case 156: 
                    case 157: 
                    case 158: 
                    case 159: 
                    case 160: 
                    case 161: 
                    case 162: 
                    case 163: 
                    case 164: 
                    case 165: 
                    case 166: 
                    case 167: 
                    case 168: 
                    case 169: 
                    case 170: 
                    case 171: 
                    case 173: 
                    case 174: 
                    case 175: 
                    case 176: 
                    case 177: 
                    case 179: 
                    case 180: 
                    case 182: 
                    case 183: 
                    case 184: 
                    case 185: 
                    case 195: 
                    case 495: {
                        String string = lETokenizer.getNextQuotedString();
                        if (lEConfig == null) continue block9;
                        lEConfig.setField(Integer.toString(n), string);
                        break;
                    }
                    case 181: 
                    case 197: {
                        String string = lETokenizer.getNextQuotedString();
                        if (string.equals("on")) {
                            lEConfig.setField(Integer.toString(n), "enable");
                            break;
                        }
                        lEConfig.setField(Integer.toString(n), "disable");
                        break;
                    }
                    case 178: {
                        String string = lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 65535: {
                        bl2 = true;
                        if (lETokenizer.getNextInt() != 1) continue block9;
                        bl = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("Global", n, lETokenizer.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return bl;
    }

    public static boolean ParseRadius(LEConfig lEConfig, LETokenizer lETokenizer) {
        boolean bl = false;
        try {
            boolean bl2 = false;
            block9: while (!bl2) {
                int n = lETokenizer.getNextInt();
                switch (n) {
                    case 0x220000: {
                        lETokenizer.getNextQuotedString();
                        if (lEConfig == null) continue block9;
                        lEConfig.setField("secret", "");
                        break;
                    }
                    case 208: 
                    case 209: 
                    case 210: 
                    case 211: {
                        String string = lETokenizer.getNextQuotedString();
                        if (lEConfig == null) continue block9;
                        lEConfig.setField(Integer.toString(n), string);
                        break;
                    }
                    case 212: 
                    case 213: {
                        String string = lETokenizer.getNextQuotedString();
                        if (string.equals(MCPU_EMPTY)) {
                            string = "1645";
                        }
                        if (lEConfig == null) continue block9;
                        lEConfig.setField(Integer.toString(n), string);
                        break;
                    }
                    case 214: 
                    case 215: {
                        String string = lETokenizer.getNextQuotedString();
                        if (string.equals(MCPU_EMPTY)) {
                            string = "1646";
                        }
                        if (lEConfig == null) continue block9;
                        lEConfig.setField(Integer.toString(n), string);
                        break;
                    }
                    case 65535: {
                        bl2 = true;
                        if (lETokenizer.getNextInt() != 1) continue block9;
                        bl = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("RADIUS", n, lETokenizer.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return bl;
    }

    public static boolean ParseChoiceNet(LEConfig lEConfig, LETokenizer lETokenizer) {
        boolean bl = false;
        try {
            boolean bl2 = false;
            block8: while (!bl2) {
                int n = lETokenizer.getNextInt();
                switch (n) {
                    case 0x170000: {
                        lETokenizer.getNextQuotedString();
                        if (lEConfig == null) continue block8;
                        lEConfig.setField("choicenet-secret", "");
                        break;
                    }
                    case 208: 
                    case 209: {
                        String string = lETokenizer.getNextQuotedString();
                        if (lEConfig == null) continue block8;
                        lEConfig.setField(Integer.toString(n), string);
                        break;
                    }
                    case 212: 
                    case 213: {
                        String string = lETokenizer.getNextQuotedString();
                        if (string.equals(MCPU_EMPTY)) {
                            string = "1647";
                        }
                        if (lEConfig == null) continue block8;
                        lEConfig.setField(Integer.toString(n), string);
                        break;
                    }
                    case 65535: {
                        bl2 = true;
                        if (lETokenizer.getNextInt() != 1) continue block8;
                        bl = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("ChoiceNet", n, lETokenizer.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return bl;
    }

    public static boolean ParseSyslog(LEConfig lEConfig, LETokenizer lETokenizer) {
        boolean bl = false;
        try {
            boolean bl2 = false;
            String string = null;
            block8: while (!bl2) {
                int n = lETokenizer.getNextInt();
                switch (n) {
                    case 327680: {
                        String string2 = lETokenizer.getNextQuotedString();
                        if (string2.length() <= 0) continue block8;
                        string = string2;
                        break;
                    }
                    case 91: {
                        string = lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 90: {
                        String string3 = lETokenizer.getNextQuotedString();
                        if (string == null) continue block8;
                        lEConfig.setField(string, string3);
                        break;
                    }
                    case 65535: {
                        bl2 = true;
                        if (lETokenizer.getNextInt() != 1) continue block8;
                        bl = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("Syslog", n, lETokenizer.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return bl;
    }

    public static boolean ParseSNMP(LEConfig lEConfig, LETokenizer lETokenizer) {
        boolean bl = false;
        try {
            LESNMPHosts lESNMPHosts = null;
            boolean bl2 = false;
            String string = null;
            block16: while (!bl2) {
                int n = lETokenizer.getNextInt();
                switch (n) {
                    case 0x150000: {
                        lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 17: {
                        lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 87: {
                        lEConfig.setField("sysname", lETokenizer.getNextQuotedString());
                        break;
                    }
                    case 85: {
                        lEConfig.setField("read", lETokenizer.getNextQuotedString());
                        lESNMPHosts = (LESNMPHosts)lEConfig.getConfig("readhost");
                        lESNMPHosts.clearList();
                        string = "readtype";
                        break;
                    }
                    case 86: {
                        lEConfig.setField("write", lETokenizer.getNextQuotedString());
                        lESNMPHosts = (LESNMPHosts)lEConfig.getConfig("writehost");
                        lESNMPHosts.clearList();
                        string = "writetype";
                        break;
                    }
                    case 12: {
                        int n2 = lETokenizer.getNextInt();
                        switch (n2) {
                            case -1: {
                                if (string != null) {
                                    lEConfig.setField(string, "any");
                                }
                                if (lESNMPHosts == null) continue block16;
                                lESNMPHosts.setType(0);
                                break;
                            }
                            case 0: {
                                if (string != null) {
                                    lEConfig.setField(string, "none");
                                }
                                if (lESNMPHosts == null) continue block16;
                                lESNMPHosts.setType(1);
                                break;
                            }
                            default: {
                                if (string != null) {
                                    lEConfig.setField(string, "specified");
                                }
                                if (lESNMPHosts == null) continue block16;
                                lESNMPHosts.setType(2);
                                break;
                            }
                        }
                        continue block16;
                    }
                    case 3: {
                        String string2 = lETokenizer.getNextQuotedString();
                        if (string2.endsWith(".in-addr.arpa")) {
                            string2 = LEPMEntityParser.fixHostname(string2);
                        }
                        if (lESNMPHosts == null) continue block16;
                        lESNMPHosts.addField(string2);
                        break;
                    }
                    case 65535: {
                        bl2 = true;
                        if (lETokenizer.getNextInt() != 1) continue block16;
                        bl = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("SNMP", n, lETokenizer.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return bl;
    }

    static String fixHostname(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        stringBuffer.insert(0, stringTokenizer.nextToken());
        stringBuffer.insert(0, '.');
        stringBuffer.insert(0, stringTokenizer.nextToken());
        stringBuffer.insert(0, '.');
        stringBuffer.insert(0, stringTokenizer.nextToken());
        stringBuffer.insert(0, '.');
        stringBuffer.insert(0, stringTokenizer.nextToken());
        return stringBuffer.toString();
    }

    public static boolean ParseOSPF(LEConfig lEConfig, LETokenizer lETokenizer) {
        boolean bl = false;
        try {
            boolean bl2 = false;
            block7: while (!bl2) {
                int n = lETokenizer.getNextInt();
                switch (n) {
                    case 0x100000: {
                        lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 97: 
                    case 100: {
                        String string = lETokenizer.getNextQuotedString();
                        if (lEConfig == null) continue block7;
                        lEConfig.setField(Integer.toString(n), string);
                        break;
                    }
                    case 65535: {
                        bl2 = true;
                        if (lETokenizer.getNextInt() != 1) continue block7;
                        bl = true;
                        break;
                    }
                    default: {
                        lETokenizer.getNextQuotedString();
                        LEDebug.getLog().logln(20, "Bad OSPF attribute: " + n);
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return bl;
    }

    public static boolean ParseOSPFAreas(LEConfig lEConfig, LETokenizer lETokenizer) {
        boolean bl = false;
        try {
            LEOSPFArea lEOSPFArea = null;
            LETable lETable = null;
            boolean bl2 = false;
            String string = null;
            block14: while (!bl2) {
                int n = lETokenizer.getNextInt();
                switch (n) {
                    case 524288: {
                        String string2 = lETokenizer.getNextQuotedString();
                        if (string2.length() <= 0 || string2.equals(MCPU_EMPTY)) continue block14;
                        lEOSPFArea = (LEOSPFArea)lEConfig.getConfig(string2);
                        lETable = (LENetworkRanges)lEOSPFArea.getConfig("range");
                        break;
                    }
                    case 9: {
                        String string2 = lETokenizer.getNextQuotedString();
                        lEOSPFArea = (LEOSPFArea)lEConfig.getConfig(string2);
                        lETable = (LENetworkRanges)lEOSPFArea.getConfig("range");
                        break;
                    }
                    case 12: {
                        String string2 = lETokenizer.getNextQuotedString();
                        int n2 = Integer.parseInt(string2);
                        break;
                    }
                    case 101: {
                        String string2 = lETokenizer.getNextQuotedString();
                        if (lEOSPFArea == null) continue block14;
                        if (string2.equalsIgnoreCase("md5")) {
                            lEOSPFArea.setField("AuthType", "md5");
                        } else if (string2.equalsIgnoreCase("none")) {
                            lEOSPFArea.setField("AuthType", "none");
                        } else {
                            lEOSPFArea.setField("AuthType", "password");
                        }
                        if (!string2.equalsIgnoreCase("md5")) {
                            lEOSPFArea.setField("AuthID", "");
                            lEOSPFArea.setField("AuthKey", "");
                        }
                        lEOSPFArea.setField("password", "");
                        break;
                    }
                    case 99: {
                        String string2 = lETokenizer.getNextQuotedString();
                        if (lEOSPFArea == null) continue block14;
                        lEOSPFArea.setField("AuthID", string2);
                        break;
                    }
                    case 102: {
                        String string3;
                        String string2 = lETokenizer.getNextQuotedString();
                        string2.length();
                        StringBuffer stringBuffer = new StringBuffer(string2);
                        if (lEOSPFArea == null || (string3 = (String)lEOSPFArea.get("AuthType")) == null) continue block14;
                        if (string3.equals("md5")) {
                            lEOSPFArea.setField("AuthKey", stringBuffer.toString());
                            break;
                        }
                        if (!string3.equals("password")) continue block14;
                        lEOSPFArea.setField("password", stringBuffer.toString());
                        break;
                    }
                    case 103: {
                        String string2 = lETokenizer.getNextQuotedString();
                        if (lEOSPFArea == null) continue block14;
                        if (string2.equalsIgnoreCase("external")) {
                            lEOSPFArea.setField("AreaType", "external");
                            break;
                        }
                        if (string2.equalsIgnoreCase("stub")) {
                            lEOSPFArea.setField("AreaType", "stub");
                            break;
                        }
                        lEOSPFArea.setField("AreaType", "nssa");
                        break;
                    }
                    case 117: {
                        String string2;
                        string = string2 = lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 104: {
                        String string2 = lETokenizer.getNextQuotedString();
                        if (lETable == null || string == null) continue block14;
                        lETable.setField(string2, string);
                        break;
                    }
                    case 65535: {
                        bl2 = true;
                        if (lETokenizer.getNextInt() != 1) continue block14;
                        bl = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("OSPF Area", n, lETokenizer.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return bl;
    }

    public static boolean ParseHosts(LEConfig lEConfig, LETokenizer lETokenizer) {
        boolean bl = false;
        try {
            LEHosts lEHosts = (LEHosts)lEConfig;
            lEHosts.clearList();
            String string = null;
            boolean bl2 = false;
            block8: while (!bl2) {
                int n = lETokenizer.getNextInt();
                switch (n) {
                    case 0x130000: {
                        String string2 = lETokenizer.getNextQuotedString();
                        if (string2.length() <= 0) continue block8;
                        string = string2;
                        break;
                    }
                    case 9: {
                        string = lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 3: {
                        String string3 = lETokenizer.getNextQuotedString();
                        if (string == null) continue block8;
                        LEHost lEHost = (LEHost)lEHosts.addConfig();
                        lEHost.setField("address", string);
                        lEHost.setField("hostname", string3);
                        break;
                    }
                    case 65535: {
                        bl2 = true;
                        if (lETokenizer.getNextInt() != 1) continue block8;
                        bl = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("Hosts", n, lETokenizer.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return bl;
    }

    public static boolean ParseModems(LEConfig lEConfig, LETokenizer lETokenizer) {
        boolean bl = false;
        try {
            LEModems lEModems = null;
            if (lEConfig instanceof LEModems) {
                lEModems = (LEModems)lEConfig;
            }
            String string = null;
            boolean bl2 = false;
            block9: while (!bl2) {
                int n = lETokenizer.getNextInt();
                switch (n) {
                    case 275: {
                        LEBoard lEBoard;
                        String string2 = lETokenizer.getNextQuotedString();
                        if (!(lEConfig instanceof LEBoards) || (lEBoard = (LEBoard)lEConfig.get(string2)) == null) continue block9;
                        lEModems = (LEModems)lEBoard.get(LEBoard.MODEMS);
                        break;
                    }
                    case 196608: {
                        String string2 = lETokenizer.getNextQuotedString();
                        if (string2.length() <= 0) continue block9;
                        string = "M" + string2;
                        break;
                    }
                    case 40: {
                        string = "M" + lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 41: {
                        String string3 = lETokenizer.getNextQuotedString();
                        if (string == null) continue block9;
                        lEModems.setField(string, string3);
                        break;
                    }
                    case 65535: {
                        bl2 = true;
                        if (lETokenizer.getNextInt() != 1) continue block9;
                        bl = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("Modems", n, lETokenizer.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return bl;
    }

    public static boolean ParseLines(LEConfig lEConfig, LETokenizer lETokenizer) {
        boolean bl = false;
        try {
            LELines lELines = null;
            if (lEConfig instanceof LELines) {
                lELines = (LELines)lEConfig;
            }
            LEConfig lEConfig2 = null;
            LETable lETable = null;
            LEGroup lEGroup = null;
            boolean bl2 = false;
            block13: while (!bl2) {
                int n = lETokenizer.getNextInt();
                switch (n) {
                    case 275: {
                        LEBoard lEBoard;
                        String string = lETokenizer.getNextQuotedString();
                        if (!(lEConfig instanceof LEBoards) || (lEBoard = (LEBoard)lEConfig.get(string)) == null) continue block13;
                        lELines = (LELines)lEBoard.get(LEBoard.LINES);
                        break;
                    }
                    case 131072: {
                        String string = lETokenizer.getNextQuotedString();
                        if (string.length() <= 0) continue block13;
                        lEConfig2 = (LELine)lELines.getConfig("line" + string);
                        lETable = (LEGroups)lEConfig2.getConfig("groups");
                        break;
                    }
                    case 11: {
                        String string = "line" + lETokenizer.getNextQuotedString();
                        lEConfig2 = (LELine)lELines.getConfig(string);
                        lETable = (LEGroups)lEConfig2.getConfig("groups");
                        break;
                    }
                    case 17: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 37: 
                    case 39: 
                    case 472: 
                    case 474: 
                    case 475: 
                    case 476: {
                        String string = lETokenizer.getNextQuotedString().toLowerCase();
                        if (lEConfig2 == null) continue block13;
                        lEConfig2.setField(Integer.toString(n), string);
                        break;
                    }
                    case 129: {
                        String string = lETokenizer.getNextQuotedString();
                        if (lETable == null) continue block13;
                        lEGroup = (LEGroup)lETable.getConfig(string);
                        break;
                    }
                    case 130: 
                    case 131: 
                    case 132: {
                        String string = lETokenizer.getNextQuotedString().toLowerCase();
                        if (lEGroup == null) continue block13;
                        lEGroup.setField(Integer.toString(n), string);
                        break;
                    }
                    case 128: {
                        lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 38: {
                        String string = lETokenizer.getNextQuotedString();
                        if (string.equals("r2 custom") || string.equals("R2 custom")) {
                            string = "r2custom";
                        } else if (string.equals("r2mf generic") || string.equals("R2MF generic")) {
                            string = "r2generic";
                        }
                        if (lEConfig2 == null) continue block13;
                        lEConfig2.setField(Integer.toString(n), string);
                        break;
                    }
                    case 65535: {
                        bl2 = true;
                        if (lETokenizer.getNextInt() != 1) continue block13;
                        bl = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("Lines", n, lETokenizer.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean ParseSubInterface(LEConfig var0, LETokenizer var1_1) {
        var2_2 = false;
        var3_3 = (LESubInterfaces)var0;
        var4_4 = null;
        var6_5 = false;
        try {
            block8: while (true) lbl-1000:
            // 9 sources

            {
                if (var6_5) {
                    return var2_2;
                }
                var7_7 = var1_1.getNextInt();
                switch (var7_7) {
                    case 0x260000: {
                        var5_6 = var1_1.getNextQuotedString();
                        if (var5_6.length() <= 0) continue block8;
                        var4_4 = (LESubInterface)var3_3.getConfig(var5_6);
                        ** break;
                    }
                    case 237: {
                        var5_6 = var1_1.getNextQuotedString();
                        var4_4 = (LESubInterface)var3_3.getConfig(var5_6);
                        ** break;
                    }
                    case 9: 
                    case 15: 
                    case 186: 
                    case 260: {
                        var5_6 = var1_1.getNextQuotedString();
                        if (var4_4 == null) continue block8;
                        var4_4.setField(Integer.toString(var7_7), var5_6);
                        ** break;
                    }
                    case 65535: {
                        var6_5 = true;
                        if (var1_1.getNextInt() != 1) continue block8;
                        var2_2 = true;
                        ** break;
                    }
                }
                LEPMEntityParser.LogBadAttribute("SubInterfaces", var7_7, var1_1.getNextQuotedString());
            }
        }
        catch (Exception var8_8) {
            LEDebug.getLog().logln(20, var8_8);
        }
        return var2_2;
    }

    public static boolean ParseBoards(LEConfig lEConfig, LETokenizer lETokenizer) {
        boolean bl = false;
        try {
            LEConfig lEConfig2 = null;
            String string = null;
            boolean bl2 = false;
            block10: while (!bl2) {
                int n = lETokenizer.getNextInt();
                switch (n) {
                    case 0x270000: {
                        lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 275: {
                        string = lETokenizer.getNextQuotedString();
                        lEConfig2 = null;
                        break;
                    }
                    case 272: {
                        String string2 = lETokenizer.getNextQuotedString();
                        if (string != null && !string2.equals(MCPU_EMPTY) && (lEConfig2 = (LEBoard)lEConfig.getConfig(string)) != null) {
                            if (string2.equals(MCPU_PRESENT)) {
                                string2 = "Present";
                            } else if (string2.equals(MCPU_MGR_PM4)) {
                                string2 = "System Manager";
                                lEConfig2.getConfig(LEBoard.PORTS);
                                lEConfig2.getConfig(LEBoard.ETHERNETS);
                            } else if (string2.equals(MCPU_ETHER)) {
                                string2 = "Ethernet";
                                lEConfig2.getConfig(LEBoard.ETHERNETS);
                            } else if (string2.equals(MCPU_PM4_QT1)) {
                                string2 = "Quad T1";
                                lEConfig2.getConfig(LEBoard.PORTS);
                                lEConfig2.getConfig(LEBoard.LINES);
                                lEConfig2.getConfig(LEBoard.MODEMS);
                            } else if (string2.equals(MCPU_PM4_TE1)) {
                                string2 = "Tri E1";
                                lEConfig2.getConfig(LEBoard.PORTS);
                                lEConfig2.getConfig(LEBoard.LINES);
                                lEConfig2.getConfig(LEBoard.MODEMS);
                            } else {
                                string2 = string2.equals(MCPU_T3MX) ? "T3 Mux" : (string2.equals(MCPU_E3MX) ? "E3 Mux" : "Unknown");
                            }
                        }
                        if (lEConfig2 == null) continue block10;
                        lEConfig2.setField(Integer.toString(n), string2);
                        break;
                    }
                    case 17: 
                    case 164: 
                    case 165: 
                    case 172: 
                    case 273: 
                    case 274: 
                    case 276: 
                    case 472: 
                    case 473: {
                        String string2 = lETokenizer.getNextQuotedString();
                        if (lEConfig2 == null) continue block10;
                        lEConfig2.setField(Integer.toString(n), string2);
                        break;
                    }
                    case 279: {
                        String string2 = lETokenizer.getNextQuotedString();
                        if (lEConfig2 == null) continue block10;
                        if (string.equals(ETHERNET_DAUGHTER_CARD)) {
                            string2 = "on";
                        }
                        lEConfig2.setField(LEBoard.POWER, string2);
                        break;
                    }
                    case 65535: {
                        bl2 = true;
                        if (lETokenizer.getNextInt() != 1) continue block10;
                        bl = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("Boards", n, lETokenizer.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean ParseLocations(LEConfig var0, LETokenizer var1_1) {
        var2_2 = false;
        var3_3 = (LELocations)var0;
        var4_4 = null;
        var5_5 = false;
        var8_6 = null;
        var9_7 = null;
        var10_8 = null;
        var11_9 = null;
        var12_10 = null;
        try {
            block18: while (true) lbl-1000:
            // 27 sources

            {
                if (var5_5) {
                    return var2_2;
                }
                var6_11 = var1_1.getNextInt();
                switch (var6_11) {
                    case 0x1A0000: {
                        var7_12 = var1_1.getNextQuotedString();
                        if (var7_12.length() <= 0) continue block18;
                        var4_4 = (LELocation)var3_3.getConfig(var7_12);
                        ** break;
                    }
                    case 237: {
                        var7_12 = var1_1.getNextQuotedString();
                        var4_4 = (LELocation)var3_3.getConfig(var7_12);
                        ** break;
                    }
                    case 2: 
                    case 9: 
                    case 15: 
                    case 74: 
                    case 129: 
                    case 170: 
                    case 177: 
                    case 187: 
                    case 188: 
                    case 193: 
                    case 194: 
                    case 241: 
                    case 242: 
                    case 243: 
                    case 244: 
                    case 245: 
                    case 246: 
                    case 289: 
                    case 290: 
                    case 291: 
                    case 292: 
                    case 293: 
                    case 294: 
                    case 295: 
                    case 296: 
                    case 297: 
                    case 298: 
                    case 299: 
                    case 300: 
                    case 301: 
                    case 302: 
                    case 353: 
                    case 354: 
                    case 355: 
                    case 356: 
                    case 357: 
                    case 358: 
                    case 359: 
                    case 360: 
                    case 361: 
                    case 362: 
                    case 363: {
                        var7_12 = var1_1.getNextQuotedString();
                        if (var4_4 == null) continue block18;
                        var4_4.setField(Integer.toString(var6_11), var7_12);
                        ** break;
                    }
                    case 288: {
                        var7_12 = var1_1.getNextQuotedString();
                        if (var7_12.equals("on_demand")) {
                            var7_12 = "on-demand";
                        }
                        if (var4_4 == null) continue block18;
                        var4_4.setField(Integer.toString(var6_11), var7_12);
                        ** break;
                    }
                    case 189: {
                        var7_12 = var1_1.getNextQuotedString();
                        if (var4_4 == null) continue block18;
                        var13_13 = new LEOctets(var7_12);
                        var7_12 = var13_13.toHexString();
                        var4_4.setField(Integer.toString(var6_11), var7_12);
                        ** break;
                    }
                    case 303: {
                        var7_12 = var1_1.getNextQuotedString();
                        if (var4_4 == null) continue block18;
                        var12_10 = (LEDialScript)var4_4.getConfig("script");
                        LEDialScript.LoadScript(var12_10, var7_12);
                        var4_4.setField("script", var12_10);
                        ** break;
                    }
                    case 304: {
                        var7_12 = var1_1.getNextQuotedString();
                        if (var4_4 == null) continue block18;
                        var12_10 = (LEDialScript)var4_4.getConfig("v25bis");
                        LEDialScript.LoadScript(var12_10, var7_12);
                        var4_4.setField("v25bis", var12_10);
                        ** break;
                    }
                    case 339: {
                        var7_12 = var1_1.getNextQuotedString();
                        if (var4_4 == null) continue block18;
                        var8_6 = (LEDLCITable)var4_4.getConfig("ipdlci");
                        ** break;
                    }
                    case 340: {
                        var7_12 = var1_1.getNextQuotedString();
                        if (var4_4 == null) continue block18;
                        var9_7 = (LEDLCITable)var4_4.getConfig("ipxdlci");
                        ** break;
                    }
                    case 305: {
                        var10_8 = var1_1.getNextQuotedString();
                        ** break;
                    }
                    case 306: {
                        var11_9 = var1_1.getNextQuotedString();
                        ** break;
                    }
                    case 307: {
                        var7_12 = var1_1.getNextQuotedString();
                        if (var10_8 == null || var8_6 == null) continue block18;
                        var13_13 = (LEDLCI)var8_6.getConfig(var10_8);
                        if (var13_13 != null) {
                            var13_13.setField("address", var7_12);
                        }
                        var10_8 = null;
                        ** break;
                    }
                    case 308: {
                        var7_12 = var1_1.getNextQuotedString();
                        if (var11_9 == null || var9_7 == null) continue block18;
                        var13_13 = (LEDLCI)var9_7.getConfig(var11_9);
                        if (var13_13 != null) {
                            var13_13.setField("address", var7_12);
                        }
                        var11_9 = null;
                        ** break;
                    }
                    case 65535: {
                        var5_5 = true;
                        if (var1_1.getNextInt() != 1) continue block18;
                        var2_2 = true;
                        ** break;
                    }
                }
                LEPMEntityParser.LogBadAttribute("Locations", var6_11, var1_1.getNextQuotedString());
            }
        }
        catch (Exception var13_14) {
            LEDebug.getLog().logln(20, var13_14);
        }
        return var2_2;
    }

    public static boolean ParsePorts(LEConfig lEConfig, LETokenizer lETokenizer) {
        boolean bl = false;
        try {
            LEPorts lEPorts = null;
            LEBoard lEBoard = null;
            LEBoards lEBoards = null;
            if (lEConfig instanceof LEPorts) {
                lEPorts = (LEPorts)lEConfig;
            } else if (lEConfig instanceof LEBoards) {
                lEBoards = (LEBoards)lEConfig;
            }
            boolean bl2 = false;
            int n = 0;
            block8: while (!bl2) {
                int n2;
                if (n > 0) {
                    n2 = n;
                    n = 0;
                } else {
                    n2 = lETokenizer.getNextInt();
                }
                switch (n2) {
                    case 262144: {
                        lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 275: {
                        String string = lETokenizer.getNextQuotedString();
                        if (lEBoards == null || (lEBoard = (LEBoard)lEBoards.getConfig(string)) == null) continue block8;
                        lEPorts = (LEPorts)lEBoard.getConfig(LEBoard.PORTS);
                        break;
                    }
                    case 333: {
                        String string = lETokenizer.getNextQuotedString();
                        if (lEPorts == null) continue block8;
                        if (string.equals(ASYNC_PORT)) {
                            n = LEPMEntityParser.ParseAsyncPort(lEPorts, lETokenizer);
                            break;
                        }
                        if (string.equals(ISDN_PORT)) {
                            n = LEPMEntityParser.ParseISDNPort(lEPorts, lETokenizer);
                            break;
                        }
                        if (string.equals(PARA_PORT)) {
                            n = LEPMEntityParser.ParseParallelPort(lEPorts, lETokenizer);
                            break;
                        }
                        if (!string.equals(SYNC_PORT)) continue block8;
                        n = LEPMEntityParser.ParseSyncPort(lEPorts, lETokenizer);
                        break;
                    }
                    case 65535: {
                        bl2 = true;
                        if (lETokenizer.getNextInt() != 1) continue block8;
                        bl = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("Ports", n2, lETokenizer.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return bl;
    }

    public static int ParseAsyncPort(LEPorts lEPorts, LETokenizer lETokenizer) {
        int n = 0;
        try {
            LEAsyncPorts lEAsyncPorts = (LEAsyncPorts)lEPorts.getConfig("AsyncPort");
            LEConfig lEConfig = null;
            boolean bl = false;
            block8: while (!bl) {
                n = lETokenizer.getNextInt();
                switch (n) {
                    case 275: 
                    case 333: 
                    case 65535: 
                    case 262144: {
                        bl = true;
                        break;
                    }
                    case 1: {
                        String string = lETokenizer.getNextQuotedString();
                        if (lEAsyncPorts == null) continue block8;
                        lEConfig = (LEAsyncPort)lEAsyncPorts.getConfig(string);
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 15: 
                    case 23: 
                    case 74: 
                    case 129: 
                    case 130: 
                    case 173: 
                    case 174: 
                    case 175: 
                    case 176: 
                    case 177: 
                    case 187: 
                    case 188: 
                    case 193: 
                    case 194: 
                    case 241: 
                    case 242: 
                    case 243: 
                    case 244: 
                    case 245: 
                    case 246: 
                    case 289: 
                    case 290: 
                    case 295: 
                    case 297: 
                    case 299: 
                    case 302: 
                    case 309: 
                    case 310: 
                    case 312: 
                    case 313: 
                    case 314: 
                    case 315: 
                    case 316: 
                    case 317: 
                    case 322: 
                    case 323: 
                    case 324: 
                    case 325: 
                    case 326: 
                    case 332: 
                    case 334: 
                    case 335: 
                    case 336: 
                    case 337: 
                    case 338: 
                    case 353: 
                    case 354: 
                    case 355: 
                    case 356: 
                    case 357: 
                    case 358: 
                    case 359: 
                    case 360: 
                    case 361: 
                    case 362: 
                    case 363: {
                        String string = lETokenizer.getNextQuotedString();
                        if (lEConfig == null) continue block8;
                        lEConfig.setField(Integer.toString(n), string);
                        break;
                    }
                    case 327: 
                    case 328: 
                    case 329: 
                    case 330: 
                    case 331: {
                        LEHostOverrides lEHostOverrides;
                        String string = lETokenizer.getNextQuotedString();
                        if (lEConfig == null || (lEHostOverrides = (LEHostOverrides)lEConfig.getConfig("overrides")) == null) continue block8;
                        lEHostOverrides.setField(Integer.toString(n), string);
                        break;
                    }
                    default: {
                        String string = lETokenizer.getNextQuotedString();
                        LEPMEntityParser.LogBadAttribute("Async Port", n, string);
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return n;
    }

    public static int ParseISDNPort(LEPorts lEPorts, LETokenizer lETokenizer) {
        int n = 0;
        try {
            LEISDNPorts lEISDNPorts = (LEISDNPorts)lEPorts.getConfig("ISDNPort");
            LEISDNPort lEISDNPort = null;
            boolean bl = false;
            block9: while (!bl) {
                n = lETokenizer.getNextInt();
                switch (n) {
                    case 275: 
                    case 333: 
                    case 65535: 
                    case 262144: {
                        bl = true;
                        break;
                    }
                    case 1: {
                        String string = lETokenizer.getNextQuotedString();
                        if (lEISDNPorts == null) continue block9;
                        lEISDNPort = (LEISDNPort)lEISDNPorts.getConfig(string);
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 15: 
                    case 74: 
                    case 129: 
                    case 130: 
                    case 173: 
                    case 174: 
                    case 175: 
                    case 176: 
                    case 177: 
                    case 181: 
                    case 187: 
                    case 188: 
                    case 193: 
                    case 194: 
                    case 241: 
                    case 242: 
                    case 243: 
                    case 244: 
                    case 245: 
                    case 246: 
                    case 290: 
                    case 295: 
                    case 297: 
                    case 302: 
                    case 309: 
                    case 310: 
                    case 312: 
                    case 317: 
                    case 320: 
                    case 321: 
                    case 322: 
                    case 323: 
                    case 325: 
                    case 332: 
                    case 336: 
                    case 337: 
                    case 338: 
                    case 353: 
                    case 354: 
                    case 355: 
                    case 356: 
                    case 357: 
                    case 358: 
                    case 359: 
                    case 360: 
                    case 361: 
                    case 362: 
                    case 363: {
                        String string = lETokenizer.getNextQuotedString();
                        if (lEISDNPort == null) continue block9;
                        lEISDNPort.setField(Integer.toString(n), string);
                        break;
                    }
                    case 189: {
                        String string = lETokenizer.getNextQuotedString();
                        if (lEISDNPort == null) continue block9;
                        LEOctets lEOctets = new LEOctets(string);
                        string = lEOctets.toHexString();
                        lEISDNPort.setField(Integer.toString(n), string);
                        break;
                    }
                    case 289: {
                        String string = lETokenizer.getNextQuotedString();
                        break;
                    }
                    default: {
                        String string = lETokenizer.getNextQuotedString();
                        LEPMEntityParser.LogBadAttribute("ISDN Port", n, string);
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return n;
    }

    public static int ParseParallelPort(LEPorts lEPorts, LETokenizer lETokenizer) {
        int n = 0;
        try {
            LEParallelPorts lEParallelPorts = (LEParallelPorts)lEPorts.getConfig("ParallelPort");
            LEParallelPort lEParallelPort = null;
            boolean bl = false;
            block7: while (!bl) {
                n = lETokenizer.getNextInt();
                switch (n) {
                    case 275: 
                    case 333: 
                    case 65535: 
                    case 262144: {
                        bl = true;
                        break;
                    }
                    case 1: {
                        String string = lETokenizer.getNextQuotedString();
                        if (lEParallelPorts == null) continue block7;
                        lEParallelPort = (LEParallelPort)lEParallelPorts.getConfig(string);
                        break;
                    }
                    case 173: 
                    case 309: 
                    case 310: 
                    case 311: {
                        String string = lETokenizer.getNextQuotedString();
                        if (lEParallelPort == null) continue block7;
                        lEParallelPort.setField(Integer.toString(n), string);
                        break;
                    }
                    default: {
                        String string = lETokenizer.getNextQuotedString();
                        LEPMEntityParser.LogBadAttribute("Parallel Port", n, string);
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return n;
    }

    public static int ParseSyncPort(LEPorts lEPorts, LETokenizer lETokenizer) {
        int n = 0;
        try {
            LESyncPorts lESyncPorts = (LESyncPorts)lEPorts.getConfig("SyncPort");
            LEConfig lEConfig = null;
            LEDLCITable lEDLCITable = null;
            LEDLCITable lEDLCITable2 = null;
            String string = null;
            String string2 = null;
            boolean bl = false;
            block14: while (!bl) {
                n = lETokenizer.getNextInt();
                switch (n) {
                    case 275: 
                    case 333: 
                    case 65535: 
                    case 262144: {
                        bl = true;
                        break;
                    }
                    case 1: {
                        String string3 = lETokenizer.getNextQuotedString();
                        if (lESyncPorts == null || string3.startsWith("X")) continue block14;
                        lEConfig = (LESyncPort)lESyncPorts.getConfig(string3);
                        break;
                    }
                    case 4: 
                    case 15: 
                    case 74: 
                    case 129: 
                    case 130: 
                    case 177: 
                    case 181: 
                    case 187: 
                    case 188: 
                    case 193: 
                    case 194: 
                    case 289: 
                    case 290: 
                    case 295: 
                    case 297: 
                    case 312: 
                    case 316: 
                    case 318: 
                    case 319: 
                    case 332: 
                    case 353: 
                    case 354: 
                    case 355: 
                    case 356: 
                    case 357: 
                    case 358: 
                    case 359: 
                    case 360: 
                    case 361: 
                    case 362: 
                    case 363: {
                        String string3 = lETokenizer.getNextQuotedString();
                        if (lEConfig == null) continue block14;
                        lEConfig.setField(Integer.toString(n), string3);
                        break;
                    }
                    case 189: {
                        String string3 = lETokenizer.getNextQuotedString();
                        if (lEConfig == null) continue block14;
                        Object object = new LEOctets(string3);
                        string3 = ((LEOctets)object).toHexString();
                        lEConfig.setField(Integer.toString(n), string3);
                        break;
                    }
                    case 339: {
                        String string3 = lETokenizer.getNextQuotedString();
                        if (lEConfig == null) continue block14;
                        lEDLCITable = (LEDLCITable)lEConfig.getConfig(LESyncPort.IP_DLCI_TAB);
                        break;
                    }
                    case 340: {
                        String string3 = lETokenizer.getNextQuotedString();
                        if (lEConfig == null) continue block14;
                        lEDLCITable2 = (LEDLCITable)lEConfig.getConfig(LESyncPort.IPX_DLCI_TAB);
                        break;
                    }
                    case 305: {
                        string = lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 306: {
                        string2 = lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 307: {
                        String string3 = lETokenizer.getNextQuotedString();
                        if (string == null || lEDLCITable == null) continue block14;
                        Object object = (LEDLCI)lEDLCITable.getConfig(string);
                        if (object != null) {
                            ((LEConfig)object).setField("address", string3);
                        }
                        string = null;
                        break;
                    }
                    case 308: {
                        String string3 = lETokenizer.getNextQuotedString();
                        if (string2 == null || lEDLCITable2 == null) continue block14;
                        Object object = (LEDLCI)lEDLCITable2.getConfig(string2);
                        if (object != null) {
                            ((LEConfig)object).setField("address", string3);
                        }
                        string2 = null;
                        break;
                    }
                    default: {
                        String string3 = lETokenizer.getNextQuotedString();
                        LEPMEntityParser.LogBadAttribute("Sync Port", n, string3);
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return n;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean ParseNATMaps(LEConfig var0, LETokenizer var1_1) {
        var2_2 = false;
        var3_3 = false;
        var6_4 = (LENATMaps)var0;
        var7_5 = null;
        var8_6 = null;
        var9_7 = null;
        var10_8 = 0;
        var11_9 = null;
        var12_10 = null;
        var13_11 = null;
        var14_12 = null;
        var15_13 = null;
        var16_14 = null;
        var17_15 = 0;
        var18_16 = 0;
        var19_17 = 0;
        try {
            block29: while (true) lbl-1000:
            // 28 sources

            {
                if (var3_3) {
                    return var2_2;
                }
                var5_19 = var1_1.getNextInt();
                switch (var5_19) {
                    case 0x290000: {
                        var4_18 = var1_1.getNextQuotedString();
                        if (var4_18.length() <= 0) continue block29;
                        var7_5 = (LENATMap)var6_4.getConfig(var4_18);
                        ** break;
                    }
                    case 237: {
                        var4_18 = var1_1.getNextQuotedString();
                        var7_5 = (LENATMap)var6_4.getConfig(var4_18);
                        ** break;
                    }
                    case 341: {
                        var4_18 = var1_1.getNextQuotedString();
                        if (var7_5 != null) {
                            var8_6 = (LENATMapRule)var7_5.getConfig(var4_18);
                            ** break;
                        }
                        var8_6 = null;
                        ** break;
                    }
                    case 352: {
                        var4_18 = var1_1.getNextQuotedString();
                        if (var8_6 == null) continue block29;
                        var8_6.setField("type", var4_18);
                        ** break;
                    }
                    case 351: {
                        var4_18 = var1_1.getNextQuotedString();
                        if (var8_6 == null) continue block29;
                        if (var4_18.equals("off")) {
                            var8_6.setField("log", "off");
                            ** break;
                        }
                        var8_6.setField("log", "on");
                        ** break;
                    }
                    case 342: {
                        var17_15 = Integer.parseInt(var1_1.getNextQuotedString());
                        ** break;
                    }
                    case 343: {
                        var18_16 = Integer.parseInt(var1_1.getNextQuotedString()) + var17_15;
                        ** break;
                    }
                    case 344: {
                        var19_17 = Integer.parseInt(var1_1.getNextQuotedString()) + 1;
                        ** break;
                    }
                    case 345: {
                        var10_8 = Integer.parseInt(var1_1.getNextQuotedString());
                        ** break;
                    }
                    case 15: {
                        var11_9 = var1_1.getNextQuotedString();
                        ** break;
                    }
                    case 346: {
                        var12_10 = var1_1.getNextQuotedString();
                        ** break;
                    }
                    case 347: {
                        var13_11 = var1_1.getNextQuotedString();
                        ** break;
                    }
                    case 348: {
                        var14_12 = var1_1.getNextQuotedString();
                        ** break;
                    }
                    case 349: {
                        var15_13 = var1_1.getNextQuotedString();
                        ** break;
                    }
                    case 350: {
                        var16_14 = var1_1.getNextQuotedString();
                        if (var8_6 == null) continue block29;
                        if (var9_7 == null) {
                            var9_7 = new StringBuffer();
                        } else {
                            var9_7.append(",");
                        }
                        switch (var10_8) {
                            case 1: {
                                var9_7.append(var14_12);
                                var9_7.append('/');
                                var9_7.append(var11_9);
                                break;
                            }
                            case 2: {
                                var9_7.append(var15_13);
                                var9_7.append('-');
                                var9_7.append(var16_14);
                                break;
                            }
                            case 4: {
                                var9_7.append(var15_13);
                                break;
                            }
                            case 8: {
                                var9_7.append(var15_13);
                                var9_7.append(':');
                                var9_7.append(var12_10);
                                break;
                            }
                            case 16: {
                                var9_7.append(var15_13);
                                var9_7.append(':');
                                var9_7.append(var12_10);
                                var9_7.append('-');
                                var9_7.append(var13_11);
                                break;
                            }
                            case 132: {
                                var9_7.append("@ipaddr");
                                break;
                            }
                        }
                        if (var19_17 == var17_15) {
                            var8_6.setField("lhs", var9_7.toString());
                            var9_7 = null;
                            ** break;
                        }
                        if (var19_17 != var18_16) continue block29;
                        var8_6.setField("rhs", var9_7.toString());
                        var9_7 = null;
                        ** break;
                    }
                    case 12: {
                        var4_18 = var1_1.getNextQuotedString();
                        ** break;
                    }
                    case 65535: {
                        var3_3 = true;
                        if (var1_1.getNextInt() != 1) continue block29;
                        var2_2 = true;
                        ** break;
                    }
                }
                LEPMEntityParser.LogBadAttribute("NAT Maps", var5_19, var1_1.getNextQuotedString());
            }
        }
        catch (Exception var20_20) {
            LEDebug.getLog().logln(20, var20_20);
        }
        return var2_2;
    }

    public static boolean ParseEthernets(LEConfig lEConfig, LETokenizer lETokenizer) {
        boolean bl = false;
        try {
            LEEthernets lEEthernets = null;
            if (lEConfig instanceof LEEthernets) {
                lEEthernets = (LEEthernets)lEConfig;
            }
            LEEthernet lEEthernet = null;
            boolean bl2 = false;
            block11: while (!bl2) {
                int n = lETokenizer.getNextInt();
                switch (n) {
                    case 720896: {
                        String string = lETokenizer.getNextQuotedString();
                        if (string.length() <= 0 || lEEthernets == null) continue block11;
                        lEEthernet = (LEEthernet)lEEthernets.getConfig(string);
                        break;
                    }
                    case 275: {
                        LEBoard lEBoard;
                        String string = lETokenizer.getNextQuotedString();
                        if (!(lEConfig instanceof LEBoards) || (lEBoard = (LEBoard)lEConfig.get(string)) == null) continue block11;
                        lEEthernets = (LEEthernets)lEBoard.get(LEBoard.ETHERNETS);
                        break;
                    }
                    case 260: {
                        String string = lETokenizer.getNextQuotedString();
                        if (lEEthernets == null) continue block11;
                        lEEthernet = (LEEthernet)lEEthernets.getConfig(string);
                        break;
                    }
                    case 190: {
                        String string = lETokenizer.getNextQuotedString().toLowerCase();
                        if (lEEthernet == null) continue block11;
                        lEEthernet.setField(Integer.toString(n), string);
                        break;
                    }
                    case 9: 
                    case 15: 
                    case 186: 
                    case 187: 
                    case 188: 
                    case 189: 
                    case 193: 
                    case 194: 
                    case 195: 
                    case 242: 
                    case 243: 
                    case 244: 
                    case 246: 
                    case 353: 
                    case 354: 
                    case 355: 
                    case 356: 
                    case 357: 
                    case 358: 
                    case 359: 
                    case 360: 
                    case 361: 
                    case 362: 
                    case 363: {
                        String string = lETokenizer.getNextQuotedString();
                        if (lEEthernet == null) continue block11;
                        lEEthernet.setField(Integer.toString(n), string);
                        break;
                    }
                    case 191: 
                    case 192: {
                        String string = lETokenizer.getNextQuotedString();
                        if (string.equals("on")) {
                            lEEthernet.setField(Integer.toString(n), "enable");
                            break;
                        }
                        lEEthernet.setField(Integer.toString(n), "disable");
                        break;
                    }
                    case 65535: {
                        bl2 = true;
                        if (lETokenizer.getNextInt() != 1) continue block11;
                        bl = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("Ethernets", n, lETokenizer.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return bl;
    }

    public static boolean ParseUsers(LEConfig lEConfig, LETokenizer lETokenizer) {
        boolean bl = false;
        try {
            LEConfig lEConfig2 = lEConfig.getConfig("netuser");
            LEConfig lEConfig3 = lEConfig.getConfig("netdialback");
            LEConfig lEConfig4 = lEConfig.getConfig("user");
            LEConfig lEConfig5 = lEConfig.getConfig("logindialback");
            LEConfig lEConfig6 = null;
            String string = null;
            String string2 = null;
            boolean bl2 = false;
            block14: while (!bl2) {
                int n = lETokenizer.getNextInt();
                switch (n) {
                    case 0x1C0000: {
                        String string3 = lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 237: {
                        string = lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 78: {
                        String string3 = lETokenizer.getNextQuotedString();
                        lEConfig6 = null;
                        if (lEConfig == null || string == null) continue block14;
                        if (string3.equals("network")) {
                            lEConfig6 = lEConfig2.getConfig(string);
                            lEConfig6.setField("password", "");
                            break;
                        }
                        if (string3.equals("dialback_network")) {
                            lEConfig6 = lEConfig3.getConfig(string);
                            lEConfig6.setField("password", "");
                            break;
                        }
                        if (string3.equals("login")) {
                            lEConfig6 = lEConfig4.getConfig(string);
                            lEConfig6.setField("password", "");
                            break;
                        }
                        if (!string3.equals("dialback_login")) continue block14;
                        lEConfig6 = lEConfig5.getConfig(string);
                        break;
                    }
                    case 300: {
                        String string3 = lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 173: {
                        String string3 = lETokenizer.getNextQuotedString();
                        if (lEConfig6 == null) continue block14;
                        if (string3.equals("0.0.0.0")) {
                            lEConfig6.setField("host", "default");
                        } else if (string3.equals("255.255.255.255")) {
                            lEConfig6.setField("host", "prompt");
                        } else {
                            lEConfig6.setField("host", "specified");
                        }
                        lEConfig6.setField("HostAddress", string3);
                        break;
                    }
                    case 74: {
                        String string3 = lETokenizer.getNextQuotedString();
                        if (lEConfig6 == null) continue block14;
                        if (string3.equals("255.255.255.255")) {
                            lEConfig6.setField("destination", "negotiated");
                        } else if (string3.equals("255.255.255.254")) {
                            lEConfig6.setField("destination", "assigned");
                        } else {
                            lEConfig6.setField("destination", "specified");
                        }
                        lEConfig6.setField("IPAddress", string3);
                        break;
                    }
                    case 369: {
                        string2 = lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 370: {
                        String string3 = lETokenizer.getNextQuotedString();
                        if (lEConfig6 == null || string2 == null) continue block14;
                        if ((string2.equals("netdata") || string2.equals("telnet")) && string3.length() > 0) {
                            string2 = String.valueOf(string2) + "@" + string3;
                        }
                        lEConfig6.setField("service", string2);
                        string2 = null;
                        break;
                    }
                    case 15: 
                    case 177: 
                    case 187: 
                    case 188: 
                    case 189: 
                    case 193: 
                    case 194: 
                    case 241: 
                    case 242: 
                    case 243: 
                    case 244: 
                    case 245: 
                    case 246: 
                    case 289: 
                    case 290: 
                    case 295: 
                    case 296: 
                    case 297: 
                    case 299: 
                    case 301: 
                    case 353: 
                    case 354: 
                    case 355: 
                    case 356: 
                    case 357: 
                    case 358: 
                    case 359: 
                    case 360: 
                    case 361: 
                    case 362: 
                    case 363: 
                    case 368: 
                    case 371: {
                        String string3 = lETokenizer.getNextQuotedString();
                        if (lEConfig6 == null) continue block14;
                        lEConfig6.setField(Integer.toString(n), string3);
                        break;
                    }
                    case 65535: {
                        bl2 = true;
                        if (lETokenizer.getNextInt() != 1) continue block14;
                        bl = true;
                        break;
                    }
                    default: {
                        String string3 = lETokenizer.getNextQuotedString();
                        LEPMEntityParser.LogBadAttribute("User", n, string3);
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return bl;
    }

    public static boolean ParseUserPasswords(LEConfig lEConfig, LETokenizer lETokenizer) {
        if (!(lEConfig instanceof LEUsers)) {
            return false;
        }
        LEUsers lEUsers = (LEUsers)lEConfig;
        boolean bl = false;
        try {
            boolean bl2 = false;
            String string = null;
            block8: while (!bl2) {
                int n = lETokenizer.getNextInt();
                switch (n) {
                    case 0x310000: {
                        lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 237: {
                        string = lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 300: {
                        String string2 = lETokenizer.getNextQuotedString();
                        if (string != null && string2.length() > 0) {
                            LEConfig lEConfig2 = (LEConfig)lEUsers.getUser(string);
                            if (lEConfig2 instanceof LELoginUser) {
                                ((LELoginUser)lEConfig2).setPassword(string2);
                            } else if (lEConfig2 instanceof LENetUser) {
                                ((LENetUser)lEConfig2).setPassword(string2);
                            } else if (lEConfig2 instanceof LEDBNetUser) {
                                ((LEDBNetUser)lEConfig2).setPassword(string2);
                            }
                        }
                        string = null;
                        break;
                    }
                    case 65535: {
                        bl2 = true;
                        if (lETokenizer.getNextInt() != 1) continue block8;
                        bl = true;
                        break;
                    }
                    default: {
                        String string2 = lETokenizer.getNextQuotedString();
                        LEPMEntityParser.LogBadAttribute("User Passwords", n, string2);
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return bl;
    }

    public static boolean ParseSecrets(LEConfig lEConfig, LETokenizer lETokenizer) {
        LERadius lERadius = (LERadius)lEConfig.get("2228224");
        LEChoicenet lEChoicenet = (LEChoicenet)lEConfig.get("1507328");
        boolean bl = false;
        try {
            boolean bl2 = false;
            block8: while (!bl2) {
                int n = lETokenizer.getNextInt();
                switch (n) {
                    case 0x320000: {
                        lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 64: {
                        String string = lETokenizer.getNextQuotedString();
                        if (lERadius == null) continue block8;
                        lERadius.setSecret(string);
                        break;
                    }
                    case 65: {
                        String string = lETokenizer.getNextQuotedString();
                        if (lEChoicenet == null) continue block8;
                        lEChoicenet.setSecret(string);
                        break;
                    }
                    case 65535: {
                        bl2 = true;
                        if (lETokenizer.getNextInt() != 1) continue block8;
                        bl = true;
                        break;
                    }
                    default: {
                        String string = lETokenizer.getNextQuotedString();
                        LEPMEntityParser.LogBadAttribute("Secrets", n, string);
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return bl;
    }

    public static boolean ParseBGP(LEConfig lEConfig, LETokenizer lETokenizer) {
        boolean bl = false;
        try {
            boolean bl2 = false;
            block7: while (!bl2) {
                int n = lETokenizer.getNextInt();
                switch (n) {
                    case 589824: {
                        lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 9: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 111: 
                    case 112: {
                        String string = lETokenizer.getNextQuotedString();
                        if (lEConfig == null) continue block7;
                        lEConfig.setField(Integer.toString(n), string);
                        break;
                    }
                    case 65535: {
                        bl2 = true;
                        if (lETokenizer.getNextInt() != 1) continue block7;
                        bl = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("BGP", n, lETokenizer.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return bl;
    }

    public static boolean ParseBGPPeers(LEConfig lEConfig, LETokenizer lETokenizer) {
        boolean bl = false;
        try {
            LEConfig lEConfig2 = null;
            boolean bl2 = false;
            block8: while (!bl2) {
                int n = lETokenizer.getNextInt();
                switch (n) {
                    case 0x160000: {
                        String string = lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 9: {
                        String string = lETokenizer.getNextQuotedString();
                        if (string.length() <= 0 || lEConfig == null) continue block8;
                        lEConfig2 = (LEBGPPeer)lEConfig.getConfig(string);
                        break;
                    }
                    case 96: 
                    case 106: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 118: 
                    case 119: 
                    case 121: 
                    case 122: 
                    case 123: 
                    case 177: {
                        String string = lETokenizer.getNextQuotedString();
                        if (lEConfig2 == null) continue block8;
                        lEConfig2.setField(Integer.toString(n), string);
                        break;
                    }
                    case 65535: {
                        bl2 = true;
                        if (lETokenizer.getNextInt() != 1) continue block8;
                        bl = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("BGPPeers", n, lETokenizer.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return bl;
    }

    public static boolean ParseSAs(LEConfig lEConfig, LETokenizer lETokenizer) {
        boolean bl = false;
        try {
            LEConfig lEConfig2 = lEConfig.getConfig("ipsec");
            LEConfig lEConfig3 = lEConfig.getConfig("ipip");
            LEConfig lEConfig4 = lEConfig.getConfig("proxy");
            LEConfig lEConfig5 = null;
            String string = null;
            boolean bl2 = false;
            block11: while (!bl2) {
                int n = lETokenizer.getNextInt();
                switch (n) {
                    case 0x250000: {
                        String string2 = lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 237: {
                        string = lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 289: {
                        String string2 = lETokenizer.getNextQuotedString();
                        lEConfig5 = null;
                        if (lEConfig == null || string == null) continue block11;
                        if (string2.equals("IPSEC")) {
                            lEConfig5 = lEConfig2.getConfig(string);
                            break;
                        }
                        if (string2.equals("IPIP")) {
                            lEConfig5 = lEConfig3.getConfig(string);
                            break;
                        }
                        if (!string2.equals("PROXY")) continue block11;
                        lEConfig5 = lEConfig4.getConfig(string);
                        break;
                    }
                    case 74: 
                    case 225: 
                    case 228: 
                    case 229: 
                    case 230: 
                    case 231: 
                    case 232: 
                    case 233: 
                    case 234: 
                    case 235: 
                    case 236: 
                    case 238: 
                    case 239: 
                    case 247: {
                        String string2 = lETokenizer.getNextQuotedString();
                        if (lEConfig5 == null) continue block11;
                        lEConfig5.setField(Integer.toString(n), string2);
                        break;
                    }
                    case 226: {
                        String string2 = lETokenizer.getNextQuotedString();
                        if (string2.equals("")) {
                            string2 = "none";
                        }
                        if (lEConfig5 == null) continue block11;
                        lEConfig5.setField(Integer.toString(n), string2);
                        break;
                    }
                    case 240: {
                        String string2 = lETokenizer.getNextQuotedString();
                        if (lEConfig5 == null) continue block11;
                        int n2 = string2.length();
                        StringBuffer stringBuffer = new StringBuffer(n2);
                        int n3 = 0;
                        while (n3 < n2) {
                            stringBuffer.append('*');
                            ++n3;
                        }
                        lEConfig5.setField("secret", stringBuffer.toString());
                        break;
                    }
                    case 65535: {
                        bl2 = true;
                        if (lETokenizer.getNextInt() != 1) continue block11;
                        bl = true;
                        break;
                    }
                    default: {
                        String string2 = lETokenizer.getNextQuotedString();
                        LEPMEntityParser.LogBadAttribute("SA", n, string2);
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return bl;
    }

    public static boolean ParseBGPPolicies(LEConfig lEConfig, LETokenizer lETokenizer) {
        boolean bl = false;
        try {
            LETable lETable = null;
            LEConfig lEConfig2 = null;
            boolean bl2 = false;
            block9: while (!bl2) {
                int n = lETokenizer.getNextInt();
                switch (n) {
                    case 0x300000: {
                        String string = lETokenizer.getNextQuotedString();
                        break;
                    }
                    case 237: {
                        String string = lETokenizer.getNextQuotedString();
                        if (string.length() <= 0 || lEConfig == null) continue block9;
                        lETable = (LEBGPPolicy)lEConfig.getConfig(string);
                        break;
                    }
                    case 416: {
                        String string = lETokenizer.getNextQuotedString();
                        if (string.length() <= 0 || lETable == null) continue block9;
                        lEConfig2 = (LEBGPPolicyRule)lETable.getConfig(string);
                        break;
                    }
                    case 417: 
                    case 418: 
                    case 419: 
                    case 420: 
                    case 421: 
                    case 422: 
                    case 423: 
                    case 424: 
                    case 425: 
                    case 426: 
                    case 427: 
                    case 428: 
                    case 429: 
                    case 430: 
                    case 431: {
                        String string = lETokenizer.getNextQuotedString();
                        if (lEConfig2 == null) continue block9;
                        lEConfig2.setField(Integer.toString(n), string);
                        break;
                    }
                    case 65535: {
                        bl2 = true;
                        if (lETokenizer.getNextInt() != 1) continue block9;
                        bl = true;
                        break;
                    }
                    default: {
                        LEPMEntityParser.LogBadAttribute("BGPPolicies", n, lETokenizer.getNextQuotedString());
                    }
                }
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        return bl;
    }

    static void LogBadAttribute(String string, int n, String string2) {
        LEDebug.getLog().log(20, "Bad ");
        LEDebug.getLog().log(20, string);
        LEDebug.getLog().log(20, " Attribute: ", n);
        LEDebug.getLog().log(20, ", ");
        LEDebug.getLog().logln(20, string2);
    }
}

