/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.model.LEConfig;
import COM.livingston.model.LEDataSpec;
import COM.livingston.model.LEDataSpecFactory;
import COM.livingston.model.LETable;
import COM.livingston.ui.LEErrorDialog;
import COM.livingston.ui.LETree;
import COM.livingston.ui.LETreeItem;
import COM.livingston.ui.LEUiUtils;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEVector;
import java.io.IOException;
import java.util.Vector;

public class LEControlTree
extends LETree {
    public static final String ALARMS = new String("alarms");
    public static final String COMMAND = new String("command");
    public static final String CONFIG = new String("config");
    public static final String DEBUG = new String("debug");
    public static final String DETAILS = new String("details");
    public static final String DIAGNOSE = new String("diagnose");
    public static final String GRAPHS = new String("graph");
    public static final String IFACES = new String("interfaces");
    public static final String INSTALL = new String("install");
    public static final String LINES = new String("lines");
    public static final String L2TP_SESSIONS = new String("l2tp_sessions");
    public static final String L2TP_TUNNELS = new String("l2tp_tunnels");
    public static final String MAINTAIN = new String("maintain");
    public static final String MODEM_GRAPH = new String("modem_graph");
    public static final String MODEM_SUM = new String("modem_summary");
    public static final String MODEMS = new String("modems");
    public static final String MONITOR = new String("monitor");
    public static final String NAT_SESS = new String("nat_sess");
    public static final String NAT_STATS = new String("nat_stats");
    public static final String OSPF_NEIGHBOR = new String("ospf_neighbor");
    public static final String OSPF_LINKS = new String("ospf_links");
    public static final String RESTORE = new String("restore");
    public static final String ROOT = new String("portmasters");
    public static final String SAVE = new String("save");
    public static final String SESSION_GRAPH = new String("session_graph");
    public static final String SESSION_SUM = new String("session_summary");
    public static final String SESSIONS = new String("sessions");
    public static final String STATUS = new String("status");
    public static final String SUMMARY = new String("summary");
    public static final String SYSLOG = new String("syslog");
    public static final String TOTALS = new String("totals");
    public static final String UPGRADE = new String("upgrade");
    public static final String VPN = new String("vpn");
    public static final String MON_USERS = new String("mon_users");

    public LEControlTree() {
        LETreeItem lETreeItem = new LETreeItem("PortMaster", ROOT);
        LETreeItem lETreeItem2 = new LETreeItem("Monitor", MONITOR);
        lETreeItem2.addChild(new LETreeItem("Chassis", STATUS));
        lETreeItem2.addChild(new LETreeItem("Users", MON_USERS));
        lETreeItem2.addChild(new LETreeItem("Modem Summary", MODEM_SUM));
        lETreeItem2.addChild(new LETreeItem("Modem Details", MODEMS));
        lETreeItem2.addChild(new LETreeItem("Session Summary", SESSION_SUM));
        lETreeItem2.addChild(new LETreeItem("Session Details", SESSIONS));
        lETreeItem2.addChild(new LETreeItem("Lines", LINES));
        lETreeItem2.addChild(new LETreeItem("Interfaces", IFACES));
        lETreeItem2.addChild(new LETreeItem("Alarms", ALARMS));
        lETreeItem2.addChild(new LETreeItem("OSPF Neighbors", OSPF_NEIGHBOR));
        lETreeItem.addChild(lETreeItem2);
        lETreeItem2 = new LETreeItem("Graph", GRAPHS);
        lETreeItem2.addChild(new LETreeItem("Modems", MODEM_GRAPH));
        lETreeItem2.addChild(new LETreeItem("Sessions", SESSION_GRAPH));
        lETreeItem.addChild(lETreeItem2);
        lETreeItem2 = new LETreeItem("Diagnose", DIAGNOSE);
        lETreeItem2.addChild(new LETreeItem("Debug", DEBUG));
        lETreeItem.addChild(lETreeItem2);
        lETreeItem2 = new LETreeItem("Maintain", MAINTAIN);
        lETreeItem2.addChild(new LETreeItem("Back Up", SAVE));
        lETreeItem2.addChild(new LETreeItem("Restore", RESTORE));
        lETreeItem2.addChild(new LETreeItem("Upgrade", UPGRADE));
        lETreeItem.addChild(lETreeItem2);
        lETreeItem2 = new LETreeItem("Command", COMMAND);
        lETreeItem.addChild(lETreeItem2);
        lETreeItem2 = this.createConfigTree();
        if (lETreeItem2 != null) {
            lETreeItem.addChild(lETreeItem2);
        }
        this.addTree(lETreeItem);
    }

    public boolean selectParent(String string, boolean bl) {
        LETreeItem lETreeItem = this.findParent(this.getSelectedItem(), string);
        if (lETreeItem == null) {
            return false;
        }
        this.select(lETreeItem, bl);
        return true;
    }

    public boolean selectChild(LEConfig lEConfig, String string, String string2, boolean bl) {
        LETreeItem lETreeItem = this.findChild(this.getSelectedItem(), lEConfig, string, string2);
        if (lETreeItem == null) {
            return false;
        }
        this.select(lETreeItem, bl);
        return true;
    }

    boolean selectItem(LEVector lEVector, boolean bl) {
        LETreeItem lETreeItem = this.findItem(this.getRoots(), lEVector);
        if (lETreeItem == null) {
            return false;
        }
        this.select(lETreeItem, bl);
        return true;
    }

    LETreeItem createConfigTree() {
        LETreeItem lETreeItem = null;
        try {
            LEDataSpec lEDataSpec = LEDataSpecFactory.GetPortMasterSpec();
            if (lEDataSpec != null && lEDataSpec.getAllSpecs() != null) {
                lETreeItem = new LETreeItem("Configure", CONFIG);
                this.addSpec(lETreeItem, lEDataSpec);
            }
        }
        catch (IOException iOException) {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), iOException.getMessage());
            LEDebug.getLog().logln(20, iOException);
        }
        return lETreeItem;
    }

    void addSpec(LETreeItem lETreeItem, LEDataSpec lEDataSpec) {
        LEVector lEVector = lEDataSpec.getAllSpecs();
        int n = lEVector.size();
        int n2 = 0;
        while (n2 < n) {
            LEDataSpec lEDataSpec2 = (LEDataSpec)lEVector.elementAt(n2);
            if (lEDataSpec2.getAllSpecs() != null) {
                LETreeItem lETreeItem2 = new LETreeItem(lEDataSpec2.getDescription());
                lETreeItem2.m_object = lEDataSpec2.getTag();
                if (lEDataSpec2.getSpecFor("entry") == null) {
                    this.addSpec(lETreeItem2, lEDataSpec2);
                    if (lETreeItem2.m_children != null) {
                        lETreeItem2.m_collapsed = true;
                    }
                }
                lETreeItem.addChild(lETreeItem2);
            }
            ++n2;
        }
    }

    LETreeItem findParent(LETreeItem lETreeItem, String string) {
        while (lETreeItem != null && !string.equals((String)lETreeItem.m_object)) {
            lETreeItem = lETreeItem.m_parent;
        }
        return lETreeItem;
    }

    LETreeItem findItem(Vector vector, LEVector lEVector) {
        LETreeItem lETreeItem = null;
        int n = lEVector.size();
        int n2 = 0;
        while (n2 < n) {
            lETreeItem = null;
            if (vector == null) break;
            int n3 = vector.size();
            String string = (String)lEVector.elementAt(n2);
            int n4 = 0;
            while (n4 < n3 && lETreeItem == null) {
                lETreeItem = (LETreeItem)vector.elementAt(n4);
                if (!string.equals((String)lETreeItem.m_object)) {
                    lETreeItem = null;
                }
                ++n4;
            }
            if (lETreeItem == null) break;
            vector = lETreeItem.m_children;
            ++n2;
        }
        return lETreeItem;
    }

    LETreeItem findChild(LETreeItem lETreeItem, LEConfig lEConfig, String string, String string2) {
        LETreeItem lETreeItem2 = null;
        if (lETreeItem.m_children != null) {
            int n = lETreeItem.m_children.size();
            int n2 = 0;
            while (n2 < n) {
                lETreeItem2 = (LETreeItem)lETreeItem.m_children.elementAt(n2);
                if (string.equals((String)lETreeItem2.m_object)) break;
                lETreeItem2 = null;
                ++n2;
            }
        }
        if (lETreeItem2 == null && lEConfig != null) {
            LEDataSpec lEDataSpec = lEConfig.getSpecFor(string);
            if (lEConfig instanceof LETable) {
                if (lETreeItem.m_children != null) {
                    lETreeItem.m_children.removeAllElements();
                }
                lETreeItem2 = new LETreeItem(string2, string);
                if (lEDataSpec != null && lEDataSpec.getAllSpecs() != null) {
                    this.addSpec(lETreeItem2, lEDataSpec);
                }
                lETreeItem.addChild(lETreeItem2);
            }
            if (lETreeItem2 == null) {
                lETreeItem2 = new LETreeItem(string2, string);
                if (lEDataSpec != null && lEDataSpec.getAllSpecs() != null) {
                    this.addSpec(lETreeItem2, lEDataSpec);
                }
                lETreeItem.addChild(lETreeItem2);
            }
        }
        lETreeItem.m_collapsed = false;
        this.recalcTree();
        return lETreeItem2;
    }
}

