/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.model.LEPortMaster;
import COM.livingston.ui.LEColor;
import COM.livingston.ui.LEFont;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class LEPMDisplay
implements LEMonitorDisplay {
    LEPortMaster m_pm;
    String m_host;
    String m_model;
    String m_msg;
    int m_width = -1;
    int m_height = -1;

    public void setPortMaster(LEPortMaster lEPortMaster) {
        this.m_pm = lEPortMaster;
        this.m_host = this.m_pm.getHostname();
        this.m_model = this.m_pm.getHardwareType();
        if (this.m_model == null || this.m_model.length() == 0) {
            this.m_msg = "Cannot determine PortMaster model";
            return;
        }
        this.m_msg = "Cannot find image for PortMaster model " + this.m_model;
    }

    public void select(int n, int n2, LEViewListener lEViewListener) {
    }

    public void shutdown() {
    }

    public int getHeight(Graphics graphics) {
        if (this.m_height == -1) {
            this.determineSize(graphics);
        }
        return this.m_height;
    }

    public int getWidth(Graphics graphics) {
        if (this.m_height == -1) {
            this.determineSize(graphics);
        }
        return this.m_width;
    }

    public void draw(Graphics graphics, int n, int n2) {
        if (this.m_width == -1) {
            this.determineSize(graphics);
        }
        graphics.setColor(LEColor.getBackground());
        graphics.fillRect(n, n2, this.m_width, this.m_height);
        Font font = LEFont.getBoldFont();
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n3 = fontMetrics.getHeight() + 2;
        graphics.setColor(LEColor.getForeground());
        graphics.drawRect(n, n2 + n3, this.m_width, this.m_height - n3);
        graphics.drawRect(n + 1, n2 + n3 + 1, this.m_width - 2, this.m_height - n3 - 2);
        n3 = fontMetrics.getAscent();
        int n4 = (this.m_width - fontMetrics.stringWidth(this.m_host)) / 2;
        graphics.drawString(this.m_host, n + n4, n2 + n3);
        n3 = fontMetrics.getHeight() + fontMetrics.getAscent() + 7;
        graphics.drawString(this.m_msg, n + 5, n2 + n3);
    }

    public int heartbeat(Graphics graphics) {
        return 0;
    }

    public int blink(Graphics graphics, boolean bl) {
        return 0;
    }

    void determineSize(Graphics graphics) {
        Font font = LEFont.getBoldFont();
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        this.m_width = fontMetrics.stringWidth(this.m_msg) + 10;
        this.m_height = fontMetrics.getHeight() * 2 + 12;
    }
}

