/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.model.LEDataSpec;
import COM.livingston.model.LEDataSpecFactory;
import COM.livingston.model.LEPortMaster;
import COM.livingston.ui.LETreeItem;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEStatusManager;
import COM.livingston.util.LEVector;
import java.awt.Component;
import java.awt.Panel;

public class LEViewFactory {
    static LEMainView s_main;
    static LEMaintainView s_maintain;
    static LEConfigsView s_configs;
    static LEDiagnoseView s_diagnose;
    static LECommandView s_command;
    static LESaveView s_save;
    static LEUpgradeView s_upgrade;
    static LERestoreView s_restore;
    static LEGraphView s_graph;

    public static LEView GetView(LEControlTree lEControlTree, LEPortMaster[] lEPortMasterArray) {
        String string;
        LEStatusManager.SetStatus("Building display...");
        LEView lEView = null;
        LEVector lEVector = new LEVector();
        LETreeItem lETreeItem = lEControlTree.getSelectedItem();
        while (lETreeItem != null) {
            string = (String)lETreeItem.m_object;
            if (string.equals(LEControlTree.ROOT)) {
                lETreeItem = null;
                continue;
            }
            lEVector.insertElementAt(string, 0);
            lETreeItem = lETreeItem.m_parent;
        }
        if (lEVector.size() > 0) {
            string = (String)lEVector.removeElementAt(0);
            if (string.equals(LEControlTree.MONITOR)) {
                lEView = LEViewFactory.GetMonitorView(lEVector);
            } else if (string.equals(LEControlTree.GRAPHS)) {
                lEView = LEViewFactory.GetGraphView(lEVector, lEPortMasterArray);
            } else if (string.equals(LEControlTree.DIAGNOSE)) {
                lEView = LEViewFactory.GetDiagnoseView(lEVector, lEPortMasterArray);
            } else if (string.equals(LEControlTree.MAINTAIN)) {
                lEView = LEViewFactory.GetMaintainView(lEVector, lEPortMasterArray);
            } else if (string.equals(LEControlTree.COMMAND)) {
                lEView = LEViewFactory.GetCommandView();
            } else if (string.equals(LEControlTree.CONFIG)) {
                lEView = LEViewFactory.GetConfigView(lEControlTree.getSelectedItem(), lEVector, lEPortMasterArray);
            }
        } else {
            lEView = LEViewFactory.GetMainView();
        }
        if (lEView != null) {
            lEView.setSelection(lEPortMasterArray);
        }
        return lEView;
    }

    public static LEView GetView(LEControlTree lEControlTree, LEPortMaster[] lEPortMasterArray, LEPortMaster lEPortMaster, String string) {
        LEView lEView = LEViewFactory.GetView(lEControlTree, lEPortMasterArray);
        if (lEView instanceof LEMonitorDetailPanel) {
            LEMonitorDetailPanel lEMonitorDetailPanel = (LEMonitorDetailPanel)lEView;
            if (lEPortMaster != null) {
                LEMonitorDetailPanel.Display(lEPortMaster.getHostname(), string);
            }
            lEMonitorDetailPanel.setSelection(lEPortMasterArray);
        }
        return lEView;
    }

    public static LEView GetMainView() {
        if (s_main == null) {
            s_main = new LEMainView(LEConsole.GetConsole());
        } else {
            s_main.getMainPanel().setVisible(true);
        }
        return s_main;
    }

    public static LEView GetMonitorView(LEVector lEVector) {
        Component component = null;
        if (lEVector.size() == 0) {
            component = new LEMonitorView();
        } else {
            String string = (String)lEVector.removeElementAt(0);
            if (string.equals(LEControlTree.STATUS)) {
                component = new LEMonStatusView();
            } else if (string.equals(LEControlTree.MON_USERS)) {
                component = new LEMonUsersView();
            } else if (string.equals(LEControlTree.MODEM_SUM)) {
                component = new LEModemSummaryView();
            } else if (string.equals(LEControlTree.SESSION_SUM)) {
                component = new LESessionSummaryView();
            } else if (string.equals(LEControlTree.SESSIONS)) {
                component = new LEMonSessionsView();
            } else if (string.equals(LEControlTree.MODEMS)) {
                component = new LEMonModemsView();
            } else if (string.equals(LEControlTree.LINES)) {
                component = new LEMonLinesView();
            } else if (string.equals(LEControlTree.IFACES)) {
                component = new LEMonIfacesView();
            } else if (string.equals(LEControlTree.NAT_SESS)) {
                component = new LEMonNATSessView();
            } else if (string.equals(LEControlTree.NAT_STATS)) {
                component = new LEMonNATStatsView();
            } else if (string.equals(LEControlTree.ALARMS)) {
                component = new LEMonAlarmsView();
            } else if (string.equals(LEControlTree.OSPF_NEIGHBOR)) {
                component = new LEMonOSPFNeighborView();
            }
        }
        return component;
    }

    public static LEView GetGraphView(LEVector lEVector, LEPortMaster[] lEPortMasterArray) {
        Panel panel = null;
        if (lEVector.size() == 0) {
            if (s_graph == null) {
                s_graph = new LEGraphView();
            } else {
                s_graph.setVisible(true);
            }
            panel = s_graph;
        } else {
            String string = (String)lEVector.removeElementAt(0);
            if (string.equals(LEControlTree.MODEM_GRAPH)) {
                panel = new LEGraphModemsView();
            } else if (string.equals(LEControlTree.SESSION_GRAPH)) {
                panel = new LEGraphSessionsView();
            }
        }
        return panel;
    }

    public static LEView GetDiagnoseView(LEVector lEVector, LEPortMaster[] lEPortMasterArray) {
        Panel panel = null;
        if (lEVector.size() == 0) {
            if (s_diagnose == null) {
                s_diagnose = new LEDiagnoseView();
            } else {
                s_diagnose.setVisible(true);
            }
            panel = s_diagnose;
        } else {
            panel = new LEDebugView();
        }
        return panel;
    }

    public static LEView GetMaintainView(LEVector lEVector, LEPortMaster[] lEPortMasterArray) {
        Panel panel = null;
        if (lEVector.size() == 0) {
            if (s_maintain == null) {
                s_maintain = new LEMaintainView();
            } else {
                s_maintain.setVisible(true);
            }
            panel = s_maintain;
        } else {
            String string = (String)lEVector.removeElementAt(0);
            if (string.equals(LEControlTree.SAVE)) {
                if (s_save == null) {
                    s_save = new LESaveView();
                } else {
                    s_save.setVisible(true);
                }
                panel = s_save;
            } else if (string.equals(LEControlTree.UPGRADE)) {
                if (s_upgrade == null) {
                    s_upgrade = new LEUpgradeView();
                } else {
                    s_upgrade.setVisible(true);
                }
                panel = s_upgrade;
            } else if (string.equals(LEControlTree.RESTORE)) {
                if (s_restore == null) {
                    s_restore = new LERestoreView();
                } else {
                    s_restore.setVisible(true);
                }
                panel = s_restore;
            }
        }
        return panel;
    }

    public static LEView GetCommandView() {
        if (s_command == null) {
            s_command = new LECommandView();
        } else {
            s_command.setVisible(true);
        }
        return s_command;
    }

    public static LEView GetConfigView(LETreeItem lETreeItem, LEVector lEVector, LEPortMaster[] lEPortMasterArray) {
        LEView lEView = null;
        if (lEVector.size() == 0) {
            if (s_configs == null) {
                s_configs = new LEConfigsView(lETreeItem);
            } else {
                s_configs.setVisible(true);
            }
            lEView = s_configs;
        } else {
            try {
                StringBuffer stringBuffer = new StringBuffer("Configuration");
                LEDataSpec lEDataSpec = LEDataSpecFactory.GetPortMasterSpec();
                int n = lEVector.size();
                int n2 = 0;
                while (n2 < n) {
                    lEDataSpec = lEDataSpec.getSpecFor((String)lEVector.elementAt(n2));
                    stringBuffer.append(" - ");
                    stringBuffer.append(lEDataSpec.getDescription());
                    ++n2;
                }
                lEView = LEConfigViewFactory.GetView(lEVector);
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
            }
        }
        return lEView;
    }
}

