/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.backend;

import COM.livingston.amf.LEAMFactory;
import COM.livingston.backend.LEEntityFactory;
import COM.livingston.backend.LEEntityMessage;
import COM.livingston.backend.LEMemorySummaryMessage;
import COM.livingston.backend.LEModemSummaryMessage;
import COM.livingston.backend.LEMonEnvMessage;
import COM.livingston.backend.LEMonIfacesMessage;
import COM.livingston.backend.LEMonLinesMessage;
import COM.livingston.backend.LEMonModemsMessage;
import COM.livingston.backend.LEMonSessionsMessage;
import COM.livingston.backend.LEMonSyslogMessage;
import COM.livingston.backend.LESessionSummaryMessage;

public class LEMonitorFactory
extends LEEntityFactory {
    public static final String MONITOR = "MONITOR";
    static LEMonitorFactory s_factory = null;

    public static LEAMFactory GetFactory() {
        if (s_factory == null) {
            s_factory = new LEMonitorFactory();
        }
        return s_factory;
    }

    public static void Register() {
        LEMonitorFactory.GetFactory();
    }

    LEMonitorFactory() {
        LEAMFactory.GetFactory().register(MONITOR, this);
    }

    LEEntityMessage createMessage(int n, int n2, String string) {
        LEEntityMessage lEEntityMessage = null;
        switch (n2) {
            case 0x120000: {
                lEEntityMessage = new LEMonIfacesMessage(n, string);
                break;
            }
            case 131072: {
                lEEntityMessage = new LEMonLinesMessage(n, string);
                break;
            }
            case 65536: {
                lEEntityMessage = new LEMonSessionsMessage(n, string);
                break;
            }
            case 327680: {
                lEEntityMessage = new LEMonSyslogMessage(n, string);
                break;
            }
            case 196608: {
                lEEntityMessage = new LEMonModemsMessage(n, string);
                break;
            }
            case 0x2C0000: {
                lEEntityMessage = new LEModemSummaryMessage(n, string);
                break;
            }
            case 0x2D0000: {
                lEEntityMessage = new LEMemorySummaryMessage(n, string);
                break;
            }
            case 0x2E0000: {
                lEEntityMessage = new LESessionSummaryMessage(n, string);
                break;
            }
            case 0x330000: {
                lEEntityMessage = new LEMonEnvMessage(n, string);
            }
        }
        return lEEntityMessage;
    }
}

