/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.backend.LEDSSPortMaster;
import COM.livingston.backend.LEPMCommand;
import COM.livingston.model.LEBoard;
import COM.livingston.model.LEBoards;
import COM.livingston.model.LEConfigFacility;
import COM.livingston.model.LEPMEntityParser;
import COM.livingston.model.LEPMOldParser;
import COM.livingston.model.LEPortMaster;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEStatusManager;
import COM.livingston.util.LEVector;

public class LEPMConfigFacility
implements LEConfigFacility {
    LEPortMaster m_pm;

    public LEPMConfigFacility(LEPortMaster lEPortMaster) {
        this.m_pm = lEPortMaster;
    }

    public String getDescription() {
        return this.m_pm.getHostname();
    }

    public boolean getConfig(String string) {
        return this.getConfig(string, null);
    }

    public boolean getConfig(String string, String string2) {
        LEDSSPortMaster lEDSSPortMaster = this.m_pm.getDSS();
        if (lEDSSPortMaster == null) {
            return false;
        }
        boolean bl = false;
        if (string2 == null) {
            if (lEDSSPortMaster.supportsEntities() && (!string.equals("2162688") || this.globalEntityOkay())) {
                bl = LEPMEntityParser.Parse(string, lEDSSPortMaster, this.m_pm);
            }
            if (!bl) {
                bl = LEPMOldParser.Parse(string, lEDSSPortMaster, this.m_pm);
            }
        } else if (lEDSSPortMaster.supportsEntities()) {
            bl = LEPMEntityParser.Parse(string, string2, lEDSSPortMaster, this.m_pm);
        }
        return bl;
    }

    public LEPMCommand execute(String string) {
        String string2;
        LEDSSPortMaster lEDSSPortMaster = this.m_pm.getDSS();
        if (lEDSSPortMaster == null) {
            return null;
        }
        LEStatusManager.SetStatus(string);
        LEPMCommand lEPMCommand = lEDSSPortMaster.execute(string);
        if (LEPMCommand.IsReboot(string) && (string2 = this.m_pm.getHardwareType()) != null && string2.equals("PM-4")) {
            this.checkForBoards();
        }
        return lEPMCommand;
    }

    void checkForBoards() {
        LEBoards lEBoards = (LEBoards)this.m_pm.get("2555904");
        if (lEBoards == null) {
            return;
        }
        LEVector lEVector = lEBoards.getKeys();
        int n = lEVector.size();
        boolean bl = true;
        while (bl) {
            lEBoards.refresh();
            bl = false;
            int n2 = 0;
            while (!bl && n2 < n) {
                LEBoard lEBoard = (LEBoard)lEBoards.get((String)lEVector.elementAt(n2));
                if (lEBoard != null) {
                    String string = (String)lEBoard.get(LEBoard.BOARD_TYPE);
                    String string2 = (String)lEBoard.get(LEBoard.POWER);
                    if (string != null && string.equals("Present") && string2 != null && string2.equals("on")) {
                        bl = true;
                    }
                }
                ++n2;
            }
            if (!bl) continue;
            try {
                Thread.currentThread();
                Thread.sleep(5000L);
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
            }
        }
    }

    boolean globalEntityOkay() {
        boolean bl;
        block4: {
            bl = true;
            String string = this.m_pm.getSoftwareVersion();
            if (!string.startsWith("3.8b")) break block4;
            String string2 = string.substring(4);
            int n = string2.indexOf(47);
            if (n > -1) {
                string2 = string2.substring(0, n);
            }
            try {
                int n2 = Integer.parseInt(string2);
                if (n2 < 18) {
                    bl = false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                LEDebug.getLog().logln(20, numberFormatException);
            }
        }
        return bl;
    }
}

