/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.amf.LEAMFactory;
import COM.livingston.backend.LEDeltaSessionsMessage;
import COM.livingston.backend.LEMonSessionsMessage;
import COM.livingston.backend.LEStatusMessage;
import COM.livingston.forms.LECmdErrorDialog;
import COM.livingston.model.LEBoard;
import COM.livingston.model.LEBoards;
import COM.livingston.model.LEConfig;
import COM.livingston.model.LEPort;
import COM.livingston.model.LEPorts;
import COM.livingston.ui.LEMLEvent;
import COM.livingston.ui.LEUiUtils;
import COM.livingston.util.LEVector;
import java.awt.Button;
import java.awt.Component;
import java.awt.event.ActionEvent;

public class LEMonSessionsView
extends LEMonitorDetailPanel {
    static int[] s_monitors = null;
    Button m_resetPorts;

    public LEMonSessionsView() {
        this.initialize(1, 3, 11);
        this.setCellJustification(1, 2);
        int n = this.getNumColumns();
        int n2 = 8;
        while (n2 < n) {
            this.setCellJustification(n2, 2);
            ++n2;
        }
        this.m_resetCols = new int[3];
        int n3 = 0;
        while (n3 < 3) {
            this.m_resetCols[n3] = n3 + 11;
            ++n3;
        }
        this.m_resetPorts = new Button("Reset Port");
        this.m_buttons.add((Component)this.m_resetPorts, 0);
        this.m_resetPorts.addActionListener(this);
        this.m_resetPorts.setEnabled(false);
    }

    public synchronized void onLEMLEvent(LEMLEvent lEMLEvent) {
        super.onLEMLEvent(lEMLEvent);
        if (lEMLEvent.getType() == 3) {
            if (this.getSelectSize() > 0) {
                this.m_resetPorts.setEnabled(true);
                return;
            }
            this.m_resetPorts.setEnabled(false);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_resetPorts) {
            LEConfig lEConfig;
            Object object;
            if (this.getSelectSize() == 0) {
                return;
            }
            LEPorts lEPorts = null;
            if (this.m_selected_brd != null) {
                object = (LEBoards)this.m_selected_pm.get("2555904");
                if (object == null) {
                    return;
                }
                lEConfig = (LEBoard)((LEConfig)object).get(this.m_selected_brd);
                if (lEConfig == null) {
                    return;
                }
                lEPorts = (LEPorts)lEConfig.get(LEBoard.PORTS);
            } else {
                lEPorts = (LEPorts)this.m_selected_pm.get("262144");
            }
            if (lEPorts == null) {
                return;
            }
            int[] nArray = this.getSelectedRows();
            int n = 0;
            while (n < nArray.length) {
                object = (String)this.getCellItem(nArray[n], 2);
                lEConfig = null;
                LEVector lEVector = null;
                if (object != null) {
                    lEConfig = lEPorts.getPort((String)object);
                }
                if (lEConfig != null) {
                    lEVector = ((LEPort)lEConfig).reset();
                }
                if (lEVector != null) {
                    new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), this.m_selected_pm.getConfigFacility(), lEVector);
                }
                ++n;
            }
            return;
        }
        super.actionPerformed(actionEvent);
    }

    public synchronized void update(LEAMFactory lEAMFactory, String string, Object object) {
        if (object instanceof LEDeltaSessionsMessage) {
            LEDeltaSessionsMessage lEDeltaSessionsMessage = (LEDeltaSessionsMessage)object;
            String string2 = String.valueOf(lEDeltaSessionsMessage.getBoard()) + lEDeltaSessionsMessage.getName();
            Integer n = this.getRow(string, string2);
            if (n != null) {
                this.updateRow((int)n, lEDeltaSessionsMessage);
                return;
            }
        } else {
            if (object instanceof LEMonSessionsMessage) {
                LEMonSessionsMessage lEMonSessionsMessage = (LEMonSessionsMessage)object;
                String string3 = String.valueOf(lEMonSessionsMessage.getBoard()) + lEMonSessionsMessage.getName();
                Integer n = this.getRow(string, string3);
                if (n == null) {
                    this.createRow(string, string3, lEMonSessionsMessage);
                    return;
                }
                this.updateRow((int)n, lEMonSessionsMessage);
                return;
            }
            if (object instanceof LEStatusMessage) {
                this.updateStatus(string, (LEStatusMessage)object);
            }
        }
    }

    void createColumnTitles(int n, int n2, Object[] objectArray) {
        objectArray[n2++] = new String("Board");
        objectArray[n2++] = new String("Port");
        objectArray[n2++] = new String("User");
        objectArray[n2++] = new String("Destination");
        objectArray[n2++] = new String("Port Config");
        objectArray[n2++] = new String("Direction");
        objectArray[n2++] = new String("Status");
        objectArray[n2++] = new String("Modem");
        objectArray[n2++] = new String("Start Time");
        objectArray[n2++] = new String("Idle Time");
        objectArray[n2++] = new String("In Bytes");
        objectArray[n2++] = new String("Out Bytes");
        objectArray[n2++] = new String("Pending Bytes");
    }

    void createRow(String string, String string2, LEMonSessionsMessage lEMonSessionsMessage) {
        Object[] objectArray = new Object[14];
        int n = 0;
        objectArray[n++] = string;
        objectArray[n++] = lEMonSessionsMessage.getBoard();
        objectArray[n++] = lEMonSessionsMessage.getPortName();
        objectArray[n++] = lEMonSessionsMessage.getUsername();
        objectArray[n++] = lEMonSessionsMessage.getHostname();
        objectArray[n++] = lEMonSessionsMessage.getPortType();
        objectArray[n++] = lEMonSessionsMessage.getDirection();
        objectArray[n++] = lEMonSessionsMessage.getStatus();
        objectArray[n++] = lEMonSessionsMessage.getModem();
        objectArray[n++] = lEMonSessionsMessage.getStartTime();
        objectArray[n++] = lEMonSessionsMessage.getIdleTime();
        objectArray[n++] = new Long(lEMonSessionsMessage.getInputBytes());
        objectArray[n++] = new Long(lEMonSessionsMessage.getOutputBytes());
        objectArray[n++] = new Long(lEMonSessionsMessage.getPendingBytes());
        this.addRow(string, string2, objectArray);
    }

    void updateRow(int n, LEMonSessionsMessage lEMonSessionsMessage) {
        int n2 = 0;
        ++n2;
        ++n2;
        int n3 = ++n2;
        this.setCellItem(n, n3, lEMonSessionsMessage.getUsername());
        int n4 = ++n2;
        this.setCellItem(n, n4, lEMonSessionsMessage.getHostname());
        int n5 = ++n2;
        this.setCellItem(n, n5, lEMonSessionsMessage.getPortType());
        int n6 = ++n2;
        this.setCellItem(n, n6, lEMonSessionsMessage.getDirection());
        int n7 = ++n2;
        this.setCellItem(n, n7, lEMonSessionsMessage.getStatus());
        int n8 = ++n2;
        this.setCellItem(n, n8, lEMonSessionsMessage.getModem());
        int n9 = ++n2;
        this.setCellItem(n, n9, lEMonSessionsMessage.getStartTime());
        int n10 = ++n2;
        ++n2;
        this.setCellItem(n, n10, lEMonSessionsMessage.getIdleTime());
        LEMonitorData lEMonitorData = (LEMonitorData)this.getRowObject(n);
        if (lEMonitorData == null) {
            return;
        }
        this.setCellItem(n, n2, lEMonitorData.getCounter(n2, lEMonSessionsMessage.getInputBytes()));
        this.setCellItem(n, ++n2, lEMonitorData.getCounter(n2, lEMonSessionsMessage.getOutputBytes()));
        this.setCellItem(n, ++n2, lEMonitorData.getCounter(n2, lEMonSessionsMessage.getPendingBytes()));
    }

    void updateRow(int n, LEDeltaSessionsMessage lEDeltaSessionsMessage) {
        int n2 = 0;
        ++n2;
        ++n2;
        ++n2;
        ++n2;
        ++n2;
        ++n2;
        ++n2;
        if (lEDeltaSessionsMessage.getStatusChanged()) {
            this.setCellItem(n, n2, lEDeltaSessionsMessage.getStatus());
        }
        ++n2;
        ++n2;
        ++n2;
        ++n2;
        LEMonitorData lEMonitorData = (LEMonitorData)this.getRowObject(n);
        if (lEMonitorData == null) {
            return;
        }
        if (lEDeltaSessionsMessage.getInputBytesChanged()) {
            this.setCellItem(n, n2, lEMonitorData.getCounter(n2, lEDeltaSessionsMessage.getInputBytes()));
        }
        ++n2;
        if (lEDeltaSessionsMessage.getOutputBytesChanged()) {
            this.setCellItem(n, n2, lEMonitorData.getCounter(n2, lEDeltaSessionsMessage.getOutputBytes()));
        }
        ++n2;
        if (lEDeltaSessionsMessage.getPendingBytesChanged()) {
            this.setCellItem(n, n2, lEMonitorData.getCounter(n2, lEDeltaSessionsMessage.getPendingBytes()));
        }
    }

    int[] getMonitorEntities() {
        if (s_monitors == null) {
            s_monitors = new int[1];
            LEMonSessionsView.s_monitors[0] = 65536;
        }
        return s_monitors;
    }

    boolean isValidBoardType(String string) {
        return string.equals("Quad T1");
    }
}

