/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.dTree;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import oracle.ewt.dTree.DTree;
import oracle.ewt.dTree.DTreeDecoration;
import oracle.ewt.dTree.DTreeItem;
import oracle.ewt.graphics.GraphicUtils;

public abstract class DTreeBaseItem
implements DTreeItem {
    private DTreeItem _parent;
    private int _index;
    private static final int _MARGIN_THICKNESS = 2;

    protected DTreeBaseItem() {
    }

    public void activate() {
        DTree dTree = this.getTree();
        dTree.itemActivate(this);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public int getHeight() {
        Image image;
        if (this.getParent() == null) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        DTree dTree = this.getTree();
        Font font = dTree.getFont();
        FontMetrics fontMetrics = null;
        if (font != null && (fontMetrics = dTree.getFontMetrics(font)) != null) {
            n = fontMetrics.getHeight() + 2 * this.getLabelMarginThickness();
        }
        if ((image = this.getIcon()) != null) {
            n2 = image.getHeight(dTree);
        }
        return Math.max(n2, n);
    }

    public int getIndex() {
        return this._index;
    }

    public DTreeItem getItem(int n) {
        return null;
    }

    public DTreeItem getItemAt(int n, int n2) {
        if (n2 < this.getHeight()) {
            return this;
        }
        return null;
    }

    public int getItemCount() {
        return 0;
    }

    public DTreeItem getNextExpandedChild(DTreeItem dTreeItem) {
        return null;
    }

    public DTreeItem getParent() {
        return this._parent;
    }

    public int getSubTreeHeight() {
        return this.getHeight();
    }

    public int getSubTreeWidth() {
        return this.getWidth();
    }

    public int getSubTreeX() {
        return this.getX();
    }

    public int getSubTreeY() {
        return this.getY();
    }

    public DTree getTree() {
        DTreeItem dTreeItem = this.getParent();
        if (dTreeItem == null) {
            return null;
        }
        return dTreeItem.getTree();
    }

    public int getWidth() {
        DTree dTree = this.getTree();
        Font font = dTree.getFont();
        FontMetrics fontMetrics = null;
        String string = null;
        Image image = this.getIcon();
        int n = 0;
        int n2 = 0;
        int n3 = 2 * this.getLabelMarginThickness();
        if (font != null && (fontMetrics = dTree.getFontMetrics(font)) != null && (string = this.getLabel()) != null) {
            n = fontMetrics.stringWidth(string);
        }
        if (image != null) {
            n2 = image.getWidth(dTree);
        }
        return n + n2 + n3;
    }

    public int getX() {
        int n = 0;
        DTreeItem dTreeItem = this.getParent();
        while (dTreeItem != null) {
            ++n;
            dTreeItem = dTreeItem.getParent();
        }
        DTree dTree = this.getTree();
        int n2 = dTree.getIndentWidth();
        int n3 = this._getRootIndentWidth(dTree, n2);
        if (n == 0) {
            return n3;
        }
        return (n - 1) * n2 + n3;
    }

    public boolean isExpandable() {
        return this.getItemCount() > 0;
    }

    public boolean isExpanded() {
        return false;
    }

    public void itemAdded(DTreeItem dTreeItem, int n) {
        this._parent = dTreeItem;
        this._index = n;
    }

    public void itemRemoved() {
        this._parent = null;
    }

    public void paint(Graphics graphics, boolean bl, boolean bl2) {
        DTree dTree = this.getTree();
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        Image image = this.getIcon();
        String string = this.getLabel();
        int n = this.getLabelMarginThickness();
        int n2 = fontMetrics.getHeight() + 2 * n;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (image != null) {
            n3 = image.getHeight(dTree);
            n4 = image.getWidth(dTree);
            if (n3 < n2) {
                n6 = (n2 - n3) / 2;
            }
            graphics.drawImage(image, 0, n6, dTree);
        }
        n5 = n4;
        n6 = 0;
        if (n3 > n2) {
            n6 = (n3 - n2) / 2;
        }
        if (string != null) {
            Color color = graphics.getColor();
            if (bl) {
                this.paintHighlightRect(graphics, n5, n6, fontMetrics.stringWidth(string) + 2 * n, n2);
            }
            if (bl2) {
                this.paintFocusRect(graphics, n5, n6, fontMetrics.stringWidth(string) + 2 * n - 1, n2 - 1, bl);
            }
            this.paintText(graphics, string, n5 + n, n6 + fontMetrics.getAscent() + fontMetrics.getLeading() + n, bl);
            if (graphics.getColor() != color) {
                graphics.setColor(color);
            }
        }
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401) {
            this.keyPressed(keyEvent);
        }
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 501) {
            this.mousePressed(mouseEvent);
        }
    }

    public void setExpanded(boolean bl) {
    }

    public void setIndex(int n) {
        this._index = n;
    }

    protected abstract Image getIcon();

    protected abstract String getLabel();

    protected int getLabelMarginThickness() {
        return 2;
    }

    protected void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 37: {
                if (!this.isExpandable() || !this.isExpanded()) break;
                this.setExpanded(false);
                keyEvent.consume();
                return;
            }
            case 39: {
                if (!this.isExpandable() || this.isExpanded()) break;
                this.setExpanded(true);
                keyEvent.consume();
                return;
            }
        }
    }

    protected void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getClickCount();
        this.getTree();
        int n3 = this.getWidth();
        if ((mouseEvent.getModifiers() & 0x10) != 0 && n2 % 2 == 0 && n > 0 && n < n3) {
            this.activate();
            if (this.isExpandable()) {
                this.setExpanded(!this.isExpanded());
            }
            mouseEvent.consume();
        }
    }

    protected void paintFocusRect(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        if (bl) {
            graphics.setColor(Color.yellow);
        } else {
            graphics.setColor(SystemColor.textText);
        }
        GraphicUtils.drawFocusRect(graphics, n, n2, n3, n4);
    }

    protected void paintHighlightRect(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(SystemColor.textHighlight);
        graphics.fillRect(n, n2, n3, n4);
    }

    protected void paintText(Graphics graphics, String string, int n, int n2, boolean bl) {
        if (bl) {
            graphics.setColor(SystemColor.textHighlightText);
        } else {
            graphics.setColor(SystemColor.textText);
        }
        graphics.drawString(string, n, n2);
    }

    private int _getRootIndentWidth(DTree dTree, int n) {
        DTreeDecoration dTreeDecoration = dTree.getDecoration();
        Insets insets = dTreeDecoration.getDecorationInsets(dTree);
        if (insets != null) {
            return insets.left;
        }
        return 0;
    }

    public abstract int getY();

    public abstract void layout(int var1, int var2);
}

