/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT.lwText;

import oracle.ewt.lwAWT.lwText.LWTextComponent;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.lwAWT.lwText.TextPosition;
import oracle.ewt.timer.Timer;

final class AutoScroller
implements Runnable {
    private static final int _INITIAL_SCROLLING_DELAY = 100;
    private static final int _REPEAT_SCROLLING_DELAY = 50;
    private static AutoScroller _sAutoScroller;
    private LWTextField _scrollee;
    private Timer _timer = new Timer((Runnable)this, "AutoScroller");
    private int _scrollAmount;

    private AutoScroller() {
    }

    public static AutoScroller getAutoScroller() {
        if (_sAutoScroller == null) {
            _sAutoScroller = new AutoScroller();
        }
        return _sAutoScroller;
    }

    public void schedule(LWTextField lWTextField, int n) {
        this._scrollee = lWTextField;
        this._scrollAmount = n;
        this._timer.schedule(100L);
    }

    public void run() {
        int n;
        if (this._scrollAmount < 0) {
            n = this._scrollee.canvasPixelToSelectionIndex(0);
            if (n <= 0) {
                return;
            }
            if ((n += this._scrollAmount) < 0) {
                n = 0;
            }
        } else {
            int n2 = this._scrollee.getText().length();
            n = this._scrollee.canvasPixelToSelectionIndex(this._scrollee.getInnerSize().width);
            if (n >= n2) {
                return;
            }
            if ((n += this._scrollAmount) > n2) {
                n = n2;
            }
        }
        TextPosition textPosition = this._scrollee.getPosition(n);
        this._scrollee.scrollSelectionIntoView(textPosition);
        this._scrollee.growSelection(textPosition);
        this._timer.schedule(50L);
    }

    public void cancel() {
        this._timer.cancel();
    }

    public void cancel(LWTextComponent lWTextComponent) {
        if (this._scrollee == lWTextComponent) {
            this.cancel();
        }
    }
}

