/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.toolBar;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import java.util.Enumeration;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.graphics.ImageUtils;
import oracle.ewt.graphics.frame.ArmedButtonFramePainter;
import oracle.ewt.graphics.frame.ButtonFramePainter;
import oracle.ewt.graphics.frame.FramePainter;
import oracle.ewt.toolBar.ToolBar;
import oracle.ewt.toolBar.ToolBarActionListener;
import oracle.ewt.toolBar.ToolBarBaseItem;
import oracle.ewt.toolBar.ToolBarEvent;

public class ToolBarButton
extends ToolBarBaseItem
implements ImageObserver {
    private Image _normalIcon;
    private Image _disabledIcon;
    private boolean _armed;
    private boolean _mouseDown;
    private String _helpText;
    private ListenerManager _actionListeners;
    private static final int _SHADOWWD = 2;

    public ToolBarButton() {
        this(-1, null);
    }

    public ToolBarButton(int n, Image image) {
        this.storeSize(18, 18);
        this.setID(n);
        this.setIcon(image);
    }

    public boolean isArmed() {
        return this._armed;
    }

    public void setIcon(Image image) {
        this.setIconNoRedraw(image);
        ToolBar toolBar = this.getParent();
        if (toolBar != null && toolBar.isValid()) {
            Point point = this.getLocation();
            Dimension dimension = this.getSize();
            this.outerToIconSize(dimension, dimension);
            toolBar.repaintCanvas(point.x + 2, point.y + 2, dimension.width, dimension.height);
        }
    }

    protected void setIconNoRedraw(Image image) {
        this._normalIcon = image;
        this._disabledIcon = null;
        if (image == null) {
            this.setSize(0, 0);
            return;
        }
        this._disabledIcon = this.createDisabledIcon(image);
        ToolBarButton toolBarButton = this;
        synchronized (toolBarButton) {
            Dimension dimension = new Dimension(image.getWidth(this), image.getHeight(this));
            if (dimension.width > 0 && dimension.height > 0) {
                this.iconToOuterSize(dimension, dimension);
                this.setSize(dimension.width, dimension.height);
            }
            return;
        }
    }

    public Image getIcon() {
        return this._normalIcon;
    }

    public void addToolBarActionListener(ToolBarActionListener toolBarActionListener) {
        if (this._actionListeners == null) {
            this._actionListeners = new ListenerManager();
        }
        this._actionListeners.addListener(toolBarActionListener);
    }

    public void removeToolBarActionListener(ToolBarActionListener toolBarActionListener) {
        this._actionListeners.removeListener(toolBarActionListener);
    }

    public boolean mousePressed(MouseEvent mouseEvent, int n, int n2) {
        if (this.isEnabled() && (mouseEvent.getModifiers() & 0x10) != 0) {
            this._mouseDown = true;
            this.setArmed(true);
            this.paintItem();
        }
        return true;
    }

    public boolean mouseReleased(MouseEvent mouseEvent, int n, int n2) {
        boolean bl = this.isArmed();
        this._mouseDown = false;
        this.setArmed(false);
        if (this.isEnabled() && this.inside(n, n2) && (mouseEvent.getModifiers() & 0x10) != 0) {
            this.activate();
        }
        if (bl) {
            this.paintItem();
        }
        return true;
    }

    public boolean mouseDragged(MouseEvent mouseEvent, int n, int n2) {
        if (this.isEnabled() && this._mouseDown) {
            boolean bl = this.inside(n, n2);
            if (this.isArmed() != bl) {
                this.setArmed(bl);
                this.paintItem();
            }
        }
        return true;
    }

    public void paint(Graphics graphics) {
        if (this.isArmed()) {
            this.drawPressed(graphics);
            return;
        }
        this.drawReleased(graphics);
    }

    protected void drawPressed(Graphics graphics) {
        Dimension dimension = this.getSize();
        Point point = this.getLocation();
        if (dimension.width <= 0 || dimension.height <= 0) {
            return;
        }
        Color color = graphics.getColor();
        Color color2 = this.getParent().getBackground();
        graphics.setColor(color2);
        FramePainter framePainter = ArmedButtonFramePainter.getFramePainter();
        framePainter.paint(graphics, point.x, point.y, dimension.width, dimension.height, 2);
        graphics.setColor(color2);
        graphics.fillRect(point.x + 2, point.y + 2, dimension.width - 4, dimension.height - 4);
        graphics.setColor(color);
        this.drawIcon(graphics, point.x + 2 + 1, point.y + 2 + 1);
    }

    protected void drawReleased(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (dimension.width <= 0 || dimension.height <= 0) {
            return;
        }
        Color color = graphics.getColor();
        Color color2 = this.getParent().getBackground();
        Point point = this.getLocation();
        graphics.setColor(color2);
        FramePainter framePainter = ButtonFramePainter.getFramePainter();
        framePainter.paint(graphics, point.x, point.y, dimension.width, dimension.height, 2);
        graphics.setColor(color2);
        graphics.fillRect(point.x + 2, point.y + 2, dimension.width - 4, dimension.height - 4);
        graphics.setColor(color);
        this.drawIcon(graphics, point.x + 2, point.y + 2);
    }

    protected void drawIcon(Graphics graphics, int n, int n2) {
        Image image = this.getCurrentIcon();
        if (image != null) {
            graphics.drawImage(image, n, n2, this);
        }
    }

    protected Image getCurrentIcon() {
        Image image = this._normalIcon;
        if (image == null) {
            return null;
        }
        if (!this.isEnabled()) {
            if (this._disabledIcon == null) {
                this._disabledIcon = this.createDisabledIcon(image);
            }
            image = this._disabledIcon;
        }
        return image;
    }

    protected Image createDisabledIcon(Image image) {
        if (image == null) {
            return null;
        }
        ToolBar toolBar = this.getParent();
        if (toolBar == null) {
            return null;
        }
        Image image2 = ImageUtils.createDisabledImage(image);
        toolBar.prepareImage(image2, this);
        return image2;
    }

    protected void setParent(ToolBar toolBar) {
        super.setParent(toolBar);
        if (toolBar != null && this._disabledIcon == null) {
            this._disabledIcon = this.createDisabledIcon(this._normalIcon);
        }
    }

    protected void activate() {
        Enumeration enumeration;
        ToolBarEvent toolBarEvent = new ToolBarEvent(this.getParent(), 2000, this);
        ListenerManager listenerManager = this._actionListeners;
        if (listenerManager != null && (enumeration = listenerManager.getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                ToolBarActionListener toolBarActionListener = (ToolBarActionListener)enumeration.nextElement();
                toolBarActionListener.toolBarItemActionPerformed(toolBarEvent);
            }
        }
        this.getParent().dispatchEvent(toolBarEvent);
    }

    protected void iconToOuterSize(Dimension dimension, Dimension dimension2) {
        dimension2.width = dimension.width != -1 ? dimension.width + 4 : 0;
        if (dimension.height != -1) {
            dimension2.height = dimension.height + 4;
            return;
        }
        dimension2.height = 0;
    }

    protected void outerToIconSize(Dimension dimension, Dimension dimension2) {
        dimension2.width = dimension.width != -1 ? dimension.width - 4 : 0;
        if (dimension.height != -1) {
            dimension2.height = dimension.height - 4;
            return;
        }
        dimension2.height = 0;
    }

    public synchronized boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        Dimension dimension = this.getSize();
        ToolBar toolBar = this.getParent();
        if ((n & 3) != 0) {
            this.outerToIconSize(dimension, dimension);
            if ((n & 1) != 0) {
                dimension.width = n4;
            }
            if ((n & 2) != 0) {
                dimension.height = n5;
            }
            this.iconToOuterSize(dimension, dimension);
            this.setSize(dimension.width, dimension.height);
        }
        if (toolBar != null && (n & 0x30) != 0 && image == this.getCurrentIcon()) {
            Point point = this.getLocation();
            this.outerToIconSize(dimension, dimension);
            toolBar.repaintCanvas(point.x + 2, point.y + 2, dimension.width, dimension.height);
        }
        return (n & 0xA0) == 0;
    }

    public String getHelpText() {
        return this._helpText;
    }

    public void setHelpText(String string) {
        this._helpText = string;
    }

    private void setArmed(boolean bl) {
        this._armed = bl;
    }
}

