/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.imageCanvas;

import java.awt.Adjustable;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import oracle.ewt.EwtComponent;
import oracle.ewt.scrolling.ScrollableException;

public class ImageCanvas
extends EwtComponent {
    private Image _image;
    private Adjustable _hAdjustable;
    private Adjustable _vAdjustable;
    private static final int _MINIMUM_WIDTH = 10;
    private static final int _MINIMUM_HEIGHT = 10;

    public ImageCanvas(Image image) {
        this._image = image;
    }

    public Image getImage() {
        return this._image;
    }

    public void setImage(Image image) {
        this._image = image;
        this.invalidateCanvas();
    }

    public final boolean isHScrollable() {
        return true;
    }

    public final boolean isVScrollable() {
        return true;
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 3) != 0) {
            this.invalidateCanvas();
        }
        return super.imageUpdate(image, n, n2, n3, n4, n5);
    }

    public Dimension getMinimumSize() {
        int n = 0;
        int n2 = 0;
        if (this._image != null) {
            n = this._image.getWidth(this);
            n2 = this._image.getHeight(this);
        }
        if (n > 10) {
            n = 10;
        }
        if (n2 > 10) {
            n2 = 10;
        }
        return this.convertInnerToOuterSize(n, n2);
    }

    public Dimension getPreferredSize() {
        int n = 0;
        int n2 = 0;
        if (this._image != null) {
            n = this._image.getWidth(this);
            n2 = this._image.getHeight(this);
        }
        return this.convertInnerToOuterSize(n, n2);
    }

    public Adjustable getHAdjustable() {
        return this._hAdjustable;
    }

    public Adjustable getVAdjustable() {
        return this._vAdjustable;
    }

    public void attachHAdjustable(Adjustable adjustable) throws ScrollableException {
        if (this._hAdjustable != null) {
            throw new ScrollableException();
        }
        this._hAdjustable = adjustable;
    }

    public void attachVAdjustable(Adjustable adjustable) throws ScrollableException {
        if (this._vAdjustable != null) {
            throw new ScrollableException();
        }
        this._vAdjustable = adjustable;
    }

    public void detachAdjustable(Adjustable adjustable) throws ScrollableException {
        if (this._hAdjustable == adjustable) {
            this._hAdjustable = null;
            return;
        }
        if (this._vAdjustable == adjustable) {
            this._vAdjustable = null;
            return;
        }
        throw new ScrollableException();
    }

    protected void paintCanvasInterior(Graphics graphics) {
        if (this._image != null) {
            graphics.drawImage(this._image, 0, 0, this);
        }
    }

    protected Dimension layoutCanvas() {
        if (this._image == null) {
            return new Dimension(0, 0);
        }
        return new Dimension(this._image.getWidth(this), this._image.getHeight(this));
    }
}

