/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.ui;

import COM.livingston.util.LEHelpManager;
import COM.livingston.util.LEVector;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class LETriStateBox
extends Canvas
implements MouseListener,
KeyListener,
FocusListener {
    public static final int ON = 2;
    public static final int MID = 1;
    public static final int OFF = 0;
    private static final int SIZE = 15;
    private static final int INSET = 2;
    private static final int HORIZONTAL = 1;
    private static final int VERTICAL = 2;
    String m_label;
    int m_label_size;
    int m_state;
    int m_height;
    int m_width;
    LEVector m_states;
    boolean m_pressed;
    boolean m_enabled;
    boolean m_frozen;
    boolean m_tri;
    boolean m_help;

    public LETriStateBox() {
        this.initialize();
        this.m_state = 0;
        this.determineSize();
        this.setSize(this.m_width, this.m_height);
    }

    public LETriStateBox(String string, int n) {
        this.initialize();
        this.setLabel(string);
        this.determineSize();
        this.setSize(this.m_width, this.m_height);
        this.m_state = n;
    }

    public LETriStateBox(String string) {
        this.initialize();
        this.setLabel(string);
        this.determineSize();
        this.setSize(this.m_width, this.m_height);
        this.m_state = 0;
    }

    public void setLabel(String string) {
        this.m_label = string;
    }

    public void setState(int n) {
        this.m_state = n;
        this.repaint();
    }

    public void setEnabled(boolean bl) {
        this.m_enabled = bl;
    }

    public void setFrozen(boolean bl) {
        this.m_frozen = bl;
    }

    public void setThreeWay(boolean bl) {
        this.m_tri = bl;
    }

    public void setHelp(LEVector lEVector) {
        if (lEVector != null) {
            this.m_help = true;
            this.m_states = lEVector;
            return;
        }
        this.m_help = false;
        this.m_states = null;
    }

    public int getState() {
        return this.m_state;
    }

    public String getLabel() {
        return this.m_label;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public boolean isFrozen() {
        return this.m_frozen;
    }

    public boolean isThreeWay() {
        return this.m_tri;
    }

    public void addNotify() {
        super.addNotify();
    }

    public Dimension getMininumSize() {
        this.determineSize();
        return new Dimension(this.m_width, this.m_height);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        this.repaint();
    }

    public void setSize(Dimension dimension) {
        super.setSize(dimension);
        this.repaint();
    }

    public boolean isFocusTraversable() {
        return this.isEnabled() && !this.isFrozen();
    }

    public void paint(Graphics graphics) {
        this.getSize();
        int n = 2;
        int n2 = 2;
        this.drawTriBox(graphics, Color.white);
        int n3 = n + 15 + 2 + 2;
        if (this.m_enabled) {
            graphics.setColor(Color.black);
            if (this.m_label != null) {
                graphics.drawString(this.m_label, n3, n2 + 15 - 2);
                return;
            }
        } else {
            graphics.setColor(Color.white);
            if (this.m_label != null) {
                graphics.drawString(this.m_label, n3 + 1, n2 + 15 - 1);
            }
            graphics.setColor(Color.gray);
            if (this.m_label != null) {
                graphics.drawString(this.m_label, n3, n2 + 15 - 2);
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.m_help) {
            LEHelpManager.SetHelp(this.getValidValues());
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.m_help) {
            LEHelpManager.SetHelp("");
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed() || !this.isEnabled() || this.isFrozen()) {
            return;
        }
        this.m_pressed = true;
        Graphics graphics = this.getGraphics();
        this.drawTriBox(graphics, Color.lightGray);
        graphics.dispose();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed() || !this.m_pressed || !this.isEnabled() || this.isFrozen()) {
            return;
        }
        this.m_pressed = false;
        this.switchState();
        this.requestFocus();
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == ' ' && this.isEnabled()) {
            this.m_pressed = true;
            Graphics graphics = this.getGraphics();
            this.drawTriBox(graphics, Color.lightGray);
            graphics.dispose();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (!this.m_pressed || !this.isEnabled()) {
            return;
        }
        this.m_pressed = false;
        this.switchState();
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
        Graphics graphics = this.getGraphics();
        this.drawHighlight(graphics);
        graphics.dispose();
    }

    public void focusLost(FocusEvent focusEvent) {
        Graphics graphics = this.getGraphics();
        this.eraseHighlight(graphics);
        graphics.dispose();
    }

    private void initialize() {
        this.m_pressed = false;
        this.m_label_size = 0;
        this.m_enabled = true;
        this.m_frozen = false;
        this.m_help = false;
        this.m_states = null;
        this.m_tri = true;
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.addFocusListener(this);
    }

    private String getValidValues() {
        StringBuffer stringBuffer = new StringBuffer(100);
        int n = 0;
        while (n < this.m_states.size()) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append((String)this.m_states.elementAt(n));
            ++n;
        }
        return stringBuffer.toString();
    }

    private void drawTriBox(Graphics graphics, Color color) {
        int n = 2;
        int n2 = 2;
        int n3 = n + 15;
        int n4 = n2 + 15;
        graphics.setColor(color);
        graphics.fillRect(3, 3, 15, 15);
        graphics.setColor(Color.darkGray);
        graphics.drawLine(n, n2, n3 - 2, n2);
        graphics.drawLine(n, n2, n, n4 - 2);
        graphics.setColor(Color.white);
        graphics.drawLine(n3, n2, n3, n4);
        graphics.drawLine(n, n4, n3, n4);
        graphics.setColor(Color.darkGray);
        graphics.drawLine(n + 1, n2 + 1, n3 - 2, n2 + 1);
        graphics.drawLine(n + 1, n2 + 1, n + 1, n4 - 2);
        graphics.setColor(Color.lightGray);
        graphics.drawLine(n3 - 1, n2 + 1, n3 - 1, n4);
        graphics.drawLine(n + 1, n4 - 1, n3 - 1, n4 - 1);
        if (this.m_state == 2) {
            this.drawOn(graphics);
            return;
        }
        if (this.m_state == 1) {
            this.drawMid(graphics);
        }
    }

    private void drawOn(Graphics graphics) {
        int n = 6;
        int n2 = 6;
        int n3 = 9;
        int n4 = 13;
        int n5 = 13;
        if (this.isEnabled()) {
            graphics.setColor(Color.black);
        } else {
            graphics.setColor(Color.lightGray);
        }
        graphics.drawLine(n, n3, n4, n3);
        graphics.drawLine(n, n3 + 1, n4, n3 + 1);
        graphics.drawLine(n3, n2, n3, n5);
        graphics.drawLine(n3 + 1, n2, n3 + 1, n5);
    }

    private void drawMid(Graphics graphics) {
        int n = 6;
        int n2 = 9;
        int n3 = 13;
        int n4 = 9;
        if (this.isEnabled()) {
            graphics.setColor(Color.black);
        } else {
            graphics.setColor(Color.lightGray);
        }
        graphics.drawLine(n, n2, n3, n4);
        graphics.drawLine(n, n2 + 1, n3, n4 + 1);
    }

    private void determineSize() {
        if (this.m_label != null && this.m_label.length() > 0) {
            this.m_height = 21;
            this.m_width = 19 + this.m_label.length() * 10;
            return;
        }
        this.m_width = 21;
        this.m_height = 21;
    }

    private void switchState() {
        this.m_state = this.m_state == 0 ? 2 : (this.m_tri ? --this.m_state : 0);
        Graphics graphics = this.getGraphics();
        this.drawTriBox(graphics, Color.white);
        graphics.dispose();
    }

    private void drawHighlight(Graphics graphics) {
        if (this.m_label == null || this.m_label.length() == 0) {
            return;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.stringWidth(this.m_label);
        int n2 = 19;
        int n3 = 2;
        int n4 = n2 + n + 2 + 2;
        int n5 = 17;
        this.drawDottedLine(graphics, Color.black, n2, n4, n3, 1);
        this.drawDottedLine(graphics, Color.black, n2, n4, n5, 1);
        this.drawDottedLine(graphics, Color.black, n3, n5, n2, 2);
        this.drawDottedLine(graphics, Color.black, n3, n5, n4, 2);
    }

    private void eraseHighlight(Graphics graphics) {
        if (this.m_label == null || this.m_label.length() == 0) {
            return;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.stringWidth(this.m_label);
        int n2 = 19;
        int n3 = 2;
        int n4 = n2 + n + 2 + 2;
        int n5 = 17;
        Color color = this.getBackground();
        this.drawDottedLine(graphics, color, n2, n4, n3, 1);
        this.drawDottedLine(graphics, color, n2, n4, n5, 1);
        this.drawDottedLine(graphics, color, n3, n5, n2, 2);
        this.drawDottedLine(graphics, color, n3, n5, n4, 2);
    }

    private void drawDottedLine(Graphics graphics, Color color, int n, int n2, int n3, int n4) {
        graphics.setColor(color);
        if (n4 == 1) {
            int n5 = n;
            while (n5 <= n2) {
                graphics.drawLine(n5, n3, n5, n3);
                n5 += 2;
            }
            return;
        }
        int n6 = n;
        while (n6 <= n2) {
            graphics.drawLine(n3, n6, n3, n6);
            n6 += 2;
        }
    }
}

