/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.util;

public class MD5 {
    private int[] state;
    private long count;
    private byte[] buffer = new byte[64];
    private static final int S11 = 7;
    private static final int S12 = 12;
    private static final int S13 = 17;
    private static final int S14 = 22;
    private static final int S21 = 5;
    private static final int S22 = 9;
    private static final int S23 = 14;
    private static final int S24 = 20;
    private static final int S31 = 4;
    private static final int S32 = 11;
    private static final int S33 = 16;
    private static final int S34 = 23;
    private static final int S41 = 6;
    private static final int S42 = 10;
    private static final int S43 = 15;
    private static final int S44 = 21;
    private static byte[] padding = new byte[]{-128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int TEST_BLOCK_LEN = 1000;
    private static final int TEST_BLOCK_COUNT = 1000;

    private static final int uadd(int n, int n2) {
        long l = (long)n & 0xFFFFFFFFL;
        long l2 = (long)n2 & 0xFFFFFFFFL;
        return (int)(l + l2 & 0xFFFFFFFFL);
    }

    private static final int uadd(int n, int n2, int n3) {
        long l = (long)n & 0xFFFFFFFFL;
        long l2 = (long)n2 & 0xFFFFFFFFL;
        long l3 = (long)n3 & 0xFFFFFFFFL;
        return (int)(l + l2 + l3 & 0xFFFFFFFFL);
    }

    private static final int uadd(int n, int n2, int n3, int n4) {
        long l = (long)n & 0xFFFFFFFFL;
        long l2 = (long)n2 & 0xFFFFFFFFL;
        long l3 = (long)n3 & 0xFFFFFFFFL;
        long l4 = (long)n4 & 0xFFFFFFFFL;
        return (int)(l + l2 + l3 + l4 & 0xFFFFFFFFL);
    }

    private static final int rotate_left(int n, int n2) {
        return n << n2 | n >>> 32 - n2;
    }

    private static final int FF(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        n = MD5.uadd(n, n2 & n3 | ~n2 & n4, n5, n7);
        return MD5.uadd(MD5.rotate_left(n, n6), n2);
    }

    private static final int GG(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        n = MD5.uadd(n, n2 & n4 | n3 & ~n4, n5, n7);
        return MD5.uadd(MD5.rotate_left(n, n6), n2);
    }

    private static final int HH(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        n = MD5.uadd(n, n2 ^ n3 ^ n4, n5, n7);
        return MD5.uadd(MD5.rotate_left(n, n6), n2);
    }

    private static final int II(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        n = MD5.uadd(n, n3 ^ (n2 | ~n4), n5, n7);
        return MD5.uadd(MD5.rotate_left(n, n6), n2);
    }

    public MD5() {
        this.state = new int[4];
        this.init();
    }

    public void init() {
        this.count = 0L;
        this.state[0] = 1732584193;
        this.state[1] = -271733879;
        this.state[2] = -1732584194;
        this.state[3] = 271733878;
    }

    public final void update(String string, int n, int n2) {
        byte[] byArray = string.getBytes();
        this.update(byArray, n, n2);
    }

    public final void update(String string) {
        this.update(string, 0, string.length());
    }

    public final void update(byte[] byArray) {
        this.update(byArray, 0, byArray.length);
    }

    public final void update(byte[] byArray, int n, int n2) {
        int n3;
        if (n2 - n > byArray.length) {
            throw new IllegalArgumentException();
        }
        int n4 = (int)(this.count >>> 3) & 0x3F;
        this.count += (long)(n2 << 3);
        int n5 = 64 - n4;
        if (n2 >= n5) {
            System.arraycopy(byArray, n, this.buffer, n4, n5);
            this.Transform(this.buffer, 0);
            n3 = n5 + n;
            while (n3 + 63 < n + n2) {
                this.Transform(byArray, n3);
                n3 += 64;
            }
            n4 = 0;
        } else {
            n3 = n;
        }
        System.arraycopy(byArray, n3, this.buffer, n4, n2 - (n3 - n));
    }

    public final byte[] digest() {
        int[] nArray = new int[]{(int)(this.count & 0xFFFFFFFFL), (int)(this.count >>> 32 & 0xFFFFFFFFL)};
        byte[] byArray = MD5.Encode(nArray, 8);
        int n = (int)(this.count >> 3) & 0x3F;
        int n2 = n < 56 ? 56 - n : 120 - n;
        this.update(padding, 0, n2);
        this.update(byArray, 0, 8);
        byte[] byArray2 = MD5.Encode(this.state, 16);
        this.init();
        return byArray2;
    }

    private final void Transform(byte[] byArray, int n) {
        int n2 = this.state[0];
        int n3 = this.state[1];
        int n4 = this.state[2];
        int n5 = this.state[3];
        int[] nArray = MD5.Decode(byArray, n, 64);
        n2 = MD5.FF(n2, n3, n4, n5, nArray[0], 7, -680876936);
        n5 = MD5.FF(n5, n2, n3, n4, nArray[1], 12, -389564586);
        n4 = MD5.FF(n4, n5, n2, n3, nArray[2], 17, 606105819);
        n3 = MD5.FF(n3, n4, n5, n2, nArray[3], 22, -1044525330);
        n2 = MD5.FF(n2, n3, n4, n5, nArray[4], 7, -176418897);
        n5 = MD5.FF(n5, n2, n3, n4, nArray[5], 12, 1200080426);
        n4 = MD5.FF(n4, n5, n2, n3, nArray[6], 17, -1473231341);
        n3 = MD5.FF(n3, n4, n5, n2, nArray[7], 22, -45705983);
        n2 = MD5.FF(n2, n3, n4, n5, nArray[8], 7, 1770035416);
        n5 = MD5.FF(n5, n2, n3, n4, nArray[9], 12, -1958414417);
        n4 = MD5.FF(n4, n5, n2, n3, nArray[10], 17, -42063);
        n3 = MD5.FF(n3, n4, n5, n2, nArray[11], 22, -1990404162);
        n2 = MD5.FF(n2, n3, n4, n5, nArray[12], 7, 1804603682);
        n5 = MD5.FF(n5, n2, n3, n4, nArray[13], 12, -40341101);
        n4 = MD5.FF(n4, n5, n2, n3, nArray[14], 17, -1502002290);
        n3 = MD5.FF(n3, n4, n5, n2, nArray[15], 22, 1236535329);
        n2 = MD5.GG(n2, n3, n4, n5, nArray[1], 5, -165796510);
        n5 = MD5.GG(n5, n2, n3, n4, nArray[6], 9, -1069501632);
        n4 = MD5.GG(n4, n5, n2, n3, nArray[11], 14, 643717713);
        n3 = MD5.GG(n3, n4, n5, n2, nArray[0], 20, -373897302);
        n2 = MD5.GG(n2, n3, n4, n5, nArray[5], 5, -701558691);
        n5 = MD5.GG(n5, n2, n3, n4, nArray[10], 9, 38016083);
        n4 = MD5.GG(n4, n5, n2, n3, nArray[15], 14, -660478335);
        n3 = MD5.GG(n3, n4, n5, n2, nArray[4], 20, -405537848);
        n2 = MD5.GG(n2, n3, n4, n5, nArray[9], 5, 568446438);
        n5 = MD5.GG(n5, n2, n3, n4, nArray[14], 9, -1019803690);
        n4 = MD5.GG(n4, n5, n2, n3, nArray[3], 14, -187363961);
        n3 = MD5.GG(n3, n4, n5, n2, nArray[8], 20, 1163531501);
        n2 = MD5.GG(n2, n3, n4, n5, nArray[13], 5, -1444681467);
        n5 = MD5.GG(n5, n2, n3, n4, nArray[2], 9, -51403784);
        n4 = MD5.GG(n4, n5, n2, n3, nArray[7], 14, 1735328473);
        n3 = MD5.GG(n3, n4, n5, n2, nArray[12], 20, -1926607734);
        n2 = MD5.HH(n2, n3, n4, n5, nArray[5], 4, -378558);
        n5 = MD5.HH(n5, n2, n3, n4, nArray[8], 11, -2022574463);
        n4 = MD5.HH(n4, n5, n2, n3, nArray[11], 16, 1839030562);
        n3 = MD5.HH(n3, n4, n5, n2, nArray[14], 23, -35309556);
        n2 = MD5.HH(n2, n3, n4, n5, nArray[1], 4, -1530992060);
        n5 = MD5.HH(n5, n2, n3, n4, nArray[4], 11, 1272893353);
        n4 = MD5.HH(n4, n5, n2, n3, nArray[7], 16, -155497632);
        n3 = MD5.HH(n3, n4, n5, n2, nArray[10], 23, -1094730640);
        n2 = MD5.HH(n2, n3, n4, n5, nArray[13], 4, 681279174);
        n5 = MD5.HH(n5, n2, n3, n4, nArray[0], 11, -358537222);
        n4 = MD5.HH(n4, n5, n2, n3, nArray[3], 16, -722521979);
        n3 = MD5.HH(n3, n4, n5, n2, nArray[6], 23, 76029189);
        n2 = MD5.HH(n2, n3, n4, n5, nArray[9], 4, -640364487);
        n5 = MD5.HH(n5, n2, n3, n4, nArray[12], 11, -421815835);
        n4 = MD5.HH(n4, n5, n2, n3, nArray[15], 16, 530742520);
        n3 = MD5.HH(n3, n4, n5, n2, nArray[2], 23, -995338651);
        n2 = MD5.II(n2, n3, n4, n5, nArray[0], 6, -198630844);
        n5 = MD5.II(n5, n2, n3, n4, nArray[7], 10, 1126891415);
        n4 = MD5.II(n4, n5, n2, n3, nArray[14], 15, -1416354905);
        n3 = MD5.II(n3, n4, n5, n2, nArray[5], 21, -57434055);
        n2 = MD5.II(n2, n3, n4, n5, nArray[12], 6, 1700485571);
        n5 = MD5.II(n5, n2, n3, n4, nArray[3], 10, -1894986606);
        n4 = MD5.II(n4, n5, n2, n3, nArray[10], 15, -1051523);
        n3 = MD5.II(n3, n4, n5, n2, nArray[1], 21, -2054922799);
        n2 = MD5.II(n2, n3, n4, n5, nArray[8], 6, 1873313359);
        n5 = MD5.II(n5, n2, n3, n4, nArray[15], 10, -30611744);
        n4 = MD5.II(n4, n5, n2, n3, nArray[6], 15, -1560198380);
        n3 = MD5.II(n3, n4, n5, n2, nArray[13], 21, 1309151649);
        n2 = MD5.II(n2, n3, n4, n5, nArray[4], 6, -145523070);
        n5 = MD5.II(n5, n2, n3, n4, nArray[11], 10, -1120210379);
        n4 = MD5.II(n4, n5, n2, n3, nArray[2], 15, 718787259);
        n3 = MD5.II(n3, n4, n5, n2, nArray[9], 21, -343485551);
        this.state[0] = this.state[0] + n2;
        this.state[1] = this.state[1] + n3;
        this.state[2] = this.state[2] + n4;
        this.state[3] = this.state[3] + n5;
        int n6 = 0;
        while (n6 < nArray.length) {
            nArray[n6] = 0;
            ++n6;
        }
    }

    private static final byte[] Encode(int[] nArray, int n) {
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            byArray[n3] = (byte)(nArray[n2] & 0xFF);
            byArray[n3 + 1] = (byte)(nArray[n2] >>> 8 & 0xFF);
            byArray[n3 + 2] = (byte)(nArray[n2] >>> 16 & 0xFF);
            byArray[n3 + 3] = (byte)(nArray[n2] >>> 24 & 0xFF);
            ++n2;
            n3 += 4;
        }
        return byArray;
    }

    private static final int[] Decode(byte[] byArray, int n, int n2) {
        if (n2 % 4 != 0) {
            throw new IllegalArgumentException();
        }
        int[] nArray = new int[n2 / 4];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            nArray[n3] = byArray[n4 + n] & 0xFF | (byArray[n4 + n + 1] & 0xFF) << 8 | (byArray[n4 + n + 2] & 0xFF) << 16 | (byArray[n4 + n + 3] & 0xFF) << 24;
            ++n3;
            n4 += 4;
        }
        return nArray;
    }

    public static final String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length);
        int n = 0;
        while (n < byArray.length) {
            int n2 = byArray[n] >> 4 & 0xF;
            int n3 = byArray[n] & 0xF;
            stringBuffer.append(Character.forDigit(n2, 16));
            stringBuffer.append(Character.forDigit(n3, 16));
            ++n;
        }
        return new String(stringBuffer);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equals("-s")) {
                    MD5.MDString(stringArray[n + 1]);
                } else if (stringArray[n].equals("-t")) {
                    MD5.MDTimeTrial();
                } else if (stringArray[n].equals("-x")) {
                    MD5.MDTestSuite();
                }
                ++n;
            }
        }
    }

    private static void MDString(String string) {
        MD5 mD5 = new MD5();
        byte[] byArray = string.getBytes();
        mD5.update(byArray, 0, string.length());
        byte[] byArray2 = mD5.digest();
        System.out.println(MD5.toHexString(byArray2));
    }

    private static final void MDTimeTrial() {
        byte[] byArray = new byte[1000];
        System.out.print("MD5 time trial. Digesting " + 1000 + " " + 1000 + "-byte blocks ...");
        int n = 0;
        while (n < 1000) {
            byArray[n] = (byte)(n & 0xFF);
            ++n;
        }
        long l = System.currentTimeMillis();
        MD5 mD5 = new MD5();
        n = 0;
        while (n < 1000) {
            mD5.update(byArray, 0, 1000);
            ++n;
        }
        byte[] byArray2 = mD5.digest();
        long l2 = System.currentTimeMillis();
        System.out.println(" done");
        System.out.println("Digest = " + MD5.toHexString(byArray2));
        long l3 = l2 - l;
        long l4 = 1000000L / l3;
        System.out.println("Time = " + l3 + ", Speed = " + l4);
    }

    static void MDTestSuite() {
        System.out.println("MD5 test suite:\n");
        MD5.MDString("");
        MD5.MDString("a");
        MD5.MDString("abc");
        MD5.MDString("message digest");
        MD5.MDString("abcdefghijklmnopqrstuvwxyz");
        MD5.MDString("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789");
        MD5.MDString("12345678901234567890123456789012345678901234567890123456789012345678901234567890");
    }
}

