/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.forms.LEConfigForm;
import COM.livingston.model.LEPortMaster;
import COM.livingston.ui.LEUiUtils;
import COM.livingston.util.LEHelpManager;
import COM.livingston.util.LEVector;
import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class LEConfigView
implements LEModelView,
ActionListener,
Runnable {
    public static final String ACTION_SAVE = "save";
    public static final String ACTION_REFRESH = "refresh";
    LEViewListener m_listener;
    LEConfigForm m_form = new LEConfigForm();
    Panel m_buttons;
    String m_action;
    String m_tag;

    public void setContext(LEVector lEVector) {
        this.m_buttons = new Panel();
        this.m_buttons.setLayout(new FlowLayout(1));
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 2, 10, 10));
        Button button = new Button("Save...");
        button.setActionCommand(ACTION_SAVE);
        button.addActionListener(this);
        panel.add(button);
        button = new Button("Refresh");
        button.setActionCommand(ACTION_REFRESH);
        button.addActionListener(this);
        panel.add(button);
        this.m_buttons.add(panel);
        this.m_form.setContext(lEVector);
        this.m_form.setActionListener(this);
    }

    public void save() {
        this.m_form.save(LEUiUtils.GetBaseFrame());
    }

    public void refresh() {
        this.m_form.refresh();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        String string2 = actionEvent.getActionCommand();
        if (string2.equals(ACTION_SAVE)) {
            this.dispatch(string2);
            return;
        }
        if (string2.equals(ACTION_REFRESH)) {
            this.dispatch(string2);
            return;
        }
        Object object = actionEvent.getSource();
        if (object instanceof Button && (string = this.m_form.getTagFor(object)) != null && this.m_listener != null) {
            this.m_listener.onLEViewEvent(new LEViewEvent(1, string));
        }
    }

    public void lock() {
        this.m_form.setEnabled(false);
        this.m_buttons.setEnabled(false);
        if (this.m_listener != null) {
            this.m_listener.onLEViewEvent(new LEViewEvent(8, null));
        }
    }

    public void unlock() {
        if (this.m_listener != null) {
            this.m_listener.onLEViewEvent(new LEViewEvent(9, null));
        }
        this.m_form.setEnabled(true);
        this.m_buttons.setEnabled(true);
    }

    public void dispatch(String string) {
        this.lock();
        this.m_action = string;
        new Thread((Runnable)this, "LEConfigView.dispatch").start();
    }

    public void run() {
        this.handleAction(this.m_action);
        this.m_action = null;
        this.unlock();
    }

    public void handleAction(String string) {
        if (string.equals(ACTION_SAVE)) {
            this.save();
            return;
        }
        if (string.equals(ACTION_REFRESH)) {
            this.refresh();
        }
    }

    public void setSelection(LEPortMaster[] lEPortMasterArray) {
        this.m_form.setPortMasters(lEPortMasterArray);
    }

    public Component getMainPanel() {
        return this.m_form;
    }

    public Component getBottomPanel() {
        return this.m_buttons;
    }

    public void going() {
        this.save();
        LEHelpManager.SetHelp("");
    }

    public void gone() {
        this.m_form.gone();
    }

    public void addListener(LEViewListener lEViewListener) {
        this.m_listener = lEViewListener;
    }

    public void deleteListener(LEViewListener lEViewListener) {
        if (this.m_listener == lEViewListener) {
            this.m_listener = null;
        }
    }
}

