/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.backend;

import COM.livingston.amf.LEAMManager;
import COM.livingston.backend.LEDSSPortMaster;
import COM.livingston.backend.LESendResponse;
import COM.livingston.util.LEAppInfo;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEObservable;
import COM.livingston.util.LETokenizer;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public class LEPMListen
extends LEObservable
implements Runnable {
    static FileWriter s_dbgFile;
    static PrintWriter s_pw;
    LESendResponse m_sbIn;
    DataInputStream m_inStream;
    String m_hostname;
    boolean m_running = false;
    Thread m_thread;

    public LEPMListen(DataInputStream dataInputStream, String string) {
        this.m_inStream = dataInputStream;
        this.m_hostname = string;
        if (s_dbgFile == null) {
            try {
                String string2 = LEAppInfo.getUserAppDirPath("dbgmsg.txt");
                File file = new File(string2);
                s_dbgFile = new FileWriter(file);
                s_pw = new PrintWriter((Writer)s_dbgFile, true);
                return;
            }
            catch (Exception exception) {
                s_dbgFile = null;
                s_pw = null;
                return;
            }
        }
    }

    public void run() {
        while (this.m_running) {
            this.readSocket();
        }
        this.m_inStream = null;
        this.m_thread = null;
    }

    void readSocket() {
        try {
            this.m_sbIn = new LESendResponse();
            this.m_sbIn.m_idByte = this.m_inStream.readByte();
            this.m_sbIn.m_opCode = this.m_inStream.readByte();
            this.m_sbIn.m_sendLength = this.m_inStream.readShort();
            this.m_sbIn.setSize(this.m_sbIn.m_sendLength);
            this.dumpLogV("Send Length: " + this.m_sbIn.m_sendLength);
            LEDSSPortMaster.dumpSRMsg("Listened: " + LEDSSPortMaster.GetOpCodeString(this.m_sbIn.m_opCode));
            LEPMListen.dumpSRMsg("Listened: " + LEDSSPortMaster.GetOpCodeString(this.m_sbIn.m_opCode));
            this.m_inStream.readFully(this.m_sbIn.m_data, 0, this.m_sbIn.m_sendLength);
            switch (this.m_sbIn.m_opCode) {
                case 9: {
                    this.setChanged();
                    LEDSSPortMaster.dumpSRMsg(this.m_sbIn.toString());
                    LEDSSPortMaster.dumpSRMsg("End Listen");
                    LEDSSPortMaster.dumpSRMsg("");
                    this.notifyObservers(this.m_sbIn);
                    return;
                }
                case 26: {
                    LEPMListen.dumpSRMsg(this.m_sbIn.toString());
                    LEPMListen.dumpSRMsg("End Listen");
                    LEPMListen.dumpSRMsg("");
                    LETokenizer lETokenizer = new LETokenizer(new ByteArrayInputStream(this.m_sbIn.m_data));
                    LEAMManager.Process(this.m_hostname, "MONITOR", lETokenizer);
                    return;
                }
                case 27: {
                    LEPMListen.dumpSRMsg(this.m_sbIn.toString());
                    LEPMListen.dumpSRMsg("End Listen");
                    LEPMListen.dumpSRMsg("");
                    LETokenizer lETokenizer = new LETokenizer(new ByteArrayInputStream(this.m_sbIn.m_data));
                    LEAMManager.Process(this.m_hostname, "DEBUG", lETokenizer);
                    return;
                }
                case 28: {
                    LEPMListen.dumpSRMsg(this.m_sbIn.toString());
                    LEPMListen.dumpSRMsg("End Listen");
                    LEPMListen.dumpSRMsg("");
                    LETokenizer lETokenizer = new LETokenizer(new ByteArrayInputStream(this.m_sbIn.m_data));
                    LEAMManager.Process(this.m_hostname, "DELTA", lETokenizer);
                    return;
                }
                case 30: {
                    LEPMListen.dumpSRMsg(this.m_sbIn.toString());
                    LEPMListen.dumpSRMsg("End Listen");
                    LEPMListen.dumpSRMsg("");
                    LETokenizer lETokenizer = new LETokenizer(new ByteArrayInputStream(this.m_sbIn.m_data));
                    LEAMManager.Process(this.m_hostname, "ALARM", lETokenizer);
                    return;
                }
                case 32: {
                    this.setChanged();
                    LEDSSPortMaster.dumpSRMsg(this.m_sbIn.toString());
                    LEDSSPortMaster.dumpSRMsg("End Listen");
                    LEDSSPortMaster.dumpSRMsg("");
                    this.notifyObservers(this.m_sbIn);
                    return;
                }
                case 34: {
                    this.setChanged();
                    LEDSSPortMaster.dumpSRMsg(this.m_sbIn.toString());
                    LEDSSPortMaster.dumpSRMsg("End Listen");
                    LEDSSPortMaster.dumpSRMsg("");
                    this.notifyObservers(this.m_sbIn);
                    return;
                }
                default: {
                    this.dumpLogV("Unexpected message: " + LEDSSPortMaster.GetOpCodeString(this.m_sbIn.m_opCode));
                    return;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 29: 
                case 33: {
                    return;
                }
            }
        }
        catch (EOFException eOFException) {
            if (!this.m_running) {
                return;
            }
            LEDebug.getLog().logln(20, eOFException);
            LEDebug.getLog().logln(20, "LEPMListen Socket Exception ");
            EOFException eOFException2 = new EOFException("LEPMListen Socket Exception " + eOFException.getMessage());
            this.shutdown();
            this.setChanged();
            this.notifyObservers(eOFException2);
            return;
        }
        catch (IOException iOException) {
            if (!this.m_running) {
                return;
            }
            LEDebug.getLog().logln(20, iOException);
            LEDebug.getLog().logln(20, "LEPMListen Socket Exception ");
            IOException iOException2 = new IOException("LEPMListen Socket Exception " + iOException.getMessage());
            this.shutdown();
            this.setChanged();
            this.notifyObservers(iOException2);
            return;
        }
        catch (Exception exception) {
            if (!this.m_running) {
                return;
            }
            LEDebug.getLog().logln(20, "***** LEPMListen problem");
            LEDebug.getLog().logln(20, this.m_sbIn.toString());
            LEDebug.getLog().logln(20, exception);
            this.shutdown();
            this.setChanged();
            this.notifyObservers(exception);
            return;
        }
    }

    public synchronized void start() {
        if (!this.m_running) {
            this.m_thread = new Thread(this);
            this.m_thread.setName("PM Listener for " + this.m_hostname);
            this.m_running = true;
            this.m_thread.start();
        }
    }

    public void shutdown() {
        this.m_running = false;
        try {
            this.m_inStream.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    protected final void dumpLogV(String string) {
        LEDebug.getLog().logln(40, string);
    }

    public static void dumpSRMsg(String string) {
        if (s_pw != null && LEDebug.getLog().shouldLog(30)) {
            try {
                s_pw.println(string);
                return;
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
                return;
            }
        }
    }
}

