/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.forms;

import COM.livingston.forms.LEAddDialog;
import COM.livingston.forms.LECmdErrorDialog;
import COM.livingston.forms.LEFormLine;
import COM.livingston.forms.LEFormLineFactory;
import COM.livingston.forms.LENewEntry;
import COM.livingston.forms.LETableForm;
import COM.livingston.model.LEDataSpec;
import COM.livingston.model.LEPortMaster;
import COM.livingston.model.LERoute;
import COM.livingston.model.LERoutes;
import COM.livingston.model.LETable;
import COM.livingston.ui.LECompGrid;
import COM.livingston.ui.LEErrorDialog;
import COM.livingston.ui.LEFont;
import COM.livingston.ui.LEUiUtils;
import COM.livingston.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;

public class LERoutesForm
extends LETableForm {
    String m_addDest;
    String m_addGateway;
    String m_addMetric;

    boolean addNewEntry(LEDataSpec lEDataSpec, LEDataSpec lEDataSpec2) {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        Component[][] componentArray = new Component[3][2];
        componentArray[0][0] = new Label(String.valueOf(lEDataSpec.getDescription()) + ":");
        componentArray[0][0].setFont(LEFont.getBoldFont());
        componentArray[0][1] = LEFormLineFactory.BuildFormLine(null, null, null, lEDataSpec);
        LEDataSpec lEDataSpec3 = lEDataSpec2.getSpecFor(LERoute.GATEWAY);
        componentArray[1][0] = new Label(String.valueOf(lEDataSpec3.getDescription()) + ":");
        componentArray[1][0].setFont(LEFont.getBoldFont());
        componentArray[1][1] = LEFormLineFactory.BuildFormLine(null, null, null, lEDataSpec3);
        lEDataSpec3 = lEDataSpec2.getSpecFor(LERoute.METRIC);
        componentArray[2][0] = new Label(String.valueOf(lEDataSpec3.getDescription()) + ":");
        componentArray[2][0].setFont(LEFont.getBoldFont());
        componentArray[2][1] = LEFormLineFactory.BuildFormLine(null, null, null, lEDataSpec3);
        panel.add("Center", new LECompGrid(componentArray, 2, false));
        LEAddDialog lEAddDialog = new LEAddDialog(LEUiUtils.GetBaseFrame(), "Add Route", panel);
        if (lEAddDialog.okay()) {
            this.m_addDest = ((LEFormLine)((Object)componentArray[0][1])).getValue();
            this.m_addGateway = ((LEFormLine)((Object)componentArray[1][1])).getValue();
            this.m_addMetric = ((LEFormLine)((Object)componentArray[2][1])).getValue();
            return true;
        }
        return false;
    }

    LENewEntry addNewEntryTo(LEPortMaster lEPortMaster) {
        LERoutes lERoutes = (LERoutes)this.getTable(lEPortMaster);
        if (lERoutes.get(this.m_addDest) == null) {
            LEVector lEVector = lERoutes.add(this.m_addDest, this.m_addGateway, this.m_addMetric);
            if (lEVector != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConfigFacility(), lEVector);
            }
            this.addEntry(lEPortMaster.getHostname(), lERoutes, this.m_addDest);
        } else {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), String.valueOf(lEPortMaster.getHostname()) + " already contains a route to " + this.m_addDest);
        }
        return null;
    }

    void delete(LEPortMaster lEPortMaster, LETable lETable, String string) {
        if (!(lETable instanceof LERoutes)) {
            return;
        }
        LERoute lERoute = (LERoute)lETable.get(string);
        String string2 = (String)lERoute.get(LERoute.SOURCE);
        String string3 = (String)lERoute.get(LERoute.STATUS);
        if (!string2.equals("local") || !string3.equals("static")) {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), "Route " + string + " on " + lEPortMaster.getHostname() + " cannot be deleted");
            return;
        }
        String string4 = (String)lERoute.get(LERoute.OBSOLETE);
        if (string4 != null && !string4.equals("0")) {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), "Route " + string + " on " + lEPortMaster.getHostname() + " has already been deleted");
            return;
        }
        LERoutes lERoutes = (LERoutes)lETable;
        LEVector lEVector = lERoutes.delete(string);
        if (lEVector != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConfigFacility(), lEVector);
        }
    }

    void pasteEntryTo(LEPortMaster lEPortMaster, Object object) {
        String string = this.getPasteKey(lEPortMaster, object);
        if (string == null) {
            return;
        }
        this.updateEntry(lEPortMaster.getHostname(), this.getTable(lEPortMaster), string);
    }

    String getPasteKey(LEPortMaster lEPortMaster, Object object) {
        String string;
        if (!(object instanceof LERoute)) {
            return null;
        }
        LERoute lERoute = (LERoute)object;
        LERoutes lERoutes = (LERoutes)this.getTable(lEPortMaster);
        if (lERoutes.get(string = lERoute.getName()) != null) {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), String.valueOf(lEPortMaster.getHostname()) + " already contains a route to " + string);
            string = null;
        } else {
            String string2 = (String)lERoute.get(LERoute.GATEWAY);
            String string3 = (String)lERoute.get(LERoute.METRIC);
            if (string2 == null || string3 == null) {
                return null;
            }
            LEVector lEVector = lERoutes.add(string, string2, string3);
            if (lEVector != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConfigFacility(), lEVector);
                string = null;
            }
        }
        return string;
    }
}

