/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.graph;

import COM.livingston.graph.LEGraphData;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.Vector;

public abstract class LEGraphCanvas
extends Canvas {
    Dimension m_dim = new Dimension(250, 150);
    int m_width;
    int m_height;
    int m_west;
    int m_south;
    int m_north;
    Image m_buf;
    boolean m_draw = false;
    int m_count;
    double m_max;
    Vector m_data = new Vector();
    String m_xLabel = "Time";
    String m_yLabel = "Data";

    public LEGraphCanvas() {
        this.setBackground(Color.lightGray);
    }

    public int getDataCount() {
        return this.m_data.size();
    }

    public LEGraphData getGraphData(int n) {
        if (n > -1 && n < this.m_data.size()) {
            return (LEGraphData)this.m_data.elementAt(n);
        }
        return null;
    }

    public void setMaxValue(double d) {
        this.m_max = d;
    }

    public void setXLabel(String string) {
        if (string == null) {
            this.m_xLabel = "";
            return;
        }
        this.m_xLabel = string;
    }

    public void setYLabel(String string) {
        if (string == null) {
            this.m_yLabel = "";
            return;
        }
        this.m_yLabel = string;
    }

    public void addGraphData(LEGraphData lEGraphData) {
        if (lEGraphData == null) {
            return;
        }
        lEGraphData.setCount(this.m_count);
        this.m_data.addElement(lEGraphData);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void redraw() {
        this.m_draw = true;
        this.repaint();
    }

    public void paint(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        if (this.m_buf == null) {
            this.createBuffer();
        }
        if (this.m_buf != null) {
            if (this.m_draw) {
                this.redrawGraph();
            }
            graphics.drawImage(this.m_buf, 0, 0, null);
        }
    }

    public Dimension getPreferredSize() {
        return this.m_dim;
    }

    public Dimension getMinimumSize() {
        return this.m_dim;
    }

    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        this.resize();
    }

    public void setSize(Dimension dimension) {
        super.setSize(dimension);
        this.resize();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.resize();
    }

    public void setBounds(Rectangle rectangle) {
        super.setBounds(rectangle);
        this.resize();
    }

    void createBuffer() {
        Dimension dimension = this.getSize();
        this.m_width = dimension.width;
        this.m_height = dimension.height;
        this.m_buf = this.createImage(this.m_width, this.m_height);
        this.m_draw = true;
    }

    void resize() {
        if (this.m_buf != null) {
            this.m_buf.flush();
        }
        this.m_buf = null;
        this.repaint();
    }

    void redrawGraph() {
        Graphics graphics = this.m_buf.getGraphics();
        if (graphics != null) {
            int n;
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.m_width, this.m_height);
            String string = Double.toString(this.m_max);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            this.m_west = fontMetrics.stringWidth(this.m_yLabel);
            this.m_west = Math.max(this.m_west, fontMetrics.stringWidth(string)) + 4;
            this.m_south = fontMetrics.getHeight() + 2;
            this.m_north = fontMetrics.getHeight() / 2 + 2;
            int n2 = this.m_width - this.m_west;
            if (n2 != this.m_count) {
                n = this.m_data.size();
                int n3 = 0;
                while (n3 < n) {
                    ((LEGraphData)this.m_data.elementAt(n3)).setCount(n2);
                    ++n3;
                }
                this.m_count = n2;
            }
            n = this.m_data.size();
            int n4 = 0;
            while (n4 < n) {
                LEGraphData lEGraphData = (LEGraphData)this.m_data.elementAt(n4);
                this.drawData(graphics, lEGraphData);
                ++n4;
            }
            graphics.setColor(this.getForeground());
            int n5 = this.m_height - this.m_south - this.m_north;
            graphics.drawLine(this.m_west, this.m_north, this.m_west, this.m_height - this.m_south);
            graphics.drawLine(this.m_west, this.m_height - this.m_south, this.m_width, this.m_height - this.m_south);
            int n6 = (n5 - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent() + this.m_north;
            graphics.drawString(this.m_yLabel, this.m_west - fontMetrics.stringWidth(this.m_yLabel) - 2, n6);
            int n7 = fontMetrics.stringWidth(this.m_xLabel);
            int n8 = this.m_west + (this.m_width - this.m_west - n7) / 2;
            graphics.drawString(this.m_xLabel, n8, this.m_height - 2 - fontMetrics.getDescent());
            graphics.drawString(string, this.m_west - fontMetrics.stringWidth(string) - 2, fontMetrics.getAscent() + 2);
            graphics.drawString("0.0", this.m_west - fontMetrics.stringWidth("0.0") - 2, this.m_height - this.m_south - fontMetrics.getHeight() / 2 + fontMetrics.getAscent());
            n6 = n5 / 2 + this.m_north;
            graphics.drawLine(this.m_west + 1, n6, this.m_width, n6);
            graphics.dispose();
            this.m_draw = false;
        }
    }

    abstract void drawData(Graphics var1, LEGraphData var2);
}

