/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.graph;

import COM.livingston.graph.LEGraphCanvas;
import COM.livingston.graph.LEGraphData;
import COM.livingston.ui.LEBorderPanel;
import COM.livingston.ui.LEColor;
import COM.livingston.ui.LECompGrid;
import COM.livingston.ui.LEFont;
import COM.livingston.ui.LETitleBar;
import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class LEGraphPanel
extends Panel
implements ItemListener {
    static Color[] s_colors = null;
    static String[] s_colorNames = null;
    LEGraphCanvas m_graph;
    LECompGrid m_grid;
    String[][] m_labels;
    String m_prop;

    public LEGraphPanel(LEGraphCanvas lEGraphCanvas, String[][] stringArray, String string) {
        this.m_labels = stringArray;
        this.m_prop = string;
        this.setLayout(new BorderLayout(5, 5));
        LEBorderPanel lEBorderPanel = new LEBorderPanel(0);
        lEBorderPanel.setLayout(new BorderLayout(0, 0));
        this.m_graph = lEGraphCanvas;
        lEBorderPanel.add("Center", this.m_graph);
        this.add("Center", lEBorderPanel);
        this.add("South", this.createLegend());
    }

    public void addNotify() {
        super.addNotify();
        if (this.m_prop != null) {
            Color color = LEColor.GetColorProperty(String.valueOf(this.m_prop) + "foreground");
            if (color != null) {
                this.m_graph.setForeground(color);
            }
            if ((color = LEColor.GetColorProperty(String.valueOf(this.m_prop) + "background")) != null) {
                this.m_graph.setBackground(color);
            }
            int n = this.m_graph.getDataCount();
            int n2 = 0;
            while (n2 < n) {
                LEGraphData lEGraphData = this.m_graph.getGraphData(n2);
                String string = lEGraphData.getLabel();
                color = LEColor.GetColorProperty(String.valueOf(this.m_prop) + string);
                if (color != null) {
                    lEGraphData.setColor(color);
                }
                ++n2;
            }
        }
        this.setupLegend();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Choice choice = (Choice)itemEvent.getSource();
        int n = 0;
        if (this.m_labels != null) {
            n = this.m_labels.length;
        }
        int n2 = this.m_grid.getRows();
        int n3 = -1;
        int n4 = n;
        while (n4 < n2) {
            if (this.m_grid.getComponent(n4, 1) == choice) {
                n3 = n4;
            }
            ++n4;
        }
        int n5 = choice.getSelectedIndex();
        switch (n3 -= n) {
            case 0: {
                this.m_graph.setBackground(s_colors[n5]);
                this.m_graph.redraw();
                if (this.m_prop == null) break;
                LEColor.SetColorProperty(String.valueOf(this.m_prop) + "background", s_colors[n5]);
                return;
            }
            case 1: {
                this.m_graph.setForeground(s_colors[n5]);
                this.m_graph.redraw();
                if (this.m_prop == null) break;
                LEColor.SetColorProperty(String.valueOf(this.m_prop) + "foreground", s_colors[n5]);
                return;
            }
            default: {
                LEGraphData lEGraphData = this.m_graph.getGraphData(n3 - 2);
                if (lEGraphData == null) break;
                lEGraphData.setColor(s_colors[n5]);
                this.m_graph.redraw();
                if (this.m_prop == null) break;
                LEColor.SetColorProperty(String.valueOf(this.m_prop) + lEGraphData.getLabel(), s_colors[n5]);
            }
            case -1: 
        }
    }

    public void setupLegend() {
        int n = 0;
        if (this.m_labels != null) {
            n = this.m_labels.length;
        }
        int n2 = this.m_grid.getRows();
        int n3 = n;
        while (n3 < n2) {
            Choice choice = (Choice)this.m_grid.getComponent(n3, 1);
            switch (n3 - n) {
                case 0: {
                    this.selectColor(choice, this.m_graph.getBackground());
                    break;
                }
                case 1: {
                    this.selectColor(choice, this.m_graph.getForeground());
                    break;
                }
                default: {
                    LEGraphData lEGraphData = this.m_graph.getGraphData(n3 - n - 2);
                    if (lEGraphData == null) break;
                    this.selectColor(choice, lEGraphData.getColor());
                    break;
                }
            }
            ++n3;
        }
        Font font = LEFont.getBoldFont();
        int n4 = 0;
        while (n4 < n2) {
            ((Label)this.m_grid.getComponent(n4, 0)).setFont(font);
            ++n4;
        }
    }

    Component createLegend() {
        LEBorderPanel lEBorderPanel = new LEBorderPanel(0);
        lEBorderPanel.setLayout(new BorderLayout(0, 0));
        int n = this.m_graph.getDataCount();
        int n2 = n + 2;
        if (this.m_labels != null) {
            n2 += this.m_labels.length;
        }
        Component[][] componentArray = new Component[n2][2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.m_labels.length) {
            componentArray[n3][0] = this.m_labels[n4][0] == null ? new Label("") : new Label(String.valueOf(this.m_labels[n4][0]) + ":");
            componentArray[n3][1] = this.m_labels[n4][1] == null ? new Label("") : new Label(this.m_labels[n4][1]);
            ++n3;
            ++n4;
        }
        componentArray[n3][0] = new Label("Background:");
        componentArray[n3++][1] = this.getColors();
        componentArray[n3][0] = new Label("Foreground:");
        componentArray[n3++][1] = this.getColors();
        int n5 = 0;
        while (n5 < n) {
            LEGraphData lEGraphData = this.m_graph.getGraphData(n5);
            componentArray[n3][0] = new Label(String.valueOf(lEGraphData.getLabel()) + ":");
            componentArray[n3++][1] = this.getColors();
            ++n5;
        }
        this.m_grid = new LECompGrid(componentArray, 0, false);
        lEBorderPanel.add("Center", this.m_grid);
        lEBorderPanel.add("North", new LETitleBar());
        return lEBorderPanel;
    }

    Choice getColors() {
        if (s_colors == null) {
            s_colors = new Color[13];
            int n = 0;
            LEGraphPanel.s_colors[n++] = Color.black;
            LEGraphPanel.s_colors[n++] = Color.blue;
            LEGraphPanel.s_colors[n++] = Color.cyan;
            LEGraphPanel.s_colors[n++] = Color.darkGray;
            LEGraphPanel.s_colors[n++] = Color.gray;
            LEGraphPanel.s_colors[n++] = Color.green;
            LEGraphPanel.s_colors[n++] = Color.lightGray;
            LEGraphPanel.s_colors[n++] = Color.magenta;
            LEGraphPanel.s_colors[n++] = Color.orange;
            LEGraphPanel.s_colors[n++] = Color.pink;
            LEGraphPanel.s_colors[n++] = Color.red;
            LEGraphPanel.s_colors[n++] = Color.white;
            LEGraphPanel.s_colors[n++] = Color.yellow;
            s_colorNames = new String[13];
            n = 0;
            LEGraphPanel.s_colorNames[n++] = "Black";
            LEGraphPanel.s_colorNames[n++] = "Blue";
            LEGraphPanel.s_colorNames[n++] = "Cyan";
            LEGraphPanel.s_colorNames[n++] = "Dark Gray";
            LEGraphPanel.s_colorNames[n++] = "Gray";
            LEGraphPanel.s_colorNames[n++] = "Green";
            LEGraphPanel.s_colorNames[n++] = "Light Gray";
            LEGraphPanel.s_colorNames[n++] = "Magenta";
            LEGraphPanel.s_colorNames[n++] = "Orange";
            LEGraphPanel.s_colorNames[n++] = "Pink";
            LEGraphPanel.s_colorNames[n++] = "Red";
            LEGraphPanel.s_colorNames[n++] = "White";
            LEGraphPanel.s_colorNames[n++] = "Yellow";
        }
        Choice choice = new Choice();
        int n = 0;
        while (n < s_colorNames.length) {
            choice.add(s_colorNames[n]);
            ++n;
        }
        choice.addItemListener(this);
        return choice;
    }

    void selectColor(Choice choice, Color color) {
        int n = 0;
        while (n < s_colors.length) {
            if (color.equals(s_colors[n])) {
                choice.select(n);
            }
            ++n;
        }
    }
}

