/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.model.LEConfig;
import COM.livingston.model.LEConfigFacility;
import COM.livingston.util.LEVector;

public class LEBGP
extends LEConfig {
    public static final String ADDRESS = "9";
    public static final String ASN_ID = "106";
    public static final String CLUSTER_ID = "110";
    public static final String CONFED = "111";
    public static final String CONNECT = "107";
    public static final String KEEP_ALIVE = "108";
    public static final String HOLD = "109";
    public static final String IGP_LOCKSTEP = "112";
    public static final int KEY_COUNT = 8;
    static String[] s_keys = null;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[8];
            int i = 0;
            LEBGP.s_keys[i++] = ADDRESS;
            LEBGP.s_keys[i++] = ASN_ID;
            LEBGP.s_keys[i++] = CLUSTER_ID;
            LEBGP.s_keys[i++] = CONFED;
            LEBGP.s_keys[i++] = CONNECT;
            LEBGP.s_keys[i++] = KEEP_ALIVE;
            LEBGP.s_keys[i++] = HOLD;
            LEBGP.s_keys[i++] = IGP_LOCKSTEP;
        }
        return s_keys;
    }

    public LEBGP(LEConfigFacility facility) {
        super(facility);
    }

    public Object clone() {
        LEBGP config = new LEBGP(this.m_facility);
        config.copy(this);
        return config;
    }

    boolean generateCommands(LEVector keys, LEVector cmds) {
        boolean allCmds = keys == null;
        int start = cmds.size();
        if (allCmds || keys.contains(ADDRESS)) {
            this.makeSetCommand(cmds, "bgp", ADDRESS, "id");
        }
        if (allCmds || keys.contains(ASN_ID)) {
            this.makeSetCommand(cmds, "bgp", ASN_ID, "as");
        }
        if (allCmds || keys.contains(CLUSTER_ID)) {
            this.makeSetCommand(cmds, "bgp", CLUSTER_ID, "cluster-id");
        }
        if (allCmds || keys.contains(CONFED)) {
            this.makeSetCommand(cmds, "bgp", CONFED, "cma");
        }
        if (allCmds || keys.contains(CONNECT)) {
            this.makeSetCommand(cmds, "bgp", CONNECT, "connect-retry-interval");
        }
        if (allCmds || keys.contains(KEEP_ALIVE)) {
            this.makeSetCommand(cmds, "bgp", KEEP_ALIVE, "keepalive-timer");
        }
        if (allCmds || keys.contains(HOLD)) {
            this.makeSetCommand(cmds, "bgp", HOLD, "hold-time");
        }
        if (allCmds || keys.contains(IGP_LOCKSTEP)) {
            this.makeSetCommand(cmds, "bgp", IGP_LOCKSTEP, "igp-lockstep");
        }
        return cmds.size() > start;
    }
}

