/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.model.LEConfig;
import COM.livingston.model.LEConfigFacility;
import COM.livingston.util.LEVector;

public class LEBGPPeer
extends LEConfig {
    public static final String ACCEPT_POLICY = "121";
    public static final String ADVERTISE_POLICY = "123";
    public static final String ASN_ID = "106";
    public static final String ASSUME_DEFAULT = "119";
    public static final String EASY_MULTIHOME = "118";
    public static final String HOP_COUNT = "113";
    public static final String INJECT_POLICY = "122";
    public static final String LOCAL_ADDRESS = "177";
    public static final String STATE = "96";
    public static final String CONFIG_CONFED = "114";
    public static final String CONFIG_REFLECT = "115";
    public static final String CONFIG_HOP = "116";
    public static final int KEY_COUNT = 12;
    public static final String ALL_POLICY = "all";
    String m_local_addr;
    String m_dest_addr;
    static String[] s_keys = null;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[12];
            int i = 0;
            LEBGPPeer.s_keys[i++] = ACCEPT_POLICY;
            LEBGPPeer.s_keys[i++] = ADVERTISE_POLICY;
            LEBGPPeer.s_keys[i++] = ASN_ID;
            LEBGPPeer.s_keys[i++] = ASSUME_DEFAULT;
            LEBGPPeer.s_keys[i++] = EASY_MULTIHOME;
            LEBGPPeer.s_keys[i++] = HOP_COUNT;
            LEBGPPeer.s_keys[i++] = INJECT_POLICY;
            LEBGPPeer.s_keys[i++] = LOCAL_ADDRESS;
            LEBGPPeer.s_keys[i++] = STATE;
            LEBGPPeer.s_keys[i++] = CONFIG_CONFED;
            LEBGPPeer.s_keys[i++] = CONFIG_REFLECT;
            LEBGPPeer.s_keys[i++] = CONFIG_HOP;
        }
        return s_keys;
    }

    public LEBGPPeer(LEConfigFacility facility, String addr) {
        super(facility);
        this.m_dest_addr = addr;
    }

    public Object clone() {
        LEBGPPeer config = new LEBGPPeer(this.m_facility, this.m_dest_addr);
        config.copy(this);
        return config;
    }

    public String getName() {
        return this.m_dest_addr;
    }

    boolean generateCommands(LEVector keys, LEVector cmds) {
        String next_hop;
        StringBuffer buf = new StringBuffer(100);
        buf.append("set ");
        buf.append("bgp peer ");
        buf.append((String)this.get(LOCAL_ADDRESS));
        buf.append(" ");
        buf.append(this.m_dest_addr);
        buf.append(" ");
        buf.append((String)this.get(ASN_ID));
        buf.append(" ");
        String assume = (String)this.get(ASSUME_DEFAULT);
        String easy_multihome = (String)this.get(EASY_MULTIHOME);
        if (easy_multihome.equals("on")) {
            buf.append("easy-multihome ");
        }
        if (assume.equals("on")) {
            buf.append("assume-default ");
            buf.append((String)this.get(HOP_COUNT));
            buf.append(" ");
        }
        String confed = (String)this.get(CONFIG_CONFED);
        String reflect = (String)this.get(CONFIG_REFLECT);
        if (confed.equals("on")) {
            buf.append("confederation-member ");
        }
        if (reflect.equals("on")) {
            buf.append("route-reflector-client ");
        }
        if ((next_hop = (String)this.get(CONFIG_HOP)).equals("on")) {
            buf.append("always-next-hop ");
        }
        if (easy_multihome.equals("off")) {
            if (!((String)this.get(ACCEPT_POLICY)).equals("")) {
                buf.append("accept-policy ");
                buf.append((String)this.get(ACCEPT_POLICY));
                buf.append(" ");
            }
            if (!((String)this.get(INJECT_POLICY)).equals("")) {
                buf.append("inject-policy ");
                buf.append((String)this.get(INJECT_POLICY));
                buf.append(" ");
            }
            if (!((String)this.get(ADVERTISE_POLICY)).equals("")) {
                buf.append("advertise-policy ");
                buf.append((String)this.get(ADVERTISE_POLICY));
            }
        }
        cmds.addElement(new String(buf));
        return true;
    }
}

