/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.backend.LEPMCommand;
import COM.livingston.model.LEBGPPeer;
import COM.livingston.model.LEConfig;
import COM.livingston.model.LEConfigFacility;
import COM.livingston.model.LETable;
import COM.livingston.util.LEVector;

public class LEBGPPeers
extends LETable {
    public LEBGPPeers(LEConfigFacility facility) {
        super(facility);
    }

    public Object clone() {
        LEBGPPeers config = new LEBGPPeers(this.m_facility);
        config.copy(this);
        return config;
    }

    public LEVector add(String name, String local, String asn) {
        LEVector errors = null;
        StringBuffer cmdbuf = new StringBuffer(30);
        cmdbuf.append("add ");
        cmdbuf.append("bgp peer ");
        cmdbuf.append(local);
        cmdbuf.append(" ");
        cmdbuf.append(name);
        cmdbuf.append(" ");
        cmdbuf.append(asn);
        LEPMCommand ret = this.m_facility.execute(cmdbuf.toString());
        if (ret.getStatus()) {
            ret = this.m_facility.execute("save all");
            this.refresh();
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    public LEVector delete(String name) {
        LEVector errors = null;
        String cmd = this.makeDeleteCommand("bgp peer", name);
        LEPMCommand ret = this.m_facility.execute(cmd);
        if (ret.getStatus()) {
            this.remove(name);
            ret = this.m_facility.execute("save all");
            if (!ret.getStatus()) {
                this.refresh();
            }
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    LEConfig createConfig(String key) {
        return new LEBGPPeer(this.m_facility, key);
    }
}

