/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.backend.LEPMCommand;
import COM.livingston.model.LEBGPPolicy;
import COM.livingston.model.LEConfig;
import COM.livingston.model.LEConfigFacility;
import COM.livingston.model.LETable;
import COM.livingston.util.LEVector;

public class LEBGPPolicies
extends LETable {
    public LEBGPPolicies(LEConfigFacility facility) {
        super(facility);
    }

    public Object clone() {
        LEBGPPolicies config = new LEBGPPolicies(this.m_facility);
        config.copy(this);
        return config;
    }

    public LEVector add(String name) {
        LEVector errors = null;
        String cmd = this.makeAddCommand("bgp policy", name);
        LEPMCommand ret = this.m_facility.execute(cmd);
        if (ret.getStatus()) {
            ret = this.m_facility.execute("save all");
            if (ret.getStatus()) {
                LEBGPPolicy policy = (LEBGPPolicy)this.getConfig(name);
            } else {
                this.refresh();
            }
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    public LEVector delete(String name) {
        LEVector errors = null;
        String cmd = this.makeDeleteCommand("bgp policy", name);
        LEPMCommand ret = this.m_facility.execute(cmd);
        if (ret.getStatus()) {
            this.remove(name);
            ret = this.m_facility.execute("save all");
            if (!ret.getStatus()) {
                this.refresh();
            }
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    boolean generateAddCommand(String key, LEVector cmds) {
        cmds.addElement(this.makeAddCommand("bgp policy", key));
        return true;
    }

    boolean generateDeleteCommand(String key, LEVector cmds) {
        cmds.addElement(this.makeDeleteCommand("bgp policy", key));
        return true;
    }

    LEConfig createConfig(String key) {
        return new LEBGPPolicy(this.m_facility, key);
    }
}

