/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.backend.LEPMCommand;
import COM.livingston.model.LEConfigFacility;
import COM.livingston.model.LEDataSpec;
import COM.livingston.util.LEAlphaNumericCompare;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEObservable;
import COM.livingston.util.LEStatusManager;
import COM.livingston.util.LEVector;
import java.util.Enumeration;
import java.util.Hashtable;

public class LEConfig
extends LEObservable
implements Cloneable {
    public static final String BLANK = "";
    public static final String DISABLE = "disable";
    public static final String ENABLE = "enable";
    public static final String FALSE = "false";
    public static final String OFF = "off";
    public static final String ON = "on";
    public static final String SPACE = " ";
    public static final String TRUE = "true";
    public static final String ADD = "add ";
    public static final String DELETE = "delete ";
    public static final String REBOOT = "reboot";
    public static final String SAVE_ALL = "save all";
    public static final String SET = "set ";
    public static final String SET_VIEW = "set view ";
    public static final String VERSION = "version";
    LEConfigFacility m_facility;
    String m_board;
    Hashtable m_fields = new Hashtable();
    LEDataSpec m_spec;
    LEConfig m_owner;
    String m_fetchKey;
    boolean m_fetched;
    LEVector m_changed;
    LEVector m_added;
    LEVector m_deleted;

    public LEConfig(LEConfigFacility facility, String board, String key) {
        this.m_facility = facility;
        this.m_board = board;
        this.m_fetchKey = key;
    }

    public LEConfig(LEConfigFacility facility, String board) {
        this(facility, board, null);
        this.m_fetched = true;
    }

    public LEConfig(LEConfigFacility facility) {
        this(facility, null, null);
        this.m_fetched = true;
    }

    public Object clone() {
        LEConfig config = new LEConfig(this.m_facility);
        config.copy(this);
        return config;
    }

    public void copy(LEConfig config) {
        Object obj;
        String key;
        LEVector oldKeys = this.getKeys();
        LEVector keys = config.getKeys();
        int len = keys.size();
        int i = 0;
        while (i < len) {
            key = (String)keys.elementAt(i);
            obj = config.get(key);
            if (obj instanceof LEConfig) {
                LEConfig newConfig = (LEConfig)this.get(key);
                if (newConfig == null) {
                    newConfig = this.getConfig(key);
                    if (this.m_added == null) {
                        this.m_added = new LEVector();
                    }
                    this.m_added.addUnique(key);
                }
                newConfig.copy((LEConfig)obj);
            } else {
                Object old_obj = this.get(key);
                if (old_obj == null || !old_obj.equals(obj)) {
                    this.set(key, obj);
                }
            }
            ++i;
        }
        len = oldKeys.size();
        int i2 = 0;
        while (i2 < len) {
            key = (String)oldKeys.elementAt(i2);
            if (!keys.contains(key) && (obj = this.get(key)) instanceof LEConfig) {
                if (this.m_deleted == null) {
                    this.m_deleted = new LEVector();
                }
                this.m_deleted.addUnique(key);
                this.remove(key);
            }
            ++i2;
        }
    }

    public LEVector getKeys() {
        return this.getKeys(true);
    }

    public LEVector getKeys(boolean fetch) {
        if (fetch && !this.m_fetched) {
            this.fetch();
        }
        LEVector keys = new LEVector();
        Enumeration enumeration = this.m_fields.keys();
        while (enumeration.hasMoreElements()) {
            keys.addElement((String)enumeration.nextElement());
        }
        keys.quickSort(new LEAlphaNumericCompare());
        return keys;
    }

    public LEConfigFacility getConfigFacility() {
        return this.m_facility;
    }

    public LEConfig getOwner() {
        return this.m_owner;
    }

    public boolean requiresReboot(String key) {
        return false;
    }

    public boolean requiresPowerCycle(String key) {
        return false;
    }

    public boolean hasChanges() {
        if (this.m_added != null || this.m_deleted != null || this.m_changed != null) {
            return true;
        }
        boolean changes = false;
        LEVector keys = this.getKeys();
        int len = keys.size();
        int i = 0;
        while (!changes && i < len) {
            String key = (String)keys.elementAt(i);
            Object obj = this.get(key);
            if (obj instanceof LEConfig) {
                changes = ((LEConfig)obj).hasChanges();
            }
            ++i;
        }
        return changes;
    }

    public void clearChangeVectors() {
        if (this.m_added != null) {
            this.m_added.removeAllElements();
            this.m_added = null;
        }
        if (this.m_changed != null) {
            this.m_changed.removeAllElements();
            this.m_changed = null;
        }
        if (this.m_deleted != null) {
            this.m_deleted.removeAllElements();
            this.m_deleted = null;
        }
        LEVector keys = this.getKeys();
        int len = keys.size();
        int i = 0;
        while (i < len) {
            String key = (String)keys.elementAt(i);
            Object obj = this.get(key);
            if (obj instanceof LEConfig) {
                ((LEConfig)obj).clearChangeVectors();
            }
            ++i;
        }
    }

    public Object get(String key) {
        if (!this.m_fetched) {
            this.fetch();
        }
        return this.m_fields.get(key);
    }

    public boolean getChanges(LEVector cmds) {
        boolean gen = this.getChangedCommands(cmds);
        if (gen) {
            cmds.addElement(SAVE_ALL);
        }
        return gen;
    }

    public boolean getCommands(LEVector cmds) {
        boolean gen = this.getAllCommands(cmds);
        if (gen) {
            cmds.addElement(SAVE_ALL);
        }
        return gen;
    }

    public void set(String key, Object value) {
        if (value instanceof LEConfig) {
            if (this.m_added == null) {
                this.m_added = new LEVector();
            }
            this.m_added.addUnique(key);
            ((LEConfig)value).setConfigFacility(this.m_facility);
        } else {
            if (this.m_changed == null) {
                this.m_changed = new LEVector();
            }
            this.m_changed.addUnique(key);
        }
        this.m_fields.put(key, value);
        if (value instanceof LEConfig) {
            ((LEConfig)value).setOwner(this);
        }
        this.setChanged();
        this.notifyObservers(key);
    }

    public void setConfigFacility(LEConfigFacility facility) {
        this.m_facility = facility;
        LEVector keys = this.getKeys();
        int len = keys.size();
        int i = 0;
        while (i < len) {
            String key = (String)keys.elementAt(i);
            Object obj = this.get(key);
            if (obj instanceof LEConfig) {
                ((LEConfig)obj).setConfigFacility(facility);
            }
            ++i;
        }
    }

    public void setOwner(LEConfig owner) {
        this.m_owner = owner;
    }

    public void refresh() {
        this.refresh(this);
    }

    public LEVector saveChanges() {
        return this.saveChanges(true);
    }

    public LEVector saveChanges(boolean reboot) {
        LEVector errors = null;
        LEVector cmds = new LEVector();
        boolean poweredDown = false;
        boolean powerOff = false;
        boolean powerOn = false;
        if (this.getChanges(cmds)) {
            int len = cmds.size();
            int i = 0;
            while (i < len) {
                String cmd = (String)cmds.elementAt(i);
                powerOn = LEPMCommand.IsPowerOn(cmd);
                powerOff = LEPMCommand.IsPowerOff(cmd);
                if (reboot || !LEPMCommand.IsReboot(cmd) && !powerOff && !powerOn) {
                    if (powerOff) {
                        poweredDown = true;
                    } else if (powerOn && poweredDown) {
                        try {
                            Thread.currentThread();
                            Thread.sleep(1000L);
                            poweredDown = false;
                        }
                        catch (Exception e) {
                            LEDebug.getLog().logln(20, e);
                        }
                    }
                    LEPMCommand ret = this.m_facility.execute(cmd);
                    if (!ret.getStatus()) {
                        if (errors == null) {
                            errors = new LEVector();
                        }
                        errors.addElement(ret);
                    }
                }
                ++i;
            }
        }
        return errors;
    }

    public void setSpec(LEDataSpec spec) {
        this.m_spec = spec;
    }

    public String getDescription() {
        String des = BLANK;
        if (this.m_spec != null) {
            des = this.m_spec.getDescription();
        }
        return des;
    }

    public LEDataSpec getSpec() {
        return this.m_spec;
    }

    public LEDataSpec getSpecFor(String key) {
        LEDataSpec spec = null;
        if (this.m_spec != null) {
            spec = this.m_spec.getSpecFor(key);
        }
        return spec;
    }

    public String getDescriptionFor(String key) {
        String des = BLANK;
        LEDataSpec spec = this.getSpecFor(key);
        if (spec != null) {
            des = spec.getDescription();
        }
        return des;
    }

    public String getTypeFor(String key) {
        String type = BLANK;
        LEDataSpec spec = this.getSpecFor(key);
        if (spec != null) {
            type = spec.getDescription();
        }
        return type;
    }

    public Object getAttributeFor(String key, String attrName) {
        Object attr = null;
        LEDataSpec spec = this.getSpecFor(key);
        if (spec != null) {
            attr = spec.getAttribute(attrName);
        }
        return attr;
    }

    public boolean hasDependencies(String key) {
        boolean dep = false;
        LEDataSpec spec = this.getSpecFor(key);
        if (spec != null) {
            dep = spec.hasDependencies();
        }
        return dep;
    }

    void markChanged() {
        if (this.m_changed == null) {
            this.m_changed = new LEVector();
        }
    }

    void refresh(LEConfig config) {
        if (this.m_fetchKey != null) {
            this.m_fetched = false;
            this.fetch();
        } else if (this.m_owner != null) {
            this.m_owner.refresh(this);
        }
    }

    void fetch() {
        if (this.m_fetched) {
            return;
        }
        StringBuffer buf = new StringBuffer("Getting ");
        buf.append(this.getDescription());
        if (this.m_board != null) {
            buf.append(" for board ");
            buf.append(this.m_board);
        }
        buf.append(" from ");
        buf.append(this.m_facility.getDescription());
        LEStatusManager.SetStatus(buf.toString());
        this.m_fetched = true;
        this.m_fetched = this.m_board != null ? this.m_facility.getConfig(this.m_fetchKey, this.m_board) : this.m_facility.getConfig(this.m_fetchKey);
    }

    Object remove(String key) {
        Object obj = this.m_fields.remove(key);
        this.setChanged();
        this.notifyObservers(key);
        return obj;
    }

    boolean getChangedCommands(LEVector cmds) {
        LEVector children;
        if (cmds == null) {
            return false;
        }
        boolean gen = false;
        if (this.m_changed != null || this.m_added != null || this.m_deleted != null) {
            gen = this.makeViewCommand(cmds);
            if (this.m_changed != null) {
                gen = this.generateCommands(this.m_changed, cmds);
                this.m_changed.removeAllElements();
                this.m_changed = null;
            }
            if (this.m_deleted != null) {
                gen |= this.getDeleteCommands(cmds);
            }
        }
        if ((children = this.getChildren(false)) != null) {
            int len = children.size();
            int i = 0;
            while (i < len) {
                String key = (String)children.elementAt(i);
                if (this.m_added != null && this.m_added.contains(key)) {
                    gen |= this.generateAddCommand(key, cmds);
                }
                LEConfig child = (LEConfig)this.get(key);
                gen |= child.getChangedCommands(cmds);
                ++i;
            }
            if (this.m_added != null) {
                this.m_added.removeAllElements();
                this.m_added = null;
            }
        }
        return gen;
    }

    boolean getDeleteCommands(LEVector cmds) {
        boolean gen = false;
        int len = this.m_deleted.size();
        int i = 0;
        while (i < len) {
            String key = (String)this.m_deleted.elementAt(i);
            gen |= this.generateDeleteCommand(key, cmds);
            ++i;
        }
        this.m_deleted.removeAllElements();
        this.m_deleted = null;
        return gen;
    }

    boolean getAllCommands(LEVector cmds) {
        if (cmds == null) {
            return false;
        }
        boolean gen = this.makeViewCommand(cmds);
        gen |= this.generateCommands(null, cmds);
        LEVector children = this.getChildren(true);
        if (children != null) {
            int len = children.size();
            int i = 0;
            while (i < len) {
                String key = (String)children.elementAt(i);
                gen |= this.generateAddCommand(key, cmds);
                LEConfig child = (LEConfig)this.get(key);
                gen |= child.getAllCommands(cmds);
                ++i;
            }
        }
        return gen;
    }

    LEVector getChildren(boolean fetch) {
        LEVector children = null;
        LEVector keys = this.getKeys(fetch);
        int len = keys.size();
        int i = 0;
        while (i < len) {
            String key = (String)keys.elementAt(i);
            Object obj = this.get(key);
            if (obj instanceof LEConfig) {
                if (children == null) {
                    children = new LEVector();
                }
                children.addElement(key);
            }
            ++i;
        }
        return children;
    }

    boolean generateCommands(LEVector keys, LEVector cmds) {
        return false;
    }

    boolean generateDeleteCommand(String key, LEVector cmds) {
        return false;
    }

    boolean generateAddCommand(String key, LEVector cmds) {
        return false;
    }

    void setField(String key, Object value) {
        if (this.m_changed != null && this.m_changed.contains(key)) {
            return;
        }
        this.m_fields.put(key, value);
        this.setChanged();
        this.notifyObservers(key);
    }

    LEConfig getConfig(String key) {
        Object obj = this.m_fields.get(key);
        if (obj instanceof LEConfig) {
            return (LEConfig)obj;
        }
        LEConfig config = this.createConfig(key);
        config.setSpec(this.getSpecFor(key));
        config.setOwner(this);
        this.setField(key, config);
        return config;
    }

    LEConfig createConfig(String key) {
        return new LEConfig(this.m_facility);
    }

    boolean makeAddCommand(LEVector cmds, String name, String key, String tag) {
        return this.makeCommand(ADD, cmds, name, key, tag);
    }

    boolean makeDeleteCommand(LEVector cmds, String name, String key, String tag) {
        return this.makeCommand(DELETE, cmds, name, key, tag);
    }

    boolean makeSetCommand(LEVector cmds, String name, String key, String tag) {
        return this.makeCommand(SET, cmds, name, key, tag);
    }

    boolean makeCommand(String cmd, LEVector cmds, String name, String key, String tag) {
        boolean gen = false;
        Object value = this.get(key);
        if (value instanceof String) {
            StringBuffer buf = new StringBuffer(cmd);
            if (name != null) {
                buf.append(name);
                buf.append(SPACE);
            }
            if (tag != null) {
                buf.append(tag);
                buf.append(SPACE);
            }
            buf.append((String)value);
            cmds.addElement(new String(buf));
            gen = true;
        }
        return gen;
    }

    boolean makeRIPCommand(LEVector cmds, String name, String tag, String broadcast, String listen) {
        boolean broad = false;
        boolean list = false;
        if (broadcast != null && broadcast.equals(ON)) {
            broad = true;
        }
        if (listen != null && listen.equals(ON)) {
            list = true;
        }
        StringBuffer buf = new StringBuffer(SET);
        if (name != null) {
            buf.append(name);
            buf.append(SPACE);
        }
        buf.append(tag);
        buf.append(SPACE);
        if (broad && list) {
            buf.append(ON);
        } else if (broad) {
            buf.append("broadcast");
        } else if (list) {
            buf.append("listen");
        } else {
            buf.append(OFF);
        }
        cmds.addElement(new String(buf));
        return true;
    }

    boolean makeServiceCommand(LEVector cmds, String name, String key, String tag) {
        if (key == null) {
            return false;
        }
        String svc = (String)this.get(key);
        if (svc == null) {
            return false;
        }
        StringBuffer buf = new StringBuffer(SET);
        if (name != null) {
            buf.append(name);
            buf.append(SPACE);
        }
        if (tag != null) {
            buf.append(tag);
            buf.append(SPACE);
        }
        buf.append(svc.replace('@', ' '));
        cmds.addElement(new String(buf));
        return true;
    }

    boolean makeNATTimeOutCommand(LEVector cmds, String prefix, String attribute, String key) {
        String val = (String)this.get(key);
        if (val == null || val.length() == 0) {
            return false;
        }
        StringBuffer buf = new StringBuffer(SET);
        buf.append(prefix);
        buf.append(" nat sto ");
        if (attribute.equals("353")) {
            buf.append("tcp ");
        } else if (attribute.equals("354")) {
            buf.append("other ");
        } else {
            return false;
        }
        buf.append(val);
        cmds.addElement(new String(buf));
        return true;
    }

    boolean makeNATFailActionCommand(LEVector cmds, String prefix, String key) {
        String val = (String)this.get(key);
        if (val == null || val.length() == 0) {
            return false;
        }
        StringBuffer buf = new StringBuffer(SET);
        buf.append(prefix);
        buf.append(" nat sdfa ");
        buf.append(val);
        cmds.addElement(new String(buf));
        return true;
    }

    boolean makeNATLogCommand(LEVector cmds, String prefix, String attribute, String key) {
        String val = (String)this.get(key);
        if (val == null || val.length() == 0) {
            return false;
        }
        StringBuffer buf = new StringBuffer(SET);
        buf.append(prefix);
        buf.append(" nat log ");
        if (attribute.equals("360")) {
            buf.append("sessionfail ");
        } else if (attribute.equals("361")) {
            buf.append("sessionsuccess ");
        } else if (attribute.equals("362")) {
            buf.append("syslog ");
        } else if (attribute.equals("363")) {
            buf.append("console ");
        } else {
            return false;
        }
        buf.append(val);
        cmds.addElement(new String(buf));
        return true;
    }

    boolean makeNATMapCommand(LEVector cmds, String prefix, String key, boolean inmap, boolean proxy) {
        String val = (String)this.get(key);
        if (val == null) {
            return false;
        }
        StringBuffer buf = new StringBuffer(SET);
        buf.append(prefix);
        if (inmap) {
            buf.append(" nat inmap ");
        } else {
            buf.append(" nat outmap ");
        }
        buf.append(val);
        if (proxy) {
            buf.append(" proxy");
        }
        cmds.addElement(new String(buf));
        return true;
    }

    boolean makeViewCommand(LEVector cmds) {
        String cmd = this.getViewCommand();
        if (cmd != null) {
            cmds.addElement(cmd);
            return true;
        }
        return false;
    }

    boolean makePowerCycleCommands(LEVector cmds) {
        if (this.m_board == null) {
            return false;
        }
        StringBuffer buf = new StringBuffer(20);
        buf.append(SET_VIEW);
        buf.append('4');
        cmds.addElement(buf.toString());
        buf.setLength(0);
        buf.append(SET);
        buf.append("slot");
        buf.append(this.m_board);
        buf.append(SPACE);
        buf.append(OFF);
        cmds.addElement(buf.toString());
        buf.setLength(0);
        buf.append(SET);
        buf.append("slot");
        buf.append(this.m_board);
        buf.append(SPACE);
        buf.append(ON);
        cmds.addElement(buf.toString());
        return true;
    }

    LEPMCommand setView() {
        String cmd = this.getViewCommand();
        if (cmd != null) {
            return this.m_facility.execute(cmd);
        }
        return null;
    }

    String getViewCommand() {
        String cmd = null;
        if (this.m_board != null) {
            StringBuffer buf = new StringBuffer(11);
            buf.append(SET_VIEW);
            buf.append(this.m_board);
            cmd = buf.toString();
        }
        return cmd;
    }

    void updateSaveStatus(String command, int total, int count) {
        int percent = 0;
        if (total > 0) {
            percent = count / total * 100;
        }
    }

    String getKeyFor(LEConfig config) {
        String key = null;
        LEVector keys = this.getKeys();
        int len = keys.size();
        int i = 0;
        while (key == null && i < len) {
            key = (String)keys.elementAt(i);
            if (config != this.get(key)) {
                key = null;
            }
            ++i;
        }
        return key;
    }
}

