/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.model.LEConfig;
import COM.livingston.model.LEConfigFacility;
import COM.livingston.model.LEIPRules;
import COM.livingston.model.LEIPXRules;
import COM.livingston.model.LESAPRules;

public class LEFilter
extends LEConfig {
    public static final String IP_RULES = "ip_rule";
    public static final String IPX_RULES = "ipx_rule";
    public static final String SAP_RULES = "sap_rule";
    public static final int KEY_COUNT = 3;
    static String[] s_keys = null;
    String m_name;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[3];
            LEFilter.s_keys[0] = IP_RULES;
            LEFilter.s_keys[1] = IPX_RULES;
            LEFilter.s_keys[2] = SAP_RULES;
        }
        return s_keys;
    }

    public LEFilter(LEConfigFacility facility, String name) {
        super(facility);
        this.m_name = name;
    }

    public void initialize() {
        this.getConfig(IP_RULES);
        this.getConfig(IPX_RULES);
        this.getConfig(SAP_RULES);
    }

    public Object clone() {
        LEFilter config = new LEFilter(this.m_facility, this.m_name);
        config.copy(this);
        return config;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        LESAPRules sap_rules;
        LEIPXRules ipx_rules;
        this.m_name = name;
        LEIPRules ip_rules = (LEIPRules)this.get(IP_RULES);
        if (ip_rules != null) {
            ip_rules.setName(this.m_name);
        }
        if ((ipx_rules = (LEIPXRules)this.get(IPX_RULES)) != null) {
            ipx_rules.setName(this.m_name);
        }
        if ((sap_rules = (LESAPRules)this.get(SAP_RULES)) != null) {
            sap_rules.setName(this.m_name);
        }
    }

    LEConfig createConfig(String key) {
        LEConfig config = key.equals(IP_RULES) ? new LEIPRules(this.m_facility, this.m_name) : (key.equals(IPX_RULES) ? new LEIPXRules(this.m_facility, this.m_name) : (key.equals(SAP_RULES) ? new LESAPRules(this.m_facility, this.m_name) : new LEConfig(this.m_facility)));
        return config;
    }
}

