/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.model.LEFilter;
import COM.livingston.model.LEFilters;
import COM.livingston.model.LEIPRule;
import COM.livingston.model.LEIPRules;
import COM.livingston.model.LEIPXRule;
import COM.livingston.model.LEIPXRules;
import COM.livingston.model.LESAPRule;
import COM.livingston.model.LESAPRules;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEVector;
import java.io.PrintWriter;
import java.util.StringTokenizer;

public class LEFilterFileParser {
    private static final int FILTER_TOKEN = 10;
    private static final int START = 3;
    LEFilters m_filters = new LEFilters(null);

    public void readFilters(LEVector cmds) {
        int len = cmds.size();
        try {
            int i = 0;
            while (i < len) {
                int min;
                String begin;
                int strlen;
                String line = (String)cmds.elementAt(i);
                if (!line.startsWith("#") && line.length() >= 3 && !line.equals("save all") && (strlen = line.length()) >= 13 && (begin = line.substring(3, 3 + (min = Math.min(strlen, 10))).toLowerCase()).indexOf("filter") >= 0) {
                    if (line.regionMatches(true, 0, "add ", 0, 4)) {
                        this.addFilter(line);
                    } else if (line.regionMatches(true, 0, "set ", 0, 4)) {
                        this.parseRule(line);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }

    public LEFilters getFilters() {
        return this.m_filters;
    }

    public void writeFilters(PrintWriter writer) {
        LEVector cmds = new LEVector();
        this.m_filters.getCommands(cmds);
        int len = cmds.size() - 1;
        int i = 0;
        while (i < len) {
            String command = (String)cmds.elementAt(i);
            writer.println(command);
            ++i;
        }
    }

    private void addFilter(String line) {
        StringTokenizer tokenizer = new StringTokenizer(line);
        tokenizer.nextToken();
        tokenizer.nextToken();
        String filtername = tokenizer.nextToken();
        LEFilter filter = new LEFilter(null, filtername);
        filter.initialize();
        this.m_filters.setField(filtername, filter);
    }

    protected void parseRule(String rule) {
        StringTokenizer tokenizer = new StringTokenizer(rule);
        try {
            tokenizer.nextToken();
            String ruletype = tokenizer.nextToken().toLowerCase();
            String filtername = tokenizer.nextToken();
            String rulenumber = tokenizer.nextToken();
            LEFilter filter = (LEFilter)this.m_filters.getConfig(filtername);
            if (ruletype.equals("filter")) {
                LEIPRules rules;
                LEIPRule iprule = new LEIPRule(null, filtername, rulenumber);
                this.parseIPRule(iprule, tokenizer);
                if (filter instanceof LEFilter && (rules = (LEIPRules)filter.getConfig("ip_rule")) instanceof LEIPRules) {
                    rules.setField(rulenumber, iprule);
                }
            } else if (ruletype.equals("ipxfilter")) {
                LEIPXRules rules;
                LEIPXRule ipxrule = new LEIPXRule(null, filtername, rulenumber);
                this.parseIPXRule(ipxrule, tokenizer);
                if (filter instanceof LEFilter && (rules = (LEIPXRules)filter.getConfig("ipx_rule")) instanceof LEIPXRules) {
                    rules.setField(rulenumber, ipxrule);
                }
            } else if (ruletype.equals("sapfilter")) {
                LESAPRules rules;
                LESAPRule saprule = new LESAPRule(null, filtername, rulenumber);
                this.parseSAPRule(saprule, tokenizer);
                if (filter instanceof LEFilter && (rules = (LESAPRules)filter.getConfig("sap_rule")) instanceof LESAPRules) {
                    rules.setField(rulenumber, saprule);
                }
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }

    protected void parseIPRule(LEIPRule rule, StringTokenizer tokenizer) {
        try {
            String action = tokenizer.nextToken();
            rule.initialize(action);
            if (!tokenizer.hasMoreTokens()) {
                return;
            }
            String srcip = tokenizer.nextToken();
            String dstip = tokenizer.nextToken();
            rule.setField("source", srcip);
            rule.setField("destination", dstip);
            if (!tokenizer.hasMoreTokens()) {
                return;
            }
            String temp1 = tokenizer.nextToken().toLowerCase();
            if (temp1.equals("log")) {
                rule.setField("log", "on");
            } else if (temp1.equals("notify")) {
                rule.setField("notify", "on");
            } else {
                this.parseIPProtocol(rule, temp1, tokenizer);
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }

    protected void parseIPProtocol(LEIPRule rule, String protocol, StringTokenizer tokenizer) {
        try {
            if (protocol.equals("tcp")) {
                rule.setField("protocol", "tcp");
                this.parseTCPProtocol(rule, tokenizer);
            } else if (protocol.equals("udp")) {
                rule.setField("protocol", "udp");
                this.parseUDPProtocol(rule, tokenizer);
            } else if (protocol.equals("icmp")) {
                rule.setField("protocol", "icmp");
                this.parseICMPProtocol(rule, tokenizer);
            } else if (protocol.equals("ip")) {
                rule.setField("protocol", "ip");
            } else if (protocol.equals("protocol")) {
                String proto_number = tokenizer.nextToken();
                rule.setField("protocol", "protocol");
                rule.setField("protocol_number", proto_number);
            } else if (protocol.equals("esp")) {
                rule.setField("protocol", "esp");
            } else if (protocol.equals("ah")) {
                rule.setField("protocol", "ah");
            } else if (protocol.equals("ipip")) {
                rule.setField("protocol", "ipip");
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }

    protected void parseTCPProtocol(LEIPRule rule, StringTokenizer tokenizer) {
        if (!tokenizer.hasMoreElements()) {
            return;
        }
        try {
            String tmp = tokenizer.nextToken().toLowerCase();
            if (tmp.indexOf("estab") > -1) {
                rule.setField("estab", "on");
            } else if (tmp.equals("log")) {
                rule.setField("log", "on");
            } else if (tmp.equals("notify")) {
                rule.setField("notify", "on");
            } else if (tmp.equals("src")) {
                String compare = tokenizer.nextToken();
                String port = tokenizer.nextToken();
                rule.setField("src_cmp", compare);
                rule.setField("src_port", port);
            } else if (tmp.equals("dst")) {
                String compare = tokenizer.nextToken();
                String port = tokenizer.nextToken();
                rule.setField("dst_cmp", compare);
                rule.setField("dst_port", port);
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        this.parseTCPProtocol(rule, tokenizer);
    }

    protected void parseUDPProtocol(LEIPRule rule, StringTokenizer tokenizer) {
        if (!tokenizer.hasMoreElements()) {
            return;
        }
        try {
            String tmp = tokenizer.nextToken().toLowerCase();
            if (tmp.equals("log")) {
                rule.setField("log", "on");
            } else if (tmp.equals("notify")) {
                rule.setField("notify", "on");
            } else if (tmp.equals("src")) {
                String compare = tokenizer.nextToken();
                String port = tokenizer.nextToken();
                rule.setField("src_cmp", compare);
                rule.setField("src_port", port);
            } else if (tmp.equals("dst")) {
                String compare = tokenizer.nextToken();
                String port = tokenizer.nextToken();
                rule.setField("dst_cmp", compare);
                rule.setField("dst_port", port);
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        this.parseUDPProtocol(rule, tokenizer);
    }

    protected void parseICMPProtocol(LEIPRule rule, StringTokenizer tokenizer) {
        if (!tokenizer.hasMoreElements()) {
            return;
        }
        try {
            String tmp = tokenizer.nextToken().toLowerCase();
            if (tmp.equals("log")) {
                rule.setField("log", "on");
            } else if (tmp.equals("notify")) {
                rule.setField("notify", "on");
            } else if (tmp.equals("type")) {
                String itype = tokenizer.nextToken();
                rule.setField("type", itype);
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        this.parseICMPProtocol(rule, tokenizer);
    }

    protected void parseIPXRule(LEIPXRule rule, StringTokenizer tokenizer) {
        try {
            String action = tokenizer.nextToken();
            rule.initialize(action);
            if (!tokenizer.hasMoreElements()) {
                return;
            }
            this.parseIPXOptions(rule, tokenizer);
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }

    protected void parseIPXOptions(LEIPXRule rule, StringTokenizer tokenizer) {
        if (!tokenizer.hasMoreElements()) {
            return;
        }
        try {
            String tmp = tokenizer.nextToken().toLowerCase();
            if (tmp.equals("srcnet")) {
                String ipxnet = tokenizer.nextToken();
                rule.setField("src_net", ipxnet);
            } else if (tmp.equals("srchost")) {
                String host = tokenizer.nextToken();
                rule.setField("src_host", host);
            } else if (tmp.equals("srcsocket")) {
                String compare = tokenizer.nextToken();
                String ipxsock = tokenizer.nextToken();
                rule.setField("src_cmp", compare);
                rule.setField("src_socket", ipxsock);
            } else if (tmp.equals("dstnet")) {
                String ipxnet = tokenizer.nextToken();
                rule.setField("dst_net", ipxnet);
            } else if (tmp.equals("dsthost")) {
                String host = tokenizer.nextToken();
                rule.setField("dst_host", host);
            } else if (tmp.equals("dstsocket")) {
                String compare = tokenizer.nextToken();
                String ipxsock = tokenizer.nextToken();
                rule.setField("dst_cmp", compare);
                rule.setField("dst_socket", ipxsock);
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        this.parseIPXOptions(rule, tokenizer);
    }

    protected void parseSAPRule(LESAPRule rule, StringTokenizer tokenizer) {
        try {
            String action = tokenizer.nextToken();
            rule.initialize(action);
            if (!tokenizer.hasMoreTokens()) {
                return;
            }
            this.parseSAPOptions(rule, tokenizer);
        }
        catch (Exception exception) {}
    }

    protected void parseSAPOptions(LESAPRule rule, StringTokenizer tokenizer) {
        if (!tokenizer.hasMoreTokens()) {
            return;
        }
        try {
            String tmp = tokenizer.nextToken().toLowerCase();
            if (tmp.equals("server")) {
                String server = tokenizer.nextToken();
                rule.setField("server", server);
            } else if (tmp.equals("network")) {
                String network = tokenizer.nextToken();
                rule.setField("network", network);
            } else if (tmp.equals("host")) {
                String node = tokenizer.nextToken();
                rule.setField("host", node);
            } else if (tmp.equals("socket")) {
                String compare = tokenizer.nextToken();
                String socket = tokenizer.nextToken();
                rule.setField("cmp", compare);
                rule.setField("socket", socket);
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
        this.parseSAPOptions(rule, tokenizer);
    }
}

