/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.backend.LEPMCommand;
import COM.livingston.model.LEConfig;
import COM.livingston.model.LEConfigFacility;
import COM.livingston.model.LEFilter;
import COM.livingston.model.LETable;
import COM.livingston.util.LEVector;

public class LEFilters
extends LETable {
    public LEFilters(LEConfigFacility facility) {
        super(facility);
    }

    public Object clone() {
        LEFilters config = new LEFilters(this.m_facility);
        config.copy(this);
        return config;
    }

    public LEVector add(String name) {
        LEVector errors = null;
        String cmd = this.makeAddCommand("filter", name);
        LEPMCommand ret = this.m_facility.execute(cmd);
        if (ret.getStatus()) {
            ret = this.m_facility.execute("save all");
            if (ret.getStatus()) {
                LEFilter filter = (LEFilter)this.getConfig(name);
                filter.initialize();
            } else {
                this.refresh();
            }
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    public LEVector delete(String name) {
        LEVector errors = null;
        String cmd = this.makeDeleteCommand("filter", name);
        LEPMCommand ret = this.m_facility.execute(cmd);
        if (ret.getStatus()) {
            this.remove(name);
            ret = this.m_facility.execute("save all");
            if (!ret.getStatus()) {
                this.refresh();
            }
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    boolean generateAddCommand(String key, LEVector cmds) {
        cmds.addElement(this.makeAddCommand("filter", key));
        return true;
    }

    boolean generateDeleteCommand(String key, LEVector cmds) {
        cmds.addElement(this.makeDeleteCommand("filter", key));
        return true;
    }

    LEConfig createConfig(String key) {
        return new LEFilter(this.m_facility, key);
    }
}

