/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.model.LEConfig;
import COM.livingston.model.LEConfigFacility;
import COM.livingston.util.LEVector;

public class LEGroup
extends LEConfig {
    public static final String AGGREGATE_SPEED = Integer.toString(131);
    public static final String CHANNELS = Integer.toString(132);
    public static final String SPEED = Integer.toString(130);
    public static final int KEY_COUNT = 3;
    public static final String GROUP_TAG = "group";
    static String[] s_keys = null;
    String m_line;
    String m_cgroup;
    String m_tag;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[3];
            int i = 0;
            LEGroup.s_keys[i++] = AGGREGATE_SPEED;
            LEGroup.s_keys[i++] = CHANNELS;
            LEGroup.s_keys[i++] = SPEED;
        }
        return s_keys;
    }

    public LEGroup(LEConfigFacility facility, String board, String line, String cgroup) {
        super(facility, board);
        this.m_line = line;
        this.m_cgroup = cgroup;
        this.m_tag = String.valueOf(this.m_line) + " " + GROUP_TAG + " " + this.m_cgroup;
    }

    public LEGroup(LEConfigFacility facility, String line, String cgroup) {
        this(facility, null, line, cgroup);
    }

    public Object clone() {
        LEGroup config = new LEGroup(this.m_facility, this.m_board, this.m_line, this.m_cgroup);
        config.copy(this);
        return config;
    }

    public String getCGroup() {
        return this.m_cgroup;
    }

    boolean generateCommands(LEVector keys, LEVector cmds) {
        boolean allCmds = keys == null;
        int start = cmds.size();
        if (allCmds || keys.contains(CHANNELS)) {
            this.makeSetCommand(cmds, this.m_tag, CHANNELS, "channels");
        }
        if (allCmds || keys.contains(SPEED)) {
            this.makeSetCommand(cmds, this.m_tag, SPEED, null);
        }
        return cmds.size() > start;
    }
}

