/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.model.LEConfig;
import COM.livingston.model.LEConfigFacility;
import COM.livingston.util.LEVector;

public class LEHostOverrides
extends LEConfig {
    public static final String DATABITS = Integer.toString(329);
    public static final String PARITY = Integer.toString(330);
    public static final String SPEED = Integer.toString(328);
    public static final String RTS_CTS = Integer.toString(331);
    public static final String XON_XOFF = Integer.toString(327);
    public static final int KEY_COUNT = 5;
    static String[] s_keys = null;
    String m_name;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[5];
            LEHostOverrides.s_keys[0] = DATABITS;
            LEHostOverrides.s_keys[1] = PARITY;
            LEHostOverrides.s_keys[2] = SPEED;
            LEHostOverrides.s_keys[3] = RTS_CTS;
            LEHostOverrides.s_keys[4] = XON_XOFF;
        }
        return s_keys;
    }

    public LEHostOverrides(LEConfigFacility facility, String name) {
        super(facility);
        this.m_name = name;
    }

    public Object clone() {
        LEHostOverrides config = new LEHostOverrides(this.m_facility, this.m_name);
        config.copy(this);
        return config;
    }

    boolean generateCommands(LEVector keys, LEVector cmds) {
        boolean allCmds = keys == null;
        int start = cmds.size();
        if (allCmds || keys.contains(DATABITS)) {
            this.makeSetCommand(cmds, this.m_name, DATABITS, "override databits");
        }
        if (allCmds || keys.contains(PARITY)) {
            this.makeSetCommand(cmds, this.m_name, PARITY, "override parity");
        }
        if (allCmds || keys.contains(SPEED)) {
            this.makeSetCommand(cmds, this.m_name, SPEED, "override speed");
        }
        if (allCmds || keys.contains(RTS_CTS)) {
            this.makeSetCommand(cmds, this.m_name, RTS_CTS, "override rts");
        }
        if (allCmds || keys.contains(XON_XOFF)) {
            this.makeSetCommand(cmds, this.m_name, XON_XOFF, "override xon");
        }
        return cmds.size() > start;
    }
}

